/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.render;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.domainmodel.Composite;
import net.sf.jailer.domainmodel.Domain;
import net.sf.jailer.domainmodel.DomainModel;
import net.sf.jailer.render.DataModelRenderer;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.PrintUtil;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class HtmlDataModelRenderer
implements DataModelRenderer {
    private static final String COLOR_KEYWORDS = "font-style: italic; color: rgb(120, 0, 0);";
    private final String outputDir;
    private final int maxDepth;
    private static final Logger _log = Logger.getLogger(HtmlDataModelRenderer.class);

    public HtmlDataModelRenderer(String outputDir, int maxDepth) {
        this.outputDir = outputDir;
        this.maxDepth = maxDepth;
    }

    @Override
    public void render(DataModel dataModel) {
        try {
            ArrayList<Table> tableList = new ArrayList<Table>(dataModel.getTables());
            Collections.sort(tableList);
            ArrayList<String> tablesColumn = new ArrayList<String>();
            ArrayList<String> domainsColumn = new ArrayList<String>();
            DomainModel domainModel = new DomainModel(dataModel);
            for (Table table : tableList) {
                Composite composite = domainModel.composites.get(table);
                Domain domain = domainModel.getDomain(table);
                if (composite != null) {
                    tablesColumn.add(this.linkTo(table));
                    domainsColumn.add(domain == null ? "" : "&nbsp;&nbsp;&nbsp;<small>" + this.linkTo(domain) + "</small>");
                }
                StringBuffer legend = new StringBuffer();
                String closure = this.renderClosure(domainModel, composite == null ? domainModel.getComposite(table) : composite, legend);
                closure = PrintUtil.applyTemplate("template" + File.separatorChar + "table.html", new Object[]{"Closure", "", closure});
                String columns = this.generateColumnsTable(table);
                columns = columns == null ? "" : columns + "<br>";
                String components = "";
                if (composite != null && composite.componentTables.size() > 0) {
                    components = this.generateComponentsTable(composite) + "<br>";
                }
                String domainSuffix = "";
                if (domain != null) {
                    domainSuffix = " <small>(" + this.linkTo(domain) + ")</small>";
                }
                String title = composite == null ? "Component " + table.getName() : composite.toString();
                HtmlDataModelRenderer.writeFile(new File(this.outputDir, HtmlDataModelRenderer.toFileName(table)), PrintUtil.applyTemplate("template" + File.separator + "tableframe.html", new Object[]{title, this.renderTableBody(table, table, 0, 1, new HashSet<Table>()), closure + legend, components + columns, domainSuffix}));
                CancellationHandler.checkForCancellation(null);
            }
            String restrictions = "none";
            List<String> restrictionModels = CommandLineParser.getInstance().arguments;
            if (!(restrictionModels = restrictionModels.subList(0, restrictionModels.size())).isEmpty()) {
                restrictionModels = restrictionModels.subList(1, restrictionModels.size());
            }
            if (!restrictionModels.isEmpty()) {
                restrictions = restrictionModels.toString();
                restrictions = restrictions.substring(1, restrictions.length() - 1);
            }
            String domains = "";
            if (!domainModel.getDomains().isEmpty()) {
                domains = this.renderDomainModel(domainModel) + "<br>";
            }
            HtmlDataModelRenderer.writeFile(new File(this.outputDir, "index.html"), PrintUtil.applyTemplate("template" + File.separatorChar + "index.html", new Object[]{new Date(), this.generateHTMLTable("Tables", null, tablesColumn, domainsColumn), restrictions, domains}));
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String renderClosure(DomainModel domainModel, Composite composite, StringBuffer legend) throws FileNotFoundException, IOException {
        StringBuffer lines = new StringBuffer();
        int distance = 0;
        HashSet closure = new HashSet();
        HashSet<Composite> associatedComposites = new HashSet<Composite>();
        boolean printLegend = false;
        Domain domain = domainModel.getDomain(composite.mainTable);
        do {
            associatedComposites.clear();
            if (distance == 0) {
                associatedComposites.add(composite);
            } else {
                for (Composite c : closure) {
                    for (Association a : c.getAssociations()) {
                        Composite destinationComposite;
                        if (a.getJoinCondition() == null || closure.contains(destinationComposite = domainModel.getComposite(a.destination)) || this.excludeFromClosure(a.destination)) continue;
                        associatedComposites.add(destinationComposite);
                    }
                }
            }
            ArrayList cl = new ArrayList(associatedComposites);
            Collections.sort(cl, new Comparator<Composite>(){

                @Override
                public int compare(Composite o1, Composite o2) {
                    return o1.mainTable.compareTo(o2.mainTable);
                }
            });
            StringBuffer ts = new StringBuffer();
            boolean firstTime = true;
            for (Composite dt : cl) {
                if (!firstTime) {
                    ts.append(", ");
                }
                Domain dtDomain = domainModel.getDomain(dt.mainTable);
                boolean differentDomains = false;
                boolean subDomain = false;
                if (dtDomain == null && domain == null) {
                    differentDomains = false;
                } else if (dtDomain == null || domain == null) {
                    differentDomains = true;
                } else {
                    differentDomains = !domain.equals(dtDomain);
                    subDomain = dtDomain.isSubDomainOf(domain);
                }
                if (differentDomains && !subDomain) {
                    ts.append("<span style=\"font-style: italic;\">");
                    printLegend = true;
                }
                ts.append(dt.equals(composite) ? dt.mainTable.getName() : this.linkTo(dt.mainTable));
                if (subDomain) {
                    ts.append("*");
                    printLegend = true;
                }
                if (differentDomains && !subDomain) {
                    ts.append("**</span>");
                }
                firstTime = false;
            }
            if (!cl.isEmpty()) {
                lines.append(PrintUtil.applyTemplate("template" + File.separator + "table_line.html", new Object[]{"", "&nbsp;&nbsp;distance&nbsp;" + distance, "", "&nbsp;", ts.toString(), COLOR_KEYWORDS, distance % 2 != 0 ? "class=\"highlightedrow\"" : ""}));
            }
            ++distance;
            closure.addAll(associatedComposites);
        } while (!associatedComposites.isEmpty());
        if (printLegend) {
            legend.append(PrintUtil.applyTemplate("template" + File.separatorChar + "legend.html", new Object[0]));
        }
        return lines.toString();
    }

    protected boolean excludeFromClosure(Table table) {
        return false;
    }

    protected boolean excludeFromNeighborhood(Table table) {
        return false;
    }

    private String renderTableBody(Table table, Table current, int depth, int indent, Set<Table> alreadyRendered) throws FileNotFoundException, IOException {
        if (alreadyRendered.contains(table)) {
            return "";
        }
        alreadyRendered.add(table);
        StringBuffer lines = new StringBuffer();
        ArrayList<Association> all = new ArrayList<Association>(table.associations);
        Collections.sort(all, new Comparator<Association>(){

            @Override
            public int compare(Association o1, Association o2) {
                return o1.destination.getName().compareTo(o2.destination.getName());
            }
        });
        ArrayList<Association> dep = new ArrayList<Association>();
        ArrayList<Association> hasDep = new ArrayList<Association>();
        ArrayList<Association> assoc = new ArrayList<Association>();
        ArrayList<Association> ignored = new ArrayList<Association>();
        for (Association association : all) {
            if (association.isIgnored()) {
                ignored.add(association);
                continue;
            }
            if (association.isInsertDestinationBeforeSource()) {
                dep.add(association);
                continue;
            }
            if (association.isInsertSourceBeforeDestination()) {
                hasDep.add(association);
                continue;
            }
            assoc.add(association);
        }
        String prefix = "";
        String gap = "<small><small>&nbsp;<br></small></small>";
        if (!dep.isEmpty()) {
            lines.append(this.tableRow(indent, "depends&nbsp;on"));
            int lineNr = 0;
            for (Association association : dep) {
                if ("".equals(association.toString())) continue;
                prefix = gap;
                lines.append(this.tableRow(indent, association, current, ++lineNr % 2 == 0));
            }
        }
        if (!hasDep.isEmpty()) {
            lines.append(this.tableRow(indent, prefix + "has&nbsp;dependent"));
            int lineNr = 0;
            for (Association association : hasDep) {
                if ("".equals(association.toString())) continue;
                prefix = gap;
                lines.append(this.tableRow(indent, association, current, ++lineNr % 2 == 0));
            }
        }
        if (!assoc.isEmpty()) {
            lines.append(this.tableRow(indent, prefix + "is&nbsp;associated&nbsp;with"));
            int lineNr = 0;
            for (Association association : assoc) {
                if ("".equals(((Object)assoc).toString())) continue;
                prefix = gap;
                lines.append(this.tableRow(indent, association, current, ++lineNr % 2 == 0));
            }
        }
        if (!ignored.isEmpty()) {
            lines.append(this.tableRow(indent, prefix + "ignored"));
            int lineNr = 0;
            for (Association association : ignored) {
                if ("".equals(association.toString())) continue;
                prefix = gap;
                lines.append(this.tableRow(indent, association, current, ++lineNr % 2 == 0));
            }
        }
        StringBuffer result = new StringBuffer(PrintUtil.applyTemplate("template" + File.separator + "table.html", new Object[]{table.equals(current) ? "Associations" : this.linkTo(table), this.indentSpaces(indent), lines.toString()}));
        if (depth < this.maxDepth) {
            if (depth == 0) {
                result.append("<br>" + PrintUtil.applyTemplate("template" + File.separator + "table.html", new Object[]{"Neighborhood", this.indentSpaces(1), ""}) + "<br>");
            }
            HashSet<Table> rendered = new HashSet<Table>();
            boolean firstTime = true;
            for (Association association : all) {
                if (rendered.contains(association.destination) || this.excludeFromNeighborhood(association.destination)) continue;
                String tableBody = this.renderTableBody(association.destination, current, depth + 1, indent + 1, alreadyRendered);
                if (tableBody.length() > 0) {
                    if (!firstTime) {
                        result.append("<br>");
                    }
                    firstTime = false;
                }
                result.append(tableBody);
                rendered.add(association.destination);
            }
        }
        return result.toString();
    }

    private String tableRow(int indent, String content) throws FileNotFoundException, IOException {
        return PrintUtil.applyTemplate("template" + File.separator + "table_top_line.html", new Object[]{this.indentSpaces(indent), content, "", "", "", COLOR_KEYWORDS, ""});
    }

    private String tableRow(int indent, Association association, Table current, boolean highlighted) throws FileNotFoundException, IOException {
        String jc = association.renderJoinCondition("<span style=\"font-style: italic; color: rgb(120, 0, 0);\">restricted by</span>");
        String aliasA = "A";
        String aliasB = "B";
        if (!association.source.equals(association.destination)) {
            aliasA = association.source.getName();
            aliasB = association.destination.getName();
        }
        aliasA = this.linkTo(association.source, aliasA);
        aliasB = this.linkTo(association.destination, aliasB);
        jc = SqlUtil.replaceAliases(jc, aliasA, aliasB);
        return PrintUtil.applyTemplate("template" + File.separator + "table_line.html", new Object[]{this.indentSpaces(indent), "&nbsp;&nbsp;" + (association.destination.equals(current) ? association.destination.getName() : this.linkTo(association.destination)), "&nbsp;&nbsp;" + (association.getCardinality() != null ? association.getCardinality() : ""), "&nbsp;on&nbsp;", jc, "", highlighted ? "class=\"highlightedrow\"" : ""});
    }

    private String generateColumnsTable(Table table) throws SQLException, FileNotFoundException, IOException {
        StringBuffer result = new StringBuffer();
        int count = 0;
        for (Column column : table.getColumns()) {
            ++count;
            String COLUMN_NAME = column.name;
            boolean nullable = true;
            String type = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + column.toSQL(null).substring(column.name.length()).trim().replaceAll(" ", "&nbsp;");
            String constraint = !nullable ? "&nbsp;&nbsp;&nbsp;&nbsp;<small>NOT&nbsp;NULL</small>" : "";
            boolean isPK = false;
            for (Column c : table.primaryKey.getColumns()) {
                isPK = isPK || c.name.equalsIgnoreCase(COLUMN_NAME);
            }
            result.append(PrintUtil.applyTemplate("template" + File.separator + "table_line.html", new Object[]{this.indentSpaces(1), "&nbsp;&nbsp;" + COLUMN_NAME, type, "", constraint, isPK ? COLOR_KEYWORDS : "", count % 2 == 0 ? "class=\"highlightedrow\"" : ""}));
        }
        return count == 0 ? null : PrintUtil.applyTemplate("template" + File.separatorChar + "table.html", new Object[]{"Columns", "", result.toString()});
    }

    private String generateComponentsTable(Composite composite) throws SQLException, FileNotFoundException, IOException {
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Table component : composite.componentTables) {
            componentNames.add(this.linkTo(component));
        }
        return this.generateHTMLTable("Components", null, componentNames, null);
    }

    private String generateHTMLTable(String title, List<Integer> indents, List<String> column1, List<String> column2) throws FileNotFoundException, IOException {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < column1.size(); ++i) {
            result.append(PrintUtil.applyTemplate("template" + File.separator + "table_line.html", new Object[]{"", this.indentSpaces(indents == null ? 1 : indents.get(i)) + column1.get(i), column2 == null ? "" : column2.get(i), "", "", "", i % 2 != 0 ? "class=\"highlightedrow\"" : ""}));
        }
        return column1.isEmpty() ? null : PrintUtil.applyTemplate("template" + File.separatorChar + "table.html", new Object[]{title, "", result.toString()});
    }

    public String renderDomainModel(DomainModel domainModel) throws FileNotFoundException, IOException {
        ArrayList<String> column1 = new ArrayList<String>();
        ArrayList<String> column2 = new ArrayList<String>();
        ArrayList<Integer> indent = new ArrayList<Integer>();
        HashSet<Domain> renderedDomains = new HashSet<Domain>();
        for (Domain domain : domainModel.getDomains().values()) {
            if (domain.getSuperDomains().isEmpty()) {
                this.appendDomainTree(domain, column1, column2, 1, indent, domainModel.getDomains().size() + 2, domain.name, renderedDomains);
            }
            ArrayList<String> column = new ArrayList<String>();
            for (Domain subDomain : domain.getSubDomains()) {
                column.add(this.linkTo(subDomain));
            }
            String containsTable = this.generateHTMLTable("contains", null, column, null);
            String content = "";
            if (containsTable != null) {
                content = content + containsTable + "<br>";
            }
            column.clear();
            for (Domain superDomain : domain.getSuperDomains()) {
                column.add(this.linkTo(superDomain));
            }
            String partOfTable = this.generateHTMLTable("Part of", null, column, null);
            if (partOfTable != null) {
                content = content + partOfTable + "<br>";
            }
            column.clear();
            for (Table table : domain.tables) {
                if (domainModel.composites.get(table) == null) continue;
                column.add(this.linkTo(table));
            }
            String tablesTable = this.generateHTMLTable("Tables", null, column, null);
            if (tablesTable != null) {
                content = content + tablesTable + "<br>";
            }
            HtmlDataModelRenderer.writeFile(new File(this.outputDir, domain.name + "_DOMAIN.html"), PrintUtil.applyTemplate("template" + File.separator + "tableframe.html", new Object[]{"Domain " + domain.name, content, "", "", ""}));
        }
        return this.generateHTMLTable("Domains", indent, column1, column2);
    }

    private void appendDomainTree(Domain domain, List<String> column1, List<String> column2, int level, List<Integer> indent, int maxLevel, String path, Set<Domain> renderedDomains) {
        if (level > maxLevel) {
            throw new RuntimeException("cyclic domain containment: " + path);
        }
        String suffix = "";
        if (renderedDomains.contains(domain) && !domain.getSubDomains().isEmpty()) {
            suffix = "&nbsp;&#x2191;";
        }
        column1.add(this.linkTo(domain) + suffix + "&nbsp;&nbsp;&nbsp;");
        column2.add("&nbsp;&nbsp;<small>" + domain.tables.size() + "&nbsp;Tables</small>&nbsp;&nbsp;");
        indent.add(level);
        if (!renderedDomains.contains(domain)) {
            renderedDomains.add(domain);
            for (Domain subDomain : domain.getSubDomains()) {
                this.appendDomainTree(subDomain, column1, column2, level + 1, indent, maxLevel, path + "->" + subDomain.name, renderedDomains);
            }
        }
    }

    private String indentSpaces(int indent) {
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < indent; ++i) {
            for (int j = 0; j < 8; ++j) {
                result.append("&nbsp;");
            }
        }
        return result.toString();
    }

    private String linkTo(Domain domain) {
        return "<a href=\"" + domain.name + "_DOMAIN.html\">" + domain.name + "</a>";
    }

    private String linkTo(Table table) {
        return this.linkTo(table, table.getName());
    }

    private String linkTo(Table table, String name) {
        return "<a href=\"" + HtmlDataModelRenderer.toFileName(table) + "\">" + name + "</a>";
    }

    public static String toFileName(Table table) {
        StringBuilder sb = new StringBuilder();
        String tableName = table.getName();
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.";
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (chars.indexOf(c) < 0) continue;
            sb.append(c);
        }
        return sb.toString() + ".html";
    }

    public static void writeFile(File file, String content) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        out.print(content);
        out.close();
        _log.info("file '" + file + "' written");
    }
}

