/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.progress;

import net.sf.jailer.datamodel.ModelElement;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.progress.ProgressListener;

public class ProgressListenerRegistry {
    private static InheritableThreadLocal<ProgressListener> progressListener = new InheritableThreadLocal();
    private static ProgressListener NULL_PROGRESS_LISTENER = new ProgressListener(){

        @Override
        public void collectionJobEnqueued(int day, ModelElement association) {
        }

        @Override
        public void collectionJobStarted(int day, ModelElement modelElement) {
        }

        @Override
        public void collected(int day, ModelElement association, long numberOfRows) {
        }

        @Override
        public void exported(Table table, long rc) {
        }

        @Override
        public void newStage(String stage, boolean isErrorStage, boolean isFinalStage) {
        }
    };

    public static synchronized void setProgressListener(ProgressListener theProgressListener) {
        progressListener.set(theProgressListener);
    }

    public static synchronized ProgressListener getProgressListener() {
        ProgressListener theProgressListener = (ProgressListener)progressListener.get();
        if (theProgressListener == null) {
            return NULL_PROGRESS_LISTENER;
        }
        return theProgressListener;
    }
}

