/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.modelbuilder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKeyFactory;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.ModelElementFinder;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class ModelBuilder {
    private static final Logger _log = Logger.getLogger(ModelBuilder.class);
    private static Session session;
    public static CsvFile.LineFilter assocFilter;

    public static String getModelBuilderTablesFilename() {
        return DataModel.getDatamodelFolder() + File.separator + "model-builder-table.csv";
    }

    public static String getModelBuilderColumnsFilename() {
        return DataModel.getDatamodelFolder() + File.separator + "model-builder-column.csv";
    }

    public static String getModelBuilderAssociationsFilename() {
        return DataModel.getDatamodelFolder() + File.separator + "model-builder-association.csv";
    }

    private static CsvFile getExcludeTablesCSV() {
        try {
            File exTFile = CommandLineParser.getInstance().newFile(DataModel.getDatamodelFolder() + File.separator + "exclude-tables.csv");
            if (!exTFile.exists()) {
                exTFile.createNewFile();
            }
            return new CsvFile(exTFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CsvFile getExcludeAssociationsCSV() {
        try {
            File exAFile = CommandLineParser.getInstance().newFile(DataModel.getDatamodelFolder() + File.separator + "exclude-associations.csv");
            if (!exAFile.exists()) {
                exAFile.createNewFile();
            }
            return new CsvFile(exAFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void build(String driverClassName, String dbUrl, String dbUser, String dbPassword, String schema, StringBuffer warnings) throws Exception {
        session = new Session(driverClassName, dbUrl, dbUser, dbPassword);
        session.setIntrospectionSchema(schema);
        ModelBuilder.resetFiles();
        DataModel dataModel = new DataModel();
        ArrayList<Table> tables = new ArrayList<Table>();
        List<ModelElementFinder> modelElementFinder = Configuration.getModelElementFinder();
        for (ModelElementFinder finder : modelElementFinder) {
            _log.info("find tables with " + finder);
            tables.addAll(finder.findTables(session));
        }
        ArrayList allTables = new ArrayList(tables);
        HashSet<Table> written = new HashSet<Table>();
        Iterator iT = tables.iterator();
        while (iT.hasNext()) {
            Table table = (Table)iT.next();
            if (written.contains(table)) {
                iT.remove();
                continue;
            }
            written.add(table);
        }
        String tableDefinitions = "";
        ArrayList sortedTables = new ArrayList(tables);
        Collections.sort(sortedTables, new Comparator<Table>(){

            @Override
            public int compare(Table t1, Table t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
        HashMap<Table, List<Column>> columnPerTable = new HashMap<Table, List<Column>>();
        StringBuilder columnsDefinition = new StringBuilder();
        CsvFile excludeTablesCSV = ModelBuilder.getExcludeTablesCSV();
        block2: for (Table table : allTables) {
            if (ModelBuilder.isJailerTable(table) || excludeTablesCSV.contains(new String[]{table.getName()}) || excludeTablesCSV.contains(new String[]{table.getName().toUpperCase()})) continue;
            for (ModelElementFinder finder : modelElementFinder) {
                _log.info("find colums with " + finder);
                List<Column> columns = finder.findColumns(table, session);
                if (columns.isEmpty()) continue;
                columnPerTable.put(table, columns);
                columnsDefinition.append(CsvFile.encodeCell(table.getName()) + "; ");
                for (Column c : columns) {
                    columnsDefinition.append(CsvFile.encodeCell(c.toSQL(null) + (c.isIdentityColumn ? " identity" : "")) + "; ");
                }
                columnsDefinition.append("\n");
                continue block2;
            }
        }
        ModelBuilder.resetColumnsFile(columnsDefinition.toString());
        for (Table table : sortedTables) {
            if (ModelBuilder.isJailerTable(table) || excludeTablesCSV.contains(new String[]{table.getName()}) || excludeTablesCSV.contains(new String[]{table.getName().toUpperCase()})) continue;
            if (table.primaryKey.getColumns().isEmpty()) {
                Table old = dataModel.getTable(table.getName());
                if (old != null && !old.primaryKey.getColumns().isEmpty() && columnPerTable.containsKey(table)) {
                    ArrayList<Column> newPk = new ArrayList<Column>();
                    block6: for (Column c : (List)columnPerTable.get(table)) {
                        for (Column opk : old.primaryKey.getColumns()) {
                            if (!c.name.equals(opk.name)) continue;
                            newPk.add(c);
                            continue block6;
                        }
                    }
                    if (newPk.size() == old.primaryKey.getColumns().size()) {
                        table = new Table(old.getName(), new PrimaryKeyFactory().createPrimaryKey(newPk), false);
                        table.setAuthor(old.getAuthor());
                    }
                }
                String warning = "Table '" + table.getName() + "' has no primary key";
                if (table.primaryKey.getColumns().size() == 0) {
                    warnings.append(warning + "\n");
                } else {
                    warning = warning + ", taking manually defined key.";
                }
                _log.warn(warning);
            }
            tableDefinitions = tableDefinitions + CsvFile.encodeCell(table.getName()) + "; N; ";
            for (Column pk : table.primaryKey.getColumns()) {
                tableDefinitions = tableDefinitions + CsvFile.encodeCell(pk.toString()) + ";";
            }
            tableDefinitions = tableDefinitions + "   ;" + CsvFile.encodeCell(table.getAuthor()) + ";\n";
        }
        ModelBuilder.resetTableFile(tableDefinitions);
        dataModel = new DataModel(ModelBuilder.getModelBuilderTablesFilename(), ModelBuilder.getModelBuilderAssociationsFilename(), new HashMap<String, String>(), assocFilter);
        ArrayList<Association> associations = new ArrayList<Association>();
        HashMap<Association, String[]> namingSuggestion = new HashMap<Association, String[]>();
        for (ModelElementFinder finder : modelElementFinder) {
            _log.info("find associations with " + finder);
            associations.addAll(finder.findAssociations(dataModel, namingSuggestion, session));
        }
        ArrayList<Association> associationsToWrite = new ArrayList<Association>();
        CsvFile excludeAssociationsCSV = ModelBuilder.getExcludeAssociationsCSV();
        for (Association association : associations) {
            if (excludeAssociationsCSV.contains(new String[]{association.source.getName(), association.destination.getName(), null, association.getJoinCondition()}) || ModelBuilder.contains(association, dataModel)) continue;
            ModelBuilder.insert(association, dataModel);
            associationsToWrite.add(association);
        }
        String associationDefinition = "";
        HashSet<String> names = new HashSet<String>();
        for (Table table : dataModel.getTables()) {
            for (Association association : table.associations) {
                if (association.getName() == null) continue;
                names.add(association.getName());
            }
        }
        for (Association association : associationsToWrite) {
            String firstInsert = " ";
            if (association.isInsertSourceBeforeDestination()) {
                firstInsert = "A";
            }
            if (association.isInsertDestinationBeforeSource()) {
                firstInsert = "B";
            }
            String card = "   ";
            if (association.getCardinality() != null) {
                card = association.getCardinality().toString();
            }
            String sep = "_to_";
            if (association.source.getName().charAt(0) >= 'A' && association.source.getName().charAt(0) <= 'Z') {
                sep = "_TO_";
            }
            String name = association.source.getName() + sep + association.destination.getName();
            if (namingSuggestion.containsKey(association)) {
                String nameSuggestion;
                String[] arr$ = (String[])namingSuggestion.get(association);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && names.contains(name = (nameSuggestion = arr$[i$])); ++i$) {
                }
            }
            if (names.contains(name)) {
                int i = 1;
                while (true) {
                    String nameWithSuffix;
                    if (!names.contains(nameWithSuffix = name + "_" + i)) {
                        name = nameWithSuffix;
                        break;
                    }
                    ++i;
                }
            }
            names.add(name);
            associationDefinition = associationDefinition + CsvFile.encodeCell(association.source.getName()) + "; " + CsvFile.encodeCell(association.destination.getName()) + "; " + firstInsert + "; " + card + "; " + CsvFile.encodeCell(association.getJoinCondition()) + "; " + CsvFile.encodeCell(name) + "; " + CsvFile.encodeCell(association.getAuthor()) + ";\n";
        }
        ModelBuilder.resetAssociationFile(associationDefinition);
    }

    private static void resetAssociationFile(String associationDefinition) throws IOException {
        ModelBuilder.writeFile(ModelBuilder.getModelBuilderAssociationsFilename(), "# generated by Jailer\n\n# Table A;    Table B;  first-insert; cardinality (opt); join-condition; name (opt); author\n" + associationDefinition);
    }

    private static void resetTableFile(String tableDefinitions) throws IOException {
        ModelBuilder.writeFile(ModelBuilder.getModelBuilderTablesFilename(), "# generated by Jailer\n\n# Name;   upsert; primary key;    ; author\n" + tableDefinitions);
    }

    private static void resetColumnsFile(String columnsDefinitions) throws IOException {
        ModelBuilder.writeFile(ModelBuilder.getModelBuilderColumnsFilename(), "# generated by Jailer\n\n# Table; columns\n" + columnsDefinitions);
    }

    private static void insert(Association association, DataModel dataModel) {
        Association associationB;
        Association associationA = association;
        Cardinality reversedCard = association.getCardinality();
        if (reversedCard != null) {
            reversedCard = reversedCard.reverse();
        }
        associationA.reversalAssociation = associationB = new Association(association.destination, association.destination, association.isInsertSourceBeforeDestination(), association.isInsertSourceBeforeDestination(), association.getJoinCondition(), dataModel, true, reversedCard);
        associationB.reversalAssociation = associationA;
        associationA.source.associations.add(associationA);
        associationB.source.associations.add(associationB);
    }

    private static boolean isJailerTable(Table table) {
        String tName = table.getUnqualifiedName().toUpperCase();
        return SqlUtil.JAILER_TABLES.contains(tName) || tName.endsWith("_T") && SqlUtil.JAILER_TABLES.contains(tName.substring(0, tName.length() - 2));
    }

    private static boolean contains(Association association, DataModel dataModel) {
        for (Association a : association.source.associations) {
            if (!a.source.equals(association.source) || !a.destination.equals(association.destination) || !a.isInsertDestinationBeforeSource() && association.isInsertDestinationBeforeSource() || !a.isInsertSourceBeforeDestination() && association.isInsertSourceBeforeDestination() || !a.getJoinCondition().equals(association.getJoinCondition())) continue;
            return true;
        }
        return false;
    }

    private static void writeFile(String fileName, String content) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        out.print(content);
        out.close();
        _log.info("file '" + fileName + "' written");
    }

    public static void resetFiles() throws IOException {
        ModelBuilder.resetTableFile("");
        ModelBuilder.resetAssociationFile("");
    }

    public static void cleanUp() {
        File f = new File(ModelBuilder.getModelBuilderTablesFilename());
        if (f.exists()) {
            f.delete();
            _log.info("File '" + f.getAbsolutePath() + "' removed");
        }
        if ((f = new File(ModelBuilder.getModelBuilderAssociationsFilename())).exists()) {
            f.delete();
            _log.info("File '" + f.getAbsolutePath() + "' removed");
        }
        if ((f = new File(ModelBuilder.getModelBuilderColumnsFilename())).exists()) {
            f.delete();
            _log.info("File '" + f.getAbsolutePath() + "' removed");
        }
    }

    static {
        assocFilter = null;
    }
}

