/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.modelbuilder;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.PrimaryKeyFactory;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.ModelElementFinder;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.Quoting;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class JDBCMetaDataBasedModelElementFinder
implements ModelElementFinder {
    private static final Logger _log = Logger.getLogger(JDBCMetaDataBasedModelElementFinder.class);
    private final Set<String> typesWithLength = new HashSet<String>();
    private Session forDefaultSchema;
    private String defaultSchema;

    public JDBCMetaDataBasedModelElementFinder() {
        this.typesWithLength.add("NVARCHAR2");
        this.typesWithLength.add("NVARCHAR");
        this.typesWithLength.add("NCHAR");
        this.typesWithLength.add("RAW");
        this.forDefaultSchema = null;
        this.defaultSchema = null;
    }

    @Override
    public Collection<Association> findAssociations(DataModel dataModel, Map<Association, String[]> namingSuggestion, Session session) throws Exception {
        ArrayList<Association> associations = new ArrayList<Association>();
        DatabaseMetaData metaData = session.getMetaData();
        Quoting quoting = new Quoting(metaData);
        String defaultSchema = JDBCMetaDataBasedModelElementFinder.getDefaultSchema(session, session.dbUser);
        for (Table table : dataModel.getTables()) {
            ResultSet resultSet;
            _log.info("find associations with " + table.getName());
            try {
                resultSet = metaData.getImportedKeys(null, quoting.unquote(table.getOriginalSchema(quoting.quote(defaultSchema))), quoting.unquote(table.getUnqualifiedName()));
            }
            catch (Exception e) {
                _log.info("failed. " + e.getMessage());
                continue;
            }
            HashMap<String, Association> fkMap = new HashMap<String, Association>();
            while (resultSet.next()) {
                Table pkTable = dataModel.getTable(this.toQualifiedTableName(quoting.quote(defaultSchema), quoting.quote(resultSet.getString(2)), quoting.quote(resultSet.getString(3))));
                String pkColumn = quoting.quote(resultSet.getString(4));
                Table fkTable = dataModel.getTable(this.toQualifiedTableName(quoting.quote(defaultSchema), quoting.quote(resultSet.getString(6)), quoting.quote(resultSet.getString(7))));
                String fkColumn = quoting.quote(resultSet.getString(8));
                String foreignKey = resultSet.getString(12);
                String fkName = fkTable + "." + foreignKey;
                if (foreignKey != null && fkMap.containsKey(fkName)) {
                    ((Association)fkMap.get(fkName)).appendCondition("A." + fkColumn + "=B." + pkColumn);
                    continue;
                }
                if (pkTable == null || fkTable == null) continue;
                Association association = new Association(fkTable, pkTable, false, true, "A." + fkColumn + "=B." + pkColumn, dataModel, false, Cardinality.MANY_TO_ONE);
                association.setAuthor(metaData.getDriverName());
                associations.add(association);
                fkMap.put(fkName, association);
                if (foreignKey == null) continue;
                namingSuggestion.put(association, new String[]{foreignKey, fkTable.getUnqualifiedName() + "." + foreignKey});
            }
            resultSet.close();
            CancellationHandler.checkForCancellation(null);
        }
        return associations;
    }

    private String toQualifiedTableName(String defaultSchema, String schema, String table) {
        if (schema != null && schema.trim().length() > 0 && !schema.trim().equals(defaultSchema)) {
            return schema.trim() + "." + table;
        }
        return table;
    }

    public Set<Table> findTables(Session session) throws Exception {
        Map<Integer, Column> pk;
        Table tmp;
        PrimaryKeyFactory primaryKeyFactory = new PrimaryKeyFactory();
        HashSet<Table> tables = new HashSet<Table>();
        DatabaseMetaData metaData = session.getMetaData();
        Quoting quoting = new Quoting(metaData);
        ResultSet resultSet = metaData.getTables(null, session.getIntrospectionSchema(), "%", new String[]{"TABLE"});
        ArrayList<String> tableNames = new ArrayList<String>();
        while (resultSet.next()) {
            String tableName = resultSet.getString(3);
            if ("TABLE".equalsIgnoreCase(resultSet.getString(4))) {
                if (this.isValidName(tableName)) {
                    String schemaName;
                    tableName = quoting.quote(tableName);
                    if (CommandLineParser.getInstance().qualifyNames && (schemaName = resultSet.getString(2)) != null && (schemaName = quoting.quote(schemaName.trim())).length() > 0) {
                        tableName = schemaName + "." + tableName;
                    }
                    tableNames.add(tableName);
                    _log.info("found table " + tableName);
                } else {
                    _log.info("skip table " + tableName);
                }
            }
            CancellationHandler.checkForCancellation(null);
        }
        resultSet.close();
        HashMap<String, HashMap<Integer, Column>> pkColumns = new HashMap<String, HashMap<Integer, Column>>();
        for (String tableName : tableNames) {
            tmp = new Table(tableName, null, false);
            resultSet = metaData.getPrimaryKeys(null, quoting.unquote(tmp.getOriginalSchema(quoting.quote(session.getIntrospectionSchema()))), quoting.unquote(tmp.getUnqualifiedName()));
            pk = (HashMap<Integer, Column>)pkColumns.get(tableName);
            if (pk == null) {
                pk = new HashMap<Integer, Column>();
                pkColumns.put(tableName, (HashMap<Integer, Column>)pk);
            }
            boolean hasPK = false;
            int nextKeySeq = 0;
            while (resultSet.next()) {
                hasPK = true;
                int keySeq = resultSet.getInt(5);
                if (session.dbms == DBMS.SQLITE) {
                    keySeq = nextKeySeq++;
                }
                pk.put(keySeq, new Column(quoting.quote(resultSet.getString(4)), "", 0, -1));
            }
            if (!hasPK) {
                _log.info("find unique index of table " + tableName);
                hasPK = this.findUniqueIndexBasedKey(metaData, quoting, session, tmp, pk);
            }
            if (!hasPK) {
                _log.info("find unique index of table " + tableName);
                hasPK = this.findUniqueIndexBasedKey(metaData, quoting, session, tmp, pk);
            }
            _log.info((hasPK ? "" : "no ") + "primary key found for table " + tableName);
            resultSet.close();
            CancellationHandler.checkForCancellation(null);
        }
        for (String tableName : tableNames) {
            tmp = new Table(tableName, null, false);
            _log.info("getting columns for " + quoting.unquote(tmp.getOriginalSchema(quoting.quote(session.getIntrospectionSchema()))) + "." + quoting.unquote(tmp.getUnqualifiedName()));
            resultSet = metaData.getColumns(null, quoting.unquote(tmp.getOriginalSchema(quoting.quote(session.getIntrospectionSchema()))), quoting.unquote(tmp.getUnqualifiedName()), "%");
            _log.info("done");
            pk = (Map)pkColumns.get(tableName);
            while (resultSet.next()) {
                String colName = quoting.quote(resultSet.getString(4));
                int type = resultSet.getInt(5);
                int length = 0;
                int precision = -1;
                String sqlType = this.toSqlType(resultSet.getString(6), session.dbms);
                if ((sqlType == null || sqlType.trim().length() == 0 || resultSet.wasNull()) && (sqlType = SqlUtil.SQL_TYPE.get(type)) == null) {
                    throw new RuntimeException("unknown SQL type: " + type);
                }
                if (this.typesWithLength.contains(sqlType.toUpperCase()) || type == 2 || type == 3 || type == 12 || type == 1 || type == -2 || type == -3) {
                    length = resultSet.getInt(7);
                }
                if (sqlType != null && sqlType.equalsIgnoreCase("uniqueidentifier")) {
                    length = 0;
                }
                if (type == 2 || type == 3 || type == 12 || type == 1) {
                    precision = resultSet.getInt(9);
                    if (resultSet.wasNull() || precision == 0) {
                        precision = -1;
                    }
                }
                if (type == 2001) {
                    length = 0;
                    precision = -1;
                }
                Column column = new Column(colName, sqlType, this.filterLength(length, resultSet.getString(6), type, session.dbms, resultSet.getInt(7)), precision);
                for (int i : pk.keySet()) {
                    if (!pk.get((Object)Integer.valueOf((int)i)).name.equals(column.name)) continue;
                    pk.put(i, column);
                }
            }
            resultSet.close();
            _log.info("read primary key type for table " + tableName);
            ArrayList<Integer> keySeqs = new ArrayList<Integer>(pk.keySet());
            Collections.sort(keySeqs);
            ArrayList<Column> columns = new ArrayList<Column>();
            Iterator i$ = keySeqs.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Column column = pk.get(i);
                if (column.type == null || column.type.trim().length() <= 0) continue;
                columns.add(column);
            }
            PrimaryKey primaryKey = primaryKeyFactory.createPrimaryKey(columns);
            Table table = new Table(tableName, primaryKey, false);
            table.setAuthor(metaData.getDriverName());
            tables.add(table);
            CancellationHandler.checkForCancellation(null);
        }
        return tables;
    }

    private boolean findUniqueIndexBasedKey(DatabaseMetaData metaData, Quoting quoting, Session session, Table tmp, Map<Integer, Column> pk) {
        try {
            ResultSet resultSet = metaData.getColumns(null, quoting.unquote(tmp.getOriginalSchema(quoting.quote(session.getIntrospectionSchema()))), quoting.unquote(tmp.getUnqualifiedName()), "%");
            ArrayList<String> nonNullColumns = new ArrayList<String>();
            boolean hasNullable = false;
            while (resultSet.next()) {
                int type = resultSet.getInt(5);
                if (resultSet.getInt(11) == 0) {
                    nonNullColumns.add(resultSet.getString(4));
                    if (type == -5 || type == 16 || type == 1 || type == 91 || type == 3 || type == 8 || type == 6 || type == 4 || type == -15 || type == -9 || type == 7 || type == 5 || type == 92 || type == 93 || type == -6 || type == 12) continue;
                    hasNullable = true;
                    continue;
                }
                hasNullable = true;
            }
            resultSet.close();
            if (nonNullColumns.isEmpty()) {
                return false;
            }
            resultSet = metaData.getIndexInfo(null, quoting.unquote(tmp.getOriginalSchema(quoting.quote(session.getIntrospectionSchema()))), quoting.unquote(tmp.getUnqualifiedName()), true, true);
            TreeMap<String, ArrayList<String>> indexes = new TreeMap<String, ArrayList<String>>();
            while (resultSet.next()) {
                String indexName = resultSet.getString(6);
                if (indexName == null) continue;
                ArrayList<String> indexColumns = (ArrayList<String>)indexes.get(indexName);
                if (indexColumns == null) {
                    indexColumns = new ArrayList<String>();
                    indexes.put(indexName, indexColumns);
                }
                indexColumns.add(resultSet.getString(9));
            }
            resultSet.close();
            for (String index : indexes.keySet()) {
                ArrayList<Column> columns = new ArrayList<Column>();
                boolean isNullable = false;
                for (String column : (List)indexes.get(index)) {
                    if (column == null || !nonNullColumns.contains(column)) {
                        isNullable = true;
                        break;
                    }
                    columns.add(new Column(quoting.quote(column), "", 0, -1));
                }
                if (isNullable || columns.isEmpty()) continue;
                for (int i = 1; i <= columns.size(); ++i) {
                    pk.put(i, (Column)columns.get(i - 1));
                }
                return true;
            }
            if (!hasNullable && nonNullColumns.size() <= 6) {
                for (int i = 1; i <= nonNullColumns.size(); ++i) {
                    pk.put(i, new Column(quoting.quote((String)nonNullColumns.get(i - 1)), "", 0, -1));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            _log.error(e.getMessage(), e);
            return false;
        }
    }

    private boolean isValidName(String name) {
        return name != null && !name.contains("$") && !name.contains("/") && !name.contains("=");
    }

    public static List<String> getSchemas(Session session, String userName) throws Exception {
        ArrayList<String> schemas;
        block3: {
            schemas = new ArrayList<String>();
            try {
                DatabaseMetaData metaData = session.getMetaData();
                ResultSet rs = metaData.getSchemas();
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM").trim();
                    if (schema == null || session.dbms == DBMS.POSTGRESQL && schema.startsWith("pg_toast_temp")) continue;
                    schemas.add(schema);
                }
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (userName == null) break block3;
                schemas.add(userName);
            }
        }
        return schemas;
    }

    public static String getDefaultSchema(Session session, String userName) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = session.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            boolean isPostgreSQL = dbName != null && dbName.toLowerCase().contains("PostgreSQL".toLowerCase());
            boolean isH2Sql = dbName != null && dbName.toLowerCase().startsWith("H2".toLowerCase());
            ResultSet rs = metaData.getSchemas();
            while (rs.next()) {
                schemas.add(rs.getString("TABLE_SCHEM"));
            }
            rs.close();
            String userSchema = null;
            Iterator i = schemas.iterator();
            while (i.hasNext()) {
                String schema = ((String)i.next()).trim();
                if ((isPostgreSQL || isH2Sql) && "public".equalsIgnoreCase(schema)) {
                    return schema;
                }
                if (!schema.equalsIgnoreCase(userName.trim())) {
                    rs = metaData.getTables(null, schema, "%", new String[]{"TABLE"});
                    if (!rs.next()) {
                        i.remove();
                    }
                    rs.close();
                    continue;
                }
                userSchema = schema;
            }
            if (userSchema != null) {
                return userSchema;
            }
            return userName;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return userName;
        }
    }

    @Override
    public List<Column> findColumns(Table table, Session session) throws Exception {
        ArrayList<Column> columns = new ArrayList<Column>();
        DatabaseMetaData metaData = session.getMetaData();
        Quoting quoting = new Quoting(metaData);
        if (this.forDefaultSchema != session) {
            this.forDefaultSchema = session;
            _log.info("getting default schema...");
            this.defaultSchema = JDBCMetaDataBasedModelElementFinder.getDefaultSchema(session, session.dbUser);
            _log.info("default schema is '" + this.defaultSchema + "'");
        }
        _log.info("getting columns for " + table.getOriginalSchema(this.defaultSchema) + "." + quoting.unquote(table.getUnqualifiedName()));
        ResultSet resultSet = metaData.getColumns(null, quoting.unquote(table.getOriginalSchema(this.defaultSchema)), quoting.unquote(table.getUnqualifiedName()), "%");
        _log.info("done");
        while (resultSet.next()) {
            String sqlType;
            String colName = quoting.quote(resultSet.getString(4));
            int type = resultSet.getInt(5);
            int length = 0;
            int precision = -1;
            if (type == 2 || type == 3 || type == 12 || type == 1) {
                length = resultSet.getInt(7);
            }
            if (type == 2 || type == 3 || type == 12 || type == 1) {
                precision = resultSet.getInt(9);
                if (resultSet.wasNull() || precision == 0) {
                    precision = -1;
                }
            }
            if (((sqlType = this.toSqlType(resultSet.getString(6), session.dbms)) == null || sqlType.trim().length() == 0 || resultSet.wasNull()) && (sqlType = SqlUtil.SQL_TYPE.get(type)) == null) continue;
            if (this.typesWithLength.contains(sqlType.toUpperCase()) || type == 2 || type == 3 || type == 12 || type == 1 || type == -2 || type == -3) {
                length = resultSet.getInt(7);
                if (type == 12 && Configuration.forDbms(session).getVarcharLengthLimit() != null) {
                    length = Math.min(length, Configuration.forDbms(session).getVarcharLengthLimit());
                }
            }
            if (sqlType != null && sqlType.equalsIgnoreCase("uniqueidentifier")) {
                length = 0;
            }
            if (type == 2 || type == 3 || type == 12 || type == 1) {
                precision = resultSet.getInt(9);
                if (resultSet.wasNull() || precision == 0) {
                    precision = -1;
                }
            }
            if (type == 2001) {
                length = 0;
                precision = -1;
            }
            _log.debug("column info: '" + colName + "' '" + sqlType + "' " + type + " '" + resultSet.getString(6) + "'");
            columns.add(new Column(colName, sqlType, this.filterLength(length, resultSet.getString(6), type, session.dbms, resultSet.getInt(7)), precision));
        }
        resultSet.close();
        _log.info("found columns for table " + table.getName());
        return columns;
    }

    private int filterLength(int length, String typeName, int type, DBMS dbms, int origLength) {
        if (length > 0) {
            if (dbms == DBMS.POSTGRESQL) {
                if (type == 12 && length >= 0xA00000) {
                    length = 0;
                } else if (type == 2 && length > 1000) {
                    length = 0;
                } else if ("bytea".equalsIgnoreCase(typeName)) {
                    length = 0;
                }
            } else if (dbms == DBMS.SQLITE) {
                return 0;
            }
        } else if (dbms == DBMS.POSTGRESQL && "bit".equalsIgnoreCase(typeName)) {
            length = origLength;
        }
        return length;
    }

    private String toSqlType(String sqlType, DBMS dbms) {
        if (sqlType == null) {
            return null;
        }
        sqlType = sqlType.trim();
        if (dbms == DBMS.MySQL && (sqlType.equalsIgnoreCase("SET") || sqlType.equalsIgnoreCase("ENUM"))) {
            return "VARCHAR";
        }
        if (!sqlType.toLowerCase().endsWith(" identity")) {
            int i = sqlType.indexOf(32);
            if (i > 0) {
                sqlType = sqlType.substring(0, i);
            }
            if ((i = sqlType.indexOf(40)) > 0) {
                sqlType = sqlType.substring(0, i);
            }
        }
        return sqlType;
    }

    public String toString() {
        return "JDBC based model element finder";
    }
}

