/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.modelbuilder;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKeyFactory;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.ModelElementFinder;
import net.sf.jailer.util.PrintUtil;
import org.apache.log4j.Logger;

public class DBMetaDataBasedModelElementFinder
implements ModelElementFinder {
    private static final Logger _log = Logger.getLogger(DBMetaDataBasedModelElementFinder.class);
    private final String selectTablesScript;
    private final String selectColumnsScript;
    private final String selectForeignKeysScript;

    public DBMetaDataBasedModelElementFinder(String selectTablesScript, String selectForeignKeysScript, String selectColumnsScript) {
        this.selectTablesScript = selectTablesScript;
        this.selectForeignKeysScript = selectForeignKeysScript;
        this.selectColumnsScript = selectColumnsScript;
    }

    @Override
    public Collection<Association> findAssociations(DataModel dataModel, Map<Association, String[]> namingSuggestion, Session session) throws Exception {
        ArrayList<Association> associations = new ArrayList<Association>();
        associations.addAll(this.findAssociations(dataModel, this.selectForeignKeysScript, session));
        return associations;
    }

    private Collection<Association> findAssociations(final DataModel dataModel, final String sqlFileName, Session session) throws Exception {
        final ArrayList<Association> associations = new ArrayList<Association>();
        String select = PrintUtil.applyTemplate(sqlFileName, new Object[]{session.getSchemaName()});
        session.executeQuery(select, (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                String tableA = resultSet.getString(1);
                String tableB = resultSet.getString(2);
                String firstInsert = resultSet.getString(3);
                Cardinality cardinality = Cardinality.parse(resultSet.getString(4));
                String joinCondition = resultSet.getString(5);
                Table a = dataModel.getTable(tableA);
                Table b = dataModel.getTable(tableB);
                if (a == null || b == null) {
                    _log.info("ignoring " + tableA + " -> " + tableB);
                    return;
                }
                boolean insertSourceBeforeDestination = "A".equalsIgnoreCase(firstInsert);
                boolean insertDestinationBeforeSource = "B".equalsIgnoreCase(firstInsert);
                Association association = new Association(a, b, insertSourceBeforeDestination, insertDestinationBeforeSource, joinCondition, dataModel, false, cardinality);
                association.setAuthor("DB:" + sqlFileName);
                associations.add(association);
            }
        });
        return associations;
    }

    public Set<Table> findTables(Session session) throws Exception {
        PrimaryKeyFactory primaryKeyFactory = new PrimaryKeyFactory();
        TreeSet<Table> tables = new TreeSet<Table>();
        String select = PrintUtil.applyTemplate(this.selectTablesScript, new Object[]{session.getSchemaName()});
        final HashMap pkColumns = new HashMap();
        session.executeQuery(select, (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                String tableName = resultSet.getString(1);
                HashMap<Integer, Column> pk = (HashMap<Integer, Column>)pkColumns.get(tableName);
                if (pk == null) {
                    pk = new HashMap<Integer, Column>();
                    pkColumns.put(tableName, pk);
                }
                String name = resultSet.getString(2);
                String type = resultSet.getString(3);
                int size = resultSet.getInt(4);
                int scale = resultSet.getInt(5);
                int keySeq = resultSet.getInt(6);
                pk.put(new Integer(keySeq), new Column(name, type, size, scale > 0 && size > 0 ? scale : -1));
            }
        });
        for (String tableName : pkColumns.keySet()) {
            ArrayList<Column> pk = new ArrayList<Column>();
            ArrayList keySeqs = new ArrayList(((Map)pkColumns.get(tableName)).keySet());
            Collections.sort(keySeqs);
            for (Integer i : keySeqs) {
                pk.add((Column)((Map)pkColumns.get(tableName)).get(i));
            }
            Table table = new Table(tableName, primaryKeyFactory.createPrimaryKey(pk), false);
            table.setAuthor(this.selectTablesScript);
            tables.add(table);
        }
        return tables;
    }

    @Override
    public List<Column> findColumns(Table table, Session session) throws Exception {
        String select = PrintUtil.applyTemplate(this.selectColumnsScript, new Object[]{session.getSchemaName(), table.getName()});
        final ArrayList<Column> columns = new ArrayList<Column>();
        session.executeQuery(select, (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                String name = resultSet.getString(2);
                String type = resultSet.getString(3);
                int size = resultSet.getInt(4);
                int scale = resultSet.getInt(5);
                columns.add(new Column(name, type, size, scale > 0 && size > 0 ? scale : -1));
            }
        });
        return columns;
    }
}

