/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.liquibase;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.entitygraph.EntityGraph;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LiquibaseXMLTransformer
extends Session.AbstractResultSetReader {
    private static final String VALUE_DATE = "valueDate";
    private static final String VALUE_NUMERIC = "valueNumeric";
    private static final String VALUE_CLOBFILE = "valueClobFile";
    private static final String VALUE_NCLOBFILE = "valueNClobFile";
    private static final String VALUE_BLOBFILE = "valueBlobFile";
    private static final String VALUE = "value";
    private final String rowElementName;
    private final TransformerHandler transformerHandler;
    private final File scriptFile;
    private final EntityGraph entityGraph;
    private final SimpleDateFormat datePattern;
    private final SimpleDateFormat timePattern;
    private final SimpleDateFormat timestampPattern;

    public LiquibaseXMLTransformer(Table table, TransformerHandler transformerHandler, DatabaseMetaData metaData, EntityGraph entityGraph, String scriptFile, String datePattern, String timePattern, String timestampPattern) throws SQLException {
        this.transformerHandler = transformerHandler;
        this.entityGraph = entityGraph;
        this.rowElementName = this.qualifiedTableName(table);
        this.scriptFile = new File(scriptFile);
        this.datePattern = new SimpleDateFormat(datePattern);
        this.timePattern = new SimpleDateFormat(timePattern);
        this.timestampPattern = new SimpleDateFormat(timestampPattern);
    }

    private String qualifiedTableName(Table t) {
        String schema = t.getOriginalSchema("");
        String mappedSchema = CommandLineParser.getInstance().getSchemaMapping().get(schema);
        if (mappedSchema != null) {
            schema = mappedSchema;
        }
        if (schema.length() == 0) {
            return this.unquote(t.getUnqualifiedName());
        }
        return this.unquote(schema) + "." + this.unquote(t.getUnqualifiedName());
    }

    private String unquote(String name) {
        String fcStr;
        char fc;
        if (!name.isEmpty() && !Character.isLetterOrDigit(fc = name.charAt(0)) && fc != '_' && name.startsWith(fcStr = Character.toString(fc)) && name.endsWith(fcStr)) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readCurrentRow(ResultSet singleRow) throws SQLException {
        int columnCount = this.getMetaData(singleRow).getColumnCount();
        try {
            AttributesImpl attrinsert = new AttributesImpl();
            attrinsert.addAttribute("", "", "tableName", "", this.rowElementName);
            TransformerHandler transformerHandler = this.transformerHandler;
            synchronized (transformerHandler) {
                this.transformerHandler.startElement("", "", "insert", attrinsert);
                for (int i = 1; i <= columnCount; ++i) {
                    AttributesImpl attrcolumn = this.getColumnAttributes(singleRow, i);
                    if (attrcolumn.getValue("name") == null) continue;
                    this.transformerHandler.startElement("", "", "column", attrcolumn);
                    this.transformerHandler.endElement("", "", "column");
                }
                this.transformerHandler.endElement("", "", "insert");
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private AttributesImpl getColumnAttributes(ResultSet singleRow, int columncount) throws SQLException {
        AttributesImpl attrcolumn = new AttributesImpl();
        String columnname = this.getMetaData(singleRow).getColumnName(columncount);
        Integer columnType = this.getMetaData(singleRow).getColumnType(columncount);
        singleRow.getObject(columncount);
        if (!singleRow.wasNull()) {
            switch (columnType) {
                case 2005: {
                    int count = this.entityGraph.incLobCount();
                    Clob clobValue = singleRow.getClob(columncount);
                    int lengthc = (int)clobValue.length();
                    if (lengthc > 0) {
                        String clobcontent = clobValue.getSubString(1L, lengthc);
                        String clobname = this.lobName(count, ".txt");
                        attrcolumn = this.createAttribute(columnname, VALUE_CLOBFILE, clobname);
                        this.writeClob(clobcontent, clobname);
                        break;
                    }
                    attrcolumn = this.createAttribute(columnname, VALUE_CLOBFILE, null);
                    break;
                }
                case 2011: {
                    int count = this.entityGraph.incLobCount();
                    NClob nclobValue = singleRow.getNClob(columncount);
                    int lengthnc = (int)nclobValue.length();
                    if (lengthnc > 0) {
                        String nclobcontent = nclobValue.getSubString(1L, lengthnc);
                        String nclobname = this.lobName(count, ".txt");
                        attrcolumn = this.createAttribute(columnname, VALUE_NCLOBFILE, nclobname);
                        this.writeClob(nclobcontent, nclobname);
                        break;
                    }
                    attrcolumn = this.createAttribute(columnname, VALUE_NCLOBFILE, null);
                    break;
                }
                case 2004: {
                    int count = this.entityGraph.incLobCount();
                    Blob blob = singleRow.getBlob(columncount);
                    int lengthb = (int)blob.length();
                    if (lengthb > 0) {
                        byte[] blobcontent = blob.getBytes(1L, lengthb);
                        String blobname = this.lobName(count, ".bin");
                        attrcolumn = this.createAttribute(columnname, VALUE_BLOBFILE, blobname);
                        this.writeBlob(blobcontent, blobname);
                        break;
                    }
                    attrcolumn = this.createAttribute(columnname, VALUE_BLOBFILE, null);
                    break;
                }
                case 93: {
                    Timestamp ts = singleRow.getTimestamp(columncount);
                    String datetimestamp = this.timestampPattern.format(ts);
                    attrcolumn = this.createAttribute(columnname, VALUE_DATE, datetimestamp);
                    break;
                }
                case 92: {
                    Timestamp t = singleRow.getTimestamp(columncount);
                    String datetime = this.timePattern.format(t);
                    attrcolumn = this.createAttribute(columnname, VALUE_DATE, datetime);
                    break;
                }
                case 91: {
                    Timestamp d = singleRow.getTimestamp(columncount);
                    String datedate = this.datePattern.format(d);
                    attrcolumn = this.createAttribute(columnname, VALUE_DATE, datedate);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigdecimalvalue = singleRow.getBigDecimal(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE_NUMERIC, bigdecimalvalue.toString());
                    break;
                }
                case 4: 
                case 5: {
                    Integer integervalue = singleRow.getInt(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE_NUMERIC, integervalue.toString());
                    break;
                }
                case 6: {
                    Float floatvalue = Float.valueOf(singleRow.getFloat(columncount));
                    attrcolumn = this.createAttribute(columnname, VALUE_NUMERIC, floatvalue.toString());
                    break;
                }
                case 8: {
                    Double doublevalue = singleRow.getDouble(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE_NUMERIC, doublevalue.toString());
                    break;
                }
                case -8: {
                    RowId rowidvalue = singleRow.getRowId(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE, rowidvalue.toString());
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    attrcolumn = this.createAttribute(columnname, VALUE, singleRow.getString(columncount));
                    break;
                }
                case 16: {
                    boolean booleanvalue = singleRow.getBoolean(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE, Boolean.toString(booleanvalue));
                    break;
                }
                case 2003: {
                    Array arrayvalue = singleRow.getArray(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE, arrayvalue.toString());
                    break;
                }
                case 2006: {
                    Ref refvalue = singleRow.getRef(columncount);
                    attrcolumn = this.createAttribute(columnname, VALUE, refvalue.toString());
                    break;
                }
                default: {
                    attrcolumn = this.createAttribute(columnname, VALUE_NUMERIC, singleRow.getString(columncount));
                    break;
                }
            }
        } else {
            attrcolumn = this.createAttribute(columnname, null, null);
        }
        return attrcolumn;
    }

    private String lobName(int count, String suffix) {
        long folderNumber;
        String path = "";
        int MAX_FILES_PER_FOLDER = 100;
        long i = 1L;
        while ((folderNumber = (long)count / (i *= 100L) * i) > 0L) {
            path = File.separator + folderNumber + path;
        }
        return this.scriptFile.getName() + ".lob" + File.separator + this.rowElementName.toLowerCase() + path + File.separator + count + suffix;
    }

    private AttributesImpl createAttribute(String columnname, String valuetype, String value) {
        AttributesImpl attrcolumn = new AttributesImpl();
        attrcolumn.addAttribute("", "", "name", "", columnname);
        if (valuetype != null && value != null) {
            attrcolumn.addAttribute("", "", valuetype, "", value);
        }
        return attrcolumn;
    }

    private void writeClob(String clobcontent, String clobname) {
        File lobFile = this.getLobFile(clobname);
        try {
            FileOutputStream fos = new FileOutputStream(lobFile);
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
                try {
                    out.write(clobcontent);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBlob(byte[] blobcontent, String blobname) {
        File lobFile = this.getLobFile(blobname);
        try {
            FileOutputStream fos = new FileOutputStream(lobFile);
            try {
                fos.write(blobcontent);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private File getLobFile(String lobname) {
        File lobFile = new File(this.scriptFile.getParent(), lobname);
        File parent = lobFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return lobFile;
    }

    @Override
    public void close() {
    }
}

