/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.extractionmodel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ParameterHandler;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.restrictionmodel.RestrictionModel;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class ExtractionModel {
    private static final Logger _log = Logger.getLogger(ExtractionModel.class);
    public final Table subject;
    public String condition;
    public final long limit;
    public final DataModel dataModel;

    public ExtractionModel(DataModel dataModel) throws Exception {
        this.dataModel = dataModel;
        this.subject = dataModel.getTables().iterator().hasNext() ? dataModel.getTables().iterator().next() : null;
        this.condition = "";
        dataModel.setRestrictionModel(new RestrictionModel(dataModel));
        this.limit = -1L;
    }

    public ExtractionModel(String fileName, Map<String, String> sourceSchemaMapping, Map<String, String> parameters) throws Exception {
        String condition;
        List<CsvFile.Line> csv = new CsvFile(CommandLineParser.getInstance().newFile(fileName)).getLines();
        if (csv.isEmpty()) {
            throw new RuntimeException("file '" + fileName + "' is empty");
        }
        CsvFile.Line subjectLine = csv.get(0);
        String location = subjectLine.location;
        DataModel dataModel = new DataModel(sourceSchemaMapping);
        Table subject = dataModel.getTable(SqlUtil.mappedSchema(sourceSchemaMapping, subjectLine.cells.get(0)));
        if (subject == null) {
            _log.warn(location + ": unknown table " + subjectLine.cells.get(0));
        }
        if ("".equals(condition = subjectLine.cells.get(1))) {
            condition = "1=1";
        }
        long limit = 0L;
        if (!"".equals(subjectLine.cells.get(2))) {
            try {
                limit = Long.parseLong(subjectLine.cells.get(2));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(location, e);
            }
        }
        int i = 3;
        while (subjectLine.cells.get(i).length() > 0) {
            if (dataModel.getRestrictionModel() == null) {
                dataModel.setRestrictionModel(new RestrictionModel(dataModel));
            }
            try {
                dataModel.getRestrictionModel().addRestrictionDefinition(subjectLine.cells.get(i), fileName, parameters);
            }
            catch (Exception e) {
                throw new RuntimeException(location, e);
            }
            ++i;
        }
        this.subject = subject;
        this.condition = condition;
        this.limit = limit;
        this.dataModel = dataModel;
        List<CsvFile.Line> xmlMapping = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "xml-mapping").getLines();
        for (CsvFile.Line xmLine : xmlMapping) {
            location = subjectLine.location;
            String name = xmLine.cells.get(0);
            String tag = xmLine.cells.get(1);
            AggregationSchema aggregationSchema = AggregationSchema.valueOf(xmLine.cells.get(2));
            Association association = dataModel.namedAssociations.get(name);
            if (association == null) {
                _log.warn("unknown association '" + name + "'");
                continue;
            }
            if (aggregationSchema != null) {
                association.setAggregationSchema(aggregationSchema);
            }
            association.setAggregationTagName(tag);
        }
        List<CsvFile.Line> upserts = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "upserts").getLines();
        for (CsvFile.Line upsert : upserts) {
            location = subjectLine.location;
            String name = upsert.cells.get(0);
            String tag = upsert.cells.get(1);
            Table table = dataModel.getTable(name);
            if (table == null) {
                _log.warn("unknown table '" + name + "'");
                continue;
            }
            table.upsert = Boolean.parseBoolean(tag);
        }
        List<CsvFile.Line> exportModusFile = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "export modus").getLines();
        Iterator<CsvFile.Line> i2 = exportModusFile.iterator();
        if (i2.hasNext()) {
            dataModel.setExportModus(i2.next().cells.get(0));
        }
        List<CsvFile.Line> columnMappingFile = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "xml column mapping").getLines();
        for (CsvFile.Line xmLine : columnMappingFile) {
            String name = xmLine.cells.get(0);
            String mapping = xmLine.cells.get(1);
            Table table = dataModel.getTable(SqlUtil.mappedSchema(sourceSchemaMapping, name));
            if (table == null) {
                _log.warn("unknown table" + name);
                continue;
            }
            table.setXmlTemplate(ParameterHandler.assignParameterValues(mapping, parameters));
        }
        List<CsvFile.Line> filtersFile = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "filters").getLines();
        for (CsvFile.Line xmLine : filtersFile) {
            String name = xmLine.cells.get(0);
            String column = xmLine.cells.get(1);
            String filter = xmLine.cells.get(2);
            Table table = dataModel.getTable(SqlUtil.mappedSchema(sourceSchemaMapping, name));
            if (table == null) {
                _log.warn("unknown table" + name);
                continue;
            }
            Column col = null;
            for (Column c : table.getColumns()) {
                if (!c.name.equals(column)) continue;
                col = c;
                break;
            }
            if (col == null) {
                _log.warn("unknown table" + name + "." + column);
                continue;
            }
            col.setFilterExpression(ParameterHandler.assignParameterValues(filter, parameters));
        }
        List<CsvFile.Line> xmlSettingsFile = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "xml settings").getLines();
        i2 = xmlSettingsFile.iterator();
        if (i2.hasNext()) {
            List<String> cells = i2.next().cells;
            dataModel.getXmlSettings().datePattern = cells.get(0);
            dataModel.getXmlSettings().timestampPattern = cells.get(1);
            dataModel.getXmlSettings().rootTag = cells.get(2);
        }
    }

    public static String loadDatamodelFolder(String fileName) throws Exception {
        List<CsvFile.Line> dmf = new CsvFile(CommandLineParser.getInstance().newFile(fileName), "datamodelfolder").getLines();
        if (dmf.size() > 0) {
            return dmf.get((int)0).cells.get(0);
        }
        return null;
    }
}

