/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.entitygraph.remote;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.entitygraph.EntityGraph;
import net.sf.jailer.progress.ProgressListenerRegistry;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;

public class RemoteEntityGraph
extends EntityGraph {
    public final Session session;
    private final PrimaryKey universalPrimaryKey;
    private int birthdayOfSubject = 0;
    private final Set<String> fieldProcTables = new HashSet<String>();
    private long totalRowcount = 0L;
    public static long maxTotalRowcount = 0L;
    private boolean explain = false;
    private int nextExplainID = 1;
    public Map<Association, Integer> explainIdOfAssociation = new HashMap<Association, Integer>();
    private int nextSetId = 1;

    private RemoteEntityGraph(DataModel dataModel, int graphID, Session session, PrimaryKey universalPrimaryKey) {
        super(graphID, dataModel);
        this.session = session;
        this.universalPrimaryKey = universalPrimaryKey;
        File fieldProcTablesFile = new File("field-proc-tables.csv");
        if (fieldProcTablesFile.exists()) {
            try {
                for (CsvFile.Line line : new CsvFile(fieldProcTablesFile).getLines()) {
                    this.fieldProcTables.add(line.cells.get(0).toLowerCase());
                }
                Session._log.info("tables with field procedures: " + this.fieldProcTables);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void setBirthdayOfSubject(int birthdayOfSubject) {
        this.birthdayOfSubject = birthdayOfSubject;
    }

    public static RemoteEntityGraph create(DataModel dataModel, int graphID, Session session, PrimaryKey universalPrimaryKey) {
        RemoteEntityGraph entityGraph = new RemoteEntityGraph(dataModel, graphID, session, universalPrimaryKey);
        try {
            session.executeUpdate("Insert into " + SQLDialect.dmlTableReference("JAILER_GRAPH", session) + "(id, age) values (" + graphID + ", 1)");
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't find working tables! Run 'bin/jailer.sh create-ddl' and execute the DDL-script first!", e);
        }
        return entityGraph;
    }

    @Override
    public EntityGraph copy(int newGraphID, Session session) throws SQLException {
        RemoteEntityGraph entityGraph = RemoteEntityGraph.create(this.dataModel, newGraphID, session, this.universalPrimaryKey);
        entityGraph.setBirthdayOfSubject(this.birthdayOfSubject);
        session.executeUpdate("Insert into " + SQLDialect.dmlTableReference("JAILER_ENTITY", session) + "(r_entitygraph, " + this.universalPrimaryKey.columnList(null) + ", birthday, orig_birthday, type) " + "Select " + newGraphID + ", " + this.universalPrimaryKey.columnList(null) + ", birthday, birthday, type From " + SQLDialect.dmlTableReference("JAILER_ENTITY", session) + " Where r_entitygraph=" + this.graphID + "");
        return entityGraph;
    }

    @Override
    public EntityGraph find(int graphID, Session session, PrimaryKey universalPrimaryKey) throws SQLException {
        RemoteEntityGraph entityGraph = new RemoteEntityGraph(this.dataModel, graphID, session, universalPrimaryKey);
        final boolean[] found = new boolean[]{false};
        session.executeQuery("Select * From " + SQLDialect.dmlTableReference("JAILER_GRAPH", session) + "Where id=" + graphID + "", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                found[0] = true;
            }

            @Override
            public void close() {
            }
        });
        if (!found[0]) {
            throw new RuntimeException("entity-graph " + graphID + " not found");
        }
        return entityGraph;
    }

    public static int createUniqueGraphID() {
        return Math.abs((int)System.currentTimeMillis());
    }

    @Override
    public int getAge() throws SQLException {
        final int[] age = new int[]{-1};
        this.session.executeQuery("Select age From " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.session) + " Where id=" + this.graphID + "", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                age[0] = resultSet.getInt(1);
            }

            @Override
            public void close() {
            }
        });
        return age[0];
    }

    @Override
    public void setAge(int age) throws SQLException {
        this.session.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.session) + " Set age=" + age + " Where id=" + this.graphID + "");
    }

    @Override
    public long getSize() throws SQLException {
        final int[] size = new int[]{-1};
        this.session.executeQuery("Select count(*) From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " Where r_entitygraph=" + this.graphID + " and birthday >= 0", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                size[0] = resultSet.getInt(1);
            }

            @Override
            public void close() {
            }
        });
        return size[0];
    }

    @Override
    public void delete() throws SQLException {
        this.session.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " Where r_entitygraph=" + this.graphID + "");
        this.session.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " Where r_entitygraph=" + this.graphID + "");
        this.session.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.session) + " Where id=" + this.graphID + "");
    }

    @Override
    public long addEntities(Table table, String condition, int today, long limit) throws SQLException {
        return this.addEntities(table, "T", condition, null, null, null, null, false, today, limit, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long resolveAssociation(Table table, Association association, int today) throws SQLException {
        String jc = association.getJoinCondition();
        if (jc != null) {
            String sourceAlias;
            String destAlias;
            if (association.reversed) {
                destAlias = "A";
                sourceAlias = "B";
            } else {
                destAlias = "B";
                sourceAlias = "A";
            }
            Integer associationExplanationID = 0;
            if (this.explain) {
                Map<Association, Integer> map = this.explainIdOfAssociation;
                synchronized (map) {
                    associationExplanationID = this.explainIdOfAssociation.get(association);
                    if (associationExplanationID == null) {
                        associationExplanationID = this.nextExplainID++;
                        this.explainIdOfAssociation.put(association, associationExplanationID);
                    }
                }
            }
            return this.addEntities(association.destination, destAlias, "E.r_entitygraph=" + this.graphID + " and E.birthday = " + (today - 1) + " and E.type='" + table.getName() + "' and " + this.pkEqualsEntityID(table, sourceAlias, "E"), table, sourceAlias, association.source, jc, true, today, 0L, associationExplanationID, association.reversed);
        }
        return -1L;
    }

    private long addEntities(Table table, String alias, String condition, Table joinedTable, String joinedTableAlias, Table source, String joinCondition, boolean joinWithEntity, int today, long limit, int associationExplanationID, boolean isInverseAssociation) throws SQLException {
        if (maxTotalRowcount > 0L && limit == 0L) {
            limit = Math.max(maxTotalRowcount - this.totalRowcount + 1L, 1L);
        }
        if (joinCondition != null) {
            joinCondition = SqlUtil.resolvePseudoColumns(joinCondition, isInverseAssociation ? null : "E", isInverseAssociation ? "E" : null, today, this.birthdayOfSubject);
        }
        String select = Configuration.forDbms(this.session).isAvoidLeftJoin() ? "Select " + (joinedTable != null ? "distinct " : "") + "" + this.graphID + " as GRAPH_ID, " + this.pkList(table, alias) + ", " + today + " AS BIRTHDAY, '" + table.getName() + "' AS TYPE" + (source == null || !this.explain ? "" : ", " + associationExplanationID + " AS ASSOCIATION, '" + source.getName() + "' AS SOURCE_TYPE, " + this.pkList(source, joinedTableAlias, "PRE_")) + " From " + table.getName() + " " + alias + (joinedTable != null ? ", " + joinedTable.getName() + " " + joinedTableAlias + " " : "") + (joinWithEntity ? ", " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E" : "") + " Where (" + condition + ") " + (joinedTable != null ? " and (" + joinCondition + ")" : "") + " AND NOT EXISTS (select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " DuplicateExists where r_entitygraph=" + this.graphID + " " + "AND DuplicateExists.type='" + table.getName() + "' and " + this.pkEqualsEntityID(table, alias, "DuplicateExists") + ")" + (limit > 0L ? " fetch first " + limit + " rows only" : "") : "Select " + (joinedTable != null ? "distinct " : "") + "" + this.graphID + " as GRAPH_ID, " + this.pkList(table, alias) + ", " + today + " AS BIRTHDAY, '" + table.getName() + "' AS TYPE" + (source == null || !this.explain ? "" : ", " + associationExplanationID + " AS ASSOCIATION, '" + source.getName() + "' AS SOURCE_TYPE, " + this.pkList(source, joinedTableAlias, "PRE_")) + " From " + table.getName() + " " + alias + " left join " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " Duplicate on Duplicate.r_entitygraph=" + this.graphID + " and Duplicate.type='" + table.getName() + "' and " + this.pkEqualsEntityID(table, alias, "Duplicate") + (joinedTable != null ? ", " + joinedTable.getName() + " " + joinedTableAlias + " " : "") + (joinWithEntity ? ", " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E" : "") + " Where (" + condition + ") and Duplicate.type is null" + (joinedTable != null ? " and (" + joinCondition + ")" : "") + (limit > 0L ? " fetch first " + limit + " rows only" : "");
        if (source != null && this.explain) {
            String max = "";
            Map<Column, Column> match = this.universalPrimaryKey.match(source.primaryKey);
            for (Column column : this.universalPrimaryKey.getColumns()) {
                if (match.get(column) == null) continue;
                if (max.length() > 0) {
                    max = max + ", ";
                }
                max = max + "max(PRE_" + column.name + ")";
            }
            select = "Select GRAPH_ID, " + this.upkColumnList(table, null) + ", BIRTHDAY, TYPE, ASSOCIATION, max(SOURCE_TYPE), " + max + " From (" + select + ") Q " + "Group by GRAPH_ID, " + this.upkColumnList(table, null) + ", BIRTHDAY, TYPE, ASSOCIATION";
        }
        String insert = "Insert into " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " (r_entitygraph, " + this.upkColumnList(table, null) + ", birthday, type" + (source == null || !this.explain ? "" : ", association, PRE_TYPE, " + this.upkColumnList(source, "PRE_")) + ") " + select;
        if (SqlUtil.dbms == DBMS.SYBASE) {
            this.session.execute("set forceplan on ");
        }
        long rc = this.session.executeUpdate(insert);
        this.totalRowcount += rc;
        if (SqlUtil.dbms == DBMS.SYBASE) {
            this.session.execute("set forceplan off ");
        }
        return rc;
    }

    @Override
    public void addDependencies(Table from, String fromAlias, Table to, String toAlias, String condition, int aggregationId, int dependencyId, boolean isAssociationReversed) throws SQLException {
        condition = SqlUtil.resolvePseudoColumns(condition, isAssociationReversed ? "E1" : "E2", isAssociationReversed ? "E2" : "E1", 0, this.birthdayOfSubject);
        String insert = "Insert into " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + "(r_entitygraph, assoc, depend_id, from_type, to_type, " + this.upkColumnList(from, "FROM_") + ", " + this.upkColumnList(to, "TO_") + ") " + "Select " + this.graphID + ", " + aggregationId + ", " + dependencyId + ", '" + from.getName() + "', '" + to.getName() + "', " + this.pkList(from, fromAlias, "FROM") + ", " + this.pkList(to, toAlias, "TO") + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E1, " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E2, " + from.getName() + " " + fromAlias + " ," + to.getName() + " " + toAlias + " " + " Where E1.r_entitygraph=" + this.graphID + " and E2.r_entitygraph=" + this.graphID + "" + " and (" + condition + ")" + " and E1.type='" + from.getName() + "' and E2.type='" + to.getName() + "'" + " and " + this.pkEqualsEntityID(from, fromAlias, "E1") + " and " + this.pkEqualsEntityID(to, toAlias, "E2");
        this.totalRowcount += (long)this.session.executeUpdate(insert);
    }

    @Override
    public Set<Integer> getDistinctDependencyIDs() throws SQLException {
        String select = "Select distinct depend_id from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " Where r_entitygraph=" + this.graphID;
        final HashSet<Integer> ids = new HashSet<Integer>();
        this.session.executeQuery(select, new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                ids.add(resultSet.getInt(1));
            }

            @Override
            public void close() {
            }
        });
        return ids;
    }

    @Override
    public void markIndependentEntities(Table table) throws SQLException {
        StringBuffer fromEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (fromEqualsPK.length() > 0) {
                fromEqualsPK.append(" and ");
            }
            if (match.get(column) != null) {
                fromEqualsPK.append("D.FROM_" + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name);
                continue;
            }
            fromEqualsPK.append("D.FROM_" + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name + " is null");
        }
        this.session.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " set birthday=0 " + "Where r_entitygraph=" + this.graphID + " and birthday>0 and " + (table != null ? "type='" + table.getName() + "' and " : "") + "not exists (Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D " + "Where D.r_entitygraph=" + this.graphID + " and D.assoc=0 and D.from_type=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".type and " + fromEqualsPK + ")");
    }

    @Override
    public void markRoots(Table table) throws SQLException {
        StringBuffer toEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (toEqualsPK.length() > 0) {
                toEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                toEqualsPK.append("D.TO_" + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name);
                continue;
            }
            toEqualsPK.append("D.TO_" + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name + " is null");
        }
        this.session.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " set birthday=0 " + "Where r_entitygraph=" + this.graphID + " and birthday>0 and type='" + table.getName() + "' and " + "not exists (Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D " + "Where D.r_entitygraph=" + this.graphID + " and D.to_type=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".type and " + toEqualsPK + ")");
    }

    @Override
    public void readMarkedEntities(Table table, Session.ResultSetReader reader, boolean orderByPK) throws SQLException {
        this.readMarkedEntities(table, reader, this.filteredSelectionClause(table), orderByPK);
    }

    @Override
    public void readMarkedEntities(Table table, Session.ResultSetReader reader, String selectionSchema, boolean orderByPK) throws SQLException {
        String orderBy = "";
        if (orderByPK) {
            orderBy = " order by " + table.primaryKey.columnList("T.");
        }
        long rc = this.session.executeQuery("Select " + selectionSchema + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E join " + table.getName() + " T on " + this.pkEqualsEntityID(table, "T", "E") + " Where E.birthday=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'" + orderBy, reader);
        ProgressListenerRegistry.getProgressListener().exported(table, rc);
    }

    @Override
    public void readMarkedEntities(Table table, Session.ResultSetReader reader, String selectionSchema, String originalPKAliasPrefix, boolean orderByPK) throws SQLException {
        if (originalPKAliasPrefix == null) {
            this.readMarkedEntities(table, reader, selectionSchema, orderByPK);
            return;
        }
        String orderBy = "";
        StringBuffer sb = new StringBuffer();
        StringBuffer selectOPK = new StringBuffer();
        for (int i = 0; i < table.primaryKey.getColumns().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
                selectOPK.append(", ");
            }
            sb.append(originalPKAliasPrefix + i);
            selectOPK.append("T." + table.primaryKey.getColumns().get((int)i).name + " AS " + originalPKAliasPrefix + i);
        }
        orderBy = "order by " + sb;
        String sqlQuery = "Select " + selectionSchema + " From (" + "Select " + selectOPK + ", " + this.filteredSelectionClause(table) + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E join " + table.getName() + " T on " + this.pkEqualsEntityID(table, "T", "E") + " Where E.birthday=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'" + ") T ";
        long rc = this.session.executeQuery(sqlQuery + (orderByPK ? orderBy : ""), reader, !orderByPK ? sqlQuery : null, null, 0);
        ProgressListenerRegistry.getProgressListener().exported(table, rc);
    }

    @Override
    public void uniteWith(EntityGraph graph) throws SQLException {
        StringBuffer e1EqualsE2 = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (e1EqualsE2.length() > 0) {
                e1EqualsE2.append(" and ");
            }
            e1EqualsE2.append("E1." + column.name + "=E2." + column.name);
        }
        this.session.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E1 " + "set E1.r_entitygraph=" + this.graphID + " " + "Where E1.r_entitygraph=" + graph.graphID + " " + "and not exists(Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E2 Where " + "E2.r_entitygraph=" + this.graphID + " and " + e1EqualsE2 + ")");
        graph.delete();
    }

    @Override
    public void readEntities(Table table, Session.ResultSetReader reader, boolean orderByPK) throws SQLException {
        long rc;
        String sqlQuery = "Select " + this.filteredSelectionClause(table) + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E join " + table.getName() + " T on " + this.pkEqualsEntityID(table, "T", "E") + " Where E.birthday>=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'";
        if (orderByPK) {
            String sqlQueryWithOrderBy = sqlQuery + (orderByPK ? " order by " + table.primaryKey.columnList("T.") : "");
            rc = this.session.executeQuery(sqlQueryWithOrderBy, reader, sqlQuery, null, 0);
        } else {
            rc = this.session.executeQuery(sqlQuery, reader);
        }
        ProgressListenerRegistry.getProgressListener().exported(table, rc);
    }

    private String filteredSelectionClause(Table table) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Column c : table.getColumns()) {
            String filterExpression;
            if (Configuration.forDbms((Session)this.session).exportBlocks.contains(c.type)) continue;
            if (!first) {
                sb.append(", ");
            }
            if ((filterExpression = c.getFilterExpression()) != null) {
                if (filterExpression.trim().toLowerCase().startsWith("select")) {
                    sb.append("(" + filterExpression + ")");
                } else {
                    sb.append(filterExpression);
                }
            } else {
                sb.append("T." + c.name);
            }
            sb.append(" as " + c.name);
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void deleteIndependentEntities(Table table) throws SQLException {
        StringBuffer fromEqualsPK = new StringBuffer();
        StringBuffer toEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (fromEqualsPK.length() > 0) {
                fromEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                fromEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".FROM_" + column.name + "=" + column.name);
            } else {
                fromEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".FROM_" + column.name + " is null and " + column.name + " is null");
            }
            if (toEqualsPK.length() > 0) {
                toEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                toEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".TO_" + column.name + "=" + column.name);
                continue;
            }
            toEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".TO_" + column.name + " is null and " + column.name + " is null");
        }
        this.session.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " " + "Where " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".r_entitygraph=" + this.graphID + " and assoc=0 and from_type='" + table.getName() + "' and " + "exists (Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E Where " + "E.r_entitygraph=" + this.graphID + " and " + fromEqualsPK + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".from_type=E.type and " + "E.birthday=0)");
        this.session.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " " + "Where " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".r_entitygraph=" + this.graphID + " and assoc=0 and to_type='" + table.getName() + "' and " + "exists (Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E Where " + "E.r_entitygraph=" + this.graphID + " and " + toEqualsPK + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".to_type=E.type and " + "E.birthday=0)");
        this.session.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " " + "Where r_entitygraph=" + this.graphID + " and type='" + table.getName() + "' and " + "birthday=0");
    }

    @Override
    public long deleteEntities(Table table) throws SQLException {
        return this.session.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " " + "Where r_entitygraph=" + this.graphID + " and " + "type='" + table.getName() + "'");
    }

    @Override
    public long countEntities(Table table) throws SQLException {
        final long[] count = new long[1];
        this.session.executeQuery("Select count(*) from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E " + "Where E.birthday>=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'", (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                count[0] = resultSet.getLong(1);
            }
        });
        return count[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long removeAssociatedDestinations(Association association, boolean deletedEntitiesAreMarked) throws SQLException {
        String jc = association.getJoinCondition();
        if (jc != null) {
            String sourceAlias;
            String destAlias;
            if (association.reversed) {
                destAlias = "A";
                sourceAlias = "B";
            } else {
                destAlias = "B";
                sourceAlias = "A";
            }
            int setId = this.getNextSetId();
            jc = SqlUtil.resolvePseudoColumns(jc, association.reversed ? "EB" : "EA", association.reversed ? "EA" : "EB", 0, this.birthdayOfSubject, "orig_birthday");
            String remove = "Insert into " + SQLDialect.dmlTableReference("JAILER_SET", this.session) + "(set_id, type, " + this.universalPrimaryKey.columnList(null) + ") " + "Select distinct " + setId + ", EB.type, " + this.universalPrimaryKey.columnList("EB.") + " from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " EB " + "join " + association.destination.getName() + " " + destAlias + " on " + this.pkEqualsEntityID(association.destination, destAlias, "EB") + " " + ", " + association.source.getName() + " " + sourceAlias + " " + (deletedEntitiesAreMarked ? "join " : "left join ") + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " EA on EA.r_entitygraph=" + this.graphID + " and EA.type='" + association.source.getName() + "' and " + this.pkEqualsEntityID(association.source, sourceAlias, "EA") + " " + "Where EB.r_entitygraph=" + this.graphID + " and EB.type='" + association.destination.getName() + "' " + "and (" + jc + ") " + "and " + (deletedEntitiesAreMarked ? "EA.birthday=-1 and EB.birthday>=0" : "EA.type is null");
            long rc = this.session.executeUpdate(remove);
            if (rc > 0L) {
                Map<Column, Column> match = this.universalPrimaryKey.match(association.destination.primaryKey);
                StringBuffer sEqualsE = new StringBuffer();
                StringBuffer sEqualsEWoAlias = new StringBuffer();
                for (Column column : this.universalPrimaryKey.getColumns()) {
                    if (sEqualsE.length() > 0) {
                        sEqualsE.append(" and ");
                    }
                    if (sEqualsEWoAlias.length() > 0) {
                        sEqualsEWoAlias.append(" and ");
                    }
                    if (match.containsKey(column)) {
                        sEqualsE.append("S." + column.name + "=E." + column.name);
                        sEqualsEWoAlias.append("S." + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name);
                        continue;
                    }
                    sEqualsE.append("S." + column.name + " is null and E." + column.name + " is null");
                    sEqualsEWoAlias.append("S." + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + "." + column.name + " is null");
                }
                remove = "Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " E set E.birthday=-1 Where E.r_entitygraph=" + this.graphID + " and E.type='" + association.destination.getName() + "' " + "and exists (Select * from " + SQLDialect.dmlTableReference("JAILER_SET", this.session) + " S where S.set_id=" + setId + " and E.type=S.type and " + sEqualsE + ") " + "and E.birthday<>-1";
                boolean silent = this.session.getSilent();
                try {
                    this.session.setSilent(true);
                    rc = this.session.executeUpdate(remove);
                    this.totalRowcount += rc;
                }
                catch (SQLException e) {
                    Session._log.debug("failed, retry without alias (" + e.getMessage() + ")");
                    remove = "Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + " set birthday=-1 Where " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".r_entitygraph=" + this.graphID + " and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".type='" + association.destination.getName() + "' " + "and exists (Select * from " + SQLDialect.dmlTableReference("JAILER_SET", this.session) + " S where S.set_id=" + setId + " and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".type=S.type and " + sEqualsEWoAlias + ") " + "and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.session) + ".birthday<>-1";
                    rc = this.session.executeUpdate(remove);
                    this.totalRowcount += rc;
                }
                finally {
                    this.session.setSilent(silent);
                }
                this.session.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_SET", this.session) + " where set_id=" + setId + "");
            }
            return rc;
        }
        return 0L;
    }

    @Override
    public void readDependentEntities(Table table, Association association, ResultSet resultSet, ResultSetMetaData resultSetMetaData, Session.ResultSetReader reader, Map<String, Integer> typeCache, String selectionSchema, String originalPKAliasPrefix) throws SQLException {
        String select;
        if (originalPKAliasPrefix != null) {
            StringBuffer selectOPK = new StringBuffer();
            for (int i = 0; i < table.primaryKey.getColumns().size(); ++i) {
                if (i > 0) {
                    selectOPK.append(", ");
                }
                selectOPK.append("T." + table.primaryKey.getColumns().get((int)i).name + " AS " + originalPKAliasPrefix + i);
            }
            select = "Select " + selectionSchema + " from (" + "Select " + selectOPK + ", " + this.filteredSelectionClause(table) + " from " + table.getName() + " T join " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D on " + this.pkEqualsEntityID(table, "T", "D", "TO_") + " and D.to_type='" + table.getName() + "'" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, "D", "FROM_", typeCache, this.session) + " and D.from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and D.r_entitygraph=" + this.graphID + ") T";
        } else {
            select = "Select " + selectionSchema + " from " + table.getName() + " T join " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D on " + this.pkEqualsEntityID(table, "T", "D", "TO_") + " and D.to_type='" + table.getName() + "'" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, "D", "FROM_", typeCache, this.session) + " and D.from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and D.r_entitygraph=" + this.graphID;
        }
        long rc = this.session.executeQuery(select, reader);
        ProgressListenerRegistry.getProgressListener().exported(table, rc);
    }

    @Override
    public void markDependentEntitiesAsTraversed(Association association, ResultSet resultSet, ResultSetMetaData resultSetMetaData, Map<String, Integer> typeCache) throws SQLException {
        String update = this.session.dbms == DBMS.SYBASE ? "Update " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " set traversed=1" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session), "FROM_", typeCache, this.session) + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + ".r_entitygraph=" + this.graphID : "Update " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D set traversed=1" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, "D", "FROM_", typeCache, this.session) + " and D.from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and D.r_entitygraph=" + this.graphID;
        this.session.executeUpdate(update);
    }

    @Override
    public void readNonTraversedDependencies(Table table, Session.ResultSetReader reader) throws SQLException {
        String select = "Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " D " + " Where (traversed is null or traversed <> 1)" + " and D.from_type='" + table.getName() + "'" + " and D.r_entitygraph=" + this.graphID;
        this.session.executeQuery(select, reader);
    }

    @Override
    public void removeReflexiveDependencies(Table table) throws SQLException {
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("FROM_" + column.name + " = TO_" + column.name);
        }
        String delete = "Delete from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.session) + " Where " + sb + " and from_type='" + table.getName() + "'" + " and to_type='" + table.getName() + "'" + " and r_entitygraph=" + this.graphID;
        this.session.executeUpdate(delete);
    }

    private String pkEqualsEntityID(Table table, ResultSet resultSet, ResultSetMetaData resultSetMetaData, String alias, String columnPrefix, Map<String, Integer> typeCache, Session session) throws SQLException {
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(alias + "." + columnPrefix + column.name);
            Column tableColumn = match.get(column);
            if (tableColumn != null) {
                int i = 0;
                for (Column c : table.primaryKey.getColumns()) {
                    if (c.name.equals(tableColumn.name)) break;
                    ++i;
                }
                sb.append("=" + SqlUtil.toSql(SqlUtil.getObject(resultSet, resultSetMetaData, "PK" + i, typeCache), session));
                continue;
            }
            sb.append(" is null");
        }
        return sb.toString();
    }

    private String pkEqualsEntityID(Table table, String tableAlias, String entityAlias) {
        return this.pkEqualsEntityID(table, tableAlias, entityAlias, "");
    }

    private String pkEqualsEntityID(Table table, String tableAlias, String entityAlias, String columnPrefix) {
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            Column tableColumn = match.get(column);
            sb.append(entityAlias + "." + columnPrefix + column.name);
            if (tableColumn != null) {
                if (this.fieldProcTables.contains(table.getUnqualifiedName().toLowerCase())) {
                    sb.append(" = " + tableColumn.type + "(" + tableAlias + "." + tableColumn.name + ")");
                    continue;
                }
                sb.append("=" + tableAlias + "." + tableColumn.name);
                continue;
            }
            sb.append(" is null");
        }
        return sb.toString();
    }

    private String pkList(Table table, String tableAlias) {
        return this.pkList(table, tableAlias, null);
    }

    private String pkList(Table table, String tableAlias, String columnAliasPrefix) {
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(tableAlias + "." + tableColumn.name);
            sb.append(" AS " + (columnAliasPrefix == null ? "" : columnAliasPrefix) + column.name);
        }
        return sb.toString();
    }

    private String upkColumnList(Table table, String columnAliasPrefix) {
        Map<Column, Column> match = this.universalPrimaryKey.match(table.primaryKey);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (columnAliasPrefix != null) {
                sb.append(columnAliasPrefix);
            }
            sb.append(column.name);
        }
        return sb.toString();
    }

    @Override
    public List<String> getStatistics(DataModel dataModel, Set<Table> tables) throws SQLException {
        return this.getStatistics(this.session, dataModel, tables);
    }

    @Override
    public long getTotalRowcount() {
        return this.totalRowcount;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public PrimaryKey getUniversalPrimaryKey() {
        return this.universalPrimaryKey;
    }

    private synchronized int getNextSetId() {
        return this.graphID + this.nextSetId++;
    }

    @Override
    public void shutDown() throws SQLException {
        this.session.shutDown();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public DataModel getDatamodel() {
        return this.dataModel;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public Session getTargetSession() {
        return this.session;
    }
}

