/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.entitygraph.local;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.DDLCreator;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.PrimaryKeyFactory;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.entitygraph.EntityGraph;
import net.sf.jailer.entitygraph.local.InlineViewBuilder;
import net.sf.jailer.entitygraph.local.InlineViewStyle;
import net.sf.jailer.entitygraph.local.LocalConfiguration;
import net.sf.jailer.progress.ProgressListenerRegistry;
import net.sf.jailer.util.ClasspathUtil;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;

public class LocalEntityGraph
extends EntityGraph {
    private final Session remoteSession;
    private final Session localSession;
    private String databaseFolder;
    private InlineViewStyle localInlineViewStyle;
    private InlineViewStyle remoteInlineViewStyle;
    private Set<String> upkColumnNames = null;
    private Set<String> nupkColumnNames = null;
    private static LocalConfiguration localConfiguration = null;
    private final PrimaryKey universalPrimaryKey;
    private int birthdayOfSubject = 0;
    private final Set<String> fieldProcTables = new HashSet<String>();
    private long totalRowcount = 0L;
    public static long maxTotalRowcount = 0L;
    private boolean explain = false;
    private int nextExplainID = 1;
    public Map<Association, Integer> explainIdOfAssociation = new HashMap<Association, Integer>();
    private int nextSetId = 1;

    private synchronized boolean isUPKColumn(String columnName) {
        if (this.upkColumnNames == null) {
            this.upkColumnNames = new HashSet<String>();
            for (Column c : this.universalPrimaryKey.getColumns()) {
                this.upkColumnNames.add(c.name);
            }
        }
        return this.upkColumnNames.contains(columnName);
    }

    private synchronized boolean isNUPKColumn(String columnName) {
        if (this.nupkColumnNames == null) {
            this.nupkColumnNames = new HashSet<String>();
            String localNPKType = LocalEntityGraph.getConfiguration().getLocalNPKType();
            for (Column c : this.universalPrimaryKey.getColumns()) {
                if (!c.type.equalsIgnoreCase(localNPKType)) continue;
                this.nupkColumnNames.add(c.name);
            }
        }
        return this.nupkColumnNames.contains(columnName);
    }

    private static synchronized LocalConfiguration getConfiguration() {
        if (localConfiguration == null && (localConfiguration = (LocalConfiguration)Configuration.localEntityGraphConfiguration) == null) {
            localConfiguration = new LocalConfiguration();
        }
        return localConfiguration;
    }

    public LocalEntityGraph(int graphID, DataModel dataModel, Session remoteSession, Session localSession, String databaseFolder, InlineViewStyle localInlineViewStyle, InlineViewStyle remoteInlineViewStyle, Set<String> upkColumnNames, PrimaryKey universalPrimaryKey, int birthdayOfSubject, Set<String> fieldProcTables) {
        super(graphID, dataModel);
        this.remoteSession = remoteSession;
        this.localSession = localSession;
        this.databaseFolder = databaseFolder;
        this.localInlineViewStyle = localInlineViewStyle;
        this.remoteInlineViewStyle = remoteInlineViewStyle;
        this.upkColumnNames = upkColumnNames;
        this.universalPrimaryKey = universalPrimaryKey;
        this.birthdayOfSubject = birthdayOfSubject;
        this.fieldProcTables.addAll(fieldProcTables);
    }

    public LocalEntityGraph(int graphID, Session remoteSession) throws Exception {
        super(graphID, new DataModel(new PrimaryKeyFactory(){

            @Override
            public PrimaryKey createPrimaryKey(List<Column> columns) {
                ArrayList<Column> localPK = new ArrayList<Column>(columns.size());
                for (Column c : columns) {
                    if (c.type.equalsIgnoreCase("nvarchar") || c.type.equalsIgnoreCase("nchar")) {
                        localPK.add(new Column(c.name, LocalEntityGraph.getConfiguration().localNPKType, LocalEntityGraph.getConfiguration().localPKLength, -1));
                        continue;
                    }
                    localPK.add(new Column(c.name, LocalEntityGraph.getConfiguration().localPKType, LocalEntityGraph.getConfiguration().localPKLength, -1));
                }
                return super.createPrimaryKey(localPK);
            }
        }, CommandLineParser.getInstance().getSourceSchemaMapping()));
        this.remoteSession = remoteSession;
        this.localSession = this.createLocalSession(LocalEntityGraph.getConfiguration().driver, LocalEntityGraph.getConfiguration().urlPattern, LocalEntityGraph.getConfiguration().lib);
        this.universalPrimaryKey = this.getDatamodel().getUniversalPrimaryKey();
        this.localInlineViewStyle = InlineViewStyle.forSession(this.localSession);
        this.remoteInlineViewStyle = InlineViewStyle.forSession(remoteSession);
        DDLCreator.createDDL(this.getDatamodel(), this.localSession, TemporaryTableScope.GLOBAL);
        File fieldProcTablesFile = new File("field-proc-tables.csv");
        if (fieldProcTablesFile.exists()) {
            try {
                for (CsvFile.Line line : new CsvFile(fieldProcTablesFile).getLines()) {
                    this.fieldProcTables.add(line.cells.get(0).toLowerCase());
                }
                Session._log.info("tables with field procedures: " + this.fieldProcTables);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private Session createLocalSession(String driverClassName, String urlPattern, String jarfile) throws Exception {
        this.databaseFolder = LocalEntityGraph.getConfiguration().databasesFolder + File.separator + UUID.randomUUID().toString();
        CommandLineParser.getInstance().newFile(this.databaseFolder).mkdirs();
        ClassLoader oldCL = Session.classLoaderForJdbcDriver;
        Session.setClassLoaderForJdbcDriver(ClasspathUtil.addJarToClasspath(jarfile, null));
        Session localSession = new Session(driverClassName, urlPattern.replace("%s", this.databaseFolder + File.separator + "local"), "", "", null, false, true);
        Session.setClassLoaderForJdbcDriver(oldCL);
        return localSession;
    }

    @Override
    public void close() throws SQLException {
        this.localSession.shutDown();
        File localFolder = CommandLineParser.getInstance().newFile(this.databaseFolder);
        File[] listFiles = localFolder.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                file.delete();
            }
        }
        localFolder.delete();
    }

    @Override
    public void setBirthdayOfSubject(int birthdayOfSubject) {
        this.birthdayOfSubject = birthdayOfSubject;
    }

    public static LocalEntityGraph create(DataModel dataModel, int graphID, Session remoteSession) throws Exception {
        LocalEntityGraph entityGraph = new LocalEntityGraph(graphID, remoteSession);
        try {
            entityGraph.localSession.executeUpdate("Insert into " + SQLDialect.dmlTableReference("JAILER_GRAPH", entityGraph.localSession) + "(id, age) values (" + graphID + ", 1)");
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't find working tables! Run 'bin/jailer.sh create-ddl' and execute the DDL-script first!", e);
        }
        return entityGraph;
    }

    @Override
    public EntityGraph copy(int newGraphID, Session globalSession) throws Exception {
        LocalEntityGraph entityGraph = new LocalEntityGraph(newGraphID, this.dataModel, this.remoteSession, this.localSession, this.databaseFolder, this.localInlineViewStyle, this.remoteInlineViewStyle, this.upkColumnNames, this.universalPrimaryKey, this.birthdayOfSubject, this.fieldProcTables);
        entityGraph.setBirthdayOfSubject(this.birthdayOfSubject);
        this.localSession.executeUpdate("Insert into " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + "(r_entitygraph, " + this.universalPrimaryKey.columnList(null) + ", birthday, orig_birthday, type) " + "Select " + newGraphID + ", " + this.universalPrimaryKey.columnList(null) + ", birthday, birthday, type From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " Where r_entitygraph=" + this.graphID + "");
        return entityGraph;
    }

    @Override
    public EntityGraph find(int graphID, Session localSession, PrimaryKey universalPrimaryKey) throws Exception {
        LocalEntityGraph entityGraph = new LocalEntityGraph(graphID, localSession);
        final boolean[] found = new boolean[]{false};
        localSession.executeQuery("Select * From " + SQLDialect.dmlTableReference("JAILER_GRAPH", localSession) + "Where id=" + graphID + "", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                found[0] = true;
            }

            @Override
            public void close() {
            }
        });
        if (!found[0]) {
            throw new RuntimeException("entity-graph " + graphID + " not found");
        }
        return entityGraph;
    }

    public static int createUniqueGraphID() {
        return Math.abs((int)System.currentTimeMillis());
    }

    @Override
    public int getAge() throws SQLException {
        final int[] age = new int[]{-1};
        this.localSession.executeQuery("Select age From " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.localSession) + " Where id=" + this.graphID + "", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                age[0] = resultSet.getInt(1);
            }

            @Override
            public void close() {
            }
        });
        return age[0];
    }

    @Override
    public void setAge(int age) throws SQLException {
        this.localSession.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.localSession) + " Set age=" + age + " Where id=" + this.graphID + "");
    }

    @Override
    public long getSize() throws SQLException {
        final int[] size = new int[]{-1};
        this.localSession.executeQuery("Select count(*) From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " Where r_entitygraph=" + this.graphID + " and birthday >= 0", new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                size[0] = resultSet.getInt(1);
            }

            @Override
            public void close() {
            }
        });
        return size[0];
    }

    @Override
    public void delete() throws SQLException {
        this.localSession.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " Where r_entitygraph=" + this.graphID + "");
        this.localSession.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " Where r_entitygraph=" + this.graphID + "");
        this.localSession.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_GRAPH", this.localSession) + " Where id=" + this.graphID + "");
    }

    @Override
    public long addEntities(Table table, String condition, int today, long limit) throws SQLException {
        return this.addEntities(table, "T", condition, today);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long resolveAssociation(Table table, Association association, final int today) throws SQLException {
        final String jc = association.getJoinCondition();
        if (jc != null) {
            String sourceAlias;
            String destAlias;
            if (association.reversed) {
                destAlias = "A";
                sourceAlias = "B";
            } else {
                destAlias = "B";
                sourceAlias = "A";
            }
            Integer associationExplanationIDm = 0;
            if (this.explain) {
                Map<Association, Integer> map = this.explainIdOfAssociation;
                synchronized (map) {
                    associationExplanationIDm = this.explainIdOfAssociation.get(association);
                    if (associationExplanationIDm == null) {
                        associationExplanationIDm = this.nextExplainID++;
                        this.explainIdOfAssociation.put(association, associationExplanationIDm);
                    }
                }
            }
            final Integer associationExplanationID = associationExplanationIDm;
            final Table destination = association.destination;
            String condition = "E.r_entitygraph=" + this.graphID + " and E.birthday = " + (today - 1) + " and E.type='" + table.getName() + "'";
            final Table source = association.source;
            String select = "Select " + this.upkColumnList(source, "E", null) + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E" + " Where " + condition;
            final long[] rc = new long[1];
            this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("E", this.upkColumnList(source, null)){

                @Override
                protected void process(String inlineView) throws SQLException {
                    String select = "Select distinct " + LocalEntityGraph.this.pkList(destination, destAlias) + " From " + inlineView + " join " + source.getName() + " " + sourceAlias + " on " + LocalEntityGraph.this.pkEqualsEntityID(source, sourceAlias, "E", "", false) + " join " + destination.getName() + " " + destAlias + " on (" + jc + ")";
                    LocalEntityGraph.this.remoteSession.executeQuery(select, (Session.ResultSetReader)new LocalInlineViewBuilder(destAlias, LocalEntityGraph.this.upkColumnList(destination, null)){

                        @Override
                        protected void process(String inlineView) throws SQLException {
                            Map match = LocalEntityGraph.this.upkMatch(destination);
                            StringBuffer sb = new StringBuffer();
                            for (Column column : LocalEntityGraph.this.universalPrimaryKey.getColumns()) {
                                if (sb.length() > 0) {
                                    sb.append(" and ");
                                }
                                Column tableColumn = (Column)match.get(column);
                                sb.append("Duplicate." + column.name);
                                if (tableColumn != null) {
                                    sb.append("=" + destAlias + "." + column.name);
                                    continue;
                                }
                                sb.append(" is null");
                            }
                            String entityJoinCondition = sb.toString();
                            String select = "Select " + LocalEntityGraph.this.graphID + " as GRAPH_ID, " + LocalEntityGraph.this.upkColumnList(destination, destAlias, null) + ", " + today + " AS BIRTHDAY, '" + destination.getName() + "' AS TYPE" + (source == null || !LocalEntityGraph.this.explain ? "" : ", " + associationExplanationID + " AS ASSOCIATION, '" + source.getName() + "' AS SOURCE_TYPE, " + LocalEntityGraph.this.upkColumnList(source, "PRE_")) + " From " + inlineView + " left join " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " Duplicate on Duplicate.r_entitygraph=" + LocalEntityGraph.this.graphID + " and Duplicate.type='" + destination.getName() + "' and " + entityJoinCondition + " Where Duplicate.type is null";
                            String insert = "Insert into " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " (r_entitygraph, " + LocalEntityGraph.this.upkColumnList(destination, null) + ", birthday, type" + (source == null || !LocalEntityGraph.this.explain ? "" : ", association, PRE_TYPE, " + LocalEntityGraph.this.upkColumnList(source, "PRE_")) + ") " + select;
                            rc[0] = rc[0] + (long)LocalEntityGraph.this.localSession.executeUpdate(insert);
                            LocalEntityGraph.this.totalRowcount += rc[0];
                        }
                    });
                }
            });
            return rc[0];
        }
        return -1L;
    }

    private long addEntities(final Table table, final String alias, String condition, final int today) throws SQLException {
        String select = "Select " + this.pkList(table, alias) + " From " + table.getName() + " " + alias + " Where (" + condition + ")";
        final long[] rc = new long[1];
        this.remoteSession.executeQuery(select, (Session.ResultSetReader)new LocalInlineViewBuilder(alias, this.upkColumnList(table, null)){

            @Override
            protected void process(String inlineView) throws SQLException {
                Map match = LocalEntityGraph.this.upkMatch(table);
                StringBuffer sb = new StringBuffer();
                for (Column column : LocalEntityGraph.this.universalPrimaryKey.getColumns()) {
                    if (sb.length() > 0) {
                        sb.append(" and ");
                    }
                    Column tableColumn = (Column)match.get(column);
                    sb.append("Duplicate." + column.name);
                    if (tableColumn != null) {
                        sb.append("=" + alias + "." + column.name);
                        continue;
                    }
                    sb.append(" is null");
                }
                String entityJoinCondition = sb.toString();
                String select = "Select " + LocalEntityGraph.this.graphID + " as GRAPH_ID, " + LocalEntityGraph.this.upkColumnList(table, alias, null) + ", " + today + " AS BIRTHDAY, '" + table.getName() + "' AS TYPE" + " From " + inlineView + " left join " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " Duplicate on Duplicate.r_entitygraph=" + LocalEntityGraph.this.graphID + " and Duplicate.type='" + table.getName() + "' and " + entityJoinCondition + " Where Duplicate.type is null";
                String insert = "Insert into " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " (r_entitygraph, " + LocalEntityGraph.this.upkColumnList(table, null) + ", birthday, type) " + select;
                rc[0] = rc[0] + (long)LocalEntityGraph.this.localSession.executeUpdate(insert);
                LocalEntityGraph.this.totalRowcount += rc[0];
            }
        });
        return rc[0];
    }

    @Override
    public void addDependencies(final Table from, final String fromAlias, final Table to, final String toAlias, final String condition, final int aggregationId, final int dependencyId, boolean isAssociationReversed) throws SQLException {
        String upkColumnList = this.upkColumnList(from, "E1", null);
        String select = "Select " + upkColumnList + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E1 " + " Where E1.r_entitygraph=" + this.graphID + " and E1.type='" + from.getName() + "'";
        this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("E1", this.upkColumnList(from, null, null)){

            @Override
            protected void process(String inlineView) throws SQLException {
                String upkColumnList = LocalEntityGraph.this.upkColumnList(from, "E1", null);
                String select = "Select " + upkColumnList + ", " + LocalEntityGraph.this.pkList(to, toAlias) + " From " + inlineView + ", " + from.getName() + " " + fromAlias + ", " + to.getName() + " " + toAlias + " Where (" + condition + ")" + " and " + LocalEntityGraph.this.pkEqualsEntityID(from, fromAlias, "E1", "", false);
                LocalEntityGraph.this.remoteSession.executeQuery(select, (Session.ResultSetReader)new LocalInlineViewBuilder("E1E2", LocalEntityGraph.this.upkColumnList(from, null, "E1") + ", " + LocalEntityGraph.this.upkColumnList(to, null, "E2"), true){

                    @Override
                    protected void process(String inlineView) throws SQLException {
                        Map match = LocalEntityGraph.this.upkMatch(to);
                        StringBuffer sb = new StringBuffer();
                        for (Column column : LocalEntityGraph.this.universalPrimaryKey.getColumns()) {
                            Column tableColumn = (Column)match.get(column);
                            if (tableColumn == null) continue;
                            if (sb.length() > 0) {
                                sb.append(" and ");
                            }
                            sb.append("E2." + column.name);
                            sb.append("=E1E2.E2" + column.name);
                        }
                        String pkEqualsEntityID = sb.toString();
                        String insert = "Insert into " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", LocalEntityGraph.this.localSession) + "(r_entitygraph, assoc, depend_id, from_type, to_type, " + LocalEntityGraph.this.upkColumnList(from, "FROM_") + ", " + LocalEntityGraph.this.upkColumnList(to, "TO_") + ") " + "Select " + LocalEntityGraph.this.graphID + ", " + aggregationId + ", " + dependencyId + ", '" + from.getName() + "', '" + to.getName() + "', " + LocalEntityGraph.this.upkColumnList(from, "E1E2", "E1") + ", " + LocalEntityGraph.this.upkColumnList(to, "E1E2", "E2") + " From " + inlineView + ", " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " E2" + " Where E2.r_entitygraph=" + LocalEntityGraph.this.graphID + "" + " and E2.type='" + to.getName() + "'" + " and " + pkEqualsEntityID;
                        LocalEntityGraph.this.totalRowcount += LocalEntityGraph.this.localSession.executeUpdate(insert);
                    }
                });
            }
        });
    }

    @Override
    public Set<Integer> getDistinctDependencyIDs() throws SQLException {
        String select = "Select distinct depend_id from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " Where r_entitygraph=" + this.graphID;
        final HashSet<Integer> ids = new HashSet<Integer>();
        this.localSession.executeQuery(select, new Session.ResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                ids.add(resultSet.getInt(1));
            }

            @Override
            public void close() {
            }
        });
        return ids;
    }

    @Override
    public void markIndependentEntities(Table table) throws SQLException {
        StringBuffer fromEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.upkMatch(table);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (fromEqualsPK.length() > 0) {
                fromEqualsPK.append(" and ");
            }
            if (match.get(column) != null) {
                fromEqualsPK.append("D.FROM_" + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + "." + column.name);
                continue;
            }
            fromEqualsPK.append("D.FROM_" + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + "." + column.name + " is null");
        }
        this.localSession.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " set birthday=0 " + "Where r_entitygraph=" + this.graphID + " and birthday>0 and " + (table != null ? "type='" + table.getName() + "' and " : "") + "not exists (Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " D " + "Where D.r_entitygraph=" + this.graphID + " and D.assoc=0 and D.from_type=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + ".type and " + fromEqualsPK + ")");
    }

    private Map<Column, Column> upkMatch(Table table) {
        return this.universalPrimaryKey.match(this.getDatamodel().getTable((String)table.getName()).primaryKey);
    }

    @Override
    public void markRoots(Table table) throws SQLException {
        StringBuffer toEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.upkMatch(table);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (toEqualsPK.length() > 0) {
                toEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                toEqualsPK.append("D.TO_" + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + "." + column.name);
                continue;
            }
            toEqualsPK.append("D.TO_" + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + "." + column.name + " is null");
        }
        this.localSession.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " set birthday=0 " + "Where r_entitygraph=" + this.graphID + " and birthday>0 and type='" + table.getName() + "' and " + "not exists (Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " D " + "Where D.r_entitygraph=" + this.graphID + " and D.to_type=" + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + ".type and " + toEqualsPK + ")");
    }

    @Override
    public void readMarkedEntities(Table table, Session.ResultSetReader reader, boolean orderByPK) throws SQLException {
        this.readMarkedEntities(table, reader, this.filteredSelectionClause(table), orderByPK);
    }

    @Override
    public void readMarkedEntities(final Table table, final Session.ResultSetReader reader, final String selectionSchema, final boolean orderByPK) throws SQLException {
        String orderBy = "";
        String upkColumnList = this.upkColumnList(table, null, "");
        if (orderByPK) {
            orderBy = " order by " + upkColumnList;
        }
        String select = "Select " + upkColumnList + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E" + " Where E.birthday=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'" + orderBy;
        this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("E", upkColumnList){

            @Override
            protected void process(String inlineView) throws SQLException {
                String orderBy = "";
                if (orderByPK) {
                    orderBy = " order by " + table.primaryKey.columnList("T.");
                }
                long rc = LocalEntityGraph.this.remoteSession.executeQuery("Select " + selectionSchema + " From " + inlineView + " join " + table.getName() + " T on " + LocalEntityGraph.this.pkEqualsEntityID(table, "T", "E", "", false) + orderBy, reader);
                ProgressListenerRegistry.getProgressListener().exported(table, rc);
            }
        });
    }

    @Override
    public void readMarkedEntities(final Table table, final Session.ResultSetReader reader, final String selectionSchema, final String originalPKAliasPrefix, final boolean orderByPK) throws SQLException {
        if (originalPKAliasPrefix == null) {
            this.readMarkedEntities(table, reader, selectionSchema, orderByPK);
            return;
        }
        String orderBy = "";
        String upkColumnList = this.upkColumnList(table, null, "");
        if (orderByPK) {
            orderBy = " order by " + upkColumnList;
        }
        String select = "Select " + upkColumnList + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E" + " Where E.birthday=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'" + orderBy;
        this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("E", upkColumnList){

            @Override
            protected void process(String inlineView) throws SQLException {
                String orderBy = "";
                if (orderByPK) {
                    orderBy = " order by " + table.primaryKey.columnList("T.");
                }
                StringBuffer sb = new StringBuffer();
                StringBuffer selectOPK = new StringBuffer();
                for (int i = 0; i < table.primaryKey.getColumns().size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                        selectOPK.append(", ");
                    }
                    sb.append(originalPKAliasPrefix + i);
                    selectOPK.append("T." + table.primaryKey.getColumns().get((int)i).name + " AS " + originalPKAliasPrefix + i);
                }
                String sqlQuery = "Select " + selectionSchema + " From (" + "Select " + selectOPK + ", " + LocalEntityGraph.this.filteredSelectionClause(table) + " From " + inlineView + " join " + table.getName() + " T on " + LocalEntityGraph.this.pkEqualsEntityID(table, "T", "E", "", false) + ") T ";
                long rc = LocalEntityGraph.this.remoteSession.executeQuery(sqlQuery + orderBy, reader);
                ProgressListenerRegistry.getProgressListener().exported(table, rc);
            }
        });
    }

    @Override
    public void uniteWith(EntityGraph graph) throws SQLException {
        StringBuffer e1EqualsE2 = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (e1EqualsE2.length() > 0) {
                e1EqualsE2.append(" and ");
            }
            e1EqualsE2.append("E1." + column.name + "=E2." + column.name);
        }
        this.localSession.executeUpdate("Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E1 " + "set E1.r_entitygraph=" + this.graphID + " " + "Where E1.r_entitygraph=" + graph.graphID + " " + "and not exists(Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E2 Where " + "E2.r_entitygraph=" + this.graphID + " and " + e1EqualsE2 + ")");
        graph.delete();
    }

    @Override
    public void readEntities(final Table table, final Session.ResultSetReader reader, final boolean orderByPK) throws SQLException {
        String upkColumnList = this.upkColumnList(table, "E", null);
        String select = "Select " + upkColumnList + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E " + " Where E.birthday>=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'";
        if (orderByPK) {
            select = select + " order by " + upkColumnList;
        }
        this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("E", this.upkColumnList(table, null, null)){

            @Override
            protected void process(String inlineView) throws SQLException {
                long rc;
                String sqlQuery = "Select " + LocalEntityGraph.this.filteredSelectionClause(table) + " From " + inlineView + " join " + table.getName() + " T on " + LocalEntityGraph.this.pkEqualsEntityID(table, "T", "E", "", false);
                if (orderByPK) {
                    String sqlQueryWithOrderBy = sqlQuery + " order by " + table.primaryKey.columnList("T.");
                    rc = LocalEntityGraph.this.remoteSession.executeQuery(sqlQueryWithOrderBy, reader, sqlQuery, null, 0);
                } else {
                    rc = LocalEntityGraph.this.remoteSession.executeQuery(sqlQuery, reader);
                }
                ProgressListenerRegistry.getProgressListener().exported(table, rc);
            }
        });
    }

    private String filteredSelectionClause(Table table) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Column c : table.getColumns()) {
            String filterExpression;
            if (Configuration.forDbms((Session)this.localSession).exportBlocks.contains(c.type)) continue;
            if (!first) {
                sb.append(", ");
            }
            if ((filterExpression = c.getFilterExpression()) != null) {
                if (filterExpression.trim().toLowerCase().startsWith("select")) {
                    sb.append("(" + filterExpression + ")");
                } else {
                    sb.append(filterExpression);
                }
            } else {
                sb.append("T." + c.name);
            }
            sb.append(" as " + c.name);
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void deleteIndependentEntities(Table table) throws SQLException {
        StringBuffer fromEqualsPK = new StringBuffer();
        StringBuffer toEqualsPK = new StringBuffer();
        Map<Column, Column> match = this.upkMatch(table);
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (fromEqualsPK.length() > 0) {
                fromEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                fromEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".FROM_" + column.name + "=" + column.name);
            } else {
                fromEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".FROM_" + column.name + " is null and " + column.name + " is null");
            }
            if (toEqualsPK.length() > 0) {
                toEqualsPK.append(" and ");
            }
            if (match.containsKey(column)) {
                toEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".TO_" + column.name + "=" + column.name);
                continue;
            }
            toEqualsPK.append(SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".TO_" + column.name + " is null and " + column.name + " is null");
        }
        this.localSession.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " " + "Where " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".r_entitygraph=" + this.graphID + " and assoc=0 and from_type='" + table.getName() + "' and " + "exists (Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E Where " + "E.r_entitygraph=" + this.graphID + " and " + fromEqualsPK + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".from_type=E.type and " + "E.birthday=0)");
        this.localSession.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " " + "Where " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".r_entitygraph=" + this.graphID + " and assoc=0 and to_type='" + table.getName() + "' and " + "exists (Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E Where " + "E.r_entitygraph=" + this.graphID + " and " + toEqualsPK + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".to_type=E.type and " + "E.birthday=0)");
        this.localSession.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " " + "Where r_entitygraph=" + this.graphID + " and type='" + table.getName() + "' and " + "birthday=0");
    }

    @Override
    public long deleteEntities(Table table) throws SQLException {
        return this.localSession.executeUpdate("Delete From " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " " + "Where r_entitygraph=" + this.graphID + " and " + "type='" + table.getName() + "'");
    }

    @Override
    public long countEntities(Table table) throws SQLException {
        final long[] count = new long[1];
        this.localSession.executeQuery("Select count(*) from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " E " + "Where E.birthday>=0 and E.r_entitygraph=" + this.graphID + " and E.type='" + table.getName() + "'", (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                count[0] = resultSet.getLong(1);
            }
        });
        return count[0];
    }

    @Override
    public long removeAssociatedDestinations(final Association association, final boolean deletedEntitiesAreMarked) throws SQLException {
        final String jc = association.getJoinCondition();
        if (jc != null) {
            String sourceAlias;
            String destAlias;
            if (association.reversed) {
                destAlias = "A";
                sourceAlias = "B";
            } else {
                destAlias = "B";
                sourceAlias = "A";
            }
            final int setId = this.getNextSetId();
            final long[] rc = new long[1];
            String selectEB = "Select " + this.upkColumnList(association.destination, "EB", "") + " from " + SQLDialect.dmlTableReference("JAILER_ENTITY", this.localSession) + " EB " + "Where " + (deletedEntitiesAreMarked ? "EB.birthday>=0 and " : "") + "EB.r_entitygraph=" + this.graphID + " and EB.type='" + association.destination.getName() + "' ";
            this.localSession.executeQuery(selectEB, (Session.ResultSetReader)new RemoteInlineViewBuilder("EB", this.upkColumnList(association.destination, ""), true){

                @Override
                protected void process(String inlineView) throws SQLException {
                    String selectSource = "Select distinct " + LocalEntityGraph.this.upkColumnList(association.destination, "EB", "") + ", " + LocalEntityGraph.this.pkList(association.source, sourceAlias, "") + " from " + inlineView + " " + "join " + association.destination.getName() + " " + destAlias + " on " + LocalEntityGraph.this.pkEqualsEntityID(association.destination, destAlias, "EB", "", false) + " " + "join " + association.source.getName() + " " + sourceAlias + " " + " on " + jc;
                    LocalEntityGraph.this.remoteSession.executeQuery(selectSource, (Session.ResultSetReader)new LocalInlineViewBuilder("EBA", LocalEntityGraph.this.upkColumnList(association.destination, null, "EB") + ", " + LocalEntityGraph.this.upkColumnList(association.source, "A"), true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void process(String inlineView) throws SQLException {
                            Map match = LocalEntityGraph.this.upkMatch(association.source);
                            StringBuffer eBAEqualsEA = new StringBuffer();
                            for (Column column : LocalEntityGraph.this.universalPrimaryKey.getColumns()) {
                                Column tableColumn = (Column)match.get(column);
                                if (tableColumn == null) continue;
                                if (eBAEqualsEA.length() > 0) {
                                    eBAEqualsEA.append(" and ");
                                }
                                eBAEqualsEA.append("EBA.A" + column.name);
                                eBAEqualsEA.append("=EA." + column.name);
                            }
                            String selectEB = "Select distinct " + setId + ", '" + association.destination.getName() + "', " + LocalEntityGraph.this.upkColumnList(association.destination, "EBA", "EB") + " from " + inlineView + (deletedEntitiesAreMarked ? " join " : " left join ") + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " EA" + " on EA.r_entitygraph=" + LocalEntityGraph.this.graphID + " and EA.type='" + association.source.getName() + "'" + " and " + eBAEqualsEA + " Where " + (deletedEntitiesAreMarked ? "EA.birthday=-1" : "EA.type is null");
                            String remove = "Insert into " + SQLDialect.dmlTableReference("JAILER_SET", LocalEntityGraph.this.localSession) + "(set_id, type, " + LocalEntityGraph.this.upkColumnList(association.destination, null, "") + ") " + selectEB;
                            long rcl = LocalEntityGraph.this.localSession.executeUpdate(remove);
                            LocalEntityGraph.this.totalRowcount += rcl;
                            if (rcl > 0L) {
                                match = LocalEntityGraph.this.upkMatch(association.destination);
                                StringBuffer sEqualsE = new StringBuffer();
                                StringBuffer sEqualsEWoAlias = new StringBuffer();
                                for (Column column : LocalEntityGraph.this.universalPrimaryKey.getColumns()) {
                                    if (sEqualsE.length() > 0) {
                                        sEqualsE.append(" and ");
                                    }
                                    if (sEqualsEWoAlias.length() > 0) {
                                        sEqualsEWoAlias.append(" and ");
                                    }
                                    if (match.containsKey(column)) {
                                        sEqualsE.append("S." + column.name + "=E." + column.name);
                                        sEqualsEWoAlias.append("S." + column.name + "=" + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + "." + column.name);
                                        continue;
                                    }
                                    sEqualsE.append("S." + column.name + " is null and E." + column.name + " is null");
                                    sEqualsEWoAlias.append("S." + column.name + " is null and " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + "." + column.name + " is null");
                                }
                                remove = "Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " E set E.birthday=-1 Where E.r_entitygraph=" + LocalEntityGraph.this.graphID + " and E.type='" + association.destination.getName() + "' " + "and exists (Select * from " + SQLDialect.dmlTableReference("JAILER_SET", LocalEntityGraph.this.localSession) + " S where S.set_id=" + setId + " and E.type=S.type and " + sEqualsE + ") " + "and E.birthday<>-1";
                                boolean silent = LocalEntityGraph.this.localSession.getSilent();
                                try {
                                    LocalEntityGraph.this.localSession.setSilent(true);
                                    long r = LocalEntityGraph.this.localSession.executeUpdate(remove);
                                    rc[0] = rc[0] + r;
                                }
                                catch (SQLException e) {
                                    Session._log.debug("failed, retry without alias (" + e.getMessage() + ")");
                                    remove = "Update " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + " set birthday=-1 Where " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + ".r_entitygraph=" + LocalEntityGraph.this.graphID + " and " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + ".type='" + association.destination.getName() + "' " + "and exists (Select * from " + SQLDialect.dmlTableReference("JAILER_SET", LocalEntityGraph.this.localSession) + " S where S.set_id=" + setId + " and " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + ".type=S.type and " + sEqualsEWoAlias + ") " + "and " + SQLDialect.dmlTableReference("JAILER_ENTITY", LocalEntityGraph.this.localSession) + ".birthday<>-1";
                                    rc[0] = rc[0] + (long)LocalEntityGraph.this.localSession.executeUpdate(remove);
                                }
                                finally {
                                    LocalEntityGraph.this.localSession.setSilent(silent);
                                }
                                LocalEntityGraph.this.localSession.executeUpdate("Delete from " + SQLDialect.dmlTableReference("JAILER_SET", LocalEntityGraph.this.localSession) + " where set_id=" + setId + "");
                            }
                        }
                    });
                }
            });
            return rc[0];
        }
        return 0L;
    }

    @Override
    public void readDependentEntities(final Table table, Association association, ResultSet resultSet, ResultSetMetaData resultSetMetaData, final Session.ResultSetReader reader, Map<String, Integer> theTypeCache, final String selectionSchema, final String originalPKAliasPrefix) throws SQLException {
        String select = "Select " + this.upkColumnList(table, "TO_") + " from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " D" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, "D", "FROM_", theTypeCache, this.localSession) + " and D.to_type='" + table.getName() + "'" + " and D.from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and D.r_entitygraph=" + this.graphID;
        this.localSession.executeQuery(select, (Session.ResultSetReader)new RemoteInlineViewBuilder("D", this.upkColumnList(table, "TO_"), true){

            @Override
            protected void process(String inlineView) throws SQLException {
                String select;
                if (originalPKAliasPrefix != null) {
                    StringBuffer selectOPK = new StringBuffer();
                    for (int i = 0; i < table.primaryKey.getColumns().size(); ++i) {
                        if (i > 0) {
                            selectOPK.append(", ");
                        }
                        selectOPK.append("T." + table.primaryKey.getColumns().get((int)i).name + " AS " + originalPKAliasPrefix + i);
                    }
                    select = "Select " + selectionSchema + " from (" + "Select " + selectOPK + ", " + LocalEntityGraph.this.filteredSelectionClause(table) + " from " + table.getName() + " T join " + inlineView + " on " + LocalEntityGraph.this.pkEqualsEntityID(table, "T", "D", "TO_", false) + ") T";
                } else {
                    select = "Select " + selectionSchema + " from " + table.getName() + " T join " + inlineView + " on " + LocalEntityGraph.this.pkEqualsEntityID(table, "T", "D", "TO_", false) + "";
                }
                long rc = LocalEntityGraph.this.remoteSession.executeQuery(select, reader);
                ProgressListenerRegistry.getProgressListener().exported(table, rc);
            }
        });
    }

    @Override
    public void markDependentEntitiesAsTraversed(Association association, ResultSet resultSet, ResultSetMetaData resultSetMetaData, Map<String, Integer> typeCache) throws SQLException {
        String update = this.localSession.dbms == DBMS.SYBASE ? "Update " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " set traversed=1" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession), "FROM_", typeCache, this.localSession) + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + ".r_entitygraph=" + this.graphID : "Update " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " D set traversed=1" + " Where " + this.pkEqualsEntityID(association.source, resultSet, resultSetMetaData, "D", "FROM_", typeCache, this.localSession) + " and D.from_type='" + association.source.getName() + "' and assoc=" + association.getId() + " and D.r_entitygraph=" + this.graphID;
        this.localSession.executeUpdate(update);
    }

    @Override
    public void readNonTraversedDependencies(Table table, Session.ResultSetReader reader) throws SQLException {
        String select = "Select * from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " D " + " Where (traversed is null or traversed <> 1)" + " and D.from_type='" + table.getName() + "'" + " and D.r_entitygraph=" + this.graphID;
        this.localSession.executeQuery(select, reader);
    }

    @Override
    public void removeReflexiveDependencies(Table table) throws SQLException {
        Map<Column, Column> match = this.upkMatch(table);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("FROM_" + column.name + " = TO_" + column.name);
        }
        String delete = "Delete from " + SQLDialect.dmlTableReference("JAILER_DEPENDENCY", this.localSession) + " Where " + sb + " and from_type='" + table.getName() + "'" + " and to_type='" + table.getName() + "'" + " and r_entitygraph=" + this.graphID;
        this.localSession.executeUpdate(delete);
    }

    private String pkEqualsEntityID(Table table, ResultSet resultSet, ResultSetMetaData resultSetMetaData, String alias, String columnPrefix, Map<String, Integer> typeCache, Session localSession) throws SQLException {
        Map<Column, Column> match = this.upkMatch(table);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(alias + "." + columnPrefix + column.name);
            Column tableColumn = match.get(column);
            if (tableColumn != null) {
                int i = 0;
                for (Column c : table.primaryKey.getColumns()) {
                    if (c.name.equals(tableColumn.name)) break;
                    ++i;
                }
                sb.append("=" + SqlUtil.toSql(SqlUtil.toSql(SqlUtil.getObject(resultSet, resultSetMetaData, "PK" + i, typeCache), localSession), localSession));
                continue;
            }
            sb.append(" is null");
        }
        return sb.toString();
    }

    private String pkEqualsEntityID(Table table, String tableAlias, String entityAlias, String columnPrefix, boolean checkNull) {
        Map<Column, Column> match = this.upkMatch(table);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (!checkNull && tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(entityAlias + "." + columnPrefix + column.name);
            if (tableColumn != null) {
                if (this.fieldProcTables.contains(table.getUnqualifiedName().toLowerCase())) {
                    sb.append(" = " + tableColumn.type + "(" + tableAlias + "." + tableColumn.name + ")");
                    continue;
                }
                sb.append("=" + tableAlias + "." + tableColumn.name);
                continue;
            }
            sb.append(" is null");
        }
        return sb.toString();
    }

    private String pkList(Table table, String tableAlias) {
        return this.pkList(table, tableAlias, null);
    }

    private String pkList(Table table, String tableAlias, String columnAliasPrefix) {
        Map<Column, Column> match = this.upkMatch(table);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (tableAlias != null) {
                sb.append(tableAlias + ".");
            }
            sb.append(tableColumn.name);
            sb.append(" AS " + (columnAliasPrefix == null ? "" : columnAliasPrefix) + column.name);
        }
        return sb.toString();
    }

    private String upkColumnList(Table table, String columnAliasPrefix) {
        return this.upkColumnList(table, null, columnAliasPrefix);
    }

    private String upkColumnList(Table table, String tableAlias, String columnAliasPrefix) {
        Map<Column, Column> match = this.upkMatch(table);
        StringBuffer sb = new StringBuffer();
        for (Column column : this.universalPrimaryKey.getColumns()) {
            Column tableColumn = match.get(column);
            if (tableColumn == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (tableAlias != null) {
                sb.append(tableAlias + ".");
            }
            if (columnAliasPrefix != null) {
                sb.append(columnAliasPrefix);
            }
            sb.append(column.name);
        }
        return sb.toString();
    }

    @Override
    public List<String> getStatistics(DataModel dataModel, Set<Table> tables) throws SQLException {
        return this.getStatistics(this.localSession, dataModel, tables);
    }

    @Override
    public long getTotalRowcount() {
        return this.totalRowcount;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = false;
    }

    @Override
    public PrimaryKey getUniversalPrimaryKey() {
        return this.universalPrimaryKey;
    }

    private synchronized int getNextSetId() {
        return this.graphID + this.nextSetId++;
    }

    @Override
    public void shutDown() throws SQLException {
        this.localSession.shutDown();
    }

    @Override
    public Session getSession() {
        return this.localSession;
    }

    @Override
    public DataModel getDatamodel() {
        return this.dataModel;
    }

    @Override
    public Session getTargetSession() {
        return this.remoteSession;
    }

    private abstract class LocalInlineViewBuilder
    extends InlineViewBuilder {
        private final boolean allUPK;

        public LocalInlineViewBuilder(String name, String columnList) {
            this(name, columnList, false);
        }

        public LocalInlineViewBuilder(String name, String columnList, boolean allUPK) {
            super(LocalEntityGraph.this.localInlineViewStyle, name, LocalEntityGraph.this.localSession, columnList.split(", *"));
            this.allUPK = allUPK;
        }

        @Override
        protected String sqlValue(ResultSet resultSet, int i) throws SQLException {
            String value = SqlUtil.toSql(SqlUtil.getObject(resultSet, this.resultSetMetaData, i, this.typeCache), this.session);
            if (this.allUPK || LocalEntityGraph.this.isUPKColumn(this.columnNames[i - 1])) {
                value = SqlUtil.toSql(value, this.session);
            }
            return value;
        }
    }

    private abstract class RemoteInlineViewBuilder
    extends InlineViewBuilder {
        private final boolean allUPK;

        public RemoteInlineViewBuilder(String name, String columnList) {
            this(name, columnList, false);
        }

        public RemoteInlineViewBuilder(String name, String columnList, boolean allUPK) {
            super(LocalEntityGraph.this.remoteInlineViewStyle, name, LocalEntityGraph.this.remoteSession, columnList.split(", *"));
            this.allUPK = allUPK;
        }

        @Override
        protected String sqlValue(ResultSet resultSet, int i) throws SQLException {
            String prefix;
            Object value = SqlUtil.getObject(resultSet, this.resultSetMetaData, i, this.typeCache);
            if (!this.allUPK && !LocalEntityGraph.this.isUPKColumn(this.columnNames[i - 1])) {
                value = SqlUtil.toSql(value, this.session);
            } else if (value instanceof String && LocalEntityGraph.this.isNUPKColumn(this.columnNames[i - 1]) && (prefix = Configuration.forDbms(LocalEntityGraph.this.remoteSession).getNcharPrefix()) != null) {
                value = prefix + value;
            }
            return (String)value;
        }
    }
}

