/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.entitygraph.local;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sf.jailer.database.Session;

enum InlineViewStyle {
    DB2("(values (1, '2', 3), (4, '5', 6)) %s(A, B, C)"){

        @Override
        String head(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames) throws SQLException {
            return "(values ";
        }

        @Override
        String item(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames, int rowNumber) throws SQLException {
            StringBuilder sb = new StringBuilder("(");
            for (int i = 1; i <= columnNames.length; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(values[i - 1]);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        String separator(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
            return ", ";
        }

        @Override
        String terminator(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String name, String[] columnNames) throws SQLException {
            StringBuilder sb = new StringBuilder(") " + name + "(");
            for (int i = 1; i <= columnNames.length; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(columnNames[i - 1]);
            }
            sb.append(")");
            return sb.toString();
        }
    }
    ,
    MySQL("(Select 1 A, '2' B, 3 C Union all Select 4, '5', 6) %s"){

        @Override
        String head(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames) throws SQLException {
            return "(Select ";
        }

        @Override
        String item(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames, int rowNumber) throws SQLException {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i <= columnNames.length; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(values[i - 1]);
                if (rowNumber != 0) continue;
                sb.append(" " + columnNames[i - 1]);
            }
            return sb.toString();
        }

        @Override
        String separator(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
            return " Union all Select ";
        }

        @Override
        String terminator(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String name, String[] columnNames) throws SQLException {
            return ") " + name;
        }
    }
    ,
    Oracle("(Select 1 A, '2' B, 3 C from dual Union all Select 4, '5', 6 from dual) %s"){

        @Override
        String head(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames) throws SQLException {
            return "(Select ";
        }

        @Override
        String item(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String[] values, String[] columnNames, int rowNumber) throws SQLException {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i <= columnNames.length; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(values[i - 1]);
                if (rowNumber != 0) continue;
                sb.append(" " + columnNames[i - 1]);
            }
            return sb.toString();
        }

        @Override
        String separator(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
            return " from dual Union all Select ";
        }

        @Override
        String terminator(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String name, String[] columnNames) throws SQLException {
            StringBuilder sb = new StringBuilder(" from dual) " + name);
            return sb.toString();
        }
    };

    public final String example;

    private InlineViewStyle(String example) {
        this.example = example;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InlineViewStyle forSession(Session session) {
        for (InlineViewStyle style : InlineViewStyle.values()) {
            boolean wasSilent = session.getSilent();
            try {
                session.setSilent(true);
                session.executeQuery("Select * from " + style.example.replace("%s", "Entity"), (Session.ResultSetReader)new Session.AbstractResultSetReader(){

                    @Override
                    public void readCurrentRow(ResultSet resultSet) throws SQLException {
                        resultSet.getInt("A");
                        resultSet.getInt("B");
                        resultSet.getInt("C");
                    }
                });
                InlineViewStyle inlineViewStyle = style;
                return inlineViewStyle;
            }
            catch (SQLException e) {
            }
            finally {
                session.setSilent(wasSilent);
            }
        }
        throw new RuntimeException("No suitable Inline-View Style known for " + session.dbUrl);
    }

    abstract String head(ResultSet var1, ResultSetMetaData var2, String[] var3, String[] var4) throws SQLException;

    abstract String item(ResultSet var1, ResultSetMetaData var2, String[] var3, String[] var4, int var5) throws SQLException;

    abstract String separator(ResultSet var1, ResultSetMetaData var2) throws SQLException;

    abstract String terminator(ResultSet var1, ResultSetMetaData var2, String var3, String[] var4) throws SQLException;
}

