/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.entitygraph.local;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatementBuilder;
import net.sf.jailer.entitygraph.local.InlineViewStyle;
import net.sf.jailer.util.SqlUtil;

public abstract class InlineViewBuilder
implements Session.ResultSetReader {
    private final InlineViewStyle style;
    public static final String DEFAULT_NAME = "JAILER_IV";
    private static final int MAX_SIZE = 35;
    protected final String name;
    private final StatementBuilder statementBuilder;
    protected ResultSetMetaData resultSetMetaData = null;
    protected Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();
    protected final Session session;
    protected final String[] columnNames;

    public InlineViewBuilder(InlineViewStyle style, String name, Session session, String[] columnNames) {
        this.name = name;
        this.style = style;
        this.session = session;
        this.columnNames = columnNames;
        this.statementBuilder = new StatementBuilder(35);
    }

    public InlineViewBuilder(InlineViewStyle style, Session session, String[] columnNames) {
        this(style, DEFAULT_NAME, session, columnNames);
    }

    @Override
    public void readCurrentRow(ResultSet resultSet) throws SQLException {
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = resultSet.getMetaData();
        }
        String[] values = new String[this.resultSetMetaData.getColumnCount()];
        for (int i = 1; i <= this.resultSetMetaData.getColumnCount(); ++i) {
            values[i - 1] = this.sqlValue(resultSet, i);
        }
        String head = this.style.head(resultSet, this.resultSetMetaData, values, this.columnNames);
        if (!this.statementBuilder.isAppendable(head)) {
            this.process(this.statementBuilder.build());
        }
        String item = this.style.item(resultSet, this.resultSetMetaData, values, this.columnNames, this.statementBuilder.size());
        this.statementBuilder.append(head, item, this.style.separator(resultSet, this.resultSetMetaData), this.style.terminator(resultSet, this.resultSetMetaData, this.name, this.columnNames));
    }

    protected String sqlValue(ResultSet resultSet, int i) throws SQLException {
        return SqlUtil.toSql(SqlUtil.getObject(resultSet, this.resultSetMetaData, i, this.typeCache), this.session);
    }

    @Override
    public void close() throws SQLException {
        if (!this.statementBuilder.isEmpty()) {
            this.process(this.statementBuilder.build());
        }
    }

    protected abstract void process(String var1) throws SQLException;
}

