/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.entitygraph;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.Table;

public abstract class EntityGraph {
    public static final String ENTITY_GRAPH = "JAILER_GRAPH";
    public static final String ENTITY_SET_ELEMENT = "JAILER_SET";
    public static final String ENTITY = "JAILER_ENTITY";
    public static final String DEPENDENCY = "JAILER_DEPENDENCY";
    public final DataModel dataModel;
    public final int graphID;
    public Map<Association, Integer> explainIdOfAssociation = new HashMap<Association, Integer>();
    private int lobCount = 0;
    public static long maxTotalRowcount;

    public abstract void setBirthdayOfSubject(int var1);

    protected EntityGraph(int graphID, DataModel dataModel) {
        this.graphID = graphID;
        this.dataModel = dataModel;
    }

    public abstract EntityGraph copy(int var1, Session var2) throws SQLException, Exception;

    public abstract EntityGraph find(int var1, Session var2, PrimaryKey var3) throws SQLException, Exception;

    public abstract int getAge() throws SQLException;

    public abstract void setAge(int var1) throws SQLException;

    public abstract long getSize() throws SQLException;

    public abstract void delete() throws SQLException;

    public abstract long addEntities(Table var1, String var2, int var3, long var4) throws SQLException;

    public abstract long resolveAssociation(Table var1, Association var2, int var3) throws SQLException;

    public abstract void addDependencies(Table var1, String var2, Table var3, String var4, String var5, int var6, int var7, boolean var8) throws SQLException;

    public abstract Set<Integer> getDistinctDependencyIDs() throws SQLException;

    public abstract void markIndependentEntities(Table var1) throws SQLException;

    public abstract void markRoots(Table var1) throws SQLException;

    public abstract void readMarkedEntities(Table var1, Session.ResultSetReader var2, boolean var3) throws SQLException;

    public abstract void readMarkedEntities(Table var1, Session.ResultSetReader var2, String var3, boolean var4) throws SQLException;

    public abstract void readMarkedEntities(Table var1, Session.ResultSetReader var2, String var3, String var4, boolean var5) throws SQLException;

    public abstract void uniteWith(EntityGraph var1) throws SQLException;

    public abstract void readEntities(Table var1, Session.ResultSetReader var2, boolean var3) throws SQLException;

    public abstract void deleteIndependentEntities(Table var1) throws SQLException;

    public abstract long deleteEntities(Table var1) throws SQLException;

    public abstract long countEntities(Table var1) throws SQLException;

    public abstract long removeAssociatedDestinations(Association var1, boolean var2) throws SQLException;

    public abstract void readDependentEntities(Table var1, Association var2, ResultSet var3, ResultSetMetaData var4, Session.ResultSetReader var5, Map<String, Integer> var6, String var7, String var8) throws SQLException;

    public abstract void markDependentEntitiesAsTraversed(Association var1, ResultSet var2, ResultSetMetaData var3, Map<String, Integer> var4) throws SQLException;

    public abstract void readNonTraversedDependencies(Table var1, Session.ResultSetReader var2) throws SQLException;

    public abstract void removeReflexiveDependencies(Table var1) throws SQLException;

    public abstract List<String> getStatistics(DataModel var1, Set<Table> var2) throws SQLException;

    public abstract long getTotalRowcount();

    public abstract void setExplain(boolean var1);

    public abstract PrimaryKey getUniversalPrimaryKey();

    public abstract void shutDown() throws SQLException;

    public abstract Session getSession();

    public static int createUniqueGraphID() {
        return Math.abs((int)System.currentTimeMillis());
    }

    public synchronized int incLobCount() {
        return ++this.lobCount;
    }

    public abstract DataModel getDatamodel();

    public abstract void close() throws SQLException;

    protected final List<String> getStatistics(Session session, final DataModel dataModel, Set<Table> tables) throws SQLException {
        final ArrayList<String> statistic = new ArrayList<String>();
        final long[] total = new long[]{0L};
        final HashSet<Table> remaining = new HashSet<Table>(tables);
        session.executeQuery("Select type, count(*) From " + SQLDialect.dmlTableReference(ENTITY, session) + " Where r_entitygraph=" + this.graphID + " and birthday>=0 group by type", (Session.ResultSetReader)new Session.AbstractResultSetReader(){

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                String type = resultSet.getString(1);
                Table table = dataModel.getTable(type);
                if (table != null) {
                    type = dataModel.getDisplayName(table);
                    remaining.remove(table);
                }
                long count = resultSet.getLong(2);
                total[0] = total[0] + count;
                while (type.length() < 30) {
                    type = type + " ";
                }
                statistic.add(type + " " + count);
            }
        });
        for (Table table : remaining) {
            String type = dataModel.getDisplayName(table);
            while (type.length() < 30) {
                type = type + " ";
            }
            statistic.add(type + " 0");
        }
        Collections.sort(statistic);
        statistic.add(0, "" + total[0]);
        return statistic;
    }

    public abstract Session getTargetSession();
}

