/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.enhancer;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Set;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.ScriptType;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.UPSERT_MODE;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.enhancer.ScriptEnhancer;
import net.sf.jailer.entitygraph.EntityGraph;

public class HelperTableEnhancer
implements ScriptEnhancer {
    private boolean dualNeeded(Set<Table> progress, SQLDialect sqlDialect) {
        if (sqlDialect.upsertMode != UPSERT_MODE.FROM_JL_DUAL) {
            return false;
        }
        if (CommandLineParser.getInstance().upsertOnly) {
            return true;
        }
        for (Table table : progress) {
            if (!table.getUpsert().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addComments(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
    }

    @Override
    public void addEpilog(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
        if (this.dualNeeded(progress, Configuration.forDbms(session).getSqlDialect())) {
            script.append("DROP TABLE JAILER_DUAL;\n");
        }
    }

    @Override
    public void addProlog(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
        if (this.dualNeeded(progress, Configuration.forDbms(session).getSqlDialect())) {
            script.append("CREATE TABLE JAILER_DUAL(D INTEGER);\n");
            script.append("INSERT INTO JAILER_DUAL(D) VALUES(1);\n");
        }
    }
}

