/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.enhancer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.ScriptType;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.enhancer.ScriptEnhancer;
import net.sf.jailer.entitygraph.EntityGraph;

public class FileBasedScriptEnhancer
implements ScriptEnhancer {
    @Override
    public void addComments(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
    }

    @Override
    public void addEpilog(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
        File dir = CommandLineParser.getInstance().newFile(CommandLineParser.getInstance().enhancerFolder + File.separatorChar + "epilog" + File.separatorChar + (Object)((Object)scriptType));
        this.addEnhancement(script, progress, dir);
        this.addEnhancement(script, dir, "EPILOG.sql");
    }

    @Override
    public void addProlog(Writer script, ScriptType scriptType, Session session, EntityGraph entityGraph, Set<Table> progress) throws IOException, SQLException {
        File dir = CommandLineParser.getInstance().newFile(CommandLineParser.getInstance().enhancerFolder + File.separatorChar + "prolog" + File.separatorChar + (Object)((Object)scriptType));
        this.addEnhancement(script, dir, "PROLOG.sql");
        this.addEnhancement(script, progress, dir);
    }

    private void addEnhancement(Writer script, Set<Table> progress, File dir) throws IOException {
        if (ScriptFormat.SQL.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
            TreeSet<String> fileNames = new TreeSet<String>();
            for (Table table : progress) {
                fileNames.add(table.getOriginalName() + ".sql");
            }
            for (String fileName : fileNames) {
                this.addEnhancement(script, dir, fileName);
            }
        }
    }

    private void addEnhancement(Writer script, File dir, String fileName) throws FileNotFoundException, IOException {
        File enhancement = new File(dir, fileName);
        if (enhancement.exists()) {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(enhancement));
            while ((line = in.readLine()) != null) {
                script.append(line);
                script.append(System.getProperty("line.separator", "\n"));
            }
            in.close();
        }
    }
}

