/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.domainmodel;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.domainmodel.Composite;
import net.sf.jailer.domainmodel.Domain;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.PrintUtil;
import org.apache.log4j.Logger;

public class DomainModel {
    Map<String, Domain> domains = new TreeMap<String, Domain>();
    private final DataModel dataModel;
    public final Map<Table, Composite> composites;
    private static final Logger _log = Logger.getLogger(DomainModel.class);
    private Map<Table, Composite> componentCache = new HashMap<Table, Composite>();
    private int numberOfWarnings = 0;
    private int numberOfErrors = 0;

    public DomainModel(DataModel dataModel) throws Exception {
        this.dataModel = dataModel;
        this.composites = new TreeMap<Table, Composite>();
        this.loadComposites();
        HashMap<String, CsvFile> csvFiles = new HashMap<String, CsvFile>();
        File domainModelDirectory = CommandLineParser.getInstance().newFile("domainmodel");
        if (!domainModelDirectory.exists() || !domainModelDirectory.isDirectory()) {
            return;
        }
        for (File domainFile : domainModelDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !"composites.csv".equalsIgnoreCase(name) && name.toLowerCase().endsWith(".csv");
            }
        })) {
            _log.info("loading domain " + domainFile);
            CsvFile csvFile = new CsvFile(domainFile);
            if (csvFile.getLines().isEmpty()) {
                throw new RuntimeException("empty domain file: " + domainFile);
            }
            String domainName = domainFile.getName().substring(0, domainFile.getName().length() - 4);
            if (domainName.length() == 0) {
                throw new RuntimeException("no domain name in: " + domainFile);
            }
            csvFiles.put(domainName, csvFile);
        }
        for (String domainName : csvFiles.keySet()) {
            TreeSet<Table> tables = new TreeSet<Table>();
            CsvFile csvFile = (CsvFile)csvFiles.get(domainName);
            for (int line = 1; line < csvFile.getLines().size(); ++line) {
                CsvFile.Line csvLine = csvFile.getLines().get(line);
                String tableName = csvLine.cells.get(0);
                Table table = dataModel.getTable(tableName);
                if (table == null) {
                    throw new RuntimeException(csvLine.location + ": unknown table '" + tableName + "'");
                }
                if (this.composites.get(table) == null) {
                    throw new RuntimeException(csvLine.location + ": table '" + tableName + "' is component of " + this.getComposite(table) + ".");
                }
                tables.addAll(this.composites.get((Object)table).componentTables);
                tables.add(table);
            }
            Domain domain = new Domain(domainName, tables);
            this.domains.put(domainName, domain);
        }
        for (String domainName : csvFiles.keySet()) {
            Domain domain = this.domains.get(domainName);
            CsvFile.Line containsLine = ((CsvFile)csvFiles.get(domainName)).getLines().get(0);
            for (String subDomainName : containsLine.cells) {
                if (subDomainName == null || subDomainName.length() <= 0) continue;
                Domain subDomain = this.domains.get(subDomainName);
                if (subDomain == null) {
                    throw new RuntimeException(containsLine.location + ": unknown domain '" + subDomainName + "'");
                }
                domain.subDomains.add(subDomain);
                subDomain.superDomains.add(domain);
            }
        }
    }

    private void loadComposites() throws Exception {
        File compositesDefinition = CommandLineParser.getInstance().newFile("domainmodel" + File.separator + "composites.csv");
        HashMap<Table, CsvFile.Line> compositeDefinitionOfTable = new HashMap<Table, CsvFile.Line>();
        if (compositesDefinition.exists()) {
            CsvFile compostitesCsvFile = new CsvFile(compositesDefinition);
            for (CsvFile.Line line : compostitesCsvFile.getLines()) {
                Table table = this.dataModel.getTable(line.cells.get(0));
                if (table == null) {
                    throw new RuntimeException("unknown table '" + line.cells.get(0) + "'");
                }
                if (compositeDefinitionOfTable.containsKey(table)) {
                    throw new RuntimeException("duplicate composite definition for '" + line.cells.get(0) + "'");
                }
                compositeDefinitionOfTable.put(table, line);
            }
        } else {
            _log.info("no composites definition (" + compositesDefinition + ")");
        }
        HashSet<Table> allComponents = new HashSet<Table>();
        for (Table table : this.dataModel.getTables()) {
            CsvFile.Line line = (CsvFile.Line)compositeDefinitionOfTable.get(table);
            if (line == null) continue;
            allComponents.add(table);
            ArrayList<Table> components = new ArrayList<Table>();
            int i = 1;
            while (line.cells.get(i).length() > 0) {
                Table component = this.dataModel.getTable(line.cells.get(i));
                if (component == null) {
                    throw new RuntimeException("unknown table '" + line.cells.get(i) + "'");
                }
                allComponents.add(component);
                components.add(component);
                ++i;
            }
            this.composites.put(table, new Composite(table, components));
        }
        for (Table table : this.dataModel.getTables()) {
            if (allComponents.contains(table)) continue;
            this.composites.put(table, new Composite(table, new ArrayList<Table>()));
        }
    }

    public Map<String, Domain> getDomains() {
        return this.domains;
    }

    public Domain getDomain(Table table) {
        for (Domain domain : this.domains.values()) {
            if (!domain.tables.contains(table)) continue;
            return domain;
        }
        return null;
    }

    public Composite getComposite(Table table) {
        if (this.componentCache.containsKey(table)) {
            return this.componentCache.get(table);
        }
        for (Composite composite : this.composites.values()) {
            if (!composite.mainTable.equals(table) && !composite.componentTables.contains(table)) continue;
            this.componentCache.put(table, composite);
            return composite;
        }
        return null;
    }

    public boolean check() {
        TreeSet<Table> withoutDomain = new TreeSet<Table>();
        for (Table table : this.dataModel.getTables()) {
            TreeSet<Domain> domainsOfTable = new TreeSet<Domain>();
            for (Domain domain : this.domains.values()) {
                if (!domain.tables.contains(table)) continue;
                domainsOfTable.add(domain);
            }
            if (domainsOfTable.size() == 0) {
                withoutDomain.add(table);
            }
            if (domainsOfTable.size() <= 1) continue;
            this.printError("Table '" + table.getName() + "' in more than 1 domain: " + domainsOfTable);
        }
        if (withoutDomain.size() > 0) {
            this.warn("Tables without domain: " + PrintUtil.tableSetAsString(withoutDomain, "    "));
        }
        for (Domain domain : this.domains.values()) {
            for (Table table : domain.tables) {
                for (Association association : table.associations) {
                    Domain destinationDomain;
                    if (association.isIgnored() || (destinationDomain = this.getDomain(association.destination)) != null && (destinationDomain.equals(domain) || destinationDomain.isSubDomainOf(domain))) continue;
                    String associationName = association.source.getName() + "->" + association.destination.getName();
                    this.warn((association.isInsertDestinationBeforeSource() ? "dependency '" : "association '") + associationName + "' deserts " + domain + (destinationDomain != null ? " to " + destinationDomain : ""));
                }
            }
        }
        System.out.println(this.numberOfErrors + " errors");
        System.out.println(this.numberOfWarnings + " warnings");
        return this.numberOfErrors == 0;
    }

    private void warn(String message) {
        System.out.println("warning: " + message);
        ++this.numberOfWarnings;
    }

    private void printError(String message) {
        System.out.println("error: " + message);
        ++this.numberOfErrors;
    }

    public String toString() {
        StringBuffer modelAsString = new StringBuffer("domain model:\n");
        for (Domain domain : this.domains.values()) {
            if (!domain.superDomains.isEmpty()) continue;
            modelAsString.append(this.domainTree(domain, 0, this.domains.size() + 2));
        }
        modelAsString.append("\n");
        for (Domain domain : this.domains.values()) {
            modelAsString.append(domain.name + " = " + PrintUtil.tableSetAsString(domain.tables, "        ") + "\n");
        }
        return modelAsString.toString();
    }

    private StringBuffer domainTree(Domain domain, int indent, int maxLevel) {
        if (indent > maxLevel) {
            throw new RuntimeException("cyclic domain containment: '" + domain.name + "'");
        }
        StringBuffer domainAsString = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            domainAsString.append("  ");
        }
        domainAsString.append(domain.name + "\n");
        for (Domain subDomain : domain.subDomains) {
            domainAsString.append(this.domainTree(subDomain, indent + 1, maxLevel));
        }
        return domainAsString;
    }
}

