/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.domainmodel;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jailer.datamodel.Table;

public class Domain
implements Comparable<Domain> {
    public final String name;
    public final Set<Table> tables;
    Set<Domain> subDomains = new TreeSet<Domain>();
    Set<Domain> superDomains = new TreeSet<Domain>();

    Domain(String name, Set<Table> tables) {
        this.name = name;
        this.tables = tables;
    }

    public Set<Domain> getSubDomains() {
        return this.subDomains;
    }

    public Set<Domain> getSuperDomains() {
        return this.superDomains;
    }

    public boolean isSubDomainOf(Domain domain) {
        HashSet<Domain> superClosure = new HashSet<Domain>(this.superDomains);
        boolean ready = false;
        while (!ready) {
            HashSet<Domain> increment = new HashSet<Domain>();
            for (Domain superDomain : superClosure) {
                increment.addAll(superDomain.superDomains);
            }
            increment.removeAll(superClosure);
            superClosure.addAll(increment);
            if (!increment.isEmpty()) continue;
            break;
        }
        return superClosure.contains(domain);
    }

    @Override
    public int compareTo(Domain o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Domain) {
            return this.name.equals(((Domain)other).name);
        }
        return false;
    }

    public String toString() {
        return "Domain " + this.name;
    }
}

