/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.domainmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Table;

public class Composite {
    public final Table mainTable;
    public final List<Table> componentTables;

    public Composite(Table mainTable, List<Table> componentTables) {
        this.mainTable = mainTable;
        this.componentTables = new ArrayList<Table>(componentTables);
        Collections.sort(this.componentTables);
    }

    public Set<Association> getAssociations() {
        HashSet<Association> associationSet = new HashSet<Association>();
        HashSet<Table> allTables = new HashSet<Table>();
        allTables.add(this.mainTable);
        allTables.addAll(this.componentTables);
        for (Table table : allTables) {
            for (Association a : table.associations) {
                if (allTables.contains(a.destination)) continue;
                associationSet.add(a);
            }
        }
        return associationSet;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.componentTables.isEmpty() ? "Table " : "Composite ");
        str.append(this.mainTable.getName());
        return str.toString();
    }
}

