/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.dbunit;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.Base64;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FlatXMLTransformer
extends Session.AbstractResultSetReader {
    private final String rowElementName;
    private final TransformerHandler transformerHandler;
    private int columnCount;
    private String[] columnLabel = null;
    private Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();
    private final DBMS dbms;

    public FlatXMLTransformer(Table table, TransformerHandler transformerHandler, DatabaseMetaData metaData, DBMS dbms) throws SQLException {
        this.transformerHandler = transformerHandler;
        this.rowElementName = this.qualifiedTableName(table);
        this.dbms = dbms;
    }

    private String qualifiedTableName(Table t) {
        String schema = t.getOriginalSchema("");
        String mappedSchema = CommandLineParser.getInstance().getSchemaMapping().get(schema);
        if (mappedSchema != null) {
            schema = mappedSchema;
        }
        if (schema.length() == 0) {
            return this.unquote(t.getUnqualifiedName());
        }
        return this.unquote(schema) + "." + this.unquote(t.getUnqualifiedName());
    }

    private String unquote(String name) {
        String fcStr;
        char fc;
        if (!name.isEmpty() && !Character.isLetterOrDigit(fc = name.charAt(0)) && fc != '_' && name.startsWith(fcStr = Character.toString(fc)) && name.endsWith(fcStr)) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readCurrentRow(ResultSet resultSet) throws SQLException {
        if (this.columnLabel == null) {
            this.columnCount = this.getMetaData(resultSet).getColumnCount();
            this.columnLabel = new String[this.columnCount + 1];
            for (int i = 1; i <= this.columnCount; ++i) {
                String mdColumnLabel;
                this.columnLabel[i] = mdColumnLabel = this.getMetaData(resultSet).getColumnLabel(i);
            }
        }
        try {
            AttributesImpl attr = new AttributesImpl();
            for (int i = 1; i <= this.columnCount; ++i) {
                String value;
                if (this.columnLabel[i] == null || (value = this.getValue(resultSet, i, this.typeCache, this.dbms)) == null) continue;
                attr.addAttribute("", "", this.columnLabel[i], "CDATA", value);
            }
            TransformerHandler transformerHandler = this.transformerHandler;
            synchronized (transformerHandler) {
                this.transformerHandler.startElement("", "", this.rowElementName, attr);
                this.transformerHandler.endElement("", "", this.rowElementName);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private String getValue(ResultSet resultSet, int i, Map<Integer, Integer> typeCache, DBMS dbms) throws SQLException {
        Object object;
        Integer type = typeCache.get(i);
        if (type == null) {
            try {
                type = this.getMetaData(resultSet).getColumnType(i);
                if (dbms == DBMS.ORACLE && type == 91) {
                    type = 93;
                }
            }
            catch (SQLException e) {
                type = 1111;
            }
            typeCache.put(i, type);
        }
        if ((object = type == 93 ? resultSet.getTimestamp(i) : (type == 92 ? resultSet.getTime(i) : (type == 91 ? resultSet.getDate(i) : resultSet.getObject(i)))) == null || resultSet.wasNull()) {
            return Configuration.getNullColumnPlaceholder();
        }
        if (object instanceof byte[]) {
            return Base64.encodeBytes((byte[])object);
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            byte[] blobValue = blob.getBytes(1L, (int)blob.length());
            return Base64.encodeBytes(blobValue);
        }
        if (object instanceof Clob) {
            Clob clobValue = (Clob)object;
            int length = (int)clobValue.length();
            if (length > 0) {
                return clobValue.getSubString(1L, length);
            }
            return "";
        }
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.columnLabel != null) {
            TransformerHandler transformerHandler = this.transformerHandler;
            synchronized (transformerHandler) {
                try {
                    String content = "\n\n  ";
                    this.transformerHandler.characters(content.toCharArray(), 0, content.length());
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

