/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.ModelElement;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.util.Quoting;
import net.sf.jailer.xml.NodeVisitor;
import net.sf.jailer.xml.XmlUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Table
extends ModelElement
implements Comparable<Table> {
    private final String name;
    public final PrimaryKey primaryKey;
    private List<Column> columns;
    public final List<Association> associations = new ArrayList<Association>();
    public Boolean upsert;
    public final boolean defaultUpsert;
    private String xmlTemplate = null;
    private String originalName;

    public Table(String name, PrimaryKey primaryKey, boolean defaultUpsert) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.defaultUpsert = defaultUpsert;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getUpsert() {
        return this.upsert == null ? this.defaultUpsert : this.upsert;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return this.columns;
    }

    public boolean equals(Object other) {
        if (other instanceof Table) {
            return this.name.equals(((Table)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String str = this.name + " (" + this.primaryKey + ")\n";
        ArrayList<Association> all = new ArrayList<Association>(this.associations);
        Collections.sort(all, new Comparator<Association>(){

            @Override
            public int compare(Association o1, Association o2) {
                return o1.destination.getName().compareTo(o2.destination.getName());
            }
        });
        ArrayList<Association> dep = new ArrayList<Association>();
        ArrayList<Association> hasDep = new ArrayList<Association>();
        ArrayList<Association> assoc = new ArrayList<Association>();
        ArrayList<Association> ignored = new ArrayList<Association>();
        for (Association association : all) {
            if (association.isIgnored()) {
                ignored.add(association);
                continue;
            }
            if (association.isInsertDestinationBeforeSource()) {
                dep.add(association);
                continue;
            }
            if (association.isInsertSourceBeforeDestination()) {
                hasDep.add(association);
                continue;
            }
            assoc.add(association);
        }
        if (!dep.isEmpty()) {
            str = str + "\n  depends on:\n";
            for (Association association : dep) {
                if ("".equals(association.toString())) continue;
                str = str + "    " + association + "\n";
            }
        }
        if (!hasDep.isEmpty()) {
            str = str + "\n  has dependent:\n";
            for (Association association : hasDep) {
                if ("".equals(association.toString())) continue;
                str = str + "    " + association + "\n";
            }
        }
        if (!assoc.isEmpty()) {
            str = str + "\n  is associated with:\n";
            for (Association association : assoc) {
                if ("".equals(((Object)assoc).toString())) continue;
                str = str + "    " + association + "\n";
            }
        }
        if (!ignored.isEmpty()) {
            str = str + "\n  ignored:\n";
            for (Association association : ignored) {
                if ("".equals(association.toString())) continue;
                str = str + "    " + association + "\n";
            }
        }
        return str + "\n";
    }

    @Override
    public int compareTo(Table o) {
        return this.name.compareTo(o.name);
    }

    public Set<Table> closure(boolean directed) {
        return this.closure(new HashSet<Table>(), new HashSet<Table>(), directed);
    }

    public Set<Table> closure(Set<Table> tablesToIgnore, boolean directed) {
        return this.closure(new HashSet<Table>(), tablesToIgnore, directed);
    }

    private Set<Table> closure(Set<Table> tables, Set<Table> tablesToIgnore, boolean directed) {
        HashSet<Table> closure = new HashSet<Table>();
        if (!tables.contains(this) && !tablesToIgnore.contains(this)) {
            closure.add(this);
            tables.add(this);
            for (Association association : this.associations) {
                if (tables.contains(association.destination) || association.getJoinCondition() == null && (association.reversalAssociation.getJoinCondition() == null || directed)) continue;
                closure.addAll(association.destination.closure(tables, tablesToIgnore, directed));
            }
        }
        return closure;
    }

    public Set<Table> unrestrictedClosure(Set<Table> tables) {
        HashSet<Table> closure = new HashSet<Table>();
        if (!tables.contains(this)) {
            closure.add(this);
            tables.add(this);
            for (Association association : this.associations) {
                if (tables.contains(association.destination)) continue;
                closure.addAll(association.destination.unrestrictedClosure(tables));
            }
        }
        return closure;
    }

    public void setXmlTemplate(String xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }

    public String getXmlTemplate() {
        return this.xmlTemplate;
    }

    public Document getXmlTemplateAsDocument() throws ParserConfigurationException, SAXException, IOException {
        return this.getXmlTemplateAsDocument(this.xmlTemplate);
    }

    public Document getDefaultXmlTemplate() throws ParserConfigurationException, SAXException, IOException {
        return this.getXmlTemplateAsDocument(null);
    }

    private Document getXmlTemplateAsDocument(String xmlTemplate) throws ParserConfigurationException, SAXException, IOException {
        Document template = xmlTemplate == null ? this.createInitialXmlTemplate() : XmlUtil.parse(xmlTemplate);
        this.removeNonAggregatedAssociationElements((Element)template.getChildNodes().item(0));
        final HashSet mappedAssociations = new HashSet();
        XmlUtil.visitDocumentNodes(template, new NodeVisitor(){

            @Override
            public void visitAssociationElement(String associationName) {
                mappedAssociations.add(associationName);
            }

            @Override
            public void visitElementEnd(String elementName, boolean isRoot) {
            }

            @Override
            public void visitText(String text) {
            }

            @Override
            public void visitComment(String comment) {
            }

            @Override
            public void visitElementStart(String elementName, boolean isRoot, String[] attributeNames, String[] attributeValues) {
            }
        });
        for (Association a : this.associations) {
            if (a.getAggregationSchema() == AggregationSchema.NONE || mappedAssociations.contains(a.getName())) continue;
            Comment comment = template.createComment("associated " + a.destination.getUnqualifiedName() + (Cardinality.MANY_TO_ONE.equals((Object)a.getCardinality()) || Cardinality.ONE_TO_ONE.equals((Object)a.getCardinality()) ? " row" : " rows"));
            template.getChildNodes().item(0).appendChild(comment);
            Element associationElement = template.createElementNS("http://jailer.sf.net/", "assoc");
            associationElement.setPrefix("j");
            associationElement.appendChild(template.createTextNode(a.getName()));
            template.getChildNodes().item(0).appendChild(associationElement);
        }
        return template;
    }

    private void removeNonAggregatedAssociationElements(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element e = (Element)children.item(i);
                if ("http://jailer.sf.net/".equals(e.getNamespaceURI()) && "assoc".equals(e.getLocalName())) {
                    boolean f = false;
                    for (Association a : this.associations) {
                        if (a.getAggregationSchema() == AggregationSchema.NONE || e.getTextContent() == null || !a.getName().equals(e.getTextContent().trim())) continue;
                        f = true;
                        break;
                    }
                    if (f) {
                        ++i;
                        continue;
                    }
                    element.removeChild(e);
                    continue;
                }
                this.removeNonAggregatedAssociationElements(e);
                ++i;
                continue;
            }
            ++i;
        }
    }

    private Document createInitialXmlTemplate() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document template = builder.newDocument();
        Element root = template.createElement(XmlUtil.asElementName(this.getUnqualifiedName().toLowerCase()));
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:j", "http://jailer.sf.net/");
        template.appendChild(root);
        boolean commented = false;
        for (Column column : this.getColumns()) {
            if (!commented) {
                Comment comment = template.createComment("columns of " + this.getUnqualifiedName() + " as T");
                root.appendChild(comment);
                commented = true;
            }
            boolean isPK = false;
            for (Column pk : this.primaryKey.getColumns()) {
                if (!pk.name.equals(column.name)) continue;
                isPK = true;
                break;
            }
            Element columnElement = template.createElement(XmlUtil.asElementName(column.name.toLowerCase()));
            if (!isPK) {
                columnElement.setAttribute("j:if-not-null", "SQL:T." + column.name);
            }
            columnElement.setTextContent("SQL:T." + column.name);
            root.appendChild(columnElement);
        }
        return template;
    }

    public String getOriginalSchema(String defaultSchema) {
        int i = this.indexOfDot(this.getOriginalName());
        if (i >= 0) {
            return this.getOriginalName().substring(0, i);
        }
        return defaultSchema;
    }

    public String getSchema(String defaultSchema) {
        int i = this.indexOfDot(this.name);
        if (i >= 0) {
            return this.name.substring(0, i);
        }
        return defaultSchema;
    }

    public String getUnqualifiedName() {
        int i = this.indexOfDot(this.name);
        if (i >= 0) {
            return this.name.substring(i + 1);
        }
        return this.name;
    }

    private int indexOfDot(String fullName) {
        int end;
        char c;
        if (fullName.length() > 0 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789".indexOf(c = fullName.charAt(0)) < 0 && (end = fullName.substring(1).indexOf(c)) >= 0) {
            int i;
            if ((i = fullName.substring(++end).indexOf(46)) >= 0) {
                return i + end;
            }
            return -1;
        }
        return fullName.indexOf(46);
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalName() {
        return this.originalName == null ? this.name : this.originalName;
    }

    public boolean exists(Session session, String defaultSchema) throws SQLException {
        String tableNameToUpper;
        String tableNameToLower;
        String tableName;
        Quoting quoting;
        String schema;
        DatabaseMetaData metaData = session.getMetaData();
        if (this.exists(metaData, schema = (quoting = new Quoting(metaData)).unquote(this.getSchema(defaultSchema)), tableName = quoting.unquote(this.getUnqualifiedName()))) {
            return true;
        }
        String schemaToLower = schema.equals(this.getSchema(defaultSchema)) ? schema.toLowerCase() : schema;
        String string = tableNameToLower = tableName.equals(this.getUnqualifiedName()) ? tableName.toLowerCase() : tableName;
        if (this.exists(metaData, schemaToLower, tableNameToLower)) {
            return true;
        }
        String schemaToUpper = schema.equals(this.getSchema(defaultSchema)) ? schema.toUpperCase() : schema;
        String string2 = tableNameToUpper = tableName.equals(this.getUnqualifiedName()) ? tableName.toUpperCase() : tableName;
        return this.exists(metaData, schemaToUpper, tableNameToUpper);
    }

    private boolean exists(DatabaseMetaData metaData, String schema, String tableName) throws SQLException {
        ResultSet rs = metaData.getTables(null, schema, tableName, new String[]{"TABLE"});
        boolean exists = rs.next();
        rs.close();
        return exists;
    }
}

