/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.PrimaryKey;

public class PrimaryKeyFactory {
    private boolean closed = false;
    private PrimaryKey universalPrimaryKey = new PrimaryKey(new ArrayList<Column>());

    public PrimaryKey createPrimaryKey(List<Column> columns) {
        if (this.closed) {
            throw new IllegalStateException("factory is closed");
        }
        PrimaryKey primaryKey = new PrimaryKey(columns);
        if (Configuration.getDoMinimizeUPK()) {
            HashSet<Integer> assignedUPKColumns = new HashSet<Integer>();
            for (Column column : columns) {
                boolean assigned = false;
                for (int i = 0; i < this.universalPrimaryKey.getColumns().size(); ++i) {
                    if (assignedUPKColumns.contains(i)) continue;
                    Column uPKColumn = this.universalPrimaryKey.getColumns().get(i);
                    if (uPKColumn.type.equalsIgnoreCase(column.type) && column.precision < 0 && uPKColumn.precision < 0) {
                        if (column.length > 0 && uPKColumn.length > 0 && column.length > uPKColumn.length) {
                            this.universalPrimaryKey.getColumns().set(i, new Column(uPKColumn.name, uPKColumn.type, column.length, column.precision));
                        }
                        assigned = true;
                        assignedUPKColumns.add(i);
                        break;
                    }
                    if (!uPKColumn.type.equalsIgnoreCase(column.type) || column.precision < 0 || uPKColumn.precision < 0 || (column.length < uPKColumn.length || column.precision < uPKColumn.precision) && (column.length > uPKColumn.length || column.precision > uPKColumn.precision)) continue;
                    if (column.length > 0 && column.length > uPKColumn.length) {
                        this.universalPrimaryKey.getColumns().set(i, new Column(uPKColumn.name, uPKColumn.type, Math.max(column.length, uPKColumn.length), Math.max(column.precision, uPKColumn.precision)));
                    }
                    assigned = true;
                    assignedUPKColumns.add(i);
                    break;
                }
                if (assigned) continue;
                this.universalPrimaryKey.getColumns().add(new Column(this.createUniqueUPKName(), column.type, column.length, column.precision));
                assignedUPKColumns.add(this.universalPrimaryKey.getColumns().size() - 1);
            }
            return primaryKey;
        }
        int n = 0;
        if (!columns.isEmpty()) {
            for (int i = 0; i < this.universalPrimaryKey.getColumns().size(); ++i) {
                Column column;
                Column uPKColumn = this.universalPrimaryKey.getColumns().get(i);
                if (PrimaryKey.isAssignable(uPKColumn, column = columns.get(n))) {
                    ++n;
                } else if (PrimaryKey.isIncreasable(uPKColumn, column)) {
                    this.universalPrimaryKey.getColumns().set(i, new Column(uPKColumn.name, uPKColumn.type, Math.max(column.length, uPKColumn.length), Math.max(column.precision, uPKColumn.precision)));
                    ++n;
                }
                if (n >= columns.size()) break;
            }
        }
        while (n < columns.size()) {
            Column column = columns.get(n);
            this.universalPrimaryKey.getColumns().add(new Column(this.createUniqueUPKName(), column.type, column.length, column.precision));
            ++n;
        }
        return primaryKey;
    }

    private String createUniqueUPKName() {
        return "PK" + this.universalPrimaryKey.getColumns().size();
    }

    public PrimaryKey getUniversalPrimaryKey(Session session) {
        this.closed = true;
        return this.universalPrimaryKey;
    }
}

