/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jailer.Configuration;
import net.sf.jailer.datamodel.Column;

public class PrimaryKey {
    private final List<Column> columns;

    PrimaryKey(List<Column> columns) {
        this.columns = columns;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Map<Column, Column> match(PrimaryKey primaryKey) {
        if (Configuration.getDoMinimizeUPK()) {
            HashSet<Integer> assignedUPKColumns = new HashSet<Integer>();
            HashMap<Column, Column> match = new HashMap<Column, Column>();
            block0: for (Column column : this.getColumns()) {
                for (int i = 0; i < primaryKey.getColumns().size(); ++i) {
                    Column otherColumn;
                    if (assignedUPKColumns.contains(i) || !PrimaryKey.isAssignable(column, otherColumn = primaryKey.getColumns().get(i))) continue;
                    match.put(column, otherColumn);
                    assignedUPKColumns.add(i);
                    continue block0;
                }
            }
            return match;
        }
        HashMap<Column, Column> match = new HashMap<Column, Column>();
        int i = 0;
        for (Column column : this.getColumns()) {
            Column otherColumn;
            if (!PrimaryKey.isAssignable(column, otherColumn = primaryKey.getColumns().get(i))) continue;
            match.put(column, otherColumn);
            if (++i < primaryKey.columns.size()) continue;
            break;
        }
        return match;
    }

    public static boolean isAssignable(Column uPKColumn, Column entityColumn) {
        if (!uPKColumn.type.equals(entityColumn.type)) {
            return false;
        }
        if (uPKColumn.length == 0 && entityColumn.length != 0) {
            return false;
        }
        if (uPKColumn.length != 0 && entityColumn.length == 0) {
            return false;
        }
        if (uPKColumn.length < entityColumn.length) {
            return false;
        }
        if (uPKColumn.precision < 0 && entityColumn.precision >= 0) {
            return false;
        }
        if (uPKColumn.precision >= 0 && entityColumn.precision < 0) {
            return false;
        }
        return uPKColumn.precision >= entityColumn.precision;
    }

    public String columnList(String prefix) {
        String list = "";
        for (Column column : this.getColumns()) {
            if (list.length() > 0) {
                list = list + ", ";
            }
            if (prefix != null) {
                list = list + prefix;
            }
            list = list + column.name;
        }
        return list;
    }

    public String toSQL(String columnPrefix) {
        return this.toSQL(columnPrefix, true);
    }

    public String toSQL(String columnPrefix, boolean withContraints) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.columns.get(i).toSQL(columnPrefix) + (withContraints ? " NOT NULL" : ""));
        }
        return sb.toString();
    }

    public String toSQL(String columnPrefix, String contraint, Map<String, String> typeReplacement) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.columns.get(i).toSQL(columnPrefix, typeReplacement) + " " + contraint);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSQL(null);
    }

    public static boolean isIncreasable(Column uPKColumn, Column column) {
        if (!uPKColumn.type.equals(column.type)) {
            return false;
        }
        if (uPKColumn.precision < 0 && column.precision >= 0) {
            return false;
        }
        if (uPKColumn.precision >= 0 && column.precision < 0) {
            return false;
        }
        if (uPKColumn.length == 0 && column.length > 0) {
            return false;
        }
        if (uPKColumn.length < column.length) {
            return true;
        }
        return uPKColumn.precision < column.precision;
    }
}

