/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.util.Map;
import java.util.Set;

public class ParameterHandler {
    public static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df?#";

    public static void collectParameter(String s, Set<String> parameters) {
        int l = s.length();
        int pStart = -1;
        int lastC = 32;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (pStart < 0) {
                if (lastC == 36 && c == '{') {
                    pStart = i + 1;
                }
            } else if (c == '}') {
                if (pStart < i) {
                    parameters.add(s.substring(pStart, i));
                }
                pStart = -1;
            } else if (VALID_CHARS.indexOf(c) < 0) {
                pStart = -1;
            }
            lastC = c;
        }
    }

    public static String assignParameterValues(String s, Map<String, String> parameterValues) {
        int l = s.length();
        int pStart = -1;
        int lastC = 32;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (pStart < 0) {
                if (lastC == 36 && c == '{') {
                    pStart = i + 1;
                }
            } else if (c == '}') {
                String value;
                if (pStart < i && (value = parameterValues.get(s.substring(pStart, i))) != null) {
                    s = s.substring(0, pStart - 2) + value + s.substring(i + 1);
                    l = s.length();
                    i = pStart + value.length() - 3;
                }
                pStart = -1;
            } else if (VALID_CHARS.indexOf(c) < 0) {
                pStart = -1;
            }
            lastC = c;
        }
        return s;
    }
}

