/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.ParameterHandler;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.PrimaryKeyFactory;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.restrictionmodel.RestrictionModel;
import net.sf.jailer.ui.DataModelManager;
import net.sf.jailer.ui.RestrictionDefinition;
import net.sf.jailer.ui.graphical_view.LayoutStorage;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.PrintUtil;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class DataModel {
    public static final String TABLE_CSV_FILE = "table.csv";
    public static final String MODELNAME_CSV_FILE = "modelname.csv";
    private Map<String, Table> tables = new HashMap<String, Table>();
    private Map<String, Table> tablesByDisplayName = new HashMap<String, Table>();
    private Map<Table, String> displayName = new HashMap<Table, String>();
    public Map<String, Association> namedAssociations = new TreeMap<String, Association>();
    private RestrictionModel restrictionModel;
    public long version = 0L;
    public static final String DEFAULT_NAME = "New Model";
    private final PrimaryKeyFactory primaryKeyFactory;
    private String exportModus;
    private XmlSettings xmlSettings = new XmlSettings();
    private String name;
    private Long lastModified;
    private static final Logger _log = Logger.getLogger(DataModel.class);
    public static boolean printClosures = false;

    public static String getDatamodelFolder() {
        return CommandLineParser.getInstance().getDataModelFolder();
    }

    public static String getTablesFile() {
        return DataModel.getDatamodelFolder() + File.separator + TABLE_CSV_FILE;
    }

    public static String getModelNameFile() {
        return DataModel.getDatamodelFolder() + File.separator + MODELNAME_CSV_FILE;
    }

    public static String getDisplayNamesFile() {
        return DataModel.getDatamodelFolder() + File.separator + "displayname.csv";
    }

    public static String getColumnsFile() {
        return DataModel.getDatamodelFolder() + File.separator + "column.csv";
    }

    public static String getAssociationsFile() {
        return DataModel.getDatamodelFolder() + File.separator + "association.csv";
    }

    public static String getInitialDataTablesFile() {
        return DataModel.getDatamodelFolder() + File.separator + "initial_data_tables.csv";
    }

    public static String getExcludeFromDeletionFile() {
        return DataModel.getDatamodelFolder() + File.separator + "exclude-from-deletion.csv";
    }

    public static String getVersionFile() {
        return DataModel.getDatamodelFolder() + File.separator + "version.csv";
    }

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public Table getTableByDisplayName(String displayName) {
        return this.tablesByDisplayName.get(displayName);
    }

    public String getName() {
        return this.name;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getDisplayName(Table table) {
        String displayName = this.displayName.get(table);
        if (displayName == null) {
            return table.getName();
        }
        return displayName;
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public DataModel(PrimaryKeyFactory primaryKeyFactory, Map<String, String> sourceSchemaMapping) throws Exception {
        this(null, null, sourceSchemaMapping, null, primaryKeyFactory);
    }

    public DataModel() throws Exception {
        this(null, null, new PrimaryKeyFactory());
    }

    public DataModel(Map<String, String> sourceSchemaMapping) throws Exception {
        this(null, null, sourceSchemaMapping, null, new PrimaryKeyFactory());
    }

    public DataModel(String additionalTablesFile, String additionalAssociationsFile, PrimaryKeyFactory primaryKeyFactory) throws Exception {
        this(additionalTablesFile, additionalAssociationsFile, new HashMap<String, String>(), null, primaryKeyFactory);
    }

    public DataModel(String additionalTablesFile, String additionalAssociationsFile) throws Exception {
        this(additionalTablesFile, additionalAssociationsFile, new HashMap<String, String>(), null, new PrimaryKeyFactory());
    }

    public DataModel(String additionalTablesFile, String additionalAssociationsFile, Map<String, String> sourceSchemaMapping, CsvFile.LineFilter assocFilter) throws Exception {
        this(additionalTablesFile, additionalAssociationsFile, sourceSchemaMapping, assocFilter, new PrimaryKeyFactory());
    }

    public DataModel(String additionalTablesFile, String additionalAssociationsFile, Map<String, String> sourceSchemaMapping, CsvFile.LineFilter assocFilter, PrimaryKeyFactory primaryKeyFactory) throws Exception {
        this.primaryKeyFactory = primaryKeyFactory;
        try {
            Table table;
            File nTablesFile = CommandLineParser.getInstance().newFile(DataModel.getTablesFile());
            CsvFile tablesFile = new CsvFile(nTablesFile);
            ArrayList<CsvFile.Line> tableList = new ArrayList<CsvFile.Line>(tablesFile.getLines());
            if (additionalTablesFile != null) {
                tableList.addAll(new CsvFile(CommandLineParser.getInstance().newFile(additionalTablesFile)).getLines());
            }
            for (CsvFile.Line line : tableList) {
                int j;
                boolean defaultUpsert = "Y".equalsIgnoreCase(line.cells.get(1));
                ArrayList<Column> pk = new ArrayList<Column>();
                for (j = 2; j < line.cells.size() && line.cells.get(j).toString().length() > 0; ++j) {
                    String col = line.cells.get(j).trim();
                    try {
                        pk.add(Column.parse(col));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("unable to load table '" + line.cells.get(0) + "'. " + line.location, e);
                    }
                }
                String mappedSchemaTableName = SqlUtil.mappedSchema(sourceSchemaMapping, line.cells.get(0));
                table = new Table(mappedSchemaTableName, primaryKeyFactory.createPrimaryKey(pk), defaultUpsert);
                table.setAuthor(line.cells.get(j + 1));
                table.setOriginalName(line.cells.get(0));
                if (this.tables.containsKey(mappedSchemaTableName) && additionalTablesFile == null) {
                    throw new RuntimeException("Duplicate table name '" + mappedSchemaTableName + "'");
                }
                this.tables.put(mappedSchemaTableName, table);
            }
            File file = CommandLineParser.getInstance().newFile(DataModel.getColumnsFile());
            if (file.exists()) {
                CsvFile columnsFile = new CsvFile(file);
                ArrayList<CsvFile.Line> columnsList = new ArrayList<CsvFile.Line>(columnsFile.getLines());
                for (CsvFile.Line line : columnsList) {
                    ArrayList<Column> columns = new ArrayList<Column>();
                    for (int j = 1; j < line.cells.size() && line.cells.get(j).toString().length() > 0; ++j) {
                        String col = line.cells.get(j).trim();
                        try {
                            columns.add(Column.parse(col));
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    table = this.tables.get(SqlUtil.mappedSchema(sourceSchemaMapping, line.cells.get(0)));
                    if (table == null) continue;
                    table.setColumns(columns);
                }
            }
            ArrayList<CsvFile.Line> associationList = new ArrayList<CsvFile.Line>(new CsvFile(CommandLineParser.getInstance().newFile(DataModel.getAssociationsFile()), assocFilter).getLines());
            if (additionalAssociationsFile != null) {
                associationList.addAll(new CsvFile(CommandLineParser.getInstance().newFile(additionalAssociationsFile)).getLines());
            }
            for (CsvFile.Line line : associationList) {
                String location = line.location;
                try {
                    Association associationB;
                    Table tableB;
                    String associationLoadFailedMessage = "Unable to load association from " + line.cells.get(0) + " to " + line.cells.get(1) + " on " + line.cells.get(4) + " because: ";
                    Table tableA = this.tables.get(SqlUtil.mappedSchema(sourceSchemaMapping, line.cells.get(0)));
                    if (tableA == null || (tableB = this.tables.get(SqlUtil.mappedSchema(sourceSchemaMapping, line.cells.get(1)))) == null) continue;
                    boolean insertSourceBeforeDestination = "A".equalsIgnoreCase(line.cells.get(2));
                    boolean insertDestinationBeforeSource = "B".equalsIgnoreCase(line.cells.get(2));
                    Cardinality cardinality = Cardinality.parse(line.cells.get(3).trim());
                    if (cardinality == null) {
                        cardinality = Cardinality.MANY_TO_MANY;
                    }
                    String joinCondition = line.cells.get(4);
                    String name = line.cells.get(5);
                    if ("".equals(name)) {
                        name = null;
                    }
                    if (name == null) {
                        throw new RuntimeException(associationLoadFailedMessage + "Association name missing (column 6 is empty, each association must have an unique name)");
                    }
                    String author = line.cells.get(6);
                    Association associationA = new Association(tableA, tableB, insertSourceBeforeDestination, insertDestinationBeforeSource, joinCondition, this, false, cardinality, author);
                    associationA.reversalAssociation = associationB = new Association(tableB, tableA, insertDestinationBeforeSource, insertSourceBeforeDestination, joinCondition, this, true, cardinality.reverse(), author);
                    associationB.reversalAssociation = associationA;
                    tableA.associations.add(associationA);
                    tableB.associations.add(associationB);
                    if (name == null) continue;
                    if (this.namedAssociations.put(name, associationA) != null) {
                        throw new RuntimeException("duplicate association name: " + name);
                    }
                    associationA.setName(name);
                    name = "inverse-" + name;
                    if (this.namedAssociations.put(name, associationB) != null) {
                        throw new RuntimeException("duplicate association name: " + name);
                    }
                    associationB.setName(name);
                }
                catch (Exception e) {
                    throw new RuntimeException(location + ": " + e.getMessage(), e);
                }
            }
            this.initDisplayNames();
            File nameFile = CommandLineParser.getInstance().newFile(DataModel.getModelNameFile());
            this.name = DEFAULT_NAME;
            this.lastModified = null;
            try {
                ArrayList<CsvFile.Line> nameList;
                this.lastModified = nTablesFile.lastModified();
                if (nameFile.exists() && (nameList = new ArrayList<CsvFile.Line>(new CsvFile(nameFile).getLines())).size() > 0) {
                    CsvFile.Line line = (CsvFile.Line)nameList.get(0);
                    this.name = line.cells.get(0);
                    this.lastModified = Long.parseLong(line.cells.get(1));
                }
            }
            catch (Throwable t) {}
        }
        catch (Exception e) {
            _log.error("failed to load data-model " + DataModel.getDatamodelFolder() + File.separator, e);
            throw e;
        }
    }

    private void initDisplayNames() throws Exception {
        String uName;
        HashSet<String> unqualifiedNames = new HashSet<String>();
        HashSet<String> nonUniqueUnqualifiedNames = new HashSet<String>();
        for (Table table : this.getTables()) {
            uName = table.getUnqualifiedName();
            if (unqualifiedNames.contains(uName)) {
                nonUniqueUnqualifiedNames.add(uName);
                continue;
            }
            unqualifiedNames.add(uName);
        }
        for (Table table : this.getTables()) {
            String fcStr;
            char c;
            uName = table.getUnqualifiedName();
            if (uName != null && uName.length() > 0 && !Character.isLetterOrDigit(c = uName.charAt(0)) && c != '_' && uName.startsWith(fcStr = Character.toString(c)) && uName.endsWith(fcStr)) {
                uName = uName.substring(1, uName.length() - 1);
            }
            String string = table.getSchema(null);
            String displayName = nonUniqueUnqualifiedNames.contains(uName) && string != null ? uName + " (" + string + ")" : uName;
            this.displayName.put(table, displayName);
            this.tablesByDisplayName.put(displayName, table);
        }
        TreeMap<String, String> userDefinedDisplayNames = new TreeMap<String, String>();
        File dnFile = CommandLineParser.getInstance().newFile(DataModel.getDisplayNamesFile());
        if (dnFile.exists()) {
            for (CsvFile.Line line : new CsvFile(dnFile).getLines()) {
                userDefinedDisplayNames.put(line.cells.get(0), line.cells.get(1));
            }
        }
        for (Map.Entry entry : userDefinedDisplayNames.entrySet()) {
            Table table = this.getTable((String)entry.getKey());
            if (table == null || this.tablesByDisplayName.containsKey(entry.getValue())) continue;
            String displayName = this.getDisplayName(table);
            this.displayName.remove(table);
            if (displayName != null) {
                this.tablesByDisplayName.remove(displayName);
            }
            this.displayName.put(table, (String)entry.getValue());
            this.tablesByDisplayName.put((String)entry.getValue(), table);
        }
    }

    public PrimaryKey getUniversalPrimaryKey(Session session) {
        return this.primaryKeyFactory.getUniversalPrimaryKey(session);
    }

    public PrimaryKey getUniversalPrimaryKey() {
        return this.getUniversalPrimaryKey(null);
    }

    public RestrictionModel getRestrictionModel() {
        return this.restrictionModel;
    }

    public void setRestrictionModel(RestrictionModel restrictionModel) {
        this.restrictionModel = restrictionModel;
        ++this.version;
    }

    public Set<Table> getIndependentTables(Set<Table> tableSet) {
        return this.getIndependentTables(tableSet, null);
    }

    public Set<Table> getIndependentTables(Set<Table> tableSet, Set<Association> associations) {
        HashSet<Table> independentTables = new HashSet<Table>();
        for (Table table : tableSet) {
            boolean depends = false;
            for (Association a : table.associations) {
                if (associations != null && !associations.contains(a) || !tableSet.contains(a.destination) || a.getJoinCondition() == null || !a.isInsertDestinationBeforeSource()) continue;
                depends = true;
                break;
            }
            if (depends) continue;
            independentTables.add(table);
        }
        return independentTables;
    }

    public void transpose() {
        if (this.getRestrictionModel() != null) {
            this.getRestrictionModel().transpose();
        }
        ++this.version;
    }

    public String toString() {
        ArrayList<Table> sortedTables = new ArrayList<Table>(this.getTables());
        Collections.sort(sortedTables, new Comparator<Table>(){

            @Override
            public int compare(Table o1, Table o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuffer str = new StringBuffer();
        if (this.restrictionModel != null) {
            str.append("restricted by: " + this.restrictionModel + "\n");
        }
        for (Table table : sortedTables) {
            str.append(table);
            if (!printClosures) continue;
            str.append("  closure =");
            str.append(PrintUtil.tableSetAsString(table.closure(true)) + "\n\n");
        }
        return str.toString();
    }

    public Set<Table> normalize(Set<Table> tables) {
        HashSet<Table> result = new HashSet<Table>();
        for (Table table : tables) {
            result.add(this.getTable(table.getName()));
        }
        return result;
    }

    public void assignAssociationIDs() {
        int n = 1;
        for (Map.Entry<String, Association> e : this.namedAssociations.entrySet()) {
            e.getValue().id = n++;
        }
    }

    public String getExportModus() {
        return this.exportModus;
    }

    public void setExportModus(String modus) {
        this.exportModus = modus;
        ++this.version;
    }

    public XmlSettings getXmlSettings() {
        return this.xmlSettings;
    }

    public void setXmlSettings(XmlSettings xmlSettings) {
        this.xmlSettings = xmlSettings;
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public void checkForPrimaryKey(Table subject, boolean forDeletion) throws NoPrimaryKeyException {
        HashSet<Table> toCheck = new HashSet<Table>(subject.closure(true));
        if (forDeletion) {
            HashSet<Table> border = new HashSet<Table>();
            for (Table table : toCheck) {
                for (Association a : table.associations) {
                    if (a.reversalAssociation.isIgnored()) continue;
                    border.add(a.destination);
                }
            }
            toCheck.addAll(border);
        }
        for (Table table : toCheck) {
            if (!table.primaryKey.getColumns().isEmpty()) continue;
            throw new NoPrimaryKeyException(table);
        }
    }

    public SortedSet<String> getParameters(String subjectCondition) {
        String r;
        TreeSet<String> parameters = new TreeSet<String>();
        ParameterHandler.collectParameter(subjectCondition, parameters);
        for (Association a : this.namedAssociations.values()) {
            r = a.getRestrictionCondition();
            if (r == null) continue;
            ParameterHandler.collectParameter(r, parameters);
        }
        for (Table t : this.getTables()) {
            r = t.getXmlTemplate();
            if (r != null) {
                ParameterHandler.collectParameter(r, parameters);
            }
            for (Column c : t.getColumns()) {
                if (c.getFilterExpression() == null) continue;
                ParameterHandler.collectParameter(c.getFilterExpression(), parameters);
            }
        }
        return parameters;
    }

    public String getLastModifiedAsString() {
        try {
            return SimpleDateFormat.getDateTimeInstance(2, 2).format(new Date(this.getLastModified()));
        }
        catch (Throwable t) {
            return "";
        }
    }

    public void save(String file, Table stable, String subjectCondition, ScriptFormat scriptFormat, List<RestrictionDefinition> restrictionDefinitions, Map<String, Map<String, double[]>> positions) throws FileNotFoundException {
        File extractionModel = new File(file);
        PrintWriter out = new PrintWriter(extractionModel);
        out.println("# subject; condition;  limit; restrictions");
        out.println(CsvFile.encodeCell("" + stable.getName()) + "; " + CsvFile.encodeCell(subjectCondition) + "; ; " + RestrictionModel.EMBEDDED);
        this.saveRestrictions(out, restrictionDefinitions);
        this.saveXmlMapping(out);
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "datamodelfolder");
        String currentModelSubfolder = DataModelManager.getCurrentModelSubfolder();
        if (currentModelSubfolder != null) {
            out.println(currentModelSubfolder);
        }
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "export modus");
        out.println((Object)scriptFormat);
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "xml settings");
        out.println(CsvFile.encodeCell(this.getXmlSettings().datePattern) + ";" + CsvFile.encodeCell(this.getXmlSettings().timestampPattern) + ";" + CsvFile.encodeCell(this.getXmlSettings().rootTag));
        out.println(CsvFile.BLOCK_INDICATOR + "xml column mapping");
        for (Table table : this.getTables()) {
            String xmlMapping = table.getXmlTemplate();
            if (xmlMapping == null) continue;
            out.println(CsvFile.encodeCell(table.getName()) + "; " + CsvFile.encodeCell(xmlMapping));
        }
        out.println(CsvFile.BLOCK_INDICATOR + "upserts");
        for (Table table : this.getTables()) {
            if (table.upsert == null) continue;
            out.println(CsvFile.encodeCell(table.getName()) + "; " + CsvFile.encodeCell(table.upsert.toString()));
        }
        this.saveFilters(out);
        out.println();
        if (positions == null) {
            LayoutStorage.store(out);
        } else {
            LayoutStorage.store(out, positions);
        }
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "version");
        out.println("5.0.2");
        out.close();
    }

    private void saveXmlMapping(PrintWriter out) {
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "xml-mapping");
        for (Table table : this.getTables()) {
            for (Association a : table.associations) {
                String name = a.getName();
                String tag = a.getAggregationTagName();
                String aggregation = a.getAggregationSchema().name();
                out.println(CsvFile.encodeCell(name) + ";" + CsvFile.encodeCell(tag) + ";" + CsvFile.encodeCell(aggregation));
            }
        }
    }

    private void saveRestrictions(PrintWriter out, List<RestrictionDefinition> restrictionDefinitions) {
        out.println();
        out.println("# from A (or association name); to B; restriction-condition");
        for (RestrictionDefinition rd : restrictionDefinitions) {
            String condition;
            String string = condition = rd.isIgnored ? "ignore" : rd.condition;
            if (rd.name == null || rd.name.trim().length() == 0) {
                out.println(CsvFile.encodeCell(rd.from.getName()) + "; " + CsvFile.encodeCell(rd.to.getName()) + "; " + CsvFile.encodeCell(condition));
                continue;
            }
            out.println(CsvFile.encodeCell(rd.name) + "; ; " + CsvFile.encodeCell(condition));
        }
    }

    public void saveRestrictions(File file, List<RestrictionDefinition> restrictionDefinitions) throws Exception {
        PrintWriter out = new PrintWriter(file);
        this.saveRestrictions(out, restrictionDefinitions);
        out.close();
    }

    private void saveFilters(PrintWriter out) {
        out.println();
        out.println(CsvFile.BLOCK_INDICATOR + "filters");
        for (Table table : this.getTables()) {
            for (Column c : table.getColumns()) {
                if (c.getFilterExpression() == null) continue;
                out.println(CsvFile.encodeCell(table.getName()) + ";" + CsvFile.encodeCell(c.name) + ";" + CsvFile.encodeCell(c.getFilterExpression()));
            }
        }
    }

    public static class NoPrimaryKeyException
    extends RuntimeException {
        private static final long serialVersionUID = 4523935351640139649L;
        public final Table table;

        public NoPrimaryKeyException(Table table) {
            super("Table '" + table.getName() + "' has no primary key");
            this.table = table;
        }
    }

    public static class XmlSettings {
        public String datePattern = "yyyy-MM-dd";
        public String timestampPattern = "yyyy-MM-dd-HH.mm.ss";
        public String rootTag = "rowset";
    }
}

