/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Column {
    public final String name;
    public final String type;
    public final int length;
    public final int precision;
    public boolean isIdentityColumn = false;
    private String filterExpression = null;
    private static Pattern typeWithSizeAndPrecision = Pattern.compile("([^ ]+) +([^ \\(]+) *\\( *([0-9]+) *, *([0-9]+) *\\)");
    private static Pattern typeWithSize = Pattern.compile("([^ ]+) +([^ \\(]+) *\\( *([0-9]+) *\\)");
    private static Pattern typeWithoutSize = Pattern.compile("([^ ]+) +([^ \\(]+)");

    public Column(String name, String type, int length, int precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public static Column parse(String columnDeclaration) {
        String type;
        String name;
        String normalizedcolumnDeclaration = (columnDeclaration = columnDeclaration.trim()).replaceFirst("(\\(\\))? +[iI][dD][eE][nN][tT][iI][tT][yY]", "");
        if (!normalizedcolumnDeclaration.equals(columnDeclaration)) {
            columnDeclaration = normalizedcolumnDeclaration + " identity";
        }
        boolean isIdent = false;
        if (columnDeclaration.toLowerCase().endsWith(" identity")) {
            isIdent = true;
            columnDeclaration = columnDeclaration.substring(0, columnDeclaration.length() - 9).trim();
        }
        Character quote = null;
        if (columnDeclaration.length() > 0 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789".indexOf(columnDeclaration.charAt(0)) < 0) {
            quote = Character.valueOf(columnDeclaration.charAt(0));
            if (columnDeclaration.substring(1).indexOf(quote.charValue()) >= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(quote);
                boolean inScope = true;
                for (int i = 1; i < columnDeclaration.length(); ++i) {
                    char c = columnDeclaration.charAt(i);
                    if (c == quote.charValue()) {
                        inScope = false;
                    }
                    if (inScope && c == ' ') {
                        c = '\n';
                    }
                    sb.append(c);
                }
                columnDeclaration = sb.toString();
            }
        }
        int size = 0;
        int precision = -1;
        Matcher matcher = typeWithSizeAndPrecision.matcher(columnDeclaration);
        if (matcher.matches()) {
            name = matcher.group(1);
            type = matcher.group(2);
            size = Integer.parseInt(matcher.group(3));
            precision = Integer.parseInt(matcher.group(4));
        } else {
            matcher = typeWithSize.matcher(columnDeclaration);
            if (matcher.matches()) {
                name = matcher.group(1);
                type = matcher.group(2);
                size = Integer.parseInt(matcher.group(3));
            } else {
                matcher = typeWithoutSize.matcher(columnDeclaration);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    type = matcher.group(2);
                } else {
                    throw new RuntimeException("can't parse primary-key: " + columnDeclaration);
                }
            }
        }
        if (quote != null) {
            name = name.replace('\n', ' ');
        }
        Column column = new Column(name, type, size, precision);
        column.isIdentityColumn = isIdent;
        return column;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Column) {
            return this.name.equals(((Column)obj).name) && this.type.equals(((Column)obj).type) && this.length == ((Column)obj).length;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toSQL(null).hashCode();
    }

    public String toSQL(String columnPrefix, Map<String, String> typeReplacement) {
        String theType = this.type;
        if (typeReplacement != null && typeReplacement.containsKey(theType)) {
            theType = typeReplacement.get(theType);
        }
        return (columnPrefix == null ? "" : columnPrefix) + this.name + " " + theType + (this.length == 0 ? "" : "(" + this.length + (this.precision >= 0 ? ", " + this.precision : "") + ")");
    }

    public String toSQL(String columnPrefix) {
        return this.toSQL(columnPrefix, null);
    }

    public String toString() {
        return this.toSQL(null);
    }
}

