/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

public enum Cardinality {
    ONE_TO_ONE("1:1"),
    ONE_TO_MANY("1:n"),
    MANY_TO_ONE("n:1"),
    MANY_TO_MANY("n:m");

    private final String name;

    private Cardinality(String name) {
        this.name = name;
    }

    public Cardinality reverse() {
        if (this == ONE_TO_ONE) {
            return ONE_TO_ONE;
        }
        if (this == ONE_TO_MANY) {
            return MANY_TO_ONE;
        }
        if (this == MANY_TO_ONE) {
            return ONE_TO_MANY;
        }
        if (this == MANY_TO_MANY) {
            return MANY_TO_MANY;
        }
        return null;
    }

    public static Cardinality parse(String cardinality) {
        if (cardinality == null || "".equals(cardinality)) {
            return null;
        }
        for (Cardinality card : Cardinality.values()) {
            if (!card.name.equalsIgnoreCase(cardinality)) continue;
            return card;
        }
        throw new RuntimeException("unknown cardinality: " + cardinality);
    }

    public String toString() {
        return this.name;
    }
}

