/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.datamodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ModelElement;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.restrictionmodel.RestrictionModel;
import net.sf.jailer.util.SqlUtil;

public class Association
extends ModelElement {
    public final Table source;
    public final Table destination;
    private String joinCondition;
    private final Cardinality cardinality;
    private final boolean insertSourceBeforeDestination;
    private final boolean insertDestinationBeforeSource;
    public final boolean reversed;
    private String name;
    public Association reversalAssociation = null;
    private AggregationSchema aggregationSchema = AggregationSchema.NONE;
    private String aggregationTagName;
    private final DataModel dataModel;
    int id = -1;

    public Association(Table source, Table destination, boolean insertSourceBeforeDestination, boolean insertDestinationBeforeSource, String joinCondition, DataModel dataModel, boolean reversed, Cardinality cardinality) {
        this(source, destination, insertSourceBeforeDestination, insertDestinationBeforeSource, joinCondition, dataModel, reversed, cardinality, null);
    }

    public Association(Table source, Table destination, boolean insertSourceBeforeDestination, boolean insertDestinationBeforeSource, String joinCondition, DataModel dataModel, boolean reversed, Cardinality cardinality, String author) {
        this.source = source;
        this.destination = destination;
        this.insertSourceBeforeDestination = insertSourceBeforeDestination;
        this.insertDestinationBeforeSource = insertDestinationBeforeSource;
        this.joinCondition = joinCondition;
        this.dataModel = dataModel;
        this.reversed = reversed;
        this.cardinality = cardinality;
        if (author != null) {
            this.setAuthor(author);
        }
    }

    public String getJoinCondition() {
        String restriction;
        if (this.dataModel.getRestrictionModel() != null && (restriction = this.dataModel.getRestrictionModel().getRestriction(this)) != null) {
            if (restriction == RestrictionModel.IGNORE) {
                return null;
            }
            return "(" + this.joinCondition + ") and " + restriction;
        }
        return this.joinCondition;
    }

    public boolean isIgnored() {
        RestrictionModel restrictionModel = this.dataModel.getRestrictionModel();
        String restriction = "";
        return restrictionModel != null && (restriction = restrictionModel.getRestriction(this)) == RestrictionModel.IGNORE;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        return this.toString(30, false);
    }

    public String toString(int maxGab, boolean useDisplayName) {
        String aName;
        String r;
        RestrictionModel restrictionModel = this.dataModel.getRestrictionModel();
        String restriction = "";
        if (restrictionModel != null && (r = restrictionModel.getRestriction(this)) != null && r != RestrictionModel.IGNORE) {
            restriction = " restricted by " + r.replace('\n', ' ').replace('\r', ' ');
        }
        String gap = "";
        String string = aName = useDisplayName ? this.dataModel.getDisplayName(this.destination) : this.destination.getName();
        if (this.name != null) {
            aName = aName + " (" + this.name + ")";
        }
        while ((aName + gap).length() < maxGab) {
            gap = gap + " ";
        }
        String jc = this.joinCondition;
        String r2 = restriction;
        if (this.reversed) {
            jc = SqlUtil.reversRestrictionCondition(jc);
            r2 = SqlUtil.reversRestrictionCondition(r2);
        }
        String card = "   ";
        if (this.cardinality != null) {
            card = this.cardinality.toString();
        }
        return aName + gap + " " + card + " on " + jc + r2;
    }

    public String renderJoinCondition(String restrictionSeparator) {
        String r;
        RestrictionModel restrictionModel = this.dataModel.getRestrictionModel();
        String restriction = "";
        if (restrictionModel != null && (r = restrictionModel.getRestriction(this)) != null && r != RestrictionModel.IGNORE) {
            restriction = " " + restrictionSeparator + " " + r;
        }
        String jc = this.joinCondition;
        String r2 = restriction;
        if (this.reversed) {
            jc = SqlUtil.reversRestrictionCondition(jc);
            r2 = SqlUtil.reversRestrictionCondition(r2);
        }
        return jc + r2;
    }

    public String getUnrestrictedJoinCondition() {
        return this.joinCondition;
    }

    public String getRestrictionCondition() {
        String r;
        RestrictionModel restrictionModel = this.dataModel.getRestrictionModel();
        if (restrictionModel != null && (r = restrictionModel.getRestriction(this)) != null) {
            if (r == RestrictionModel.IGNORE) {
                return "false";
            }
            if (this.reversed) {
                r = SqlUtil.reversRestrictionCondition(r);
            }
            if (r.startsWith("(") && r.endsWith(")")) {
                r = r.substring(1, r.length() - 1);
            }
            return r;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isInsertSourceBeforeDestination() {
        if (this.dataModel.getRestrictionModel() != null && this.dataModel.getRestrictionModel().isTransposed()) {
            return this.reversalAssociation.insertSourceBeforeDestination;
        }
        return this.insertSourceBeforeDestination;
    }

    public boolean isInsertDestinationBeforeSource() {
        if (this.dataModel.getRestrictionModel() != null && this.dataModel.getRestrictionModel().isTransposed()) {
            return this.reversalAssociation.insertDestinationBeforeSource;
        }
        return this.insertDestinationBeforeSource;
    }

    public boolean isRestricted() {
        RestrictionModel restrictionModel = this.dataModel.getRestrictionModel();
        String restriction = "";
        return restrictionModel != null && (restriction = restrictionModel.getRestriction(this)) != null;
    }

    public void appendCondition(String condition) {
        this.joinCondition = this.joinCondition == null ? condition : "(" + this.joinCondition + ") and (" + condition + ")";
    }

    public AggregationSchema getAggregationSchema() {
        return this.aggregationSchema;
    }

    public String getAggregationTagName() {
        String tag = this.aggregationTagName == null ? (this.name.startsWith("inverse-") ? this.destination.getUnqualifiedName().toLowerCase() : this.name.toLowerCase()) : this.aggregationTagName;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c) && c != '-' && c != '_') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void setAggregationSchema(AggregationSchema aggregationSchema) {
        this.aggregationSchema = aggregationSchema;
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
    }

    public void setAggregationTagName(String aggregationTagName) {
        this.aggregationTagName = aggregationTagName;
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
    }

    public int getId() {
        if (this.id < 0) {
            this.dataModel.assignAssociationIDs();
        }
        return this.id;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public Map<Column, Column> createSourceToDestinationKeyMapping() {
        String[] equations = this.getUnrestrictedJoinCondition().trim().replaceAll("\\(|\\)", "").split(" *(a|A)(n|N)(d|D) *");
        HashMap<Column, Column> mapping = new HashMap<Column, Column>();
        for (String equation : equations) {
            String[] hs = equation.split(" *= *");
            if (hs.length != 2) {
                return Collections.emptyMap();
            }
            String[] lhs = hs[0].split(" *\\. *");
            String[] rhs = hs[1].split(" *\\. *");
            if (lhs.length != 2 || rhs.length != 2 || lhs[0].length() != 1 || rhs[0].length() != 1) {
                return Collections.emptyMap();
            }
            String dColumn = null;
            String sColumn = null;
            if ("A".equalsIgnoreCase(lhs[0])) {
                sColumn = lhs[1];
            }
            if ("B".equalsIgnoreCase(lhs[0])) {
                dColumn = lhs[1];
            }
            if ("A".equalsIgnoreCase(rhs[0])) {
                sColumn = rhs[1];
            }
            if ("B".equalsIgnoreCase(rhs[0])) {
                dColumn = rhs[1];
            }
            if (sColumn == null || dColumn == null) {
                return Collections.emptyMap();
            }
            if (this.reversed) {
                String h = sColumn;
                sColumn = dColumn;
                dColumn = h;
            }
            Column sourceColumn = null;
            for (Column c : this.source.getColumns()) {
                if (!c.name.equals(sColumn)) continue;
                sourceColumn = c;
                break;
            }
            Column destinationColumn = null;
            for (Column c : this.destination.getColumns()) {
                if (!c.name.equals(dColumn)) continue;
                destinationColumn = c;
                break;
            }
            if (sourceColumn == null || destinationColumn == null) {
                return Collections.emptyMap();
            }
            mapping.put(sourceColumn, destinationColumn);
        }
        return mapping;
    }
}

