/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import java.util.ArrayList;
import java.util.List;

public class StatementBuilder {
    private final int maxBodySize;
    private String head = null;
    private List<String> body = new ArrayList<String>();
    private String separator;
    private String terminator;

    public StatementBuilder(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public boolean isAppendable(String head, String item) {
        return this.body.size() < this.maxBodySize && (this.head == null || this.head.equals(head));
    }

    public boolean isAppendable(String head) {
        return this.isAppendable(head, null);
    }

    public String build() {
        if (this.head != null) {
            StringBuilder sqlStatement = new StringBuilder(this.head);
            boolean firstTime = true;
            for (String item : this.body) {
                if (!firstTime) {
                    sqlStatement.append(this.separator);
                }
                firstTime = false;
                sqlStatement.append(item);
            }
            sqlStatement.append(this.terminator);
            this.head = null;
            this.body.clear();
            return sqlStatement.toString();
        }
        return "";
    }

    public void append(String head, String item, String separator, String terminator) {
        if (this.head != null && !this.head.equals(head)) {
            throw new IllegalStateException("can't append, '" + this.head + "'!='" + head + "'");
        }
        this.head = head;
        this.terminator = terminator;
        this.separator = separator;
        this.body.add(item);
    }

    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    public int size() {
        return this.body.size();
    }
}

