/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatisticRenovator;
import net.sf.jailer.util.PrintUtil;
import net.sf.jailer.util.SqlScriptExecutor;

public class SqlScriptBasedStatisticRenovator
implements StatisticRenovator {
    private final String scriptFileName;

    public SqlScriptBasedStatisticRenovator(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    @Override
    public void renew(Session session) throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("JAILER_ENTITY", SQLDialect.dmlTableReference("JAILER_ENTITY", session));
        arguments.put("JAILER_GRAPH", SQLDialect.dmlTableReference("JAILER_GRAPH", session));
        arguments.put("JAILER_DEPENDENCY", SQLDialect.dmlTableReference("JAILER_DEPENDENCY", session));
        arguments.put("JAILER_SET", SQLDialect.dmlTableReference("JAILER_SET", session));
        String fileName = "renew.sql";
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        out.print(PrintUtil.applyTemplate(this.scriptFileName.replace('/', File.separatorChar), arguments, null));
        out.close();
        boolean silent = session.getSilent();
        session.setSilent(true);
        SqlScriptExecutor.executeScript(fileName, session);
        session.setSilent(silent);
    }
}

