/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.SqlException;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.SqlUtil;

public class Session {
    private ThreadLocal<Connection> connection = new ThreadLocal();
    private final Collection<Connection> connections = Collections.synchronizedCollection(new ArrayList());
    private static Connection temporaryTableSession = null;
    private static TemporaryTableScope temporaryTableScope;
    public final TemporaryTableScope scope;
    private boolean silent = false;
    private final boolean transactional;
    public final boolean local;
    public static final org.apache.log4j.Logger _log;
    private final ConnectionFactory connectionFactory;
    private final String schemaName;
    public final String dbUrl;
    public final String dbUser;
    public final String dbPassword;
    private String introspectionSchema;
    public static ClassLoader classLoaderForJdbcDriver;
    public final DBMS dbms;
    private static final Object DB_LOCK;
    private List<String> cliArguments;
    private String password;

    public Session(String driverClassName, String dbUrl, String user, String password) throws Exception {
        this(driverClassName, dbUrl, user, password, null, false);
    }

    public Session(String driverClassName, String dbUrl, String user, String password, TemporaryTableScope scope, boolean transactional) throws Exception {
        this(driverClassName, dbUrl, user, password, scope, transactional, false);
    }

    public Session(String driverClassName, final String dbUrl, final String user, final String password, final TemporaryTableScope scope, boolean transactional, final boolean local) throws Exception {
        this.transactional = transactional;
        this.local = local;
        this.scope = scope;
        _log.info("connect to user " + user + " at " + dbUrl);
        if (classLoaderForJdbcDriver != null) {
            Driver d = (Driver)Class.forName(driverClassName, true, classLoaderForJdbcDriver).newInstance();
            DriverManager.registerDriver(new DriverShim(d));
        } else {
            Class.forName(driverClassName);
        }
        this.schemaName = user;
        this.dbUrl = dbUrl;
        this.dbUser = user;
        this.dbPassword = password;
        if (scope != null) {
            Session.closeTemporaryTableSession();
            temporaryTableScope = scope;
        }
        this.connectionFactory = new ConnectionFactory(){
            private Connection defaultConnection = null;

            @Override
            public Connection getConnection() throws SQLException {
                Connection con;
                Connection connection = local ? (Connection)Session.this.connection.get() : (con = temporaryTableSession == null ? (Connection)Session.this.connection.get() : temporaryTableSession);
                if (con == null) {
                    boolean ac;
                    try {
                        if (dbUrl.startsWith("jdbc:mysql:")) {
                            try {
                                Properties info = new Properties();
                                if (user != null) {
                                    info.put("user", user);
                                }
                                if (password != null) {
                                    info.put("password", password);
                                }
                                info.put("noDatetimeStringSync", "true");
                                con = DriverManager.getConnection(dbUrl, info);
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        if (con == null) {
                            con = DriverManager.getConnection(dbUrl, user, password);
                        }
                        this.defaultConnection = con;
                    }
                    catch (SQLException e) {
                        if (this.defaultConnection != null) {
                            con = this.defaultConnection;
                        }
                        throw e;
                    }
                    boolean bl = ac = scope == null || scope != TemporaryTableScope.TRANSACTION_LOCAL;
                    if (Session.this.transactional) {
                        ac = false;
                    }
                    _log.info("set auto commit to " + ac);
                    con.setAutoCommit(ac);
                    try {
                        DatabaseMetaData meta = con.getMetaData();
                        String productName = meta.getDatabaseProductName();
                        if (!(productName == null || "ASE".equals(productName) || productName.toUpperCase().contains("ADAPTIVE SERVER") || productName.toUpperCase().startsWith("HSQL"))) {
                            con.setTransactionIsolation(1);
                        }
                    }
                    catch (SQLException e) {
                        _log.info("can't set isolation level to UR. Reason: " + e.getMessage());
                    }
                    if (scope != null && scope != TemporaryTableScope.GLOBAL) {
                        temporaryTableSession = con;
                    } else {
                        Session.this.connection.set(con);
                        boolean addCon = true;
                        for (Connection c : Session.this.connections) {
                            if (c != con) continue;
                            addCon = false;
                            break;
                        }
                        if (addCon) {
                            Session.this.connections.add(con);
                        }
                    }
                }
                return con;
            }
        };
        Connection connection = this.connectionFactory.getConnection();
        this.dbms = this.logDriverInfo(connection);
        if (!local) {
            SqlUtil.dbms = this.dbms;
        }
    }

    public void reconnect() throws SQLException {
        Connection con = this.connection.get();
        if (con != null) {
            if (temporaryTableScope == TemporaryTableScope.TRANSACTION_LOCAL) {
                con.commit();
            }
            con.close();
            this.connection.set(null);
            if (con == temporaryTableSession) {
                temporaryTableSession = null;
                return;
            }
        }
        if (temporaryTableSession != null) {
            if (temporaryTableScope == TemporaryTableScope.TRANSACTION_LOCAL) {
                temporaryTableSession.commit();
            }
            temporaryTableSession.close();
            temporaryTableSession = null;
        }
    }

    public synchronized void setSilent(boolean silent) {
        this.silent = silent;
    }

    public synchronized boolean getSilent() {
        return this.silent;
    }

    private DBMS logDriverInfo(Connection connection) {
        DBMS dbms = DBMS.UNKNOWN;
        try {
            DatabaseMetaData meta = connection.getMetaData();
            _log.info("driver name:    " + meta.getDriverName());
            _log.info("driver version: " + meta.getDriverVersion());
            String productName = meta.getDatabaseProductName();
            if (productName != null) {
                if (productName.toUpperCase().contains("ORACLE")) {
                    dbms = DBMS.ORACLE;
                }
                if (productName.toUpperCase().contains("DB2")) {
                    dbms = DBMS.DB2;
                }
                if (productName.toUpperCase().contains("POSTGRES")) {
                    dbms = DBMS.POSTGRESQL;
                }
                if (productName.toUpperCase().contains("MYSQL")) {
                    dbms = DBMS.MySQL;
                }
                if (productName.toUpperCase().contains("SQLITE")) {
                    dbms = DBMS.SQLITE;
                }
                if (productName.toUpperCase().contains("ADAPTIVE SERVER")) {
                    dbms = DBMS.SYBASE;
                }
                if (productName.toUpperCase().contains("HSQL")) {
                    dbms = DBMS.HSQL;
                }
                if (productName.toUpperCase().equals("ASE")) {
                    dbms = DBMS.SYBASE;
                }
            }
            _log.info("DB name:        " + productName + " (" + (Object)((Object)dbms) + ")");
            _log.info("DB version:     " + meta.getDatabaseProductVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dbms;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public long executeQuery(String sqlQuery, ResultSetReader reader) throws SQLException {
        return this.executeQuery(sqlQuery, reader, null, null, 0);
    }

    public long executeQuery(String sqlQuery, ResultSetReader reader, String alternativeSQL, Object context, int limit) throws SQLException {
        return this.executeQuery(sqlQuery, reader, alternativeSQL, context, limit, 0);
    }

    public long executeQuery(String sqlQuery, ResultSetReader reader, String alternativeSQL, Object context, int limit, int timeout) throws SQLException {
        _log.info(sqlQuery);
        long rc = 0L;
        try {
            ResultSet resultSet;
            CancellationHandler.checkForCancellation(context);
            Statement statement = this.connectionFactory.getConnection().createStatement();
            CancellationHandler.begin(statement, context);
            try {
                if (timeout > 0) {
                    statement.setQueryTimeout(timeout);
                }
                resultSet = statement.executeQuery(sqlQuery);
            }
            catch (SQLException e) {
                if (alternativeSQL != null) {
                    _log.warn("query failed, using alternative query. Reason: " + e.getMessage());
                    _log.info(alternativeSQL);
                    CancellationHandler.checkForCancellation(context);
                    resultSet = statement.executeQuery(alternativeSQL);
                }
                throw e;
            }
            while (resultSet.next()) {
                reader.readCurrentRow(resultSet);
                if (++rc % 100L == 0L) {
                    CancellationHandler.checkForCancellation(context);
                }
                if (limit <= 0 || rc < (long)limit) continue;
            }
            reader.close();
            resultSet.close();
            statement.close();
            CancellationHandler.end(statement, context);
            _log.info(rc + " row(s)");
            return rc;
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(context);
            if (!this.silent) {
                _log.error("Error executing query", e);
            }
            if (e instanceof SqlException) {
                throw e;
            }
            throw new SqlException("\"" + e.getMessage() + "\" in statement \"" + sqlQuery + "\"", sqlQuery, e);
        }
    }

    public void executeQuery(File sqlFile, ResultSetReader reader) throws SQLException {
        StringBuffer result = new StringBuffer();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(sqlFile));
            while ((line = in.readLine()) != null) {
                result.append(line);
                result.append(System.getProperty("line.separator", "\n"));
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load content of file", e);
        }
        this.executeQuery(result.toString(), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sqlUpdate) throws SQLException {
        _log.info(sqlUpdate);
        CancellationHandler.checkForCancellation(null);
        try {
            int rowCount = 0;
            int failures = 0;
            boolean ok = false;
            boolean serializeAccess = false;
            while (!ok) {
                Statement statement = null;
                try {
                    statement = this.connectionFactory.getConnection().createStatement();
                    CancellationHandler.begin(statement, null);
                    if (serializeAccess) {
                        Object object = DB_LOCK;
                        synchronized (object) {
                            rowCount = statement.executeUpdate(sqlUpdate);
                        }
                    } else {
                        rowCount = statement.executeUpdate(sqlUpdate);
                    }
                    CancellationHandler.end(statement, null);
                    ok = true;
                    _log.info("" + rowCount + " row(s)");
                }
                catch (SQLException e) {
                    CancellationHandler.checkForCancellation(null);
                    CancellationHandler.end(statement, null);
                    if (++failures > 10 || e.getErrorCode() != -911 && e.getErrorCode() != 8176) {
                        throw new SqlException("\"" + e.getMessage() + "\" in statement \"" + sqlUpdate + "\"", sqlUpdate, e);
                    }
                    serializeAccess = true;
                    _log.info("Deadlock! Try again.");
                }
                finally {
                    if (statement == null) continue;
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
            return rowCount;
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            if (!this.silent) {
                _log.error("Error executing statement", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sqlUpdate, Object[] parameter) throws SQLException {
        _log.info(sqlUpdate);
        try {
            CancellationHandler.checkForCancellation(null);
            int rowCount = 0;
            PreparedStatement statement = null;
            try {
                statement = this.connectionFactory.getConnection().prepareStatement(sqlUpdate);
                CancellationHandler.begin(statement, null);
                int i = 1;
                for (Object p : parameter) {
                    statement.setObject(i++, p);
                }
                rowCount = statement.executeUpdate();
                CancellationHandler.end(statement, null);
                _log.info("" + rowCount + " row(s)");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
            }
            return rowCount;
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            if (!this.silent) {
                _log.error("Error executing statement", e);
            }
            throw new SqlException("\"" + e.getMessage() + "\" in statement \"" + sqlUpdate + "\"", sqlUpdate, e);
        }
    }

    public void insertClob(String table, String column, String where, File lobFile, long length) throws SQLException, IOException {
        String sqlUpdate = "Update " + table + " set " + column + "=? where " + where;
        _log.info(sqlUpdate);
        PreparedStatement statement = null;
        try {
            statement = this.connectionFactory.getConnection().prepareStatement(sqlUpdate);
            CancellationHandler.begin(statement, null);
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(lobFile));
            statement.setCharacterStream(1, (Reader)inputStreamReader, (int)length);
            statement.execute();
            statement.close();
            CancellationHandler.end(statement, null);
            inputStreamReader.close();
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            throw e;
        }
    }

    public void insertSQLXML(String table, String column, String where, File lobFile, long length) throws SQLException, IOException {
        String sqlUpdate = "Update " + table + " set " + column + "=? where " + where;
        _log.info(sqlUpdate);
        PreparedStatement statement = null;
        try {
            statement = this.connectionFactory.getConnection().prepareStatement(sqlUpdate);
            CancellationHandler.begin(statement, null);
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(lobFile));
            statement.setCharacterStream(1, (Reader)inputStreamReader, (int)length);
            statement.execute();
            statement.close();
            CancellationHandler.end(statement, null);
            inputStreamReader.close();
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            throw e;
        }
    }

    public void insertBlob(String table, String column, String where, File lobFile) throws SQLException, IOException {
        String sqlUpdate = "Update " + table + " set " + column + "=? where " + where;
        _log.info(sqlUpdate);
        PreparedStatement statement = null;
        try {
            statement = this.connectionFactory.getConnection().prepareStatement(sqlUpdate);
            CancellationHandler.begin(statement, null);
            FileInputStream fileInputStream = new FileInputStream(lobFile);
            statement.setBinaryStream(1, (InputStream)fileInputStream, (int)lobFile.length());
            statement.execute();
            statement.close();
            CancellationHandler.end(statement, null);
            fileInputStream.close();
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            throw e;
        }
    }

    public long execute(String sql) throws SQLException {
        _log.info(sql);
        long rc = 0L;
        try {
            CancellationHandler.checkForCancellation(null);
            Statement statement = this.connectionFactory.getConnection().createStatement();
            CancellationHandler.begin(statement, null);
            rc = statement.executeUpdate(sql);
            statement.close();
            CancellationHandler.end(statement, null);
        }
        catch (SQLException e) {
            CancellationHandler.checkForCancellation(null);
            if (!this.silent) {
                _log.error("Error executing statement", e);
            }
            throw new SqlException("\"" + e.getMessage() + "\" in statement \"" + sql + "\"", sql, e);
        }
        return rc;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        Connection connection = this.connectionFactory.getConnection();
        return connection.getMetaData();
    }

    public static synchronized void setClassLoaderForJdbcDriver(ClassLoader classLoader) {
        classLoaderForJdbcDriver = classLoader;
    }

    public void shutDown() throws SQLException {
        _log.info("closing connection...");
        for (Connection con : this.connections) {
            con.close();
        }
        _log.info("connection closed");
    }

    public void rollbackAll() throws SQLException {
        for (Connection con : this.connections) {
            try {
                con.rollback();
            }
            catch (SQLException e) {
                _log.warn(e.getMessage());
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                _log.warn(e.getMessage());
            }
        }
        this.connection = new ThreadLocal();
    }

    public void commitAll() throws SQLException {
        for (Connection con : this.connections) {
            try {
                con.commit();
            }
            catch (SQLException e) {
                _log.warn(e.getMessage());
            }
        }
    }

    public String getIntrospectionSchema() {
        return this.introspectionSchema;
    }

    public void setIntrospectionSchema(String introspectionSchema) {
        this.introspectionSchema = introspectionSchema;
    }

    public static void closeTemporaryTableSession() {
        try {
            if (temporaryTableSession != null) {
                if (temporaryTableScope == TemporaryTableScope.TRANSACTION_LOCAL) {
                    temporaryTableSession.commit();
                }
                temporaryTableSession.close();
            }
        }
        catch (SQLException e) {
            _log.error("can't close connection", e);
        }
        temporaryTableSession = null;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    public synchronized void setCliArguments(List<String> args) {
        this.cliArguments = args;
    }

    public synchronized List<String> getCliArguments() {
        return this.cliArguments;
    }

    static {
        _log = org.apache.log4j.Logger.getLogger("sql");
        classLoaderForJdbcDriver = null;
        DB_LOCK = "DB_LOCK";
    }

    public static class DriverShim
    implements Driver {
        private Driver driver;

        public DriverShim(Driver d) {
            this.driver = d;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private static interface ConnectionFactory {
        public Connection getConnection() throws SQLException;
    }

    public static abstract class AbstractResultSetReader
    implements ResultSetReader {
        private ResultSet owner;
        private ResultSetMetaData metaData;

        protected ResultSetMetaData getMetaData(ResultSet resultSet) throws SQLException {
            if (this.owner == resultSet) {
                return this.metaData;
            }
            this.owner = resultSet;
            this.metaData = resultSet.getMetaData();
            return this.metaData;
        }

        @Override
        public void close() {
        }
    }

    public static interface ResultSetReader {
        public void readCurrentRow(ResultSet var1) throws SQLException;

        public void close() throws SQLException;
    }
}

