/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.TemporaryTableManager;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.database.UPSERT_MODE;

public class SQLDialect {
    public static final String CONFIG_TABLE_ = "JAILER_CONFIG";
    public static final String TMP_TABLE_ = "JAILER_TMP";
    public static final String DUAL_TABLE = "JAILER_DUAL";
    public boolean needsValuesKeywordForDeletes = false;
    public boolean supportsInClauseForDeletes = false;
    public boolean supportsMultiRowInserts = false;
    public UPSERT_MODE upsertMode = UPSERT_MODE.FROM_JL_DUAL;

    public boolean isNeedsValuesKeywordForDeletes() {
        return this.needsValuesKeywordForDeletes;
    }

    public void setNeedsValuesKeywordForDeletes(boolean needsValuesKeywordForDeletes) {
        this.needsValuesKeywordForDeletes = needsValuesKeywordForDeletes;
    }

    public boolean isSupportsInClauseForDeletes() {
        return this.supportsInClauseForDeletes;
    }

    public void setSupportsInClauseForDeletes(boolean supportsInClauseForDeletes) {
        this.supportsInClauseForDeletes = supportsInClauseForDeletes;
    }

    public boolean isSupportsMultiRowInserts() {
        return this.supportsMultiRowInserts;
    }

    public void setSupportsMultiRowInserts(boolean supportsMultiRowInserts) {
        this.supportsMultiRowInserts = supportsMultiRowInserts;
    }

    public UPSERT_MODE getUpsertMode() {
        return this.upsertMode;
    }

    public void setUpsertMode(UPSERT_MODE upsertMode) {
        this.upsertMode = upsertMode;
    }

    public static String dmlTableReference(String tableName, Session session) {
        TemporaryTableManager tableManager = null;
        TemporaryTableScope temporaryTableScope = CommandLineParser.getInstance().getTemporaryTableScope();
        if (temporaryTableScope == TemporaryTableScope.SESSION_LOCAL) {
            tableManager = Configuration.forDbms((Session)session).sessionTemporaryTableManager;
        }
        if (temporaryTableScope == TemporaryTableScope.TRANSACTION_LOCAL) {
            tableManager = Configuration.forDbms((Session)session).transactionTemporaryTableManager;
        }
        if (tableManager != null) {
            return tableManager.getDmlTableReference(tableName);
        }
        return tableName;
    }

    public String toString() {
        return "SQLDialect [needsValuesKeywordForDeletes=" + this.needsValuesKeywordForDeletes + ", supportsInClauseForDeletes=" + this.supportsInClauseForDeletes + ", supportsMultiRowInserts=" + this.supportsMultiRowInserts + ", upsertMode=" + (Object)((Object)this.upsertMode) + "]";
    }
}

