/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatementBuilder;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.Quoting;
import net.sf.jailer.util.SqlUtil;

public class DeletionTransformer
extends Session.AbstractResultSetReader {
    private final Table table;
    private final OutputStreamWriter scriptFileWriter;
    private StatementBuilder deleteStatementBuilder;
    private Map<String, Integer> typeCache = new HashMap<String, Integer>();
    private final Session session;
    private final Quoting quoting;

    public DeletionTransformer(Table table, OutputStreamWriter scriptFileWriter, int maxBodySize, DatabaseMetaData metaData, Session session) throws SQLException {
        this.table = table;
        this.scriptFileWriter = scriptFileWriter;
        this.deleteStatementBuilder = new StatementBuilder(maxBodySize);
        this.quoting = new Quoting(metaData);
        this.session = session;
    }

    @Override
    public void readCurrentRow(ResultSet resultSet) throws SQLException {
        try {
            SQLDialect currentDialect = Configuration.forDbms(this.session).getSqlDialect();
            if (SqlUtil.dbms == DBMS.SYBASE || currentDialect != null && !currentDialect.supportsInClauseForDeletes) {
                String deleteHead = "Delete from " + this.qualifiedTableName(this.table) + " Where (";
                boolean firstTime = true;
                String item = "";
                for (Column pkColumn : this.table.primaryKey.getColumns()) {
                    item = item + (firstTime ? "" : " and ") + pkColumn.name + "=" + SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), this.quoting.unquote(pkColumn.name), this.typeCache), this.session);
                    firstTime = false;
                }
                if (!this.deleteStatementBuilder.isAppendable(deleteHead, item)) {
                    this.writeToScriptFile(this.deleteStatementBuilder.build());
                }
                this.deleteStatementBuilder.append(deleteHead, item, ") or (", ");\n");
            } else {
                String item;
                String deleteHead;
                if (this.table.primaryKey.getColumns().size() == 1) {
                    deleteHead = "Delete from " + this.qualifiedTableName(this.table) + " Where " + this.table.primaryKey.getColumns().get((int)0).name + " in (";
                    item = SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), this.quoting.unquote(this.table.primaryKey.getColumns().get((int)0).name), this.typeCache), this.session);
                } else {
                    deleteHead = "Delete from " + this.qualifiedTableName(this.table) + " Where (";
                    item = "(";
                    boolean firstTime = true;
                    for (Column pkColumn : this.table.primaryKey.getColumns()) {
                        deleteHead = deleteHead + (firstTime ? "" : ", ") + pkColumn.name;
                        item = item + (firstTime ? "" : ", ") + SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), this.quoting.unquote(pkColumn.name), this.typeCache), this.session);
                        firstTime = false;
                    }
                    item = item + ")";
                    deleteHead = deleteHead + ") in (";
                    if (currentDialect.needsValuesKeywordForDeletes) {
                        deleteHead = deleteHead + "values ";
                    }
                }
                if (!this.deleteStatementBuilder.isAppendable(deleteHead, item)) {
                    this.writeToScriptFile(this.deleteStatementBuilder.build());
                }
                this.deleteStatementBuilder.append(deleteHead, item, ", ", ");\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String qualifiedTableName(Table t) {
        String schema = t.getOriginalSchema("");
        String mappedSchema = CommandLineParser.getInstance().getSourceSchemaMapping().get(schema);
        if (mappedSchema != null) {
            schema = mappedSchema;
        }
        if (schema.length() == 0) {
            return t.getUnqualifiedName();
        }
        return schema + "." + t.getUnqualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToScriptFile(String content) throws IOException {
        OutputStreamWriter outputStreamWriter = this.scriptFileWriter;
        synchronized (outputStreamWriter) {
            if (SqlUtil.dbms == DBMS.ORACLE) {
                this.scriptFileWriter.write(SqlUtil.splitDMLStatement(content, 2400));
            } else {
                this.scriptFileWriter.write(content);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.writeToScriptFile(this.deleteStatementBuilder.build());
            this.typeCache = new HashMap<String, Integer>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

