/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.database;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatementBuilder;
import net.sf.jailer.database.UPSERT_MODE;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.Base64;
import net.sf.jailer.util.Quoting;
import net.sf.jailer.util.SqlUtil;

public class DMLTransformer
extends Session.AbstractResultSetReader {
    private final Table table;
    private final OutputStreamWriter scriptFileWriter;
    private int columnCount;
    private String[] columnLabel = null;
    private List<String> lobColumns = null;
    private String[] emptyLobValue = null;
    private boolean tableHasLobs = false;
    private List<Integer> lobColumnIndexes = null;
    private String labelCSL;
    private final StatementBuilder insertStatementBuilder;
    private Map<String, StatementBuilder> upsertInsertStatementBuilder = new HashMap<String, StatementBuilder>();
    private final boolean upsertOnly;
    private final int maxBodySize;
    public static long numberOfExportedLOBs;
    private final Quoting quoting;
    private boolean tableHasIdentityColumn;
    private final Session session;
    private Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();
    private final SQLDialect currentDialect;
    private static Table identityInsertTable;

    public DMLTransformer(Table table, OutputStreamWriter scriptFileWriter, boolean upsertOnly, int maxBodySize, DatabaseMetaData metaData, Session session) throws SQLException {
        this.maxBodySize = maxBodySize;
        this.upsertOnly = upsertOnly;
        this.table = table;
        this.scriptFileWriter = scriptFileWriter;
        this.currentDialect = Configuration.forDbms(session).getSqlDialect();
        this.insertStatementBuilder = new StatementBuilder(this.currentDialect.supportsMultiRowInserts || session.dbms == DBMS.ORACLE || session.dbms == DBMS.SQLITE ? maxBodySize : 1);
        this.quoting = new Quoting(metaData);
        this.session = session;
        this.tableHasIdentityColumn = false;
        if (Configuration.forDbms(session).isIdentityInserts()) {
            for (Column c : table.getColumns()) {
                if (!c.isIdentityColumn) continue;
                this.tableHasIdentityColumn = true;
                break;
            }
        }
    }

    @Override
    public void readCurrentRow(ResultSet resultSet) throws SQLException {
        if (this.columnLabel == null) {
            this.columnCount = this.getMetaData(resultSet).getColumnCount();
            this.columnLabel = new String[this.columnCount + 1];
            this.lobColumns = new ArrayList<String>();
            this.emptyLobValue = new String[this.columnCount + 1];
            this.lobColumnIndexes = new ArrayList<Integer>();
            this.labelCSL = "";
            this.tableHasLobs = false;
            for (int i = 1; i <= this.columnCount; ++i) {
                String mdColumnLabel = this.quoting.quote(this.getMetaData(resultSet).getColumnLabel(i));
                int mdColumnType = this.getMetaData(resultSet).getColumnType(i);
                if ((mdColumnType == 2004 || mdColumnType == 2005 || mdColumnType == 2009) && this.session.dbms != DBMS.SQLITE) {
                    this.tableHasLobs = true;
                    this.lobColumnIndexes.add(i);
                    this.lobColumns.add(mdColumnLabel);
                    if (mdColumnType == 2009) {
                        this.emptyLobValue[i] = null;
                    } else {
                        Configuration c = Configuration.forDbms(this.session);
                        String string = this.emptyLobValue[i] = mdColumnType == 2004 ? c.emptyBLOBValue : c.emptyCLOBValue;
                    }
                    if (this.emptyLobValue[i] == null) continue;
                }
                this.columnLabel[i] = mdColumnLabel;
                if (this.labelCSL.length() > 0) {
                    this.labelCSL = this.labelCSL + ", ";
                }
                this.labelCSL = this.labelCSL + this.columnLabel[i];
            }
        }
        try {
            String item;
            StringBuffer valueList = new StringBuffer("");
            StringBuffer namedValues = new StringBuffer("");
            boolean f = true;
            for (int i = 1; i <= this.columnCount; ++i) {
                if (this.columnLabel[i] == null) continue;
                Object content = SqlUtil.getObject(resultSet, this.getMetaData(resultSet), i, this.typeCache);
                if (resultSet.wasNull()) {
                    content = null;
                }
                if (!f) {
                    namedValues.append(", ");
                    valueList.append(", ");
                }
                f = false;
                String cVal = SqlUtil.toSql(content, this.session);
                if (content != null && this.emptyLobValue[i] != null) {
                    cVal = this.emptyLobValue[i];
                }
                valueList.append(cVal);
                namedValues.append(cVal + " " + this.columnLabel[i]);
            }
            if (this.table.getUpsert().booleanValue() || this.upsertOnly) {
                StringBuffer terminator;
                HashMap<String, String> val = new HashMap<String, String>();
                StringBuffer valuesWONull = new StringBuffer("");
                StringBuffer columnsWONull = new StringBuffer("");
                f = true;
                for (int i = 1; i <= this.columnCount; ++i) {
                    int mdColumnType;
                    if (this.columnLabel[i] == null) continue;
                    Object content = SqlUtil.getObject(resultSet, this.getMetaData(resultSet), i, this.typeCache);
                    if (resultSet.wasNull()) {
                        content = null;
                    }
                    String cVal = SqlUtil.toSql(content, this.session);
                    if (SqlUtil.dbms == DBMS.POSTGRESQL && (content instanceof Date || content instanceof Timestamp)) {
                        cVal = "timestamp " + cVal;
                    }
                    if (SqlUtil.dbms == DBMS.POSTGRESQL && (mdColumnType = this.getMetaData(resultSet).getColumnType(i)) == 92) {
                        cVal = "time " + cVal;
                    }
                    if (content != null && this.emptyLobValue[i] != null) {
                        cVal = this.emptyLobValue[i];
                    }
                    val.put(this.columnLabel[i], cVal);
                    if (content == null) continue;
                    if (!f) {
                        valuesWONull.append(", ");
                        columnsWONull.append(", ");
                    }
                    f = false;
                    valuesWONull.append(cVal);
                    columnsWONull.append(this.columnLabel[i]);
                }
                String insertHead = "Insert into " + this.qualifiedTableName(this.table) + "(" + columnsWONull + ") ";
                f = true;
                StringBuffer whereForTerminator = new StringBuffer("");
                StringBuffer where = new StringBuffer("");
                StringBuffer whereWOAlias = new StringBuffer("");
                for (Column pk : this.table.primaryKey.getColumns()) {
                    if (!f) {
                        whereForTerminator.append(" and ");
                        where.append(" and ");
                        whereWOAlias.append(" and ");
                    }
                    f = false;
                    whereForTerminator.append("T." + pk.name + "=Q." + pk.name);
                    String value = val.containsKey(pk.name) ? (String)val.get(pk.name) : (val.containsKey(pk.name.toLowerCase()) ? (String)val.get(pk.name.toLowerCase()) : (String)val.get(pk.name.toUpperCase()));
                    where.append("T." + pk.name + "=" + value);
                    whereWOAlias.append(pk.name + "=" + value);
                }
                if (this.currentDialect.upsertMode == UPSERT_MODE.MERGE && !this.tableHasLobs) {
                    String item2;
                    insertHead = "MERGE INTO " + this.qualifiedTableName(this.table) + " T USING(";
                    terminator = new StringBuffer(") Q ON(" + whereForTerminator + ") ");
                    StringBuffer sets = new StringBuffer();
                    StringBuffer tSchema = new StringBuffer();
                    StringBuffer iSchema = new StringBuffer();
                    for (int i = 1; i <= this.columnCount; ++i) {
                        if (this.columnLabel[i] == null) continue;
                        if (!this.isPrimaryKeyColumn(this.columnLabel[i])) {
                            if (sets.length() > 0) {
                                sets.append(", ");
                            }
                            sets.append("T." + this.columnLabel[i] + "=Q." + this.columnLabel[i]);
                        }
                        if (tSchema.length() > 0) {
                            tSchema.append(", ");
                        }
                        tSchema.append("T." + this.columnLabel[i]);
                        if (iSchema.length() > 0) {
                            iSchema.append(", ");
                        }
                        iSchema.append("Q." + this.columnLabel[i]);
                    }
                    if (sets.length() > 0) {
                        terminator.append("WHEN MATCHED THEN UPDATE SET " + sets + " ");
                    }
                    terminator.append("WHEN NOT MATCHED THEN INSERT (" + tSchema + ") VALUES(" + iSchema + ");\n");
                    StatementBuilder sb = this.upsertInsertStatementBuilder.get(insertHead);
                    if (sb == null) {
                        sb = new StatementBuilder(this.maxBodySize);
                        this.upsertInsertStatementBuilder.put(insertHead, sb);
                    }
                    if (!sb.isAppendable(insertHead, item2 = "Select " + valueList + " from dual")) {
                        this.writeToScriptFile(sb.build(), true);
                    }
                    if (sb.isEmpty()) {
                        item2 = "Select " + namedValues + " from dual";
                    }
                    sb.append(insertHead, item2, " UNION ALL ", terminator.toString());
                } else if (this.currentDialect.upsertMode == UPSERT_MODE.DB2) {
                    String item3;
                    insertHead = insertHead + "Select * From (values ";
                    terminator = new StringBuffer(") as Q(" + columnsWONull + ") Where not exists (Select * from " + this.qualifiedTableName(this.table) + " T " + "Where ");
                    terminator.append(whereForTerminator + ");\n");
                    StatementBuilder sb = this.upsertInsertStatementBuilder.get(insertHead);
                    if (sb == null) {
                        sb = new StatementBuilder(this.maxBodySize);
                        this.upsertInsertStatementBuilder.put(insertHead, sb);
                    }
                    if (!sb.isAppendable(insertHead, item3 = "(" + valuesWONull + ")")) {
                        this.writeToScriptFile(sb.build(), true);
                    }
                    sb.append(insertHead, item3, ", ", terminator.toString());
                } else {
                    String item4 = "Select " + valuesWONull + " From " + (this.currentDialect.upsertMode == UPSERT_MODE.FROM_DUAL || this.currentDialect.upsertMode == UPSERT_MODE.MERGE ? "dual" : "JAILER_DUAL");
                    StringBuffer terminator2 = new StringBuffer(" Where not exists (Select * from " + this.qualifiedTableName(this.table) + " T " + "Where ");
                    terminator2.append(where + ");\n");
                    StatementBuilder sb = this.upsertInsertStatementBuilder.get(insertHead);
                    if (sb == null) {
                        sb = new StatementBuilder(1);
                        this.upsertInsertStatementBuilder.put(insertHead, sb);
                    }
                    if (!sb.isAppendable(insertHead, item4)) {
                        this.writeToScriptFile(sb.build(), true);
                    }
                    sb.append(insertHead, item4, ", ", terminator2.toString());
                }
                if (this.currentDialect.upsertMode != UPSERT_MODE.MERGE || this.tableHasLobs) {
                    StringBuffer insert = new StringBuffer("");
                    insert.append("Update " + this.qualifiedTableName(this.table) + " set ");
                    f = true;
                    for (int i = 1; i <= this.columnCount; ++i) {
                        if (this.columnLabel[i] == null || this.emptyLobValue[i] != null && !"null".equals(val.get(this.columnLabel[i])) || this.isPrimaryKeyColumn(this.columnLabel[i])) continue;
                        if (!f) {
                            insert.append(", ");
                        }
                        f = false;
                        insert.append(this.columnLabel[i] + "=" + (String)val.get(this.columnLabel[i]));
                    }
                    if (!f) {
                        insert.append(" Where " + whereWOAlias + ";\n");
                        this.writeToScriptFile(insert.toString(), true);
                    }
                }
            } else if (this.session.dbms == DBMS.ORACLE && this.maxBodySize > 1) {
                String insertSchema = "Insert into " + this.qualifiedTableName(this.table) + "(" + this.labelCSL + ") ";
                if (!this.insertStatementBuilder.isAppendable(insertSchema, item = "\n Select " + valueList + " From DUAL")) {
                    this.writeToScriptFile(this.insertStatementBuilder.build(), true);
                }
                this.insertStatementBuilder.append(insertSchema, item, " Union all ", ";\n");
            } else if (this.session.dbms == DBMS.SQLITE && this.maxBodySize > 1) {
                String insertSchema = "Insert into " + this.qualifiedTableName(this.table) + "(" + this.labelCSL + ") ";
                if (!this.insertStatementBuilder.isAppendable(insertSchema, item = "\n Select " + valueList + " ")) {
                    this.writeToScriptFile(this.insertStatementBuilder.build(), true);
                }
                this.insertStatementBuilder.append(insertSchema, item, " Union all ", ";\n");
            } else {
                String insertSchema = "Insert into " + this.qualifiedTableName(this.table) + "(" + this.labelCSL + ") values ";
                if (!this.insertStatementBuilder.isAppendable(insertSchema, item = (this.maxBodySize > 1 ? "\n " : "") + "(" + valueList + ")")) {
                    this.writeToScriptFile(this.insertStatementBuilder.build(), true);
                }
                this.insertStatementBuilder.append(insertSchema, item, ", ", ";\n");
            }
            this.exportLobs(this.table, resultSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String qualifiedTableName(Table t) {
        String schema = t.getOriginalSchema("");
        String mappedSchema = CommandLineParser.getInstance().getSchemaMapping().get(schema);
        if (mappedSchema != null) {
            schema = mappedSchema;
        }
        if (schema.length() == 0) {
            return t.getUnqualifiedName();
        }
        return schema + "." + t.getUnqualifiedName();
    }

    private boolean isPrimaryKeyColumn(String column) {
        for (Column c : this.table.primaryKey.getColumns()) {
            if (!c.name.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportLobs(Table table, ResultSet resultSet) throws IOException, SQLException {
        OutputStreamWriter outputStreamWriter = this.scriptFileWriter;
        synchronized (outputStreamWriter) {
            for (int i = 0; i < this.lobColumnIndexes.size(); ++i) {
                int b;
                int c;
                StringBuffer line;
                Closeable in;
                Object lob = resultSet.getObject(this.lobColumnIndexes.get(i));
                HashMap<String, String> val = new HashMap<String, String>();
                for (int j = 1; j <= this.columnCount; ++j) {
                    if (this.columnLabel[j] == null) continue;
                    Object content = SqlUtil.getObject(resultSet, this.getMetaData(resultSet), j, this.typeCache);
                    if (resultSet.wasNull()) {
                        content = null;
                    }
                    String cVal = SqlUtil.toSql(content, this.session);
                    val.put(this.columnLabel[j], cVal);
                }
                boolean f = true;
                StringBuffer where = new StringBuffer("");
                for (Column pk : table.primaryKey.getColumns()) {
                    if (!f) {
                        where.append(" and ");
                    }
                    f = false;
                    where.append(pk.name + "=" + (String)val.get(pk.name));
                }
                if (lob instanceof SQLXML) {
                    ++numberOfExportedLOBs;
                    this.flush();
                    SQLXML xml = (SQLXML)lob;
                    this.writeToScriptFile("--+XML " + this.qualifiedTableName(table) + ", " + this.lobColumns.get(i) + ", " + where + "\n", false);
                    in = xml.getCharacterStream();
                    line = new StringBuffer("--+");
                    while ((c = ((Reader)in).read()) != -1) {
                        if ((char)c == '\n') {
                            this.writeToScriptFile(line.toString() + "\\n\n", false);
                            line = new StringBuffer("--+");
                        } else if ((char)c == '\r') {
                            line.append("\\r");
                        } else {
                            line.append((char)c);
                            if ((char)c == '\\') {
                                line.append((char)c);
                            }
                        }
                        if (line.length() < 200) continue;
                        this.writeToScriptFile(line.toString() + "\n", false);
                        line = new StringBuffer("--+");
                    }
                    ((Reader)in).close();
                    this.writeToScriptFile(line.toString() + "\n" + "--." + "\n", false);
                }
                if (lob instanceof Clob) {
                    ++numberOfExportedLOBs;
                    this.flush();
                    Clob clob = (Clob)lob;
                    this.writeToScriptFile("--+CLOB " + this.qualifiedTableName(table) + ", " + this.lobColumns.get(i) + ", " + where + "\n", false);
                    in = clob.getCharacterStream();
                    line = new StringBuffer("--+");
                    while ((c = ((Reader)in).read()) != -1) {
                        if ((char)c == '\n') {
                            this.writeToScriptFile(line.toString() + "\\n\n", false);
                            line = new StringBuffer("--+");
                        } else if ((char)c == '\r') {
                            line.append("\\r");
                        } else {
                            line.append((char)c);
                            if ((char)c == '\\') {
                                line.append((char)c);
                            }
                        }
                        if (line.length() < 200) continue;
                        this.writeToScriptFile(line.toString() + "\n", false);
                        line = new StringBuffer("--+");
                    }
                    ((Reader)in).close();
                    this.writeToScriptFile(line.toString() + "\n" + "--." + "\n", false);
                }
                if (!(lob instanceof Blob)) continue;
                ++numberOfExportedLOBs;
                this.flush();
                Blob blob = (Blob)lob;
                this.writeToScriptFile("--+BLOB " + this.qualifiedTableName(table) + ", " + this.lobColumns.get(i) + ", " + where + "\n", false);
                in = blob.getBinaryStream();
                line = new StringBuffer("--+");
                byte[] buffer = new byte[64];
                int size = 0;
                while ((b = ((InputStream)in).read()) != -1) {
                    buffer[size++] = (byte)b;
                    if (size != buffer.length) continue;
                    this.writeToScriptFile(line.toString() + Base64.encodeBytes(buffer, 8) + "\n", false);
                    line = new StringBuffer("--+");
                    size = 0;
                }
                ((InputStream)in).close();
                this.writeToScriptFile(line.toString() + Base64.encodeBytes(buffer, 0, size, 8) + "\n" + "--." + "\n", false);
            }
        }
    }

    public void flush() {
        try {
            this.writeToScriptFile(this.insertStatementBuilder.build(), true);
            for (StatementBuilder sb : this.upsertInsertStatementBuilder.values()) {
                this.writeToScriptFile(sb.build(), true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.flush();
        OutputStreamWriter outputStreamWriter = this.scriptFileWriter;
        synchronized (outputStreamWriter) {
            if (identityInsertTable != null) {
                try {
                    this.scriptFileWriter.write("SET IDENTITY_INSERT " + this.qualifiedTableName(identityInsertTable) + " OFF;\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                identityInsertTable = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToScriptFile(String content, boolean wrap) throws IOException {
        OutputStreamWriter outputStreamWriter = this.scriptFileWriter;
        synchronized (outputStreamWriter) {
            if (this.tableHasIdentityColumn && identityInsertTable != this.table) {
                if (identityInsertTable != null) {
                    this.scriptFileWriter.write("SET IDENTITY_INSERT " + this.qualifiedTableName(identityInsertTable) + " OFF;\n");
                    identityInsertTable = null;
                }
                this.scriptFileWriter.write("SET IDENTITY_INSERT " + this.qualifiedTableName(this.table) + " ON;\n");
                identityInsertTable = this.table;
            }
            if (wrap && SqlUtil.dbms == DBMS.ORACLE) {
                this.scriptFileWriter.write(SqlUtil.splitDMLStatement(content, 2400));
            } else {
                this.scriptFileWriter.write(content);
            }
        }
    }

    static {
        identityInsertTable = null;
    }
}

