/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.DDLCreator;
import net.sf.jailer.ExplainTool;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.ScriptType;
import net.sf.jailer.database.DMLTransformer;
import net.sf.jailer.database.DeletionTransformer;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatisticRenovator;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ParameterHandler;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.dbunit.FlatXMLTransformer;
import net.sf.jailer.domainmodel.DomainModel;
import net.sf.jailer.enhancer.ScriptEnhancer;
import net.sf.jailer.entitygraph.EntityGraph;
import net.sf.jailer.entitygraph.local.LocalEntityGraph;
import net.sf.jailer.entitygraph.remote.RemoteEntityGraph;
import net.sf.jailer.extractionmodel.ExtractionModel;
import net.sf.jailer.liquibase.LiquibaseXMLTransformer;
import net.sf.jailer.modelbuilder.ModelBuilder;
import net.sf.jailer.progress.ProgressListener;
import net.sf.jailer.progress.ProgressListenerRegistry;
import net.sf.jailer.render.DataModelRenderer;
import net.sf.jailer.restrictionmodel.RestrictionModel;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.ClasspathUtil;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.CycleFinder;
import net.sf.jailer.util.JobManager;
import net.sf.jailer.util.PrintUtil;
import net.sf.jailer.util.SqlScriptExecutor;
import net.sf.jailer.util.SqlUtil;
import net.sf.jailer.xml.XmlExportTransformer;
import net.sf.jailer.xml.XmlUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.helpers.AttributesImpl;

public class Jailer {
    public static final String VERSION = "5.0.2";
    public static final String APPLICATION_NAME = "Jailer";
    private DataModel datamodel;
    private EntityGraph entityGraph;
    private final JobManager jobManager;
    private static final Logger _log;
    private StringBuffer commentHeader = new StringBuffer();
    private Set<Table> initialDataTables = new HashSet<Table>();
    private boolean isDown = false;
    private long lastRunstats = 0L;

    public Jailer(int threads) throws Exception {
        this.jobManager = new JobManager(threads);
    }

    public void setEntityGraph(EntityGraph entityGraph) {
        this.entityGraph = entityGraph;
    }

    public void setDataModel(DataModel dataModel) {
        this.datamodel = dataModel;
    }

    public Set<Table> export(Table table, String condition, Collection<Table> progressOfYesterday) throws Exception {
        return this.export(table, condition, progressOfYesterday, 0L);
    }

    private void appendCommentHeader(String comment) {
        this.commentHeader.append("-- " + comment.replace('\n', ' ').replace('\r', ' ') + "\n");
    }

    public Set<Table> export(Table table, String condition, Collection<Table> progressOfYesterday, long limit) throws Exception {
        _log.info("exporting " + this.datamodel.getDisplayName(table) + " Where " + condition.replace('\n', ' ').replace('\r', ' '));
        int today = this.entityGraph.getAge();
        this.entityGraph.setAge(today + 1);
        Map<Table, Collection<Association>> progress = new HashMap<Table, Collection<Association>>();
        ProgressListenerRegistry.getProgressListener().collectionJobEnqueued(1, table);
        ProgressListenerRegistry.getProgressListener().collectionJobStarted(1, table);
        long rc = this.entityGraph.addEntities(table, condition, today, limit);
        ProgressListenerRegistry.getProgressListener().collected(1, table, rc);
        if (rc > 0L) {
            progress.put(table, new ArrayList());
        }
        if (progressOfYesterday != null) {
            for (Table t : progressOfYesterday) {
                progress.put(t, new ArrayList());
            }
        }
        HashSet<Table> totalProgress = new HashSet<Table>();
        while (!progress.isEmpty()) {
            totalProgress.addAll(progress.keySet());
            _log.info("day " + today + ", progress: " + Jailer.asString(progress.keySet()));
            this.entityGraph.setAge(++today + 1);
            progress = this.resolveAssociations(today, progress);
        }
        _log.info("exported " + this.datamodel.getDisplayName(table) + " Where " + condition.replace('\n', ' ').replace('\r', ' '));
        _log.info("total progress: " + Jailer.asString(totalProgress));
        _log.info("export statistic:");
        boolean firstLine = true;
        for (String line : this.entityGraph.getStatistics(this.datamodel, new HashSet<Table>())) {
            String l = (firstLine ? "Exported Rows:     " : "    ") + line;
            _log.info(l);
            this.appendCommentHeader(l);
            if (firstLine) {
                this.appendCommentHeader("");
            }
            firstLine = false;
        }
        this.appendCommentHeader("");
        boolean isFiltered = false;
        for (Table t : new TreeSet<Table>(totalProgress)) {
            for (Column c : t.getColumns()) {
                if (c.getFilterExpression() == null) continue;
                if (!isFiltered) {
                    isFiltered = true;
                    this.appendCommentHeader("Used Filters:");
                }
                this.appendCommentHeader("    " + t.getUnqualifiedName() + "." + c.name + " := " + c.getFilterExpression());
            }
        }
        return totalProgress;
    }

    private Set<Table> exportInitialData(Table subject) throws Exception {
        Set<Table> idTables = this.initialDataTables;
        HashSet<Table> tables = new HashSet<Table>();
        for (Table table : idTables) {
            tables.add(table);
            _log.info("exporting all " + this.datamodel.getDisplayName(table));
            int today = this.entityGraph.getAge();
            ProgressListenerRegistry.getProgressListener().collectionJobEnqueued(1, table);
            ProgressListenerRegistry.getProgressListener().collectionJobStarted(1, table);
            long rc = this.entityGraph.addEntities(table, "1=1", today, 0L);
            ProgressListenerRegistry.getProgressListener().collected(1, table, rc);
            this.entityGraph.setAge(today + 1);
        }
        return tables;
    }

    private void readInitialDataTables(Map<String, String> sourceSchemaMapping, Table subject) throws Exception {
        File file = CommandLineParser.getInstance().newFile(DataModel.getInitialDataTablesFile());
        if (file.exists()) {
            Set<Table> idTables = SqlUtil.readTableList(new CsvFile(file), this.datamodel, sourceSchemaMapping);
            idTables.remove(subject);
            this.initialDataTables = idTables;
        } else {
            this.initialDataTables = new HashSet<Table>();
        }
    }

    private Map<Table, Collection<Association>> resolveAssociations(final int today, Map<Table, Collection<Association>> progressOfYesterday) throws Exception {
        final HashMap<Table, Collection<Association>> progress = new HashMap<Table, Collection<Association>>();
        HashMap<Table, ArrayList<1>> jobsPerDestination = new HashMap<Table, ArrayList<1>>();
        for (final Table table : progressOfYesterday.keySet()) {
            for (final Association association : table.associations) {
                if (this.initialDataTables.contains(association.destination)) {
                    _log.info("skip association with initial table " + this.datamodel.getDisplayName(table) + " -> " + this.datamodel.getDisplayName(association.destination));
                    continue;
                }
                Collection<Association> as = progressOfYesterday.get(table);
                if (as != null && as.size() == 1 && as.iterator().next() == association.reversalAssociation && (association.getCardinality() == Cardinality.MANY_TO_ONE || association.getCardinality() == Cardinality.ONE_TO_ONE)) {
                    _log.info("skip reversal association " + this.datamodel.getDisplayName(table) + " -> " + this.datamodel.getDisplayName(association.destination));
                    continue;
                }
                String jc = association.getJoinCondition();
                if (jc != null) {
                    ProgressListenerRegistry.getProgressListener().collectionJobEnqueued(today, association);
                }
                JobManager.Job job = new JobManager.Job(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws Exception {
                        Jailer.this.runstats(Jailer.this.entityGraph.getSession(), false);
                        if (association.getJoinCondition() != null) {
                            _log.info("resolving " + Jailer.this.datamodel.getDisplayName(table) + " -> " + association.toString(0, true) + "...");
                        }
                        ProgressListenerRegistry.getProgressListener().collectionJobStarted(today, association);
                        long rc = Jailer.this.entityGraph.resolveAssociation(table, association, today);
                        ProgressListenerRegistry.getProgressListener().collected(today, association, rc);
                        if (rc >= 0L) {
                            _log.info(rc + " entities found resolving " + Jailer.this.datamodel.getDisplayName(table) + " -> " + association.toString(0, true));
                        }
                        Map map = progress;
                        synchronized (map) {
                            if (rc > 0L) {
                                ArrayList<Association> as = (ArrayList<Association>)progress.get(association.destination);
                                if (as == null) {
                                    as = new ArrayList<Association>();
                                    progress.put(association.destination, as);
                                }
                                as.add(association);
                            }
                        }
                    }
                };
                ArrayList<1> jobList = (ArrayList<1>)jobsPerDestination.get(association.destination);
                if (jobList == null) {
                    jobList = new ArrayList<1>();
                    jobsPerDestination.put(association.destination, jobList);
                }
                jobList.add(job);
            }
        }
        ArrayList<JobManager.Job> jobs = new ArrayList<JobManager.Job>();
        for (final Map.Entry entry : jobsPerDestination.entrySet()) {
            jobs.add(new JobManager.Job(){

                @Override
                public void run() throws Exception {
                    for (JobManager.Job job : (List)entry.getValue()) {
                        job.run();
                    }
                }
            });
        }
        this.jobManager.executeJobs(jobs);
        if (EntityGraph.maxTotalRowcount > 0L && EntityGraph.maxTotalRowcount < this.entityGraph.getTotalRowcount()) {
            throw new RuntimeException("found more than " + EntityGraph.maxTotalRowcount + " entities.");
        }
        return progress;
    }

    public void addDependencies(Set<Table> progress, boolean treatAggregationAsDependency) throws Exception {
        ArrayList<JobManager.Job> jobs = new ArrayList<JobManager.Job>();
        for (final Table table : progress) {
            for (final Association association : table.associations) {
                String jc;
                if (!progress.contains(association.destination)) continue;
                final int aggregationId = treatAggregationAsDependency ? association.getId() : 0;
                final int dependencyId = association.getId();
                if (treatAggregationAsDependency) {
                    if (association.getAggregationSchema() == AggregationSchema.NONE) continue;
                    jc = association.getUnrestrictedJoinCondition();
                    jobs.add(new JobManager.Job(){

                        @Override
                        public void run() throws Exception {
                            _log.info("find aggregation for " + Jailer.this.datamodel.getDisplayName(table) + " -> " + Jailer.this.datamodel.getDisplayName(association.destination) + " on " + jc);
                            String fromAlias = association.reversed ? "B" : "A";
                            String toAlias = association.reversed ? "A" : "B";
                            Jailer.this.entityGraph.addDependencies(table, fromAlias, association.destination, toAlias, jc, aggregationId, dependencyId, association.reversed);
                        }
                    });
                    continue;
                }
                jc = association.getJoinCondition();
                if (jc != null && association.isInsertDestinationBeforeSource()) {
                    jobs.add(new JobManager.Job(){

                        @Override
                        public void run() throws Exception {
                            _log.info("find dependencies " + Jailer.this.datamodel.getDisplayName(table) + " -> " + Jailer.this.datamodel.getDisplayName(association.destination) + " on " + jc);
                            String fromAlias = association.reversed ? "B" : "A";
                            String toAlias = association.reversed ? "A" : "B";
                            Jailer.this.entityGraph.addDependencies(table, fromAlias, association.destination, toAlias, jc, aggregationId, dependencyId, association.reversed);
                        }
                    });
                }
                if (jc == null || !association.isInsertSourceBeforeDestination()) continue;
                jobs.add(new JobManager.Job(){

                    @Override
                    public void run() throws Exception {
                        _log.info("find dependencies " + Jailer.this.datamodel.getDisplayName(association.destination) + " -> " + Jailer.this.datamodel.getDisplayName(table) + " on " + jc);
                        String fromAlias = association.reversed ? "B" : "A";
                        String toAlias = association.reversed ? "A" : "B";
                        Jailer.this.entityGraph.addDependencies(association.destination, toAlias, table, fromAlias, jc, aggregationId, dependencyId, association.reversed);
                    }
                });
            }
        }
        this.jobManager.executeJobs(jobs);
    }

    private void writeEntities(OutputStreamWriter result, TransformerHandler transformerHandler, ScriptType scriptType, Table table, boolean orderByPK, String filepath) throws Exception {
        Session.ResultSetReader reader = this.createResultSetReader(result, transformerHandler, scriptType, table, filepath);
        this.entityGraph.readEntities(table, reader, orderByPK);
        this.entityGraph.deleteEntities(table);
    }

    private Session.ResultSetReader createResultSetReader(OutputStreamWriter outputWriter, TransformerHandler transformerHandler, ScriptType scriptType, Table table, String filepath) throws SQLException {
        Session targetSession = this.entityGraph.getTargetSession();
        if (scriptType == ScriptType.INSERT) {
            if (ScriptFormat.DBUNIT_FLAT_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
                return new FlatXMLTransformer(table, transformerHandler, targetSession.getMetaData(), targetSession.dbms);
            }
            if (ScriptFormat.LIQUIBASE_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
                return new LiquibaseXMLTransformer(table, transformerHandler, targetSession.getMetaData(), this.entityGraph, filepath, CommandLineParser.getInstance().xmlDatePattern, CommandLineParser.getInstance().xmlTimePattern, CommandLineParser.getInstance().xmlTimeStampPattern);
            }
            return new DMLTransformer(table, outputWriter, CommandLineParser.getInstance().upsertOnly, CommandLineParser.getInstance().numberOfEntities, targetSession.getMetaData(), targetSession);
        }
        return new DeletionTransformer(table, outputWriter, CommandLineParser.getInstance().numberOfEntities, targetSession.getMetaData(), targetSession);
    }

    public void writeEntities(final String sqlScriptFile, final ScriptType scriptType, Set<Table> progress, Session session) throws Exception {
        long rest;
        StreamResult streamResult;
        _log.info("writing file '" + sqlScriptFile + "'...");
        OutputStream outputStream = new FileOutputStream(sqlScriptFile);
        if (sqlScriptFile.toLowerCase().endsWith(".zip") || sqlScriptFile.toLowerCase().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        TransformerHandler transformerHandler = null;
        OutputStreamWriter result = null;
        Charset charset = Charset.defaultCharset();
        if (CommandLineParser.getInstance().uTF8) {
            charset = Charset.forName("UTF8");
        }
        if (scriptType == ScriptType.INSERT && ScriptFormat.DBUNIT_FLAT_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
            streamResult = new StreamResult(new OutputStreamWriter(outputStream, charset));
            transformerHandler = XmlUtil.createTransformerHandler(this.commentHeader.toString(), "dataset", streamResult, charset);
        } else if (scriptType == ScriptType.INSERT && ScriptFormat.LIQUIBASE_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
            streamResult = new StreamResult(new OutputStreamWriter(outputStream, charset));
            transformerHandler = XmlUtil.createTransformerHandler(this.commentHeader.toString(), "", streamResult, charset);
            AttributesImpl attrdatabaseChangeLog = new AttributesImpl();
            attrdatabaseChangeLog.addAttribute("", "", "xmlns:xsi", "", "http://www.w3.org/2001/XMLSchema-instance");
            attrdatabaseChangeLog.addAttribute("", "", "xmlns:ext", "", "http://www.liquibase.org/xml/ns/dbchangelog-ext");
            attrdatabaseChangeLog.addAttribute("", "", "xsi:schemaLocation", "", "http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.0.xsd http://www.liquibase.org/xml/ns/dbchangelog-ext http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-ext.xsd");
            transformerHandler.startElement("http://www.liquibase.org/xml/ns/dbchangelog", "", "databaseChangeLog", attrdatabaseChangeLog);
            AttributesImpl attrchangeset = new AttributesImpl();
            attrchangeset.addAttribute("", "", "id", "", "JailerExport");
            attrchangeset.addAttribute("", "", "author", "", System.getProperty("user.name"));
            transformerHandler.startElement("", "", "changeSet", attrchangeset);
        } else {
            result = CommandLineParser.getInstance().uTF8 ? new OutputStreamWriter(outputStream, charset) : new OutputStreamWriter(outputStream);
            result.append(this.commentHeader);
            for (ScriptEnhancer enhancer : Configuration.getScriptEnhancer()) {
                enhancer.addComments(result, scriptType, session, this.entityGraph, progress);
            }
            for (ScriptEnhancer enhancer : Configuration.getScriptEnhancer()) {
                enhancer.addProlog(result, scriptType, session, this.entityGraph, progress);
            }
        }
        Set<Table> dependentTables = this.writeEntitiesOfIndependentTables(result, transformerHandler, scriptType, progress, sqlScriptFile);
        _log.info("cyclic dependencies for: " + Jailer.asString(dependentTables));
        if (!CommandLineParser.getInstance().noSorting) {
            this.addDependencies(dependentTables, false);
            this.runstats(session, true);
            this.removeSingleRowCycles(progress, session);
        } else {
            _log.warn("skipping topological sorting");
        }
        final TransformerHandler fTransformerHandler = transformerHandler;
        final OutputStreamWriter fResult = result;
        if (scriptType == ScriptType.INSERT && (ScriptFormat.DBUNIT_FLAT_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat()) || ScriptFormat.LIQUIBASE_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat()))) {
            HashSet<Table> remaining = new HashSet<Table>(dependentTables);
            HashSet<Association> relevantAssociations = new HashSet<Association>(this.datamodel.namedAssociations.values());
            Set<Integer> existingEdges = this.entityGraph.getDistinctDependencyIDs();
            Iterator i = relevantAssociations.iterator();
            while (i.hasNext()) {
                Association association = (Association)i.next();
                if (association.source.equals(association.destination)) {
                    i.remove();
                    continue;
                }
                if (existingEdges.contains(association.getId())) continue;
                if (association.isInsertDestinationBeforeSource()) {
                    _log.info("irrelevant dependency: " + this.datamodel.getDisplayName(association.source) + " -> " + this.datamodel.getDisplayName(association.destination));
                }
                i.remove();
            }
            Set<Table> independentTables = this.datamodel.getIndependentTables(remaining, relevantAssociations);
            rest = this.entityGraph.getSize();
            while (!independentTables.isEmpty()) {
                _log.info("independent tables: " + Jailer.asString(independentTables));
                block9: for (Table independentTable : independentTables) {
                    rest = this.entityGraph.getSize();
                    while (true) {
                        this.entityGraph.markIndependentEntities(independentTable);
                        Session.ResultSetReader reader = this.createResultSetReader(fResult, fTransformerHandler, scriptType, independentTable, sqlScriptFile);
                        this.entityGraph.readMarkedEntities(independentTable, reader, true);
                        this.entityGraph.deleteIndependentEntities(independentTable);
                        long newRest = this.entityGraph.getSize();
                        if (rest == newRest) continue block9;
                        rest = newRest;
                    }
                }
                remaining.removeAll(independentTables);
                independentTables = this.datamodel.getIndependentTables(remaining, relevantAssociations);
            }
        } else {
            rest = this.entityGraph.getSize();
            while (true) {
                for (Table table : dependentTables) {
                    this.entityGraph.markIndependentEntities(table);
                }
                ArrayList<JobManager.Job> jobs = new ArrayList<JobManager.Job>();
                for (final Table table : dependentTables) {
                    jobs.add(new JobManager.Job(){

                        @Override
                        public void run() throws Exception {
                            Session.ResultSetReader reader = Jailer.this.createResultSetReader(fResult, fTransformerHandler, scriptType, table, sqlScriptFile);
                            Jailer.this.entityGraph.readMarkedEntities(table, reader, false);
                        }
                    });
                }
                this.jobManager.executeJobs(jobs);
                for (final Table table : dependentTables) {
                    this.entityGraph.deleteIndependentEntities(table);
                }
                long newRest = this.entityGraph.getSize();
                if (rest == newRest) break;
                rest = newRest;
            }
        }
        if (result != null) {
            for (ScriptEnhancer enhancer : Configuration.getScriptEnhancer()) {
                enhancer.addEpilog(result, scriptType, session, this.entityGraph, progress);
            }
            result.close();
        }
        if (transformerHandler != null) {
            String content = "\n";
            transformerHandler.characters(content.toCharArray(), 0, content.length());
            if (ScriptFormat.LIQUIBASE_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
                transformerHandler.endElement("", "", "changeSet");
                transformerHandler.endElement("", "", "databaseChangeLog");
            } else if (ScriptFormat.DBUNIT_FLAT_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
                transformerHandler.endElement("", "", "dataset");
            }
            transformerHandler.endDocument();
        }
        if (rest > 0L) {
            try {
                new File(sqlScriptFile).renameTo(new File(sqlScriptFile + ".failed"));
            }
            catch (Exception e) {
                _log.warn(e.getMessage());
            }
            Set<Table> cycle = CycleFinder.getCycle(dependentTables);
            String msgTitel = rest + " entities not exported due to cyclic dependencies.\n";
            String msg = msgTitel + (cycle.size() == 1 ? "Table" : "Tables") + " with cyclic dependencies: " + Jailer.asString(cycle);
            _log.error(msg);
            try {
                _log.info("starting cycle analysis...");
                ProgressListenerRegistry.getProgressListener().newStage("cycle error, analysing...", true, false);
                String sMsg = msgTitel + "Paths:\n";
                int i = 0;
                for (CycleFinder.Path path : CycleFinder.findCycle(this.datamodel, cycle)) {
                    ArrayList<Table> pList = new ArrayList<Table>();
                    path.fillPath(pList);
                    sMsg = sMsg + "[ ";
                    boolean ft = true;
                    for (Table t : pList) {
                        if (!ft) {
                            sMsg = sMsg + " -> ";
                        }
                        ft = false;
                        sMsg = sMsg + this.datamodel.getDisplayName(t);
                    }
                    sMsg = sMsg + " ]\n";
                    if (++i <= 30) continue;
                    sMsg = sMsg + "...\n";
                    break;
                }
                msg = sMsg + "\nConsider to disable the option \"sort topologically\" in the Data Export dialog";
            }
            catch (CancellationException e) {
                CancellationHandler.reset(null);
            }
            catch (Throwable t) {
                _log.warn("cycle analysis failed: " + t.getMessage());
            }
            throw new RuntimeException(msg);
        }
        _log.info("file '" + sqlScriptFile + "' written.");
    }

    private void removeSingleRowCycles(Set<Table> progress, Session session) throws Exception {
        for (Table table : progress) {
            boolean hasReflexiveAssociation = false;
            for (Association a : table.associations) {
                if (a.destination != table) continue;
                hasReflexiveAssociation = true;
                break;
            }
            if (!hasReflexiveAssociation) continue;
            this.entityGraph.removeReflexiveDependencies(table);
        }
    }

    public void writeEntitiesAsXml(String xmlFile, Set<Table> progress, final Set<Table> subjects, Session session) throws Exception {
        _log.info("writing file '" + xmlFile + "'...");
        OutputStream outputStream = new FileOutputStream(xmlFile);
        if (xmlFile.toLowerCase().endsWith(".zip") || xmlFile.toLowerCase().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        _log.info("create hierarchy for: " + Jailer.asString(progress));
        this.addDependencies(progress, true);
        this.runstats(session, true);
        this.removeSingleRowCycles(progress, session);
        ArrayList<Table> lexSortedTables = new ArrayList<Table>(progress);
        Collections.sort(lexSortedTables, new Comparator<Table>(){

            @Override
            public int compare(Table t1, Table t2) {
                boolean s1 = subjects.contains(t1);
                boolean s2 = subjects.contains(t2);
                if (s1 && !s2) {
                    return -1;
                }
                if (!s1 && s2) {
                    return 1;
                }
                return Jailer.this.datamodel.getDisplayName(t1).compareTo(Jailer.this.datamodel.getDisplayName(t2));
            }
        });
        ArrayList<Table> sortedTables = new ArrayList<Table>();
        boolean done = false;
        while (!done) {
            done = true;
            for (int step = 1; step <= 2; ++step) {
                for (Table table : lexSortedTables) {
                    boolean depends = false;
                    for (Association association : table.associations) {
                        if (association.destination == table || !association.isInsertDestinationBeforeSource() || !lexSortedTables.contains(association.destination) || step != 1 && (association.getAggregationSchema() != AggregationSchema.NONE || association.reversalAssociation.getAggregationSchema() != AggregationSchema.NONE)) continue;
                        depends = true;
                        break;
                    }
                    if (depends) continue;
                    sortedTables.add(table);
                    done = false;
                }
                if (!done) break;
            }
            lexSortedTables.removeAll(sortedTables);
        }
        if (!lexSortedTables.isEmpty()) {
            _log.warn("remaining tables after sorting: " + PrintUtil.tableSetAsString(new HashSet<Table>(lexSortedTables)));
            sortedTables.addAll(lexSortedTables);
        }
        Set<Table> cyclicAggregatedTables = this.getCyclicAggregatedTables(progress);
        _log.info("cyclic aggregated tables: " + PrintUtil.tableSetAsString(cyclicAggregatedTables));
        Charset charset = Charset.defaultCharset();
        if (CommandLineParser.getInstance().uTF8) {
            charset = Charset.forName("UTF8");
        }
        XmlExportTransformer reader = new XmlExportTransformer(outputStream, this.commentHeader.toString(), this.entityGraph, progress, cyclicAggregatedTables, CommandLineParser.getInstance().xmlRootTag, CommandLineParser.getInstance().xmlDatePattern, CommandLineParser.getInstance().xmlTimeStampPattern, this.entityGraph.getTargetSession(), charset);
        for (Table table : sortedTables) {
            this.entityGraph.markRoots(table);
        }
        for (Table table : sortedTables) {
            _log.info("exporting table " + this.datamodel.getDisplayName(table));
            reader.setTable(table);
            this.entityGraph.readMarkedEntities(table, reader, reader.getTableMapping((Table)table).selectionSchema, reader.getTableMapping((Table)table).originalPKAliasPrefix, true);
        }
        reader.endDocument();
        outputStream.close();
        this.checkCompletenessOfXmlExport(cyclicAggregatedTables);
        _log.info("file '" + xmlFile + "' written.");
    }

    private Set<Table> getCyclicAggregatedTables(Set<Table> progress) {
        HashSet<Table> cyclicAggregatedTables = new HashSet<Table>(progress);
        while (true) {
            HashSet<Table> nonAggregatedTables = new HashSet<Table>();
            for (Table t : cyclicAggregatedTables) {
                boolean isAggregated = false;
                for (Association association : t.associations) {
                    if (association.reversalAssociation.getAggregationSchema() == AggregationSchema.NONE || !cyclicAggregatedTables.contains(association.destination)) continue;
                    isAggregated = true;
                    break;
                }
                if (isAggregated) continue;
                nonAggregatedTables.add(t);
            }
            if (nonAggregatedTables.isEmpty()) break;
            cyclicAggregatedTables.removeAll(nonAggregatedTables);
        }
        return cyclicAggregatedTables;
    }

    private void checkCompletenessOfXmlExport(Set<Table> cyclicAggregatedTables) throws SQLException {
        for (Table table : cyclicAggregatedTables) {
            this.entityGraph.readNonTraversedDependencies(table, new Session.ResultSetReader(){

                @Override
                public void readCurrentRow(ResultSet resultSet) throws SQLException {
                    String message = "Can't export all rows from table '" + resultSet.getString("TO_TYPE") + "' due to cyclic aggregation";
                    throw new RuntimeException(message);
                }

                @Override
                public void close() {
                }
            });
        }
    }

    Set<Table> writeEntitiesOfIndependentTables(final OutputStreamWriter result, final TransformerHandler transformerHandler, final ScriptType scriptType, Set<Table> progress, final String filepath) throws Exception {
        HashSet<Table> tables = new HashSet<Table>(progress);
        Set<Table> independentTables = this.datamodel.getIndependentTables(tables);
        while (!independentTables.isEmpty()) {
            _log.info("independent tables: " + Jailer.asString(independentTables));
            ArrayList<JobManager.Job> jobs = new ArrayList<JobManager.Job>();
            for (final Table independentTable : independentTables) {
                if (ScriptFormat.DBUNIT_FLAT_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat()) || ScriptFormat.LIQUIBASE_XML.equals((Object)CommandLineParser.getInstance().getScriptFormat())) {
                    this.writeEntities(result, transformerHandler, scriptType, independentTable, true, filepath);
                    continue;
                }
                jobs.add(new JobManager.Job(){

                    @Override
                    public void run() throws Exception {
                        Jailer.this.writeEntities(result, transformerHandler, scriptType, independentTable, false, filepath);
                    }
                });
            }
            if (!jobs.isEmpty()) {
                this.jobManager.executeJobs(jobs);
            }
            tables.removeAll(independentTables);
            independentTables = this.datamodel.getIndependentTables(tables);
        }
        return tables;
    }

    public void shutDown() throws SQLException {
        if (!this.isDown) {
            this.jobManager.shutdown();
            this.entityGraph.shutDown();
            this.isDown = true;
        }
    }

    private static String asString(Set<Table> progress) {
        String str = "";
        for (Table table : progress) {
            if (!"".equals(str)) {
                str = str + ", ";
            }
            str = str + table.getName();
        }
        return str;
    }

    private synchronized void runstats(Session session, boolean force) throws Exception {
        if (force || this.lastRunstats == 0L || this.lastRunstats * 2L <= this.entityGraph.getTotalRowcount() && this.entityGraph.getTotalRowcount() > 1000L) {
            this.lastRunstats = this.entityGraph.getTotalRowcount();
            StatisticRenovator statisticRenovator = Configuration.forDbms(session).getStatisticRenovator();
            if (statisticRenovator != null) {
                _log.info("gather statistics after " + this.lastRunstats + " inserted rows...");
                try {
                    statisticRenovator.renew(session);
                }
                catch (Throwable t) {
                    _log.warn("unable to update table statistics: " + t.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        final Thread mainThread = Thread.currentThread();
        Thread shutdownHook = new Thread("shutdown-hook"){

            @Override
            public void run() {
                CancellationHandler.cancel(null);
                try {
                    mainThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            Jailer.jailerMain(args, new StringBuffer());
        }
        catch (Exception e) {
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (Exception e) {}
        }
    }

    public static boolean jailerMain(String[] args, StringBuffer warnings) throws Exception {
        return Jailer.jailerMain(args, warnings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jailerMain(String[] args, StringBuffer warnings, ProgressListener progressListener) throws Exception {
        CancellationHandler.reset(null);
        Session.closeTemporaryTableSession();
        try {
            block40: {
                String command;
                CommandLineParser clp;
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    ProgressListenerRegistry.setProgressListener(progressListener);
                                    if (!CommandLineParser.parse(args, false)) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (Configuration.getDoMinimizeUPK()) {
                                        _log.info("minimize-UPK=" + Configuration.getDoMinimizeUPK());
                                    }
                                    clp = CommandLineParser.getInstance();
                                    command = clp.arguments.get(0);
                                    if (!"create-ddl".equalsIgnoreCase(command) && !"find-association".equalsIgnoreCase(command)) {
                                        _log.info("Jailer 5.0.2");
                                    }
                                    Session.setClassLoaderForJdbcDriver(ClasspathUtil.addJarToClasspath(clp.jdbcjar, clp.jdbcjar2));
                                    if (!"check-domainmodel".equalsIgnoreCase(command)) break block41;
                                    DataModel dataModel = new DataModel();
                                    for (String rm : clp.arguments.subList(1, clp.arguments.size())) {
                                        if (dataModel.getRestrictionModel() == null) {
                                            dataModel.setRestrictionModel(new RestrictionModel(dataModel));
                                        }
                                        dataModel.getRestrictionModel().addRestrictionDefinition(rm, null, new HashMap<String, String>());
                                    }
                                    new DomainModel(dataModel).check();
                                    break block40;
                                }
                                if (!"render-datamodel".equalsIgnoreCase(command)) break block42;
                                if (clp.arguments.size() <= 1) {
                                    CommandLineParser.printUsage();
                                    break block40;
                                } else {
                                    new Jailer(1).renderDataModel(clp.arguments, clp.withClosures, clp.schema);
                                }
                                break block40;
                            }
                            if (!"import".equalsIgnoreCase(command)) break block43;
                            if (clp.arguments.size() != 6) {
                                CommandLineParser.printUsage();
                                break block40;
                            } else {
                                Session session = new Session(clp.arguments.get(2), clp.arguments.get(3), clp.arguments.get(4), clp.arguments.get(5), null, clp.transactional);
                                try {
                                    SqlScriptExecutor.executeScript(clp.arguments.get(1), session, clp.transactional);
                                }
                                finally {
                                    try {
                                        session.shutDown();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        }
                        if (!"print-datamodel".equalsIgnoreCase(command)) break block44;
                        Jailer.printDataModel(clp.arguments, clp.withClosures);
                        break block40;
                    }
                    if (!"export".equalsIgnoreCase(command)) break block45;
                    if (clp.arguments.size() != 6) {
                        CommandLineParser.printUsage();
                        break block40;
                    } else {
                        if (clp.maxNumberOfEntities > 0) {
                            EntityGraph.maxTotalRowcount = clp.maxNumberOfEntities;
                            _log.info("max-rowcount=" + EntityGraph.maxTotalRowcount);
                        }
                        if (clp.exportScriptFileName == null) {
                            System.out.println("missing '-e' option");
                            CommandLineParser.printUsage();
                            break block40;
                        } else {
                            Jailer.export(clp.arguments.get(1), clp.exportScriptFileName, clp.deleteScriptFileName, clp.arguments.get(2), clp.arguments.get(3), clp.arguments.get(4), clp.arguments.get(5), clp.explain, clp.numberOfThreads, clp.getScriptFormat());
                        }
                    }
                    break block40;
                }
                if ("find-association".equalsIgnoreCase(command)) {
                    if (clp.arguments.size() < 3) {
                        CommandLineParser.printUsage();
                    } else {
                        Jailer.findAssociation(clp.arguments.get(1), clp.arguments.get(2), clp.arguments.subList(3, clp.arguments.size()), clp.undirected);
                    }
                } else {
                    if ("create-ddl".equalsIgnoreCase(command)) {
                        if (clp.arguments.size() == 5) {
                            boolean bl = DDLCreator.createDDL(clp.arguments.get(1), clp.arguments.get(2), clp.arguments.get(3), clp.arguments.get(4), clp.getTemporaryTableScope());
                            return bl;
                        }
                        boolean bl = DDLCreator.createDDL(null, null, null, null, clp.getTemporaryTableScope());
                        return bl;
                    }
                    if (!"build-model".equalsIgnoreCase(command)) {
                        CommandLineParser.printUsage();
                        boolean bl = false;
                        return bl;
                    }
                    if (clp.arguments.size() != 5) {
                        CommandLineParser.printUsage();
                    } else {
                        _log.info("Building data model.");
                        ModelBuilder.build(clp.arguments.get(1), clp.arguments.get(2), clp.arguments.get(3), clp.arguments.get(4), clp.schema, warnings);
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (e instanceof CancellationException) {
                _log.warn("cancelled");
                throw e;
            }
            _log.error(e.getMessage(), e);
            System.out.println("Error: " + e.getClass().getName() + ": " + e.getMessage());
            String workingDirectory = System.getProperty("user.dir");
            _log.error("working directory is " + workingDirectory);
            throw e;
        }
        finally {
            ProgressListenerRegistry.setProgressListener(null);
            Session.closeTemporaryTableSession();
        }
    }

    private void renderDataModel(List<String> arguments, boolean withClosures, String schema) throws Exception {
        DataModel dataModel = new DataModel();
        for (String rm : arguments.subList(1, arguments.size())) {
            if (dataModel.getRestrictionModel() == null) {
                dataModel.setRestrictionModel(new RestrictionModel(dataModel));
            }
            dataModel.getRestrictionModel().addRestrictionDefinition(rm, null, new HashMap<String, String>());
        }
        DataModelRenderer renderer = Configuration.getRenderer();
        if (renderer == null) {
            throw new RuntimeException("no renderer found");
        }
        renderer.render(dataModel);
    }

    private static void export(String extractionModelFileName, String scriptFile, String deleteScriptFileName, String driverClassName, String dbUrl, String dbUser, String dbPassword, boolean explain, int threads, ScriptFormat scriptFormat) throws Exception {
        _log.info("exporting '" + extractionModelFileName + "' to '" + scriptFile + "'");
        Session session = new Session(driverClassName, dbUrl, dbUser, dbPassword, CommandLineParser.getInstance().getTemporaryTableScope(), false);
        if (CommandLineParser.getInstance().getTemporaryTableScope() == TemporaryTableScope.SESSION_LOCAL || CommandLineParser.getInstance().getTemporaryTableScope() == TemporaryTableScope.TRANSACTION_LOCAL) {
            DDLCreator.createDDL(session, CommandLineParser.getInstance().getTemporaryTableScope());
        }
        ExtractionModel extractionModel = new ExtractionModel(extractionModelFileName, CommandLineParser.getInstance().getSourceSchemaMapping(), CommandLineParser.getInstance().getParameters());
        _log.info(Configuration.forDbms(session).getSqlDialect());
        EntityGraph entityGraph = CommandLineParser.getInstance().getTemporaryTableScope() == TemporaryTableScope.LOCAL_DATABASE ? LocalEntityGraph.create(extractionModel.dataModel, EntityGraph.createUniqueGraphID(), session) : RemoteEntityGraph.create(extractionModel.dataModel, EntityGraph.createUniqueGraphID(), session, extractionModel.dataModel.getUniversalPrimaryKey(session));
        entityGraph.setExplain(explain);
        Jailer jailer = new Jailer(threads);
        Charset charset = Charset.defaultCharset();
        if (CommandLineParser.getInstance().uTF8) {
            charset = Charset.forName("UTF8");
            jailer.appendCommentHeader("encoding " + charset.name());
            jailer.appendCommentHeader("");
        }
        jailer.appendCommentHeader("generated by Jailer 5.0.2, " + new Date() + " from " + Jailer.getUsername());
        Set<Table> totalProgress = new HashSet<Table>();
        Set<Table> subjects = new HashSet<Table>();
        if (CommandLineParser.getInstance().where != null && CommandLineParser.getInstance().where.trim().length() > 0) {
            extractionModel.condition = CommandLineParser.getInstance().where;
        }
        jailer.appendCommentHeader("");
        String condition = extractionModel.condition != null && !"1=1".equals(extractionModel.condition) ? extractionModel.subject.getName() + " where " + extractionModel.condition : "all rows from " + extractionModel.subject.getName();
        jailer.appendCommentHeader("Extraction Model:  " + condition + " (" + extractionModelFileName + ")");
        if (CommandLineParser.getInstance().noSorting) {
            jailer.appendCommentHeader("                   unsorted");
        }
        jailer.appendCommentHeader("Database:          " + Configuration.forDbms((Session)session).dbms);
        jailer.appendCommentHeader("Database URL:      " + dbUrl);
        jailer.appendCommentHeader("Database User:     " + dbUser);
        jailer.appendCommentHeader("");
        extractionModel.dataModel.checkForPrimaryKey(extractionModel.subject, deleteScriptFileName != null);
        extractionModel.condition = ParameterHandler.assignParameterValues(extractionModel.condition, CommandLineParser.getInstance().getParameters());
        if (!CommandLineParser.getInstance().getParameters().isEmpty()) {
            String suffix = "Parameters:        ";
            for (Map.Entry<String, String> e : CommandLineParser.getInstance().getParameters().entrySet()) {
                jailer.appendCommentHeader(suffix + e.getKey() + " = " + e.getValue());
                suffix = "                   ";
            }
            jailer.appendCommentHeader("");
        }
        EntityGraph graph = entityGraph;
        jailer.setEntityGraph(graph);
        jailer.setDataModel(extractionModel.dataModel);
        EntityGraph exportedEntities = null;
        try {
            jailer.readInitialDataTables(CommandLineParser.getInstance().getSourceSchemaMapping(), extractionModel.subject);
            jailer.runstats(session, false);
            ProgressListenerRegistry.getProgressListener().newStage("collecting rows", false, false);
            Set<Table> progress = jailer.exportInitialData(extractionModel.subject);
            entityGraph.setBirthdayOfSubject(entityGraph.getAge());
            progress.addAll(jailer.export(extractionModel.subject, extractionModel.condition, progress, extractionModel.limit));
            totalProgress.addAll(progress);
            subjects.add(extractionModel.subject);
            if (explain) {
                ProgressListenerRegistry.getProgressListener().newStage("generating explain-log", false, false);
                ExplainTool.explain(entityGraph, jailer.initialDataTables, session);
            }
            totalProgress = jailer.datamodel.normalize(totalProgress);
            subjects = jailer.datamodel.normalize(subjects);
            if (deleteScriptFileName != null) {
                exportedEntities = entityGraph.copy(EntityGraph.createUniqueGraphID(), session);
            }
            ProgressListenerRegistry.getProgressListener().newStage("exporting rows", false, false);
            jailer.setEntityGraph(entityGraph);
            if (ScriptFormat.XML.equals((Object)scriptFormat)) {
                jailer.writeEntitiesAsXml(scriptFile, totalProgress, subjects, session);
            } else {
                jailer.writeEntities(scriptFile, ScriptType.INSERT, totalProgress, session);
            }
            entityGraph.delete();
            if (deleteScriptFileName != null) {
                ProgressListenerRegistry.getProgressListener().newStage("deletion-check", false, false);
                jailer.setEntityGraph(exportedEntities);
                jailer.deleteEntities(subjects, totalProgress, session, CommandLineParser.getInstance().getTabuTables(jailer.datamodel, CommandLineParser.getInstance().getSourceSchemaMapping()));
                ProgressListenerRegistry.getProgressListener().newStage("writing delete-script", false, false);
                jailer.datamodel.transpose();
                jailer.writeEntities(deleteScriptFileName, ScriptType.DELETE, totalProgress, session);
                exportedEntities.delete();
                exportedEntities.shutDown();
                jailer.setEntityGraph(entityGraph);
            }
            entityGraph.close();
        }
        catch (CancellationException e) {
            try {
                _log.info("cleaning up after cancellation...");
                CancellationHandler.reset(null);
                jailer.entityGraph.getSession().rollbackAll();
                jailer.entityGraph.delete();
                if (exportedEntities != null) {
                    if (jailer.entityGraph.getSession().scope == TemporaryTableScope.GLOBAL) {
                        exportedEntities.delete();
                    } else {
                        _log.info("skipping clean up of temporary tables");
                    }
                }
                _log.info("cleaned up");
                entityGraph.close();
                jailer.shutDown();
            }
            catch (Throwable t) {
                _log.warn(t.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            try {
                _log.info("cleaning up...");
                jailer.entityGraph.delete();
                if (exportedEntities != null) {
                    if (jailer.entityGraph.getSession().scope == TemporaryTableScope.GLOBAL) {
                        exportedEntities.delete();
                    } else {
                        _log.info("skipping clean up of temporary tables");
                    }
                }
                entityGraph.close();
                jailer.shutDown();
            }
            catch (Throwable t) {
                _log.warn(t.getMessage());
            }
            throw e;
        }
        jailer.shutDown();
    }

    private static String getUsername() {
        String host = "";
        try {
            host = "@" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return System.getProperty("user.name") + host;
    }

    private void deleteEntities(Set<Table> subjects, Set<Table> allTables, Session session, Set<Table> tabuTables) throws Exception {
        this.appendCommentHeader("");
        this.appendCommentHeader("Tabu-tables: " + PrintUtil.tableSetAsString(tabuTables, "--                 "));
        _log.info("Tabu-tables: " + PrintUtil.tableSetAsString(tabuTables, null));
        final HashMap removedEntities = new HashMap();
        HashSet<Table> dontCheckInitially = new HashSet<Table>();
        for (Table table : allTables) {
            int n = 0;
            boolean check = false;
            for (Association a : table.associations) {
                if (a.reversalAssociation.isIgnored()) continue;
                if (tabuTables.contains(a.destination)) {
                    check = true;
                    continue;
                }
                if (a.reversalAssociation.getCardinality() == Cardinality.ONE_TO_MANY || a.reversalAssociation.getCardinality() == Cardinality.ONE_TO_ONE) {
                    ++n;
                    continue;
                }
                check = true;
            }
            if (check || n != true) continue;
            dontCheckInitially.add(table);
        }
        for (Table tabuTable : tabuTables) {
            long rc = this.entityGraph.deleteEntities(tabuTable);
            _log.info("excluded " + rc + " entities from " + this.datamodel.getDisplayName(tabuTable) + " (tabu)");
            allTables.remove(tabuTable);
        }
        HashSet<Table> emptyTables = new HashSet<Table>();
        HashSet<Table> tablesToCheck = new HashSet<Table>(allTables);
        _log.info("don't check initially: " + PrintUtil.tableSetAsString(dontCheckInitially, null));
        tablesToCheck.removeAll(dontCheckInitially);
        boolean firstStep = true;
        while (!tablesToCheck.isEmpty()) {
            _log.info("tables to check: " + PrintUtil.tableSetAsString(tablesToCheck, null));
            ArrayList<JobManager.Job> jobs = new ArrayList<JobManager.Job>();
            final HashSet tablesToCheckNextTime = new HashSet();
            for (final Table table : tablesToCheck) {
                for (final Association a : table.associations) {
                    if (emptyTables.contains(table) || a.reversalAssociation.isIgnored()) continue;
                    if (this.entityGraph.countEntities(table) == 0L) {
                        emptyTables.add(table);
                        continue;
                    }
                    final boolean isFirstStep = firstStep;
                    jobs.add(new JobManager.Job(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() throws Exception {
                            long rc = Jailer.this.entityGraph.removeAssociatedDestinations(a.reversalAssociation, !isFirstStep);
                            if (rc > 0L) {
                                Map map = removedEntities;
                                synchronized (map) {
                                    Long oldRc = (Long)removedEntities.get(table);
                                    removedEntities.put(table, rc + (oldRc == null ? 0L : oldRc));
                                    _log.info("excluded " + rc + " entities from " + Jailer.this.datamodel.getDisplayName(table) + " referenced by " + a);
                                    for (Association a2 : table.associations) {
                                        tablesToCheckNextTime.add(a2.destination);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            this.jobManager.executeJobs(jobs);
            tablesToCheck = tablesToCheckNextTime;
            tablesToCheck.retainAll(allTables);
            firstStep = false;
        }
        _log.info("entities to delete:");
        this.appendCommentHeader("");
        boolean firstLine = true;
        for (String line : this.entityGraph.getStatistics(this.datamodel, removedEntities.keySet())) {
            Long re;
            if (!firstLine && (re = (Long)removedEntities.get(this.datamodel.getTable(line.split(" ")[0]))) != null && re != 0L) {
                line = line + " (-" + re + ")";
            }
            _log.info(line);
            String l = (firstLine ? "Deleted Entities: " : "     ") + line;
            this.appendCommentHeader(l);
            if (firstLine) {
                this.appendCommentHeader("");
            }
            firstLine = false;
        }
        this.appendCommentHeader("");
    }

    private static void findAssociation(String from, String to, List<String> restModels, boolean undirected) throws Exception {
        DataModel dataModel = new DataModel();
        for (String rm : restModels) {
            if (dataModel.getRestrictionModel() == null) {
                dataModel.setRestrictionModel(new RestrictionModel(dataModel));
            }
            dataModel.getRestrictionModel().addRestrictionDefinition(rm, null, new HashMap<String, String>());
        }
        Table source = dataModel.getTable(from);
        if (source == null) {
            throw new RuntimeException("unknown table: '" + from);
        }
        Table destination = dataModel.getTable(to);
        if (destination == null) {
            throw new RuntimeException("unknown table: '" + to);
        }
        Set<Table> tablesToIgnore = CommandLineParser.getInstance().getTabuTables(dataModel, null);
        if (!tablesToIgnore.isEmpty()) {
            System.out.println("ignoring: " + PrintUtil.tableSetAsString(tablesToIgnore));
        }
        System.out.println();
        System.out.println("Shortest path from " + source.getName() + " to " + destination.getName() + ":");
        HashMap<Table, Table> successor = new HashMap<Table, Table>();
        HashMap<Table, Association> outgoingAssociation = new HashMap<Table, Association>();
        ArrayList<Table> agenda = new ArrayList<Table>();
        agenda.add(destination);
        block1: while (!agenda.isEmpty()) {
            Table table = (Table)agenda.remove(0);
            for (Association association : Jailer.incomingAssociations(table, undirected)) {
                if (tablesToIgnore.contains(association.source) || successor.containsKey(association.source)) continue;
                successor.put(association.source, table);
                outgoingAssociation.put(association.source, association);
                agenda.add(association.source);
                if (!association.source.equals(source)) continue;
                agenda.clear();
                continue block1;
            }
        }
        if (successor.containsKey(source)) {
            String joinedSelect = "Select * From " + source.getName();
            System.out.println("    " + source.getName());
            Table table = source;
            while (!table.equals(destination)) {
                Association association;
                association = (Association)outgoingAssociation.get(table);
                System.out.println("    " + association);
                joinedSelect = joinedSelect + " join " + association.destination.getName() + " on " + (association.reversed ? SqlUtil.replaceAliases(association.getJoinCondition(), association.destination.getName(), association.source.getName()) : SqlUtil.replaceAliases(association.getJoinCondition(), association.source.getName(), association.destination.getName()));
                table = (Table)successor.get(table);
            }
            System.out.println();
            System.out.println();
            System.out.println("SQL query:");
            System.out.println("    " + joinedSelect);
        } else {
            System.out.println("tables are not associated");
        }
    }

    private static void printDataModel(List<String> restrictionModels, boolean printClosures) throws Exception {
        String line;
        DataModel dataModel = new DataModel();
        if (printClosures) {
            DataModel.printClosures = true;
        }
        for (String rm : restrictionModels.subList(1, restrictionModels.size())) {
            if (dataModel.getRestrictionModel() == null) {
                dataModel.setRestrictionModel(new RestrictionModel(dataModel));
            }
            dataModel.getRestrictionModel().addRestrictionDefinition(rm, null, new HashMap<String, String>());
        }
        BufferedReader in = new BufferedReader(new StringReader(dataModel.toString()));
        while ((line = in.readLine()) != null) {
            System.out.println(line);
            CancellationHandler.checkForCancellation(null);
        }
        Jailer.printCycles(dataModel);
        Jailer.printComponents(dataModel);
    }

    private static void printCycles(DataModel dataModel) {
        Set<Table> independentTables;
        HashSet<Table> tables = new HashSet<Table>(dataModel.getTables());
        do {
            independentTables = dataModel.getIndependentTables(tables);
            tables.removeAll(independentTables);
        } while (!independentTables.isEmpty());
        if (tables.isEmpty()) {
            System.out.println("no cyclic dependencies" + Jailer.asString(tables));
        } else {
            System.out.println("tables in dependent-cycle: " + Jailer.asString(tables));
        }
    }

    private static void printComponents(DataModel dataModel) {
        ArrayList<Set<Table>> components = new ArrayList<Set<Table>>();
        HashSet<Table> tables = new HashSet<Table>(dataModel.getTables());
        while (!tables.isEmpty()) {
            Table table = (Table)tables.iterator().next();
            Set<Table> set = table.closure(new HashSet<Table>(), false);
            components.add(set);
            tables.removeAll(set);
        }
        System.out.println(components.size() + " components: ");
        for (Set set : components) {
            System.out.println(PrintUtil.tableSetAsString(set));
        }
    }

    private static Collection<Association> incomingAssociations(Table table, boolean undirected) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association association : table.associations) {
            if (association.reversalAssociation.getJoinCondition() == null && (!undirected || association.getJoinCondition() == null)) continue;
            result.add(association.reversalAssociation);
        }
        return result;
    }

    static {
        InputStream in = Jailer.class.getResourceAsStream("/net/sf/jailer/resource/log4j.properties");
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PropertyConfigurator.configure(p);
        _log = Logger.getLogger(Jailer.class);
    }
}

