/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.entitygraph.EntityGraph;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class ExplainTool {
    private static final Logger _log = Logger.getLogger(ExplainTool.class);

    public static void explain(final EntityGraph graph, Set<Table> tablesToIgnore, final Session session) throws Exception {
        _log.info("generating explain.log...");
        final HashSet<String> namesOfTablesToIgnore = new HashSet<String>();
        for (Table table : tablesToIgnore) {
            namesOfTablesToIgnore.add(table.getName());
        }
        StringBuffer succEqualsE = new StringBuffer();
        for (Column column : graph.getUniversalPrimaryKey().getColumns()) {
            if (succEqualsE.length() > 0) {
                succEqualsE.append(" and ");
            }
            succEqualsE.append("Succ.PRE_" + column.name + "=E." + column.name);
        }
        final FileWriter writer = new FileWriter("explain.log");
        String selectLeafs = "Select type, " + graph.getUniversalPrimaryKey().columnList(null) + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", session) + " E Where E.r_entitygraph=" + graph.graphID + " and not exists (Select * from " + SQLDialect.dmlTableReference("JAILER_ENTITY", session) + " Succ Where Succ.r_entitygraph=" + graph.graphID + " and Succ.PRE_TYPE=E.type and " + succEqualsE + ")";
        session.executeQuery(selectLeafs, (Session.ResultSetReader)new Session.AbstractResultSetReader(){
            Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                String type = resultSet.getString(1);
                ArrayList<String> keys = new ArrayList<String>();
                int i = 2;
                for (Column column : graph.getUniversalPrimaryKey().getColumns()) {
                    keys.add(SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), i++, this.typeCache), session));
                }
                if (!namesOfTablesToIgnore.contains(type)) {
                    try {
                        writer.append(ExplainTool.path(graph, session, type, keys, graph.getDatamodel()));
                        writer.append(".\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        writer.append("\n");
        ArrayList<String> associations = new ArrayList<String>();
        for (Map.Entry<Association, Integer> e : graph.explainIdOfAssociation.entrySet()) {
            String nr = "" + e.getValue();
            while (nr.length() < 5) {
                nr = " " + nr;
            }
            String sourceName = e.getKey().source.getName();
            while (sourceName.length() < 24) {
                sourceName = sourceName + " ";
            }
            associations.add("#" + nr + " " + sourceName + " -> " + e.getKey());
        }
        Collections.sort(associations);
        for (String line : associations) {
            writer.append(line);
            writer.append("\n");
        }
        writer.close();
    }

    private static String path(final EntityGraph graph, final Session session, String type, List<String> keys, DataModel datamodel) throws SQLException {
        String where = "";
        int i = 0;
        for (Column column : graph.getUniversalPrimaryKey().getColumns()) {
            if (where.length() > 0) {
                where = where + " and ";
            }
            String value = keys.get(i++);
            where = where + column.name + (value == null || value.equals("null") ? " is null" : "=" + value);
        }
        String selectPredecessor = "Select PRE_TYPE, association, " + graph.getUniversalPrimaryKey().columnList("PRE_") + " From " + SQLDialect.dmlTableReference("JAILER_ENTITY", session) + " E Where E.r_entitygraph=" + graph.graphID + " and type='" + type + "' and " + where;
        final String[] preType = new String[1];
        final ArrayList<String> preKeys = new ArrayList<String>();
        final Integer[] associationID = new Integer[1];
        session.executeQuery(selectPredecessor, (Session.ResultSetReader)new Session.AbstractResultSetReader(){
            private Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();

            @Override
            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                preType[0] = resultSet.getString(1);
                associationID[0] = resultSet.getInt(2);
                int i = 3;
                for (Column column : graph.getUniversalPrimaryKey().getColumns()) {
                    preKeys.add(SqlUtil.toSql(SqlUtil.getObject(resultSet, this.getMetaData(resultSet), i++, this.typeCache), session));
                }
            }
        });
        String thePath = ExplainTool.entityAsString(type, keys, datamodel);
        if (preType[0] != null) {
            thePath = ExplainTool.path(graph, session, preType[0], preKeys, datamodel) + " --" + associationID[0] + "--> " + thePath;
        }
        return thePath;
    }

    private static String entityAsString(String type, List<String> keys, DataModel datamodel) {
        StringBuffer sb = new StringBuffer(type + "(");
        int i = 0;
        int ki = 0;
        Map<Column, Column> match = datamodel.getUniversalPrimaryKey().match(datamodel.getTable((String)type).primaryKey);
        for (Column column : datamodel.getUniversalPrimaryKey().getColumns()) {
            if (match.get(column) != null) {
                if (i > 0) {
                    sb.append(", ");
                }
                ++i;
                sb.append(keys.get(ki));
            }
            ++ki;
        }
        sb.append(")");
        return sb.toString();
    }
}

