/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer;

import java.io.File;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.DBMS;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.TemporaryTableManager;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.util.PrintUtil;
import net.sf.jailer.util.SqlScriptExecutor;
import net.sf.jailer.util.SqlUtil;

public class DDLCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDDL(String driverClass, String dbUrl, String user, String password, TemporaryTableScope temporaryTableScope) throws Exception {
        Session session = null;
        if (driverClass != null) {
            session = new Session(driverClass, dbUrl, user, password);
        }
        try {
            boolean bl = DDLCreator.createDDL(new DataModel(), session, temporaryTableScope);
            return bl;
        }
        finally {
            if (session != null) {
                try {
                    session.shutDown();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void createDDL(Session localSession, TemporaryTableScope temporaryTableScope) throws Exception {
        DDLCreator.createDDL(new DataModel(), localSession, temporaryTableScope);
    }

    public static boolean createDDL(DataModel datamodel, Session session, TemporaryTableScope temporaryTableScope) throws Exception {
        try {
            return DDLCreator.createDDL(datamodel, session, temporaryTableScope, 0);
        }
        catch (SQLException e) {
            session.reconnect();
            try {
                return DDLCreator.createDDL(datamodel, session, temporaryTableScope, 1);
            }
            catch (SQLException sQLException) {
                session.reconnect();
                return DDLCreator.createDDL(datamodel, session, temporaryTableScope, 2);
            }
        }
    }

    private static boolean createDDL(DataModel dataModel, Session session, TemporaryTableScope temporaryTableScope, int indexType) throws Exception {
        String template = "script" + File.separator + "ddl-template.sql";
        String contraint = session != null && (session.dbms == DBMS.SYBASE || session.dbms == DBMS.MySQL) ? " NULL" : "";
        Map<String, String> typeReplacement = Configuration.forDbms(session).getTypeReplacement();
        String universalPrimaryKey = dataModel.getUniversalPrimaryKey().toSQL(null, contraint, typeReplacement);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("upk", universalPrimaryKey);
        arguments.put("upk-hash", "" + universalPrimaryKey.hashCode());
        arguments.put("pre", dataModel.getUniversalPrimaryKey().toSQL("PRE_", contraint, typeReplacement));
        arguments.put("from", dataModel.getUniversalPrimaryKey().toSQL("FROM_", contraint, typeReplacement));
        arguments.put("to", dataModel.getUniversalPrimaryKey().toSQL("TO_", contraint, typeReplacement));
        arguments.put("version", "5.0.2");
        arguments.put("constraint", contraint);
        TemporaryTableManager tableManager = null;
        if (temporaryTableScope == TemporaryTableScope.SESSION_LOCAL) {
            tableManager = Configuration.forDbms((Session)session).sessionTemporaryTableManager;
        }
        if (temporaryTableScope == TemporaryTableScope.TRANSACTION_LOCAL) {
            tableManager = Configuration.forDbms((Session)session).transactionTemporaryTableManager;
        }
        String tableName = "JAILER_CONFIG";
        if (tableManager != null) {
            tableName = tableManager.getDmlTableReference(tableName);
        }
        arguments.put("config-dml-reference", tableName);
        if (tableManager != null) {
            arguments.put("table-suffix", "_T");
            arguments.put("drop-table", tableManager.getDropTablePrefix());
            arguments.put("create-table", tableManager.getCreateTablePrefix());
            arguments.put("create-table-suffix", tableManager.getCreateTableSuffix());
            arguments.put("create-index", tableManager.getCreateIndexPrefix());
            arguments.put("create-index-suffix", tableManager.getCreateIndexSuffix());
            arguments.put("index-table-prefix", tableManager.getIndexTablePrefix());
        } else {
            arguments.put("table-suffix", "");
            arguments.put("drop-table", "DROP TABLE ");
            arguments.put("create-table", "CREATE TABLE ");
            arguments.put("create-table-suffix", "");
            arguments.put("create-index", "CREATE INDEX ");
            arguments.put("create-index-suffix", "");
            arguments.put("index-table-prefix", "");
        }
        HashMap<String, List<String>> listArguments = new HashMap<String, List<String>>();
        if (indexType == 0) {
            listArguments.put("column-list", Collections.singletonList(", " + dataModel.getUniversalPrimaryKey().columnList(null)));
            listArguments.put("column-list-from", Collections.singletonList(", " + dataModel.getUniversalPrimaryKey().columnList("FROM_")));
            listArguments.put("column-list-to", Collections.singletonList(", " + dataModel.getUniversalPrimaryKey().columnList("TO_")));
        } else if (indexType == 1) {
            ArrayList<String> cl = new ArrayList<String>();
            ArrayList<String> clFrom = new ArrayList<String>();
            ArrayList<String> clTo = new ArrayList<String>();
            for (Column c : dataModel.getUniversalPrimaryKey().getColumns()) {
                cl.add(", " + c.name);
                clFrom.add(", FROM_" + c.name);
                clTo.add(", FROM_" + c.name);
            }
            listArguments.put("column-list", cl);
            listArguments.put("column-list-from", clFrom);
            listArguments.put("column-list-to", clTo);
        } else {
            listArguments.put("column-list", Collections.singletonList(""));
            listArguments.put("column-list-from", Collections.singletonList(""));
            listArguments.put("column-list-to", Collections.singletonList(""));
        }
        String ddl = PrintUtil.applyTemplate(template, arguments, listArguments);
        if (session != null) {
            File tmp = CommandLineParser.getInstance().newFile("jailer_ddl.sql");
            PrintWriter pw = new PrintWriter(tmp);
            pw.println(ddl);
            pw.close();
            SqlScriptExecutor.executeScript(tmp.getCanonicalPath(), session);
        }
        System.out.println(ddl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUptodate(String driverClass, String dbUrl, String user, String password) {
        block9: {
            boolean bl;
            if (driverClass == null) break block9;
            final Session session = new Session(driverClass, dbUrl, user, password);
            try {
                final boolean[] uptodate = new boolean[]{false};
                final DataModel datamodel = new DataModel();
                final Map<String, String> typeReplacement = Configuration.forDbms(session).getTypeReplacement();
                session.executeQuery("Select jvalue from JAILER_CONFIG where jversion='5.0.2' and jkey='upk'", new Session.ResultSetReader(){

                    @Override
                    public void readCurrentRow(ResultSet resultSet) throws SQLException {
                        String contraint = session.dbms == DBMS.SYBASE ? " NULL" : "";
                        String universalPrimaryKey = datamodel.getUniversalPrimaryKey().toSQL(null, contraint, typeReplacement);
                        uptodate[0] = resultSet.getString(1).equals("" + universalPrimaryKey.hashCode());
                    }

                    @Override
                    public void close() {
                    }
                });
                for (String table : SqlUtil.JAILER_MH_TABLES) {
                    session.executeQuery("Select * from " + table + " Where 1=0", new Session.ResultSetReader(){

                        @Override
                        public void readCurrentRow(ResultSet resultSet) throws SQLException {
                        }

                        @Override
                        public void close() {
                        }
                    });
                }
                bl = uptodate[0];
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        session.shutDown();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                session.shutDown();
                return bl2;
            }
            session.shutDown();
            return bl;
        }
        return false;
    }

    public static boolean isPresent(Session session) {
        try {
            final boolean[] uptodate = new boolean[]{false};
            session.executeQuery("Select jvalue from JAILER_CONFIG where jkey='upk'", new Session.ResultSetReader(){

                @Override
                public void readCurrentRow(ResultSet resultSet) throws SQLException {
                    uptodate[0] = true;
                }

                @Override
                public void close() {
                }
            });
            return uptodate[0];
        }
        catch (Exception e) {
            try {
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    public static String getTableInConflict(String driverClass, String dbUrl, String user, String password) {
        try {
            if (driverClass != null) {
                Session session = new Session(driverClass, dbUrl, user, password);
                session.setSilent(true);
                try {
                    final boolean[] uptodate = new boolean[]{false};
                    session.executeQuery("Select jvalue from JAILER_CONFIG where jkey='magic' and jvalue='837065098274756382534403654245288'", new Session.ResultSetReader(){

                        @Override
                        public void readCurrentRow(ResultSet resultSet) throws SQLException {
                            uptodate[0] = true;
                        }

                        @Override
                        public void close() {
                        }
                    });
                    if (uptodate[0]) {
                        return null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (String table : SqlUtil.JAILER_TABLES) {
                    try {
                        session.executeQuery("Select * from " + table + " Where 1=0", new Session.ResultSetReader(){

                            @Override
                            public void readCurrentRow(ResultSet resultSet) throws SQLException {
                            }

                            @Override
                            public void close() {
                            }
                        });
                        session.shutDown();
                        return table;
                    }
                    catch (Exception e) {
                    }
                }
                session.shutDown();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

