/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.SQLDialect;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.StatisticRenovator;
import net.sf.jailer.database.TemporaryTableManager;
import net.sf.jailer.enhancer.ScriptEnhancer;
import net.sf.jailer.modelbuilder.ModelElementFinder;
import net.sf.jailer.render.DataModelRenderer;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Configuration {
    private static List<ScriptEnhancer> theScriptEnhancer;
    private static DataModelRenderer theRenderer;
    private String urlPattern;
    private StatisticRenovator statisticRenovator;
    private Map<String, String> typeReplacement;
    private Map<String, String> stringLiteralEscapeSequences;
    private String sqlLimitSuffix;
    private Integer varcharLengthLimit = null;
    private Map<Character, String> charToEscapeSequence = new HashMap<Character, String>();
    private char[] keysOfCharToEscapeSequence;
    private String ncharPrefix;
    public Set<String> exportBlocks;
    private boolean identityInserts;
    public SimpleDateFormat dateFormat;
    public char nanoSep;
    public boolean appendNanosToTimestamp;
    public boolean appendMillisToTimestamp;
    public boolean useToTimestampFunction;
    public DateFormat timestampFormat;
    public String emptyCLOBValue;
    public String emptyBLOBValue;
    public String binaryPattern;
    public boolean avoidLeftJoin;
    public String timestampPattern;
    public String dbms;
    public SQLDialect sqlDialect;
    public TemporaryTableManager sessionTemporaryTableManager;
    public TemporaryTableManager transactionTemporaryTableManager;
    private static final Configuration defaultConfiguration;
    private static boolean doMinimizeUPK;
    public static Object localEntityGraphConfiguration;
    private static String nullColumnPlaceholder;
    private static AbstractXmlApplicationContext theApplicationContext;
    private static Map<String, Configuration> perUrl;

    public Configuration() {
        this.charToEscapeSequence.put(Character.valueOf('\''), "''");
        this.keysOfCharToEscapeSequence = new char[]{'\''};
        this.ncharPrefix = null;
        this.exportBlocks = new HashSet<String>();
        this.identityInserts = false;
        this.dateFormat = null;
        this.nanoSep = (char)46;
        this.appendNanosToTimestamp = true;
        this.appendMillisToTimestamp = false;
        this.useToTimestampFunction = false;
        this.timestampFormat = null;
        this.emptyCLOBValue = null;
        this.emptyBLOBValue = null;
        this.binaryPattern = "x'%s'";
        this.avoidLeftJoin = false;
        this.timestampPattern = null;
        this.dbms = "Unknown";
        this.sqlDialect = new SQLDialect();
        this.sessionTemporaryTableManager = null;
        this.transactionTemporaryTableManager = null;
    }

    public String getDbms() {
        return this.dbms;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public static String getNullColumnPlaceholder() {
        return nullColumnPlaceholder;
    }

    public static boolean getDoMinimizeUPK() {
        Configuration.getContext();
        return doMinimizeUPK;
    }

    public static List<ModelElementFinder> getModelElementFinder() throws Exception {
        List modelElementFinder = (List)Configuration.getContext().getBean("model-finder");
        return modelElementFinder;
    }

    private static synchronized AbstractXmlApplicationContext getContext() {
        if (theApplicationContext == null) {
            String configFile = "jailer.xml";
            if (CommandLineParser.getInstance().getWorkingfolder() != null) {
                configFile = "file:" + CommandLineParser.getInstance().newFile(configFile).getAbsolutePath();
            }
            theApplicationContext = new FileSystemXmlApplicationContext(configFile);
            doMinimizeUPK = Boolean.TRUE.equals(theApplicationContext.getBean("minimize-UPK"));
            theScriptEnhancer = (List)theApplicationContext.getBean("script-enhancer");
            theRenderer = (DataModelRenderer)theApplicationContext.getBean("renderer");
            if (theApplicationContext.containsBean("null-column-placeholder")) {
                nullColumnPlaceholder = (String)theApplicationContext.getBean("null-column-placeholder");
            }
            if (theApplicationContext.containsBean("local-entity-graph")) {
                localEntityGraphConfiguration = theApplicationContext.getBean("local-entity-graph");
            }
        }
        return theApplicationContext;
    }

    public static synchronized Configuration forDbms(Session session) {
        if (session == null) {
            return defaultConfiguration;
        }
        if (perUrl.containsKey(session.dbUrl)) {
            return perUrl.get(session.dbUrl);
        }
        if (Configuration.getContext().containsBean("dbms-configuration")) {
            List cs = (List)Configuration.getContext().getBean("dbms-configuration");
            for (Configuration c : cs) {
                if (!Pattern.matches(c.urlPattern, session.dbUrl)) continue;
                perUrl.put(session.dbUrl, c);
                return c;
            }
        }
        perUrl.put(session.dbUrl, defaultConfiguration);
        return defaultConfiguration;
    }

    public void setExportBlocks(Set<String> exportBlocks) {
        this.exportBlocks = exportBlocks;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public StatisticRenovator getStatisticRenovator() {
        return this.statisticRenovator;
    }

    public void setStatisticRenovator(StatisticRenovator statisticRenovator) {
        this.statisticRenovator = statisticRenovator;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNanoSep(char nanoSep) {
        this.nanoSep = nanoSep;
    }

    public void setAppendNanosToTimestamp(boolean appendNanosToTimestamp) {
        this.appendNanosToTimestamp = appendNanosToTimestamp;
    }

    public void setAppendMillisToTimestamp(boolean appendMillisToTimestamp) {
        this.appendMillisToTimestamp = appendMillisToTimestamp;
    }

    public void setUseToTimestampFunction(boolean useToTimestampFunction) {
        this.useToTimestampFunction = useToTimestampFunction;
    }

    public void setTimestampFormat(DateFormat timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public void setEmptyCLOBValue(String emptyCLOBValue) {
        this.emptyCLOBValue = emptyCLOBValue;
    }

    public void setEmptyBLOBValue(String emptyBLOBValue) {
        this.emptyBLOBValue = emptyBLOBValue;
    }

    public void setBinaryPattern(String binaryPattern) {
        this.binaryPattern = binaryPattern;
    }

    public void setTypeReplacement(Map<String, String> tr) {
        this.typeReplacement = tr;
    }

    public Map<String, String> getTypeReplacement() {
        return this.typeReplacement;
    }

    public void setSessionTemporaryTableManager(TemporaryTableManager tableManager) {
        this.sessionTemporaryTableManager = tableManager;
    }

    public void setTransactionTemporaryTableManager(TemporaryTableManager tableManager) {
        this.transactionTemporaryTableManager = tableManager;
    }

    public static List<ScriptEnhancer> getScriptEnhancer() {
        Configuration.getContext();
        return theScriptEnhancer;
    }

    public static DataModelRenderer getRenderer() {
        Configuration.getContext();
        return theRenderer;
    }

    public boolean isIdentityInserts() {
        return this.identityInserts;
    }

    public void setIdentityInserts(boolean identityInserts) {
        this.identityInserts = identityInserts;
    }

    public void setStringLiteralEscapeSequences(Map<String, String> stringLiteralEscapeSequences) {
        this.stringLiteralEscapeSequences = stringLiteralEscapeSequences;
        try {
            for (Map.Entry<String, String> e : stringLiteralEscapeSequences.entrySet()) {
                if (e.getKey().startsWith("\\")) {
                    int n;
                    char c2 = e.getKey().charAt(1);
                    if (Character.isDigit(c2)) {
                        n = (char)Integer.parseInt(e.getKey().substring(1));
                    } else if (c2 == '\\') {
                        n = 92;
                    } else if (c2 == 'b') {
                        n = 8;
                    } else if (c2 == 'n') {
                        n = 10;
                    } else if (c2 == 't') {
                        n = 9;
                    } else if (c2 == 'r') {
                        n = 13;
                    } else {
                        throw new RuntimeException("illegal escape sequence: " + e.getKey());
                    }
                    this.charToEscapeSequence.put(Character.valueOf((char)n), e.getValue());
                    continue;
                }
                this.charToEscapeSequence.put(Character.valueOf(e.getKey().charAt(0)), e.getValue());
            }
            this.keysOfCharToEscapeSequence = new char[this.charToEscapeSequence.keySet().size()];
            int i = 0;
            for (char c : this.charToEscapeSequence.keySet()) {
                this.keysOfCharToEscapeSequence[i++] = c;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cannot recognize key of stringLiteralEscapeSequences-entry", e);
        }
    }

    public Map<String, String> getStringLiteralEscapeSequences() {
        return this.stringLiteralEscapeSequences;
    }

    public String convertToStringLiteral(String string) {
        boolean esc = false;
        for (char c : this.keysOfCharToEscapeSequence) {
            if (string.indexOf(c) < 0) continue;
            esc = true;
            break;
        }
        if (!esc) {
            return string;
        }
        StringBuilder qvalue = new StringBuilder();
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            char c;
            c = string.charAt(i);
            String es = this.charToEscapeSequence.get(Character.valueOf(c));
            if (es != null) {
                qvalue.append(es);
                continue;
            }
            qvalue.append(c);
        }
        return qvalue.toString();
    }

    public boolean isAvoidLeftJoin() {
        return this.avoidLeftJoin;
    }

    public void setAvoidLeftJoin(boolean avoidLeftJoin) {
        this.avoidLeftJoin = avoidLeftJoin;
    }

    public void setSqlLimitSuffix(String sqlLimitSuffix) {
        this.sqlLimitSuffix = sqlLimitSuffix;
    }

    public String getSqlLimitSuffix() {
        return this.sqlLimitSuffix;
    }

    public Integer getVarcharLengthLimit() {
        return this.varcharLengthLimit;
    }

    public void setVarcharLengthLimit(Integer varcharLengthLimit) {
        this.varcharLengthLimit = varcharLengthLimit;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public String getNcharPrefix() {
        return this.ncharPrefix;
    }

    public void setNcharPrefix(String ncharPrefix) {
        this.ncharPrefix = ncharPrefix;
    }

    static {
        defaultConfiguration = new Configuration();
        doMinimizeUPK = false;
        nullColumnPlaceholder = null;
        theApplicationContext = null;
        perUrl = new HashMap<String, Configuration>();
    }
}

