﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using Verse;
using Harmony;
using System.Reflection;

namespace ExpandedIncidents.Harmony
{
    [HarmonyPatch(typeof(RimWorld.Pawn_Ownership), "Notify_ChangedGuestStatus")]
    public static class Notify_ChangedGuestStatusPatch
    {
        [HarmonyPostfix]
        public static void MakePotentialSaboteur(RimWorld.Pawn_Ownership __instance)
        {
            Pawn pawn = Traverse.Create(__instance).Field("pawn").GetValue<Pawn>();
            if (pawn != null && Traverse.Create(pawn).Property("IsColonist").GetValue<bool>() && !pawn.health.hediffSet.HasHediff(HediffDefOfIncidents.PotentialSaboteur) && Rand.Value < 0.25f)
            {
                Hediff potentialSaboteur = HediffMaker.MakeHediff(HediffDefOfIncidents.PotentialSaboteur, pawn);
                pawn.health.AddHediff(potentialSaboteur);
            }
        }
    }
}
