﻿using RimWorld;      // RimWorld specific functions are found here
using System;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;   // Always needed
using Verse;         // RimWorld universal objects are here
using Verse.Sound;

namespace FoodTypeDispenser
{
    [StaticConstructorOnStartup]

    public class GetFood : Building_NutrientPasteDispenser
    {
        public int status = 3;
        Thing foodtype = ThingMaker.MakeThing(ThingDefOf.MealFine, null);

        public override Thing TryDispenseFood()
        {
            if (!CanDispenseNow)
            {
                Log.Error("不能分配。");
                return null;
            }
            int foodCostPerDispense = 10;
            if (status == 1)
            {
                foodCostPerDispense = 6;
            }
            else if (status == 2)
            {
                foodCostPerDispense = 10;
            }
            else if (status == 3)
            {
                foodCostPerDispense = 10;
            }
            else
            {
                foodCostPerDispense = 20;
            }
            int num = 0;
            List<ThingDef> list = new List<ThingDef>();
            while (true)
            {
                Thing thing = FindFeedInAnyHopper();
                if (thing == null)
                {
                    break;
                }
                int num2 = Mathf.Min(thing.stackCount, foodCostPerDispense);
                num += num2;
                list.Add(thing.def);
                thing.SplitOff(num2);
                if (num >= foodCostPerDispense)
                {
                    goto Block_3;
                }
            }
            Log.Error("储料器没有足够的食物。");
            return null;
            Block_3: def.building.soundDispense.PlayOneShot(Position);

            if (status == 1)
            {
                foodtype = ThingMaker.MakeThing(ThingDefOf.MealNutrientPaste, null);
            }
            else if (status == 2)
            {
                foodtype = ThingMaker.MakeThing(ThingDefOf.MealSimple, null);
            }
            else if (status == 3)
            {
                foodtype = ThingMaker.MakeThing(ThingDefOf.MealFine, null);
            }
            else
            {
                foodtype = ThingMaker.MakeThing(ThingDefOf.MealSurvivalPack, null);
            }
            CompIngredients compIngredients = foodtype.TryGetComp<CompIngredients>();
            for (int i = 0; i < list.Count; i++)
            {
                compIngredients.RegisterIngredient(list[i]);
            }
            return foodtype;
        }

        public static Texture2D UI1 = ContentFinder<Texture2D>.Get("UI/Food1", true);
        public static Texture2D UI2 = ContentFinder<Texture2D>.Get("UI/Food2", true);
        public static Texture2D UI3 = ContentFinder<Texture2D>.Get("UI/Food3", true);
        public static Texture2D UI4 = ContentFinder<Texture2D>.Get("UI/Food4", true);

        private void Food1()
        {
            status = 2;
        }
        private void Food2()
        {
            status = 3;
        }
        private void Food3()
        {
            status = 4;
        }
        private void Food4()
        {
            status = 1;
        }

        public override IEnumerable<Gizmo> GetGizmos()
        {

            List<Gizmo> list = new List<Gizmo>();
            Command_Action ChangeFood = new Command_Action();

            if (status == 1)
            {
                ChangeFood.icon = UI1;
                ChangeFood.defaultDesc = "营养膏";
                ChangeFood.defaultLabel = "营养膏";
                ChangeFood.action = new Action(Food1);
            }
            else if (status == 2)
            {
                ChangeFood.icon = UI2;
                ChangeFood.defaultDesc = "简单食物";
                ChangeFood.defaultLabel = "简单食物";
                ChangeFood.action = new Action(Food2);
            }
            else if (status == 3)
            {
                ChangeFood.icon = UI3;
                ChangeFood.defaultDesc = "精致食物";
                ChangeFood.defaultLabel = "精致食物";
                ChangeFood.action = new Action(Food3);
            }
            else
            {
                ChangeFood.icon = UI4;
                ChangeFood.defaultDesc = "生存食品";
                ChangeFood.defaultLabel = "生存食品";
                ChangeFood.action = new Action(Food4);
            }

            ChangeFood.activateSound = SoundDefOf.Click;
            ChangeFood.groupKey = 887767441;
            list.Add(ChangeFood);
            return list.AsEnumerable();
        }

    }

}
