	try(destroydialog Hoha_Camera_HandHeld)catch()


rollout Hoha_Camera_HandHeld "HoHa Camera HandHeld V1.0"
(
		group "Usage" (
			label use1 "This script is to make Handheld effect for your " align:#left
			label use2 "selected Camera. "  align:#left
			label use2a "Handle both Target and Free Camera! "  align:#left
			label use2b "Please send me your feedback / ideas!! "  align:#left
			label use7 "" 
			label use5 "Use at your own risk !!!" 
	)
	
		label lb1 "" 
		pickbutton btPickCam "Pick The Camera!" width:200 height:30
		
		group "Camera Time Ranger " (
			spinner shake_From "From frame: " range:[0,1600,0] align:#left type:#integer scale:1 type:#float across:2
			spinner shake_To "to: " range:[0,1600,100] align:#right type:#integer scale:1
		)
		
		label lb2 "" 
		group "Shaking speed (Keyframe distance) " (
			spinner Rand_low "Random Min: " range:[0,1600,4] align:#left type:#integer scale:1 type:#float across:2
			spinner Rand_high "Max: " range:[0,1600,10] align:#right type:#integer scale:1
		)
		
		label lb3 "" 
		group "Random Camera position (+ - units) " (
			spinner Cam_Pos_x "x: " range:[0,9999,5] align:#left type:#integer scale:1 width:80 type:#float across:3
			spinner Cam_Pos_y "y: " range:[0,9999,5] align:#center type:#integer scale:1 width:80
			spinner Cam_Pos_z "z: " range:[0,9999,10] align:#right type:#integer scale:1 width:80
		)
		
		label lb4 "" 
		group "Random Camera target position (+ - units) " (
			spinner Targ_Pos_x "x: " range:[0,9999,10] align:#left type:#integer scale:1 width:80 type:#float across:3 enabled:false
			spinner Targ_Pos_y "y: " range:[0,9999,10] align:#center type:#integer scale:1 width:80 enabled:false
			spinner Targ_Pos_z "z: " range:[0,9999,15] align:#right type:#integer scale:1 width:80 enabled:false
		)
		
		label lb5 "" 
		group "Random Camera rotation (+ - angle) " (
			spinner Cam_Rot "Random angle: " range:[0,360,8] align:#center type:#integer scale:1 
		)
		
		label lb6 "" 
		button Shake_Em "SHAKE!!" width:200 height:50
		button Remove_key "Remove ALL keys from the camera!" width:200 height:30
		
		group "About" (
		label lbl1 "HoHa" align:#center
		label lbl2 "www.hohadesign.com/" 
		label lbl3 "superhoha@gmail.com" 
		label lbl4 "" 
	)
	
		global ShakeCam
	
		on btPickCam picked obj do
		(
			ShakeCam = obj
			btPickCam.caption = ShakeCam.name
			if ShakeCam.type == #target then 
				(
					Targ_Pos_x.enabled=true
					Targ_Pos_y.enabled=true
					Targ_Pos_z.enabled=true
				)
			if ShakeCam.type == #free then 
				(
					Targ_Pos_x.enabled=false
					Targ_Pos_y.enabled=false
					Targ_Pos_z.enabled=false
				)
		)

		on Shake_Em pressed do
		(
			sFrom = shake_From.value
			sTo = shake_To.value
			rLow = Rand_low.value
			rHigh = Rand_high.value
			CamPx = Cam_Pos_x.value
			CamPy = Cam_Pos_y.value
			CamPz = Cam_Pos_z.value
			TargPx = Targ_Pos_x.value 
			TargPy = Targ_Pos_y.value 
			TargPz = Targ_Pos_z.value 
			CamRot = Cam_Rot.value
			
			undo on
				(
					set animate on
						
					at time sFrom
					(
						ShakeCam.position.z += 0
						ShakeCam.position.y += 0
						ShakeCam.position.x += 0
						rotate ShakeCam (angleaxis 0 [0,0,0])
						if ShakeCam.type == #target then 
							(
								ShakeCam.Target.position.z += 0
								ShakeCam.Target.position.y += 0
								ShakeCam.Target.position.x += 0
							)
					)
					
					sFromPlus = sFrom + (random rLow rHigh)
					
					for i = sFromPlus to  sTo by (random rLow rHigh) do
					(
						at time i
							(
								--in coordsys Shakecam
								ShakeCam.position.z += random -CamPz CamPz
								ShakeCam.position.y += random -CamPy CamPy
								ShakeCam.position.x += random -CamPx CamPx  		
								if ShakeCam.type == #target then 
									(
										ShakeCam.Target.position.z += random -TargPz TargPz    
										ShakeCam.Target.position.y += random -TargPy TargPy
										ShakeCam.Target.position.x += random -TargPx TargPx    		
									)
							)
						
					)

					for i = sFromPlus to sTo by  (random rLow rHigh)   do
					(
						at time i
							(
								rotate ShakeCam (angleaxis 0 [0,0,1])
								rotate ShakeCam (angleaxis (random -CamRot CamRot) [0,0,1])
							)
					)	
	


					set animate off

				)--end Undo
		
		)--end Shake-em pressed
		
		on Remove_key pressed do
		(
			undo on
				(
					sliderTime = shake_From.value
					deleteKeys ShakeCam #allKeys
					if ShakeCam.type == #target then
					(
						deleteKeys ShakeCam.target #allKeys
					)
				)
			
		)--end Remove_key pressed 
	
)--end rollout
createDialog Hoha_Camera_HandHeld 280 700