uniform sampler2D texUnit0;
uniform sampler2D texUnit1;
uniform float randValue;
uniform int randMax;
uniform int randStep;
uniform int randBias;
uniform int vertexColor;
uniform int fogMode;

void main()
{
   // ambient/diffuse/specular operations
   vec3 l=gl_TexCoord[1].xyz;
   vec3 h=gl_TexCoord[2].xyz;
   vec3 n=gl_TexCoord[3].xyz;
   vec4 ambient=gl_FrontLightModelProduct.sceneColor+gl_FrontLightProduct[0].ambient;
   vec4 diffuse=max(dot(l, n), 0.0)*gl_FrontLightProduct[0].diffuse;
   vec4 specular=pow(max(dot(h, n), 0.0), gl_FrontMaterial.shininess)*gl_FrontLightProduct[0].specular;
   // vertex color operations
   if(vertexColor==1)
   {
      diffuse*=gl_TexCoord[4];
      ambient*=gl_TexCoord[4];
   }
   // base textures operations
   vec4 tex0=texture2D(texUnit0, gl_TexCoord[0].xy);
   // lighting operations
   float texr=tex0[int(randValue*randMax)*randStep+randBias];
   vec4 tex1=texture2D(texUnit1, vec2(texr, 0.0));
   
   vec4 color=tex1*(ambient+diffuse)+specular;
   // alpha/transparency operations
   color.a=gl_FrontMaterial.diffuse.a;

   // fog operations
   /*if(fogMode>0)
   {
      // find fog
      float fog=1.0;
      if (fogMode==1) //LINEAR
      fog=clamp((gl_Fog.end-gl_TexCoord[0].w)*gl_Fog.scale, 0.0, 1.0);
      else
      if (fogMode==2) //EXP
      fog=clamp(exp2(-gl_Fog.density*gl_TexCoord[0].w*1.442695), 0.0, 1.0);
      else
      if (fogMode==3) //EXP2
      fog=clamp(exp2(-pow(gl_Fog.density*gl_TexCoord[0].w, 2.0)*1.442695), 0.0, 1.0);
      color.xyz=mix(gl_Fog.color.xyz, color.xyz, fog).xyz;
   }*/

   // final operation
   gl_FragColor=color;
}