section.begin
   Name = ShowScenarioHelper
   Code : struct.begin
      [*] = ;// _gui_CreateBambooWindow
      [*] = ;//
      [*] = ;function _gui_CreateBambooWindow(const elementName : String; parent : Integer; hAlign, vAlign : Integer; posX, posY, width, height : Integer; bGetUpdate : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   if (width>946) then
      [*] = ;   ErrorLog('_gui_CreatePaperWindow unsupported size iwidth>946');
      [*] = ;   const bordersize = 0;
      [*] = ;   const borderoverlap = 14;
      [*] = ;   const paperborderoverlap = 40;
      [*] = ;   const materialBase = 'bambooframe';
      [*] = ;   var cMaterialBackground : String = gc_gui_material_black;
      [*] = ;   var cMaterialLeft : String = materialBase+'.left';
      [*] = ;   var cMaterialRight : String = materialBase+'.right';
      [*] = ;   var cMaterialTop : String = materialBase+'.top';
      [*] = ;   var cMaterialBottom : String = materialBase+'.bottom';
      [*] = ;   var cMaterialCornerLT : String = materialBase+'.corner_lt';
      [*] = ;   var cMaterialCornerRT : String = materialBase+'.corner_rt';
      [*] = ;   var cMaterialCornerLB : String = materialBase+'.corner_lb';
      [*] = ;   var cMaterialCornerRB : String = materialBase+'.corner_rb';
      [*] = ;
      [*] = ;   // cache width
      [*] = ;   var twBackground : Integer = GetGUITextureWidth(cMaterialBackground);
      [*] = ;   var twLeft : Integer = GetGUITextureWidth(cMaterialLeft);
      [*] = ;   var twRight : Integer = GetGUITextureWidth(cMaterialRight);
      [*] = ;   var twTop : Integer = GetGUITextureWidth(cMaterialTop);
      [*] = ;   var twBottom : Integer = GetGUITextureWidth(cMaterialBottom);
      [*] = ;
      [*] = ;   // cache height
      [*] = ;   var thBackground : Integer = GetGUITextureHeight(cMaterialBackground);
      [*] = ;   var thLeft : Integer = GetGUITextureHeight(cMaterialLeft);
      [*] = ;   var thRight : Integer = GetGUITextureHeight(cMaterialRight);
      [*] = ;   var thTop : Integer = GetGUITextureHeight(cMaterialTop);
      [*] = ;   var thBottom : Integer = GetGUITextureHeight(cMaterialBottom);
      [*] = ;
      [*] = ;   // cache width
      [*] = ;   var twCornerLT : Integer = GetGUITextureWidth(cMaterialCornerLT);
      [*] = ;   var twCornerRT : Integer = GetGUITextureWidth(cMaterialCornerRT);
      [*] = ;   var twCornerLB : Integer = GetGUITextureWidth(cMaterialCornerLB);
      [*] = ;   var twCornerRB : Integer = GetGUITextureWidth(cMaterialCornerRB);
      [*] = ;
      [*] = ;   // cache height
      [*] = ;   var thCornerLT : Integer = GetGUITextureHeight(cMaterialCornerLT);
      [*] = ;   var thCornerRT : Integer = GetGUITextureHeight(cMaterialCornerRT);
      [*] = ;   var thCornerLB : Integer = GetGUITextureHeight(cMaterialCornerLB);
      [*] = ;   var thCornerRB : Integer = GetGUITextureHeight(cMaterialCornerRB);
      [*] = ;
      [*] = ;   if (elementName<>'') and (StrExists(elementName, '.')) then ErrorLog('_gui_Create element name should not have dot char. I this cas.e we are not able to get element handle by name. elmname='+elementName);
      [*] = ;   var iwidth : Integer = width;
      [*] = ;   var iheight : Integer = Max(height, 182);
      [*] = ;   var iparent : Integer = parent;
      [*] = ;   if (iparent=0) then iparent := _gui_GetTop;
      [*] = ;
      [*] = ;   var elmWindowHnd : Integer = _gui_CreateParent(elementName, iparent, hAlign, vAlign, posX, posY, iwidth, iheight, bGetUpdate);
      [*] = ;   var elmBgHnd : Integer = _gui_CreateImage('bg', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmLHnd : Integer = _gui_CreateImage('l', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmRHnd : Integer = _gui_CreateImage('r', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmTHnd : Integer = _gui_CreateImage('t', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBHnd : Integer = _gui_CreateImage('b', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBackgroundHnd : Integer = _gui_CreateImage('background', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBlickHnd : Integer = _gui_CreateImage('blick', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   //var elmHeaderHnd : Integer = _gui_CreateImage('head', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;
      [*] = ;   var backgroundWidth : Integer = iwidth-borderoverlap*2;
      [*] = ;   var backgroundHeight : Integer = iheight-borderoverlap*2;
      [*] = ;   var tileW, tileH : Integer;
      [*] = ;   tileW := (backgroundWidth div twBackground);
      [*] = ;   if ((backgroundWidth mod twBackground)>0) then tileW := tileW+1;
      [*] = ;   tileH := (backgroundHeight div thBackground);
      [*] = ;   if ((backgroundHeight mod thBackground)>0) then tileH := tileH+1;
      [*] = ;   var i : Integer;
      [*] = ;   for i:=0 to tileW-1 do
      [*] = ;   begin
      [*] = ;      var tmpX, tmpY : Float;
      [*] = ;      var fscaleX : Float = 1;
      [*] = ;      var fscaleY : Float = 1;
      [*] = ;      var j : Integer;
      [*] = ;      for j:=0 to tileH-1 do
      [*] = ;      begin
      [*] = ;         var elmHnd : Integer = _gui_CreateTileScaleImage('bg_'+IntToStr(i)+'_'+IntToStr(j), elmBgHnd, cMaterialBackground, gc_halParentLeft, gc_valParentTop, borderoverlap+i*twBackground, borderoverlap+j*thBackground, Min(twBackground, (backgroundWidth-i*twBackground)), Min(thBackground, (backgroundHeight-j*thBackground)), bGetUpdate);
      [*] = ;         var elmwidth : Integer = twBackground;
      [*] = ;         if (iwidth<>0) and (iwidth<(elmwidth+i*twBackground)) then
      [*] = ;         fscaleX := (iwidth-i*twBackground)/elmwidth;
      [*] = ;         var elmheight : Integer = thBackground;
      [*] = ;         if (iheight<>0) and (iheight<(elmheight*(iheight div backgroundHeight)+j*thBackground)) then
      [*] = ;         fscaleY := (iheight-j*thBackground)/(elmheight*(iheight div backgroundHeight));
      [*] = ;         if (iwidth<0) then fscaleX := -fscaleX;
      [*] = ;         if (iheight<0) then fscaleY := -fscaleY;
      [*] = ;         SetGUIElementTileScales(elmHnd, fscaleX, fscaleY);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   SetGUIElementAllPositionRect(elmBackgroundHnd, 0, 0, iwidth, iheight);
      [*] = ;
      [*] = ;   var tmpwidth : Integer = (iwidth-twCornerLT-twCornerRT+bordersize*2+borderoverlap*2);
      [*] = ;   var tmpheight : Integer = (iheight-thCornerLT-thCornerRB+bordersize*2+borderoverlap*2);
      [*] = ;   tileW := (tmpwidth div twTop);
      [*] = ;   if ((tmpwidth mod twTop)>0) then tileW := tileW+1;
      [*] = ;   tileH := (tmpheight div thLeft);
      [*] = ;   if ((tmpheight mod thLeft)>0) then tileH := tileH+1;
      [*] = ;   for i:=0 to tileH-1 do
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('l_'+IntToStr(i), elmLHnd, cMaterialLeft, gc_halParentLeft, gc_valParentTop, 0, thCornerLT+i*thLeft-borderoverlap, 0, Min(thLeft, tmpheight-i*thLeft), bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('r_'+IntToStr(i), elmRHnd, cMaterialRight, gc_halParentRightWidth, gc_valParentTop, 0, thCornerRT+i*thRight-borderoverlap, 0, Min(thRight, +tmpheight-i*thRight), bGetUpdate);
      [*] = ;   end;
      [*] = ;   for i:=0 to tileW-1 do
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('t_'+IntToStr(i), elmTHnd, cMaterialTop, gc_halParentLeft, gc_valParentTop, twCornerLT+i*twTop-borderoverlap, 0, Min(twTop, tmpwidth-i*twTop), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('b_'+IntToStr(i), elmBHnd, cMaterialBottom, gc_halParentLeft, gc_valParentBottomHeight, twCornerLB+i*twTop-borderoverlap, 0, Min(twBottom, tmpwidth-i*twBottom), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;   if (iheight>0) then
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('clt', elmBackgroundHnd, cMaterialCornerLT, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, min(twCornerLT, iwidth), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('clb', elmBackgroundHnd, cMaterialCornerLB, gc_halParentLeft, gc_valParentBottomHeight, -bordersize, bordersize, min(twCornerLT, iwidth), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;   if (iwidth>0) then
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('crt', elmBackgroundHnd, cMaterialCornerRT, gc_halParentRightWidth, gc_valParentTop, bordersize, -bordersize, min(twCornerRT, iwidth), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('crb', elmBackgroundHnd, cMaterialCornerRB, gc_halParentRightWidth, gc_valParentBottomHeight, bordersize, bordersize, min(twCornerRT, iwidth), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;
      [*] = ;   var ipaperwidth : Integer = iwidth-paperborderoverlap;
      [*] = ;   var ipaperheight : Integer = iheight-paperborderoverlap;
      [*] = ;   var bShowBlink : Boolean = (Min(ipaperwidth, ipaperheight)>400);
      [*] = ;   _gui_CreatePaperWindow('paperbackground', elmBackgroundHnd, gc_halParentMiddle, gc_valParentMiddle, 0, 0, ipaperwidth, ipaperheight, 1, bShowBlink, bGetUpdate);
      [*] = ;
      [*] = ;   Result := elmWindowHnd;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure FillComboBoxAIs(elmHnd : Integer);
      [*] = ;begin
      [*] = ;   var i : Integer;
      [*] = ;   if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;   begin
      [*] = ;      GUIListBoxAddItem(elmHnd, GetLocaleTableListItemByID('gui', 'difficulty.0'), 0);
      [*] = ;      for i:=1 to gc_MaxAIDifficultyCount do
      [*] = ;      begin
      [*] = ;         var text : String = GetLocaleTableListItemByID('gui', 'difficulty.'+IntToStr(i));
      [*] = ;         GUIListBoxAddItem(elmHnd, text, i);
      [*] = ;      end;
      [*] = ;      SetGUIListBoxItemIndexSilent(elmHnd, 0);
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure FillComboBoxCountries(elmHnd : Integer; bAddRandom : Boolean);
      [*] = ;begin
      [*] = ;   var i : Integer;
      [*] = ;   if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;   begin
      [*] = ;      var csid : String;
      [*] = ;      for i:=0 to gc_MaxCountryCount-1 do
      [*] = ;      if (_country_IsCountryAvailable(i, True, False)) then
      [*] = ;      begin
      [*] = ;         _country_GetSIDByID(i, csid);
      [*] = ;         GUIListBoxAddItem(elmHnd, GetLocaleTableListItemByID(gc_loc_units, csid), i);
      [*] = ;      end;
      [*] = ;      if (bAddRandom) then
      [*] = ;      GUIListBoxAddItem(elmHnd, GetLocaleTableListItemByID('gui', 'text.random'), gc_MaxCountryCount);
      [*] = ;      SetGUIListBoxItemIndexSilent(elmHnd, 0);
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure FillComboBoxTeams(elmHnd : Integer);
      [*] = ;begin
      [*] = ;   var i : Integer;
      [*] = ;   if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;   begin
      [*] = ;      var csid : String;
      [*] = ;      GUIListBoxAddItem(elmHnd, 'x', 0);
      [*] = ;      for i:=1 to gc_MaxPlayerCount-1 do
      [*] = ;      GUIListBoxAddItem(elmHnd, IntToStr(i), i);
      [*] = ;      SetGUIListBoxItemIndexSilent(elmHnd, 0);
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;const bupdate = False;
      [*] = ;const currentstatename = 'ShowScenarioHelper';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;
      [*] = ;var ui : TUI;
      [*] = ;ui.SetContainerMaxWidthType(2);
      [*] = ;ui.fcontainerwidth := Min(1680-80, GetViewerWidth-32-80);
      [*] = ;ui.SetDebug(True);
      [*] = ;const cTagApply = 101;
      [*] = ;const cTagCancel = 102;
      [*] = ;const cTagPreview = 103;
      [*] = ;const cBaseTagList = 10000;
      [*] = ;
      [*] = ;const cTagGroupClear = 110;
      [*] = ;const cTagGroupAddSel = 111;
      [*] = ;const cTagGroupRemoveSel = 112;
      [*] = ;const cTagGroupSetSel = 113;
      [*] = ;const cTagGroupSelectGroupUnits = 114;
      [*] = ;
      [*] = ;var cTextScenarioHelper : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.scenariohelper');
      [*] = ;var cTextApply : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.apply');
      [*] = ;var cTextCancel : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.cancel');
      [*] = ;var cTextPreview : String = 'PREVIEW';
      [*] = ;var cTextMapSettingsFilename : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsfilename');
      [*] = ;var cTextMapSettingsFilenameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsfilenamehint');
      [*] = ;var cTextMapSettingsPreview : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingspreview');
      [*] = ;var cTextMapSettingsPreviewHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingspreviewhint');
      [*] = ;var cTextMapSettingsLangFileName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingslangfilename');
      [*] = ;var cTextMapSettingsLangFileNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingslangfilenamehint');
      [*] = ;var cTextMapSettingsLangTable : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingslangtable');
      [*] = ;var cTextMapSettingsLangTableHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingslangtablehint');
      [*] = ;var cTextMapSettingsName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsname');
      [*] = ;var cTextMapSettingsNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsnamehint');
      [*] = ;var cTextMapSettingsDescription : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsdescription');
      [*] = ;var cTextMapSettingsDescriptionHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsdescriptionhint');
      [*] = ;var cTextMapSettingsScenarioActive : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsscenarioactive');
      [*] = ;var cTextMapSettingsScenarioActiveHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.mapsettingsscenarioactivehint');
      [*] = ;
      [*] = ;var cTextPlayersDifficulty : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersdifficulty');
      [*] = ;var cTextPlayersDifficultyHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersdifficultyhint');
      [*] = ;var cTextPlayersCountry : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playerscountry');
      [*] = ;var cTextPlayersCountryHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playerscountryhint');
      [*] = ;var cTextPlayersTeam : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersteam');
      [*] = ;var cTextPlayersTeamHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersteamhint');
      [*] = ;var cTextPlayersAI : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersai');
      [*] = ;var cTextPlayersAIHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersaihint');
      [*] = ;var cTextPlayerName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playername');
      [*] = ;var cTextPlayerNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playernamehint');
      [*] = ;var cTextPlayersFood : String = 'gui|restype.'+IntToStr(gc_resource_type_food);
      [*] = ;var cTextPlayersWood : String = 'gui|restype.'+IntToStr(gc_resource_type_wood);
      [*] = ;var cTextPlayersStone : String = 'gui|restype.'+IntToStr(gc_resource_type_stone);
      [*] = ;var cTextPlayersGold : String = 'gui|restype.'+IntToStr(gc_resource_type_gold);
      [*] = ;var cTextPlayersIron : String = 'gui|restype.'+IntToStr(gc_resource_type_iron);
      [*] = ;var cTextPlayersCoal : String = 'gui|restype.'+IntToStr(gc_resource_type_coal);
      [*] = ;var cTextPlayersResourceHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.playersresourcehint');
      [*] = ;
      [*] = ;var cTextFlagName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.flagname');
      [*] = ;var cTextFlagNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.flagnamehint');
      [*] = ;var cTextFlagActive : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.flagactive');
      [*] = ;var cTextFlagActiveHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.flagactivehint');
      [*] = ;var cTextCounterName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.countername');
      [*] = ;var cTextCounterNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.counternamehint');
      [*] = ;var cTextCounterValue : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.countervalue');
      [*] = ;var cTextCounterValueHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.countervaluehint');
      [*] = ;
      [*] = ;var cTextTimerName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timername');
      [*] = ;var cTextTimerNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timernamehint');
      [*] = ;var cTextTimerStarted : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerstarted');
      [*] = ;var cTextTimerStartedHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerstartedhint');
      [*] = ;var cTextTimerFinished : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerfinished');
      [*] = ;var cTextTimerFinishedHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerfinishedhint');
      [*] = ;var cTextTimerTime : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timertime');
      [*] = ;var cTextTimerTimeHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timertimehint');
      [*] = ;var cTextTimerStartTime : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerstarttime');
      [*] = ;var cTextTimerStartTimeHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.timerstarttimehint');
      [*] = ;
      [*] = ;var cTextZoneActive : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneactive');
      [*] = ;var cTextZoneActiveHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneactivehint');
      [*] = ;
      [*] = ;var cTextGroupName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupname');
      [*] = ;var cTextGroupNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupnamehint');
      [*] = ;var cTextGroupCount : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupcount');
      [*] = ;var cTextGroupCountHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupcounthint');
      [*] = ;
      [*] = ;var cTextZoneName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonename');
      [*] = ;var cTextZoneNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonenamehint');
      [*] = ;var cTextZonePositionX : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonepositionx');
      [*] = ;var cTextZonePositionXHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonepositionxhint');
      [*] = ;var cTextZonePositionY : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonepositiony');
      [*] = ;var cTextZonePositionYHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonepositionyhint');
      [*] = ;var cTextZoneWidth : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonewidth');
      [*] = ;var cTextZoneWidthHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonewidthhint');
      [*] = ;var cTextZoneHeight : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneheight');
      [*] = ;var cTextZoneHeightHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneheighthint');
      [*] = ;var cTextZoneLinkToGroup : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonelinktogroup');
      [*] = ;var cTextZoneLinkToGroupHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonelinktogrouphint');
      [*] = ;var cTextZoneLinkToGroupID : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonelinktogroupid');
      [*] = ;var cTextZoneLinkToGroupIDHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonelinktogroupidhint');
      [*] = ;var cTextZoneUseAverage : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneuseaverage');
      [*] = ;var cTextZoneUseAverageHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneuseaveragehint');
      [*] = ;var cTextZoneAddRadius : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneaddradius');
      [*] = ;var cTextZoneAddRadiusHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneaddradiushint');
      [*] = ;var cTextZoneNoFilter : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonenofilter');
      [*] = ;var cTextZoneGroupNoLink : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonegroupnolink');
      [*] = ;var cTextZoneOnlyUngroup : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneonlyungroup');
      [*] = ;var cTextZoneOnlyUngroupHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zoneonlyungrouphint');
      [*] = ;var cTextZoneFilterPlayerID : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonefilterplayerid');
      [*] = ;var cTextZoneFilterPlayerIDHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonefilterplayeridhint');
      [*] = ;var cTextZoneFilterGroupID : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonefiltergroupid');
      [*] = ;var cTextZoneFilterGroupIDHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonefiltergroupidhint');
      [*] = ;var cTextZoneCount : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonecount');
      [*] = ;var cTextZoneCountHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.zonecounthint');
      [*] = ;
      [*] = ;var cTextObjectiveName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivename');
      [*] = ;var cTextObjectiveNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivenamehint');
      [*] = ;var cTextObjectiveLangTable : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivelangtable');
      [*] = ;var cTextObjectiveLangTableHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivelangtablehint');
      [*] = ;var cTextObjectiveLangKey : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivelangkey');
      [*] = ;var cTextObjectiveLangKeyHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivelangkeyhint');
      [*] = ;var cTextObjectiveVisible : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivevisible');
      [*] = ;var cTextObjectiveVisibleHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivevisiblehint');
      [*] = ;var cTextObjectiveDone : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivedone');
      [*] = ;var cTextObjectiveDoneHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.objectivedonehint');
      [*] = ;
      [*] = ;var cTextImageName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.imagename');
      [*] = ;var cTextImageNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.imagenamehint');
      [*] = ;var cTextImageMaterial : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.imagematerial');
      [*] = ;var cTextImageMaterialHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.imagematerialhint');
      [*] = ;
      [*] = ;var cTextGroupClear : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupclear');
      [*] = ;var cTextGroupAddSel : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupaddsel');
      [*] = ;var cTextGroupRemoveSel : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupremovesel');
      [*] = ;var cTextGroupSetSel : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupsetsel');
      [*] = ;var cTextGroupSelectGroupUnits : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.groupselectgroupunits');
      [*] = ;
      [*] = ;const cMaxHeight = 523+33+132;
      [*] = ;const cTopRowHeight = 80;
      [*] = ;const cBottomRowHeight = 80;
      [*] = ;const cTopBottomRowHeight = cTopRowHeight+cBottomRowHeight;
      [*] = ;
      [*] = ;var prevparent : Integer = GetGUIElementIndexByNameParent(elmname, _gui_GetTop);
      [*] = ;var elmScrollLayer : Integer = GetGUIElementIndexByNameParent('row02.collist.scrolllayer', prevparent);
      [*] = ;var lastScrollPos : Float;
      [*] = ;if (elmScrollLayer<>0) then
      [*] = ;begin
      [*] = ;   var elmVScroll : Integer = GetGUIElementVScroll(elmScrollLayer);
      [*] = ;   if (elmVScroll<>0) then
      [*] = ;   lastScrollPos := GetGUIScrollBarPosition(elmVScroll);
      [*] = ;end;
      [*] = ;
      [*] = ;var elmParent : Integer = _ui_CreateContainer(ui, elmname, 0, gc_valParentMiddle, 0, cMaxHeight, bupdate);
      [*] = ;SetGUIElementPressState(elmParent, eventstate);
      [*] = ;SetGUIElementUserBlend(_gui_CreateImageActive('', elmParent, gc_gui_material_black, gc_halLeft, gc_valTop, 0, 0, GetViewerWidth, GetViewerHeight, 0, '', '', bupdate), 0.75);
      [*] = ;var elmParentFrame : Integer = _ui_CreateFrame(ui, 'wparent', elmParent, gc_halParentLeft, gc_valParentTop, 0, 0, 0, 0, ui.frame1.fborder, 'cross', 1, bupdate);
      [*] = ;
      [*] = ;var rowTop : Integer = _ui_CreateRow(ui, 'row01', elmParent, gc_valParentTop, 0, cTopRowHeight, bupdate);
      [*] = ;var rowMiddle : Integer = _ui_CreateRow(ui, 'row02', elmParent, gc_valParentTop, cTopRowHeight, cMaxHeight-cTopBottomRowHeight, bupdate);
      [*] = ;var rowBottom : Integer = _ui_CreateRow(ui, 'row03', elmParent, gc_valParentTop, cMaxHeight-cBottomRowHeight, cBottomRowHeight, bupdate);
      [*] = ;
      [*] = ;// top header
      [*] = ;var color : TColor;
      [*] = ;_gui_ConvertHexToTColor('FFFFFF', color);
      [*] = ;var elmTopHeader : Integer = _gui_CreateText('theader', rowTop, cTextScenarioHelper, gc_halParentLeft, gc_valParentTop, 0, 0, GetGUIElementWidth(rowTop), GetGUIElementHeight(rowTop), gc_halMiddle, gc_valMiddle, gc_font_serif_21, color, bupdate);
      [*] = ;
      [*] = ;// bottom buttons
      [*] = ;var cBtnOffset : Integer = ui.btn1.fwidth+12;
      [*] = ;var cBaseOffset : Integer = -(cBtnOffset div 2);
      [*] = ;var nul : String;
      [*] = ;_ui_CreateBtn(ui, 'bapply', rowBottom, 0, cTextApply, gc_halParentMiddle, gc_valParentMiddle, cBaseOffset, 0, 0, 0, eventstate, nul, cTagApply, bupdate);
      [*] = ;_ui_CreateBtn(ui, 'bcancel', rowBottom, 0, cTextCancel, gc_halParentMiddle, gc_valParentMiddle, cBaseOffset+cBtnOffset, 0, 0, 0, eventstate, nul, cTagCancel, bupdate);
      [*] = ;var elm : Integer = _ui_CreateBtn(ui, 'bpreview', rowBottom, 0, cTextPreview, gc_halParentMiddle, gc_valParentMiddle, cBaseOffset+cBtnOffset*2, 0, 0, 0, eventstate, nul, cTagPreview, bupdate);
      [*] = ;SetGUIElementVisible(elm, gScenario.ui.helpertype=gc_scenario_ui_helpertype_queries);
      [*] = ;
      [*] = ;const wpadding = 8;
      [*] = ;const hpadding = 2;
      [*] = ;const cheadframeheight = 40;
      [*] = ;const colsize = 3;
      [*] = ;var leftrowheight : Integer = wpadding*2+31*2+hpadding*6;
      [*] = ;var rightrowheight : Integer = cheadframeheight+ui.frame1.fborder+leftrowheight;
      [*] = ;
      [*] = ;var elmListCol : Integer = _ui_CreateCol(ui, 'collist', rowMiddle, gc_valDefault, 0, 3.2, 30, 0, 0, bupdate);
      [*] = ;var elmList : Integer = _gui_CreateScrollLayer('scrolllayer', elmListCol, gc_halParentLeft, gc_valParentTop, 0, 0, 0, 0, 0, 0, 0, 0, True, bupdate);
      [*] = ;var elmMainCol : Integer = _ui_CreateCol(ui, 'colmain', rowMiddle, gc_valDefault, 3, 12, 30, 0, 0, bupdate);
      [*] = ;var elmMain : Integer = _gui_CreateScrollLayer('scrolllayer', elmMainCol, gc_halParentLeft, gc_valParentTop, 0, 0, 0, 0, 0, 0, 0, 0, True, bupdate);
      [*] = ;
      [*] = ;var ind : Integer;
      [*] = ;
      [*] = ;var randkey : Integer = GetRandomKey;
      [*] = ;SetRandomKey(260); // used in combobox render
      [*] = ;
      [*] = ;procedure CreateLeftPanel(parent : Integer);
      [*] = ;begin
      [*] = ;   var height : Integer;
      [*] = ;   var bScroller : Boolean;
      [*] = ;   var offy : Integer = GetGUITextureHeight('line.31.normal')+2;
      [*] = ;   var offx : Integer = 24;
      [*] = ;   var elmScrollHnd : Integer = GetGUIElementVScroll(parent);
      [*] = ;   SetGUIElementTag(elmScrollHnd, offy);
      [*] = ;   var btnwidth, btnwidthscroll : Integer;
      [*] = ;   var ind : Integer;
      [*] = ;   var i : Integer;
      [*] = ;   procedure CalcBtnWidthBasedOnScroller(parent, count : Integer; var btnwidthscroll, height : Integer; var bScroller : Boolean);
      [*] = ;   begin
      [*] = ;      height := count*offy;
      [*] = ;      bScroller := (height>GetGUIElementHeight(parent));
      [*] = ;      btnwidthscroll := _misc_SwitchInt(0, -1, bScroller);
      [*] = ;   end;
      [*] = ;   case gScenario.ui.helpertype of
      [*] = ;      gc_scenario_ui_helpertype_mapsettings : ;
      [*] = ;      gc_scenario_ui_helpertype_players : begin
      [*] = ;         var count : Integer = gc_MaxPlayerCount;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.players[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedplayerindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_flags : begin
      [*] = ;         var count : Integer = gc_scenario_maxflags;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.flags[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedflagindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_counters : begin
      [*] = ;         var count : Integer = gc_scenario_maxcounters;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.counters[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedcounterindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_timers : begin
      [*] = ;         var count : Integer = gc_scenario_maxtimers;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.timers[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedtimerindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_groups : begin
      [*] = ;         var count : Integer = gc_scenario_maxgroups;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.groups[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedgroupindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_zones : begin
      [*] = ;         var count : Integer = gc_scenario_maxzones;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.zones[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedzoneindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_objectives : begin
      [*] = ;         var count : Integer = gc_scenario_maxobjectives;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.objectives[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedobjectiveindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_queries : begin
      [*] = ;         var count : Integer = gc_scenario_maxqueries;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.queries[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedqueryindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_results : begin
      [*] = ;         var count : Integer = gc_scenario_maxresults;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.results[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedresultindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_images : begin
      [*] = ;         var count : Integer = gc_scenario_maximages;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.images[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedimageindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_resulttriggers : begin
      [*] = ;         log('gc_scenario_ui_helpertype_resulttriggers');
      [*] = ;         var count : Integer = gc_scenario_maxresulttriggers;
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, count, btnwidthscroll, height, bScroller);
      [*] = ;         btnwidth := GetGUIElementWidth(parent)+btnwidthscroll;
      [*] = ;         for i:=0 to count-1 do
      [*] = ;         begin
      [*] = ;            var tag : Integer = cBaseTagList+i;
      [*] = ;            var text : String = IntToStr(i)+' : '+gScenario.resulttriggers[i].name;
      [*] = ;            var elmLineBtn : Integer = _ui_CreateBtn(ui, 'line'+IntToStr(ind), parent, 1, text, gc_halParentLeft, gc_valParentTop, 0, ind*offy, btnwidth, 0, eventstate, nul, tag, bupdate);
      [*] = ;            SetGUIElementChecked(elmLineBtn, (i=gScenario.ui.pickedresulttriggerindex));
      [*] = ;            ind := ind+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   SetGUIScrollEnabled(parent, bScroller);
      [*] = ;   SetGUIElementHeight(parent, height);
      [*] = ;
      [*] = ;   // settings scroller
      [*] = ;   var cMagicNumber : Float = 1/(1-42/GetGUIElementLogicHeight(parent)); // 31 is height of 1 scroll up btn
      [*] = ;   SetGUIScrollBarPosition(elmScrollHnd, _misc_MinFloat(1, lastScrollPos*cMagicNumber));
      [*] = ;end;
      [*] = ;
      [*] = ;procedure CreateRightPanel(parent : Integer);
      [*] = ;begin
      [*] = ;   var width, height : Integer;
      [*] = ;   var bScroller : Boolean;
      [*] = ;   var offy : Integer = GetGUITextureHeight('line.31.normal')+2;
      [*] = ;   procedure CalcBtnWidthBasedOnScroller(parent, count : Integer; var width, height : Integer; var bScroller : Boolean);
      [*] = ;   begin
      [*] = ;      height := count*offy;
      [*] = ;      bScroller := (height>GetGUIElementHeight(parent));
      [*] = ;      width := GetGUIElementWidth(parent);
      [*] = ;      if (bScroller) then
      [*] = ;      width := width-31;
      [*] = ;   end;
      [*] = ;   case gScenario.ui.helpertype of
      [*] = ;      gc_scenario_ui_helpertype_mapsettings : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'filename', cTextMapSettingsFilename, cTextMapSettingsFilenameHint, gScenarioTmp.settings.filename, colsize, eventstate, True, ind, bupdate);
      [*] = ;         //_ui_CreateInputBoxScenario(ui, parent, 'preview', cTextMapSettingsPreview, cTextMapSettingsPreviewHint, gScenarioTmp.settings.preview, colsize, eventstate, True, ind, bupdate);
      [*] = ;         //_ui_CreateInputBoxScenario(ui, parent, 'langfilename', cTextMapSettingsLangFileName, cTextMapSettingsLangFileNameHint, gScenarioTmp.settings.langfilename, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langtable', cTextMapSettingsLangTable, cTextMapSettingsLangTableHint, gScenarioTmp.settings.langtable, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextMapSettingsName, cTextMapSettingsNameHint, gScenarioTmp.settings.name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'description', cTextMapSettingsDescription, cTextMapSettingsDescriptionHint, gScenarioTmp.settings.description, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bactive', cTextMapSettingsScenarioActive, cTextMapSettingsScenarioActiveHint, gScenarioTmp.bactive, colsize, eventstate, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_players : begin
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, 11, width, height, bScroller);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextPlayerName, cTextPlayerNameHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;
      [*] = ;         var elmHnd : Integer = _ui_CreateComboBoxScenario(ui, parent, 'difficulty', cTextPlayersDifficulty, cTextPlayersDifficultyHint, gc_MaxAIDifficultyCount+1, 0, colsize, eventstate, ind, True);
      [*] = ;         FillComboBoxAIs(elmHnd);
      [*] = ;         SetGUIListBoxItemIndexSilent(elmHnd, (gScenarioTmp.players[gScenario.ui.pickedplayerindex].difficulty+1));
      [*] = ;
      [*] = ;         elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'country', cTextPlayersCountry, cTextPlayersCountryHint, gint_maxcountrycountvisible+1, 0, colsize, eventstate, ind, bupdate);
      [*] = ;         FillComboBoxCountries(elmHnd, True);
      [*] = ;         SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.players[gScenario.ui.pickedplayerindex].cid);
      [*] = ;
      [*] = ;         elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'team', cTextPlayersTeam, cTextPlayersTeamHint, gc_MaxPlayerCount, 0, colsize, eventstate, ind, bupdate);
      [*] = ;         FillComboBoxTeams(elmHnd);
      [*] = ;         SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.players[gScenario.ui.pickedplayerindex].team);
      [*] = ;
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'resfood', cTextPlayersFood, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_food], colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'reswood', cTextPlayersWood, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_wood], colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'resstone', cTextPlayersStone, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_stone], colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'resgold', cTextPlayersGold, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_gold], colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'resiron', cTextPlayersIron, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_iron], colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'rescoal', cTextPlayersCoal, cTextPlayersResourceHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].resources[gc_resource_type_coal], colsize, eventstate, True, ind, bupdate);
      [*] = ;
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bai', cTextPlayersAI, cTextPlayersAIHint, gScenarioTmp.players[gScenario.ui.pickedplayerindex].bai, colsize, eventstate, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_flags : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextFlagName, cTextFlagNameHint, gScenarioTmp.flags[gScenario.ui.pickedflagindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bactive', cTextFlagActive, cTextFlagActiveHint, gScenarioTmp.flags[gScenario.ui.pickedflagindex].bactive, colsize, eventstate, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_counters : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextCounterName, cTextCounterNameHint, gScenarioTmp.counters[gScenario.ui.pickedcounterindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'value', cTextCounterValue, cTextCounterValueHint, gScenarioTmp.counters[gScenario.ui.pickedcounterindex].value, colsize, eventstate, True, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_timers : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextTimerName, cTextTimerNameHint, gScenarioTmp.timers[gScenario.ui.pickedtimerindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bstarted', cTextTimerStarted, cTextTimerStartedHint, gScenarioTmp.timers[gScenario.ui.pickedtimerindex].bstarted, colsize, eventstate, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bfinished', cTextTimerFinished, cTextTimerFinishedHint, gScenarioTmp.timers[gScenario.ui.pickedtimerindex].bfinished, colsize, eventstate, ind, bupdate);
      [*] = ;         _ui_CreateFloatInputBoxScenario(ui, parent, 'time', cTextTimerTime, cTextTimerTimeHint, gScenarioTmp.timers[gScenario.ui.pickedtimerindex].time, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateFloatInputBoxScenario(ui, parent, 'starttime', cTextTimerStartTime, cTextTimerStartTimeHint, gScenarioTmp.timers[gScenario.ui.pickedtimerindex].starttime, colsize, eventstate, False, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_groups : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextGroupName, cTextGroupNameHint, gScenarioTmp.groups[gScenario.ui.pickedgroupindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'count', cTextGroupCount, cTextGroupCountHint, gScenarioTmp.groups[gScenario.ui.pickedgroupindex].unitslist.GetCount, colsize, eventstate, False, ind, bupdate);
      [*] = ;
      [*] = ;         ind := 0;
      [*] = ;         var xoff : Integer;
      [*] = ;         var yoff : Integer = -5;
      [*] = ;         var btnwidth : Integer = GetGUIElementWidth(elmMain)-16;
      [*] = ;         const btnheight = 38;
      [*] = ;         var cstep : Integer = btnheight+6;
      [*] = ;         _ui_CreateBtn(ui, 'bclear', elmMain, 0, cTextGroupClear, gc_halParentMiddle, gc_valParentMiddle, xoff, yoff+ind*cstep, btnwidth, btnheight, eventstate, nul, cTagGroupClear, bupdate); ind := ind+1;
      [*] = ;         _ui_CreateBtn(ui, 'baddsel', elmMain, 0, cTextGroupAddSel, gc_halParentMiddle, gc_valParentMiddle, xoff, yoff+ind*cstep, btnwidth, btnheight, eventstate, nul, cTagGroupAddSel, bupdate); ind := ind+1;
      [*] = ;         _ui_CreateBtn(ui, 'bremovesel', elmMain, 0, cTextGroupRemoveSel, gc_halParentMiddle, gc_valParentMiddle, xoff, yoff+ind*cstep, btnwidth, btnheight, eventstate, nul, cTagGroupRemoveSel, bupdate); ind := ind+1;
      [*] = ;         _ui_CreateBtn(ui, 'bsetsel', elmMain, 0, cTextGroupSetSel, gc_halParentMiddle, gc_valParentMiddle, xoff, yoff+ind*cstep, btnwidth, btnheight, eventstate, nul, cTagGroupSetSel, bupdate); ind := ind+1;
      [*] = ;         _ui_CreateBtn(ui, 'bselectunits', elmMain, 0, cTextGroupSelectGroupUnits, gc_halParentMiddle, gc_valParentMiddle, xoff, yoff+ind*cstep, btnwidth, btnheight, eventstate, nul, cTagGroupSelectGroupUnits, bupdate); ind := ind+1;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_zones : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextZoneName, cTextZoneNameHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateIntInputBoxScenario(ui, parent, 'count', cTextZoneCount, cTextZoneCountHint, gScenario.zones[gScenario.ui.pickedzoneindex].unitslist.GetCount, colsize, eventstate, False, ind, bupdate);
      [*] = ;         var count : Integer = gc_scenario_maxgroups;
      [*] = ;         var elmHnd : Integer;
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bactive', cTextZoneActive, cTextZoneActiveHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].bactive, colsize, eventstate, ind, bupdate);
      [*] = ;         count := gc_MaxPlayerCount;
      [*] = ;         elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'filterplayerid', cTextZoneFilterPlayerID, cTextZoneFilterPlayerIDHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;         if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmHnd, cTextZoneNoFilter, -1);
      [*] = ;            var i : Integer;
      [*] = ;            for i:=0 to count-1 do
      [*] = ;            GUIListBoxAddItem(elmHnd, gScenarioTmp.players[i].name, i);
      [*] = ;            SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].player+1);
      [*] = ;         end;
      [*] = ;         count := gc_scenario_maxgroups;
      [*] = ;         elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'filtergroupid', cTextZoneFilterGroupID, cTextZoneFilterGroupIDHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;         if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmHnd, cTextZoneNoFilter, -1);
      [*] = ;            var i : Integer;
      [*] = ;            for i:=0 to count-1 do
      [*] = ;            GUIListBoxAddItem(elmHnd, IntToStr(i)+' : '+gScenarioTmp.groups[i].name, i);
      [*] = ;            SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].group+1);
      [*] = ;         end;
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bonlyungroup', cTextZoneOnlyUngroup, cTextZoneOnlyUngroupHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].bonlyungroup, colsize, eventstate, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'blinkgroup', cTextZoneLinkToGroup, cTextZoneLinkToGroupHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].blinkgroup, colsize, eventstate, ind, bupdate);
      [*] = ;
      [*] = ;         if (gScenarioTmp.zones[gScenario.ui.pickedzoneindex].blinkgroup) then
      [*] = ;         begin
      [*] = ;            elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'linktogroup', cTextZoneLinkToGroupID, cTextZoneLinkToGroupIDHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;            if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;            begin
      [*] = ;               GUIListBoxAddItem(elmHnd, cTextZoneGroupNoLink, -1);
      [*] = ;               var i : Integer;
      [*] = ;               for i:=0 to count-1 do
      [*] = ;               GUIListBoxAddItem(elmHnd, IntToStr(i)+' : '+gScenarioTmp.groups[i].name, i);
      [*] = ;               SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].linkgroup+1);
      [*] = ;            end;
      [*] = ;            _ui_CreateFloatInputBoxScenario(ui, parent, 'addradius', cTextZoneAddRadius, cTextZoneAddRadiusHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].addradius, colsize, eventstate, True, ind, bupdate);
      [*] = ;            _ui_CreateCheckboxScenario(ui, parent, 'buseaverage', cTextZoneUseAverage, cTextZoneUseAverageHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].buseaverage, colsize, eventstate, ind, bupdate);
      [*] = ;         end
      [*] = ;         else
      [*] = ;         begin
      [*] = ;            if (not gScenarioTmp.zones[gScenario.ui.pickedzoneindex].blinkgroup) then
      [*] = ;            begin
      [*] = ;               _ui_CreateFloatInputBoxScenario(ui, parent, 'posx', cTextZonePositionX, cTextZonePositionXHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].x, colsize, eventstate, True, ind, bupdate);
      [*] = ;               _ui_CreateFloatInputBoxScenario(ui, parent, 'posy', cTextZonePositionY, cTextZonePositionYHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].y, colsize, eventstate, True, ind, bupdate);
      [*] = ;               _ui_CreateFloatInputBoxScenario(ui, parent, 'width', cTextZoneWidth, cTextZoneWidthHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].w, colsize, eventstate, True, ind, bupdate);
      [*] = ;               _ui_CreateFloatInputBoxScenario(ui, parent, 'height', cTextZoneHeight, cTextZoneHeightHint, gScenarioTmp.zones[gScenario.ui.pickedzoneindex].h, colsize, eventstate, True, ind, bupdate);
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_objectives : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextObjectiveName, cTextObjectiveNameHint, gScenarioTmp.objectives[gScenario.ui.pickedobjectiveindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langtable', cTextObjectiveLangTable, cTextObjectiveLangTableHint, gScenario.settings.langtable, colsize, eventstate, False, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langkey', cTextObjectiveLangKey, cTextObjectiveLangKeyHint, gScenarioTmp.objectives[gScenario.ui.pickedobjectiveindex].langkey, colsize, eventstate, False, ind, bupdate);
      [*] = ;         _ui_CreateFloatInputBoxScenario(ui, parent, 'starttime', cTextTimerStartTime, cTextTimerStartTimeHint, gScenarioTmp.objectives[gScenario.ui.pickedobjectiveindex].gametime, colsize, eventstate, False, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bvisible', cTextObjectiveVisible, cTextObjectiveVisibleHint, gScenarioTmp.objectives[gScenario.ui.pickedobjectiveindex].bvisible, colsize, eventstate, ind, bupdate);
      [*] = ;         _ui_CreateCheckboxScenario(ui, parent, 'bdone', cTextObjectiveDone, cTextObjectiveDoneHint, gScenarioTmp.objectives[gScenario.ui.pickedobjectiveindex].bdone, colsize, eventstate, ind, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_queries : begin
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, 4+gc_scenario_maxqueryresults, width, height, bScroller);
      [*] = ;         var cTextQueryName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.queryname');
      [*] = ;         var cTextQueryNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.queryname.hint');
      [*] = ;         var cTextQueryLangTable : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langtable');
      [*] = ;         var cTextQueryLangTableHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langtable.hint');
      [*] = ;         var cTextQueryLangKey : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langkey');
      [*] = ;         var cTextQueryLangKeyHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langkey.hint');
      [*] = ;         var cTextImage : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.image');
      [*] = ;         var cTextImageHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.image.hint');
      [*] = ;         var cTextResult : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.result');
      [*] = ;         var cTextResultHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.result.hint');
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextQueryName, cTextQueryNameHint, gScenarioTmp.queries[gScenario.ui.pickedqueryindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langtable', cTextQueryLangTable, cTextQueryLangTableHint, gScenario.settings.langtable, colsize, eventstate, False, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langkey', cTextQueryLangKey, cTextQueryLangKeyHint, gScenarioTmp.queries[gScenario.ui.pickedqueryindex].langkey, colsize, eventstate, False, ind, bupdate);
      [*] = ;
      [*] = ;         var i : Integer;
      [*] = ;         var count : Integer = gc_scenario_maximages;
      [*] = ;         var elmHnd : Integer = _ui_CreateComboBoxScenario(ui, parent, 'imageid', cTextImage, cTextImageHint, count, 12, colsize, eventstate, ind, True);
      [*] = ;         if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmHnd, '', -1);
      [*] = ;            for i:=0 to count-1 do
      [*] = ;            GUIListBoxAddItem(elmHnd, IntToStr(i)+' : '+gScenario.images[i].name, i);
      [*] = ;            SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.queries[gScenario.ui.pickedqueryindex].imageid+1);
      [*] = ;         end;
      [*] = ;
      [*] = ;         var j : Integer;
      [*] = ;         var text : String;
      [*] = ;         count := gc_scenario_maxresults;
      [*] = ;         for i:=0 to gc_scenario_maxqueryresults-1 do
      [*] = ;         begin
      [*] = ;            text := cTextResult+IntToStr(i);
      [*] = ;            elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'resultid'+IntToStr(i), text, cTextResultHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;            if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;            begin
      [*] = ;               GUIListBoxAddItem(elmHnd, '', -1);
      [*] = ;               for j:=0 to count-1 do
      [*] = ;               GUIListBoxAddItem(elmHnd, gScenarioTmp.results[j].name, j);
      [*] = ;               SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.queries[gScenario.ui.pickedqueryindex].results[i]+1);
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_images : begin
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextImageName, cTextImageNameHint, gScenarioTmp.images[gScenario.ui.pickedimageindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'material', cTextImageMaterial, cTextImageMaterialHint, gScenarioTmp.images[gScenario.ui.pickedimageindex].material, colsize, eventstate, True, ind, bupdate);
      [*] = ;         //_gui_CreateImage('image', parent, 'dialog.7.4', gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, 0, bupdate);
      [*] = ;         var mat : String = gScenarioTmp.images[gScenario.ui.pickedimageindex].material;
      [*] = ;         var imageW : Integer = GetGUITextureWidth(mat)+120;
      [*] = ;         var imageH : Integer = GetGUITextureHeight(mat)+70;
      [*] = ;         var elmBackground : Integer = _gui_CreateBambooWindow('background', parent, gc_halParentRightWidth, gc_valParentMiddle, -7, 40, imageW, imageH, bupdate);
      [*] = ;         //_gui_CreatePaperWindow('a'
      [*] = ;         _gui_CreateImage('image', elmBackground, gScenarioTmp.images[gScenario.ui.pickedimageindex].material, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, 0, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_resulttriggers : begin
      [*] = ;         var count : Integer;
      [*] = ;         var i : Integer;
      [*] = ;         for i:=0 to gc_trigger_maxconditions-1 do
      [*] = ;         if (gScenarioTmp.resulttriggers[gScenario.ui.pickedresulttriggerindex].conditions[i].id<>gc_trigger_condition_none) then
      [*] = ;         count := count+1;
      [*] = ;
      [*] = ;         for i:=0 to gc_trigger_maxactions-1 do
      [*] = ;         if (gScenarioTmp.resulttriggers[gScenario.ui.pickedresulttriggerindex].actions[i].id<>gc_trigger_action_none) then
      [*] = ;         count := count+1;
      [*] = ;         count := count+1+1;
      [*] = ;         var eventstatetrigger : String = 'EventScenarioEditor';
      [*] = ;         _scenario_ShowTrigger(parent, ui, 0, gScenario.ui.pickedresulttriggerindex, count, eventstatetrigger, True, True, bupdate);
      [*] = ;      end;
      [*] = ;      gc_scenario_ui_helpertype_results : begin
      [*] = ;         CalcBtnWidthBasedOnScroller(parent, 5, width, height, bScroller);
      [*] = ;         var cTextResultName : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.resultname');
      [*] = ;         var cTextResultNameHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.resultname.hint');
      [*] = ;         var cTextResultLangTable : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langtable');
      [*] = ;         var cTextResultLangTableHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langtable.hint');
      [*] = ;         var cTextResultLangKey : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langkey');
      [*] = ;         var cTextResultLangKeyHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.langkey.hint');
      [*] = ;         var cTextResultNextQueryID : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.nextquery');
      [*] = ;         var cTextResultNextQueryIDHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.nextquery.hint');
      [*] = ;         var cTextResultResultTrigger : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.resulttrigger');
      [*] = ;         var cTextResultResultTriggerHint : String = GetLocaleTableListItemByID('editor', 'scenarioeditor.resulttrigger.hint');
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'name', cTextResultName, cTextResultNameHint, gScenarioTmp.results[gScenario.ui.pickedresultindex].name, colsize, eventstate, True, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langtable', cTextResultLangTable, cTextResultLangTableHint, gScenario.settings.langtable, colsize, eventstate, False, ind, bupdate);
      [*] = ;         _ui_CreateInputBoxScenario(ui, parent, 'langkey', cTextResultLangKey, cTextResultLangKeyHint, gScenarioTmp.results[gScenario.ui.pickedresultindex].langkey, colsize, eventstate, False, ind, bupdate);
      [*] = ;
      [*] = ;         var i : Integer;
      [*] = ;         var count : Integer = gc_scenario_maxqueries;
      [*] = ;         var elmHnd : Integer = _ui_CreateComboBoxScenario(ui, parent, 'nextqueryid', cTextResultNextQueryID, cTextResultNextQueryIDHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;         if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmHnd, '', -1);
      [*] = ;            for i:=0 to count-1 do
      [*] = ;            GUIListBoxAddItem(elmHnd, IntToStr(i)+' : '+gScenario.queries[i].name, i);
      [*] = ;            SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.results[gScenario.ui.pickedresultindex].nextqueryid+1);
      [*] = ;         end;
      [*] = ;         count := gc_scenario_maxresulttriggers;
      [*] = ;
      [*] = ;         elmHnd := _ui_CreateComboBoxScenario(ui, parent, 'resulttrigger', cTextResultResultTrigger, cTextResultResultTriggerHint, count+1, 12, colsize, eventstate, ind, True);
      [*] = ;         if (GetGUIListBoxItemsCount(elmHnd)=0) then
      [*] = ;         begin
      [*] = ;            GUIListBoxAddItem(elmHnd, '', -1);
      [*] = ;            for i:=0 to count-1 do
      [*] = ;            GUIListBoxAddItem(elmHnd, IntToStr(i)+' : '+gScenario.resulttriggers[i].name, i);
      [*] = ;            SetGUIListBoxItemIndexSilent(elmHnd, gScenarioTmp.results[gScenario.ui.pickedresultindex].resulttriggerid+1);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   SetGUIScrollEnabled(parent, bScroller);
      [*] = ;   SetGUIElementHeight(parent, height);
      [*] = ;end;
      [*] = ;
      [*] = ;CreateLeftPanel(elmList);
      [*] = ;CreateRightPanel(elmMain);
      [*] = ;
      [*] = ;procedure EditScenarioSettings();
      [*] = ;begin
      [*] = ;   //_ui_CreateInput;
      [*] = ;end;
      [*] = ;
      [*] = ;GUIInvalidateChildrenPositions(0);
      [*] = ;
      [*] = ;SetRandomKey(floor(Abs(randkey))); // if randkey<0 function set key0 to -1 and randomext start to provide negative values
   struct.end
section.end

