section.begin
   Name = ShowQueryWindow
   Code : struct.begin
      [*] = ;// _gui_CreateBambooWindow
      [*] = ;//
      [*] = ;function _gui_CreateBambooWindow(const elementName : String; parent : Integer; hAlign, vAlign : Integer; posX, posY, width, height : Integer; bGetUpdate : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   if (width>946) then
      [*] = ;   ErrorLog('_gui_CreatePaperWindow unsupported size iwidth>946');
      [*] = ;   const bordersize = 0;
      [*] = ;   const borderoverlap = 14;
      [*] = ;   const paperborderoverlap = 40;
      [*] = ;   const materialBase = 'bambooframe';
      [*] = ;   var cMaterialBackground : String = gc_gui_material_black;
      [*] = ;   var cMaterialLeft : String = materialBase+'.left';
      [*] = ;   var cMaterialRight : String = materialBase+'.right';
      [*] = ;   var cMaterialTop : String = materialBase+'.top';
      [*] = ;   var cMaterialBottom : String = materialBase+'.bottom';
      [*] = ;   var cMaterialCornerLT : String = materialBase+'.corner_lt';
      [*] = ;   var cMaterialCornerRT : String = materialBase+'.corner_rt';
      [*] = ;   var cMaterialCornerLB : String = materialBase+'.corner_lb';
      [*] = ;   var cMaterialCornerRB : String = materialBase+'.corner_rb';
      [*] = ;
      [*] = ;   // cache width
      [*] = ;   var twBackground : Integer = GetGUITextureWidth(cMaterialBackground);
      [*] = ;   var twLeft : Integer = GetGUITextureWidth(cMaterialLeft);
      [*] = ;   var twRight : Integer = GetGUITextureWidth(cMaterialRight);
      [*] = ;   var twTop : Integer = GetGUITextureWidth(cMaterialTop);
      [*] = ;   var twBottom : Integer = GetGUITextureWidth(cMaterialBottom);
      [*] = ;
      [*] = ;   // cache height
      [*] = ;   var thBackground : Integer = GetGUITextureHeight(cMaterialBackground);
      [*] = ;   var thLeft : Integer = GetGUITextureHeight(cMaterialLeft);
      [*] = ;   var thRight : Integer = GetGUITextureHeight(cMaterialRight);
      [*] = ;   var thTop : Integer = GetGUITextureHeight(cMaterialTop);
      [*] = ;   var thBottom : Integer = GetGUITextureHeight(cMaterialBottom);
      [*] = ;
      [*] = ;   // cache width
      [*] = ;   var twCornerLT : Integer = GetGUITextureWidth(cMaterialCornerLT);
      [*] = ;   var twCornerRT : Integer = GetGUITextureWidth(cMaterialCornerRT);
      [*] = ;   var twCornerLB : Integer = GetGUITextureWidth(cMaterialCornerLB);
      [*] = ;   var twCornerRB : Integer = GetGUITextureWidth(cMaterialCornerRB);
      [*] = ;
      [*] = ;   // cache height
      [*] = ;   var thCornerLT : Integer = GetGUITextureHeight(cMaterialCornerLT);
      [*] = ;   var thCornerRT : Integer = GetGUITextureHeight(cMaterialCornerRT);
      [*] = ;   var thCornerLB : Integer = GetGUITextureHeight(cMaterialCornerLB);
      [*] = ;   var thCornerRB : Integer = GetGUITextureHeight(cMaterialCornerRB);
      [*] = ;
      [*] = ;   if (elementName<>'') and (StrExists(elementName, '.')) then ErrorLog('_gui_Create element name should not have dot char. I this cas.e we are not able to get element handle by name. elmname='+elementName);
      [*] = ;   var iwidth : Integer = width;
      [*] = ;   var iheight : Integer = Max(height, 182);
      [*] = ;   var iparent : Integer = parent;
      [*] = ;   if (iparent=0) then iparent := _gui_GetTop;
      [*] = ;
      [*] = ;   var elmWindowHnd : Integer = _gui_CreateParent(elementName, iparent, hAlign, vAlign, posX, posY, iwidth, iheight, bGetUpdate);
      [*] = ;   var elmBgHnd : Integer = _gui_CreateImage('bg', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmLHnd : Integer = _gui_CreateImage('l', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmRHnd : Integer = _gui_CreateImage('r', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmTHnd : Integer = _gui_CreateImage('t', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBHnd : Integer = _gui_CreateImage('b', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, -bordersize, bordersize, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBackgroundHnd : Integer = _gui_CreateImage('background', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   var elmBlickHnd : Integer = _gui_CreateImage('blick', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;   //var elmHeaderHnd : Integer = _gui_CreateImage('head', elmWindowHnd, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, iwidth, iheight, 0, bGetUpdate);
      [*] = ;
      [*] = ;   var backgroundWidth : Integer = iwidth-borderoverlap*2;
      [*] = ;   var backgroundHeight : Integer = iheight-borderoverlap*2;
      [*] = ;   var tileW, tileH : Integer;
      [*] = ;   tileW := (backgroundWidth div twBackground);
      [*] = ;   if ((backgroundWidth mod twBackground)>0) then tileW := tileW+1;
      [*] = ;   tileH := (backgroundHeight div thBackground);
      [*] = ;   if ((backgroundHeight mod thBackground)>0) then tileH := tileH+1;
      [*] = ;   var i : Integer;
      [*] = ;   for i:=0 to tileW-1 do
      [*] = ;   begin
      [*] = ;      var tmpX, tmpY : Float;
      [*] = ;      var fscaleX : Float = 1;
      [*] = ;      var fscaleY : Float = 1;
      [*] = ;      var j : Integer;
      [*] = ;      for j:=0 to tileH-1 do
      [*] = ;      begin
      [*] = ;         var elmHnd : Integer = _gui_CreateTileScaleImage('bg_'+IntToStr(i)+'_'+IntToStr(j), elmBgHnd, cMaterialBackground, gc_halParentLeft, gc_valParentTop, borderoverlap+i*twBackground, borderoverlap+j*thBackground, Min(twBackground, (backgroundWidth-i*twBackground)), Min(thBackground, (backgroundHeight-j*thBackground)), bGetUpdate);
      [*] = ;         var elmwidth : Integer = twBackground;
      [*] = ;         if (iwidth<>0) and (iwidth<(elmwidth+i*twBackground)) then
      [*] = ;         fscaleX := (iwidth-i*twBackground)/elmwidth;
      [*] = ;         var elmheight : Integer = thBackground;
      [*] = ;         if (iheight<>0) and (iheight<(elmheight*(iheight div backgroundHeight)+j*thBackground)) then
      [*] = ;         fscaleY := (iheight-j*thBackground)/(elmheight*(iheight div backgroundHeight));
      [*] = ;         if (iwidth<0) then fscaleX := -fscaleX;
      [*] = ;         if (iheight<0) then fscaleY := -fscaleY;
      [*] = ;         SetGUIElementTileScales(elmHnd, fscaleX, fscaleY);
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   SetGUIElementAllPositionRect(elmBackgroundHnd, 0, 0, iwidth, iheight);
      [*] = ;
      [*] = ;   var tmpwidth : Integer = (iwidth-twCornerLT-twCornerRT+bordersize*2+borderoverlap*2);
      [*] = ;   var tmpheight : Integer = (iheight-thCornerLT-thCornerRB+bordersize*2+borderoverlap*2);
      [*] = ;   tileW := (tmpwidth div twTop);
      [*] = ;   if ((tmpwidth mod twTop)>0) then tileW := tileW+1;
      [*] = ;   tileH := (tmpheight div thLeft);
      [*] = ;   if ((tmpheight mod thLeft)>0) then tileH := tileH+1;
      [*] = ;   for i:=0 to tileH-1 do
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('l_'+IntToStr(i), elmLHnd, cMaterialLeft, gc_halParentLeft, gc_valParentTop, 0, thCornerLT+i*thLeft-borderoverlap, 0, Min(thLeft, tmpheight-i*thLeft), bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('r_'+IntToStr(i), elmRHnd, cMaterialRight, gc_halParentRightWidth, gc_valParentTop, 0, thCornerRT+i*thRight-borderoverlap, 0, Min(thRight, +tmpheight-i*thRight), bGetUpdate);
      [*] = ;   end;
      [*] = ;   for i:=0 to tileW-1 do
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('t_'+IntToStr(i), elmTHnd, cMaterialTop, gc_halParentLeft, gc_valParentTop, twCornerLT+i*twTop-borderoverlap, 0, Min(twTop, tmpwidth-i*twTop), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('b_'+IntToStr(i), elmBHnd, cMaterialBottom, gc_halParentLeft, gc_valParentBottomHeight, twCornerLB+i*twTop-borderoverlap, 0, Min(twBottom, tmpwidth-i*twBottom), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;   if (iheight>0) then
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('clt', elmBackgroundHnd, cMaterialCornerLT, gc_halParentLeft, gc_valParentTop, -bordersize, -bordersize, min(twCornerLT, iwidth), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('clb', elmBackgroundHnd, cMaterialCornerLB, gc_halParentLeft, gc_valParentBottomHeight, -bordersize, bordersize, min(twCornerLT, iwidth), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;   if (iwidth>0) then
      [*] = ;   begin
      [*] = ;      _gui_CreateTileScaleImage('crt', elmBackgroundHnd, cMaterialCornerRT, gc_halParentRightWidth, gc_valParentTop, bordersize, -bordersize, min(twCornerRT, iwidth), 0, bGetUpdate);
      [*] = ;      _gui_CreateTileScaleImage('crb', elmBackgroundHnd, cMaterialCornerRB, gc_halParentRightWidth, gc_valParentBottomHeight, bordersize, bordersize, min(twCornerRT, iwidth), 0, bGetUpdate);
      [*] = ;   end;
      [*] = ;
      [*] = ;   var ipaperwidth : Integer = iwidth-paperborderoverlap;
      [*] = ;   var ipaperheight : Integer = iheight-paperborderoverlap;
      [*] = ;   var bShowBlink : Boolean = (Min(ipaperwidth, ipaperheight)>400);
      [*] = ;   _gui_CreatePaperWindow('paperbackground', elmBackgroundHnd, gc_halParentMiddle, gc_valParentMiddle, 0, 0, ipaperwidth, ipaperheight, 1, bShowBlink, bGetUpdate);
      [*] = ;
      [*] = ;   Result := elmWindowHnd;
      [*] = ;end;
      [*] = ;
      [*] = ;procedure SetGUIElementHeightSmart(elmhnd, height : Integer);
      [*] = ;begin
      [*] = ;   SetGUIElementHeight(elmhnd, height);
      [*] = ;   SetGUIElementLogicHeight(elmhnd, height);
      [*] = ;   var dbghnd : Integer = GetGUIElementIndexByNameParent('debug', elmhnd);
      [*] = ;   if (dbghnd<>0) then
      [*] = ;   begin
      [*] = ;      SetGUIElementHeight(dbghnd, GetGUIElementHeight(elmhnd));
      [*] = ;      SetGUIElementLogicHeight(dbghnd, GetGUIElementHeight(elmhnd));
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;const bupdate = False;
      [*] = ;const currentstatename = 'ShowQueryWindow';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;
      [*] = ;var ui : TUI;
      [*] = ;ui.SetContainerMaxWidthType(6);
      [*] = ;ui.SetDebug(False); // False
      [*] = ;ui.fcontainerwidth := 584-82;
      [*] = ;ui.text1.ffont := gc_font_serif_13;
      [*] = ;ui.text2.ffont := gc_font_serif_13;
      [*] = ;
      [*] = ;var queryfont : String = gUIConst.font[ui.text1.ffont];
      [*] = ;var resultfont : String = gUIConst.font[ui.text2.ffont];
      [*] = ;
      [*] = ;const cmargin = 6;
      [*] = ;
      [*] = ;var queryID : String = GetValueByName('queryID');
      [*] = ;
      [*] = ;var queryHnd : Integer;
      [*] = ;if (queryID<>'') then
      [*] = ;queryHnd := QueryMachineCustomQueryCreate(queryID);
      [*] = ;
      [*] = ;if (queryHnd=0) then
      [*] = ;begin
      [*] = ;   var elmParent : Integer = GetGUIElementIndexByNameParent(elmname, _gui_GetTop);
      [*] = ;   if (elmParent<>0) then
      [*] = ;   DestroyGUIElement(elmParent);
      [*] = ;   SetValueByName('queryID', '');
      [*] = ;   SetProgressingPauseMode(False);
      [*] = ;   ExecuteState('ShowPause');
      [*] = ;   gbool_gui_querywindow := False;
      [*] = ;   exit;
      [*] = ;end;
      [*] = ;SetProgressingPauseMode(True);
      [*] = ;gbool_gui_querywindow := True;
      [*] = ;
      [*] = ;const cImagePadding = 8;
      [*] = ;const cTextPadding = 16;
      [*] = ;const cResultsPadding = 6;
      [*] = ;const cResultHeight = 36;
      [*] = ;const cResultsDelimiter = 8;
      [*] = ;var coloractive, colorhover, colordisabled : TColor;
      [*] = ;_gui_ConvertHexToTColor('321900', coloractive);
      [*] = ;_gui_ConvertHexToTColor('EEEEEE', colorhover);
      [*] = ;_gui_ConvertHexToTColor('555555', colordisabled);
      [*] = ;
      [*] = ;var curDefault : Integer = GetGUICursorIndexByName('crDefault');
      [*] = ;var curPress : Integer = GetGUICursorIndexByName('crPress');
      [*] = ;
      [*] = ;var querytable : String = QueryMachineQueryGetTable(queryHnd);
      [*] = ;var querykey : String = QueryMachineQueryGetKey(queryHnd);
      [*] = ;var queryicon : String = QueryMachineQueryGetIcon(queryHnd);
      [*] = ;var resultsHnd : Integer = QueryMachineQueryGetResults(queryHnd);
      [*] = ;var countResults : Integer = QueryMachineResultsCount(resultsHnd);
      [*] = ;
      [*] = ;var querytext : String = querytable+'|'+querykey;
      [*] = ;var querytextw, querytexth : Integer;
      [*] = ;var querytexttmp : String = querytext;
      [*] = ;_misc_StringToText(querytexttmp, querytext);
      [*] = ;querytext := GetGUIWrappedTextByFont(queryfont, querytext, ui.fcontainerwidth-cTextPadding*2);
      [*] = ;GetGUIElementFontTextRect(queryfont, querytext, querytextw, querytexth);
      [*] = ;
      [*] = ;var queryheight : Integer = querytexth+cTextPadding*2;
      [*] = ;
      [*] = ;var posy : Integer;
      [*] = ;var elmParent : Integer = _ui_CreateCustomContainer(ui, elmname, 0, gc_halParentMiddle, gc_valParentMiddle, 0, posy, ui.fcontainerwidth, 0, bupdate);
      [*] = ;var elmMask : Integer = _gui_CreateImageActive('blackmask', elmParent, gc_gui_material_black, gc_halLeft, gc_valTop, 0, 0, GetViewerWidth, GetViewerHeight, 0, '', '', bupdate);
      [*] = ;SetGUIElementUserBlend(elmMask, 0.35);
      [*] = ;var elmBackgroundParent : Integer = _gui_CreateParent('backgroundparent', elmParent, gc_halMiddle, gc_valMiddle, 0, 0, 0, 0, bupdate);
      [*] = ;
      [*] = ;var imageHeight : Integer;
      [*] = ;if (queryicon<>'') then
      [*] = ;imageHeight := GetGUITextureHeight(queryicon)
      [*] = ;else
      [*] = ;imageHeight := 0;
      [*] = ;var elmRowImage : Integer = _ui_CreateRow(ui, 'rowimage', elmParent, gc_valParentTop, 0, imageHeight+cImagePadding*2, bupdate);
      [*] = ;
      [*] = ;if (imageHeight=0) then
      [*] = ;SetGUIElementHeightSmart(elmRowImage, 0);
      [*] = ;
      [*] = ;if (queryicon<>'') then
      [*] = ;posy := GetGUIElementHeight(elmRowImage);
      [*] = ;var elmRowQuery : Integer = _ui_CreateRow(ui, 'rowquery', elmParent, gc_valParentTop, posy, queryheight, bupdate);
      [*] = ;posy := posy+GetGUIElementHeight(elmRowQuery)+cResultsDelimiter;
      [*] = ;var elmRowResults : Integer = _ui_CreateRow(ui, 'rowresults', elmParent, gc_valParentTop, posy, 0, bupdate);
      [*] = ;_gui_CreateImage('image', elmRowImage, queryicon, gc_halParentMiddle, gc_valParentMiddle, 0, cImagePadding, 0, 0, imageheight, bupdate);
      [*] = ;
      [*] = ;ui.text1.fcr := 0.35;
      [*] = ;ui.text1.fcg := 0.0;
      [*] = ;ui.text1.fcb := 0.0;
      [*] = ;//ui.text1.ffont := gc_font_serif_13;
      [*] = ;_ui_CreateText(ui, 'query', elmRowQuery, 0, querytext, gc_halParentLeft, gc_valParentTop, cTextPadding, cTextPadding, querytextw, queryheight, gc_halLeft, gc_valTop, bupdate);
      [*] = ;
      [*] = ;posy := 0;
      [*] = ;var elmhnd : Integer;
      [*] = ;var i : Integer;
      [*] = ;for i:=0 to QueryMachineResultsCount(resultsHnd)-1 do
      [*] = ;begin
      [*] = ;   posy := posy+cResultsPadding*2;
      [*] = ;   var resultHnd : Integer = QueryMachineResultsGetByIndex(resultsHnd, i);
      [*] = ;   var resulttable : String = QueryMachineResultGetTable(resultHnd);
      [*] = ;   var resultkey : String = QueryMachineResultGetKey(resultHnd);
      [*] = ;   var benabled : Boolean = QueryMachineResultGetEnable(resultHnd);
      [*] = ;
      [*] = ;   var resulttriggerid : Integer = QueryMachineResultGetTagInteger(resultHnd);
      [*] = ;   if (resulttriggerid>=0) then
      [*] = ;   begin
      [*] = ;      var ptrigger : Pointer = gScenario.resulttriggers[resulttriggerid];
      [*] = ;      if (ptrigger<>nil) then
      [*] = ;      benabled := _scenario_CheckTriggerConditions(ptrigger);
      [*] = ;   end;
      [*] = ;
      [*] = ;   var text : String = resulttable+'|'+resultkey;
      [*] = ;   var textw, texth : Integer;
      [*] = ;   var texttmp : String = text;
      [*] = ;   _misc_StringToText(texttmp, text);
      [*] = ;   text := GetGUIWrappedTextByFont(resultfont, text, ui.fcontainerwidth-cTextPadding*2);
      [*] = ;   GetGUIElementFontTextFormatRect(resultfont, text, textw, texth);
      [*] = ;
      [*] = ;   elmhnd := AddNewElementParent('btn.dummy', 'result', resultHnd, elmRowResults);
      [*] = ;   SetGUIElementFont(elmhnd, resultfont);
      [*] = ;   SetGUIElementTextAlign(elmhnd, 'halMiddle', 'valTop', 0, 0);
      [*] = ;   SetGUIElementTextFormatted(elmhnd, True);
      [*] = ;   SetGUIElementColor(elmhnd, 0, 0, 0, 1);
      [*] = ;
      [*] = ;   SetGUIElementAllPositionRect(elmhnd, 0, posy, GetGUIElementWidth(elmRowResults), texth);
      [*] = ;   SetGUIElementAlign(elmhnd, 'halParentLeft', 'valParentTop');
      [*] = ;   SetGUIElementText(elmhnd, text);
      [*] = ;   SetGUIAllowEvents(elmhnd, True, False, False);
      [*] = ;
      [*] = ;   SetGUIElementPressState(elmhnd, eventstate);
      [*] = ;   SetGUIElementHoverEnabled(elmhnd, benabled);
      [*] = ;   SetGUIElementEnabled(elmhnd, benabled);
      [*] = ;
      [*] = ;   SetGUIElementVisibleProperties(elmhnd, 'DownProperty', gc_gui_material_blank, 0, 0, 0, 0, curPress, coloractive.r, coloractive.g, coloractive.b, coloractive.a);
      [*] = ;   SetGUIElementVisibleProperties(elmhnd, 'CheckOnProperty', gc_gui_material_blank, 0, 0, 0, 0, curPress, coloractive.r, coloractive.g, coloractive.b, coloractive.a);
      [*] = ;   SetGUIElementVisibleProperties(elmhnd, 'UpProperty', gc_gui_material_blank, 0, 0, 0, 0, curPress, coloractive.r, coloractive.g, coloractive.b, coloractive.a);
      [*] = ;   SetGUIElementVisibleProperties(elmhnd, 'DisableProperty', gc_gui_material_blank, 0, 0, 0, 0, curDefault, colordisabled.r, colordisabled.g, colordisabled.b, colordisabled.a);
      [*] = ;   SetGUIElementVisibleProperties(elmhnd, 'HoverProperty', gc_gui_material_blank, 0, 0, 0, 0, curPress, colorhover.r, colorhover.g, colorhover.b, colorhover.a);
      [*] = ;   posy := posy+texth;
      [*] = ;end;
      [*] = ;var height : Integer = posy+32;
      [*] = ;SetGUIElementHeightSmart(elmRowResults, imageHeight+height-cResultsPadding*2);
      [*] = ;SetGUIElementHeightSmart(elmParent, GetGUIElementHeight(elmRowQuery)+GetGUIElementHeight(elmRowResults)+cResultsDelimiter);
      [*] = ;
      [*] = ;// background
      [*] = ;var maxheight : Integer = _gui_GetBottomPos(elmHnd)+cmargin*7;
      [*] = ;const cwidthborder = 82;
      [*] = ;const cheightborder = 82;
      [*] = ;var elmBackground : Integer = _gui_CreateBambooWindow('background', elmBackgroundParent, gc_halParentMiddle, gc_valParentMiddle, 0, 0, GetGUIElementWidth(elmRowImage)+cwidthborder, GetGUIElementHeight(elmRowQuery)+GetGUIElementHeight(elmRowResults)+cResultsDelimiter+cheightborder, bupdate);
      [*] = ;SetGUIElementPositionY(elmBackgroundParent, 0);
   struct.end
section.end

