section.begin
   Name = ShowEndGameStatistics
   Code : struct.begin
      [*] = ;const bupdate = False;
      [*] = ;const currentstatename = 'ShowEndGameStatistics';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;
      [*] = ;if (gInterface.gamemode<>gc_gamemode_endgamestatistics) then
      [*] = ;begin
      [*] = ;   gInterface.gamemode := gc_gamemode_endgamestatistics;
      [*] = ;   Log('On ShowEndGameStatistics gamemode<>gc_gamemode_endgamestatistics. It is set to gc_gamemode_endgamestatistics');
      [*] = ;end;
      [*] = ;
      [*] = ;dbgstatename := showstate;
      [*] = ;
      [*] = ;const cmargin = 6;
      [*] = ;const cMinWidth = 300;
      [*] = ;const cMinHeight = 140;
      [*] = ;
      [*] = ;const cTagBackToGame = 101;
      [*] = ;const cTagReplay = 102;
      [*] = ;const cTagSaveReplay = 103;
      [*] = ;const cTagExitToMenu = 104;
      [*] = ;const cTagPrev = 105;
      [*] = ;const cTagNext = 106;
      [*] = ;
      [*] = ;// common variables
      [*] = ;var elmHnd : Integer;
      [*] = ;var nul, text : String;
      [*] = ;var w, h : Integer;
      [*] = ;var color : TColor;
      [*] = ;var blackcolor : TColor;
      [*] = ;_gui_SetupTColorInteger(255, 220, 170, 255, 0.9, color);
      [*] = ;_gui_SetupTColorInteger(28, 28, 28, 255, 1, blackcolor);
      [*] = ;var maxwidth : Integer = cMinWidth;
      [*] = ;var maxheight : Integer = cMinHeight;
      [*] = ;
      [*] = ;function ShowButton(const elmName : String; elmHnd, parentHnd : Integer; btnMaterial : String; var text : String; margin, tag : Integer; bEnabled : Boolean) : Integer;
      [*] = ;begin
      [*] = ;   Result := _gui_CreateButton(elmName, parentHnd, btnMaterial, gc_halParentMiddle, gc_valParentTop, 0, _gui_GetBottomPos(elmHnd)+margin, 0, 0, eventstate, nul, tag, bupdate);
      [*] = ;   SetGUIElementEnabled(Result, bEnabled);
      [*] = ;   _gui_CreateText('txtbtn', Result, text, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_15, color, bupdate);
      [*] = ;end;
      [*] = ;
      [*] = ;var cTextStatistics : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.header');
      [*] = ;var cTextPopulAndUpgrades : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.population');
      [*] = ;var cTextScoreDynamics : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.scores');
      [*] = ;var cTextPlayers : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.players');
      [*] = ;var cTextPlayer : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.player');
      [*] = ;var cTextBackToGame : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.backtogame');
      [*] = ;var cTextRestart : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.restart');
      [*] = ;var cTextReplay : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.replay');
      [*] = ;var cTextSaveReplay : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.savereplay');
      [*] = ;var cTextExitToMenu : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.exittomenu');
      [*] = ;var cTextExit : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.exit');
      [*] = ;
      [*] = ;// parent
      [*] = ;const cWidth = 1018+220; // +220 // 1018
      [*] = ;const cHeight = 750; // 624
      [*] = ;
      [*] = ;var elmParent : Integer = _gui_CreateParent(elmname, 0, gc_halMiddle, gc_valMiddle, 0, 0, cWidth, cHeight, bupdate);
      [*] = ;var elmMask : Integer = _gui_CreateImageActive('blackmask', elmParent, gc_gui_material_black, gc_halLeft, gc_valTop, 0, 0, GetViewerWidth, GetViewerHeight, 0, '', '', bupdate);
      [*] = ;//var elmBackgroundParent : Integer = _gui_CreateParent('backgroundparent', elmParent, gc_halMiddle, gc_valMiddle, 0, 0, cWidth, cHeight, bupdate);
      [*] = ;var elmBackgroundParent : Integer = _gui_CreateImageActive('backgroundparent', elmParent, gc_gui_material_blank, gc_halMiddle, gc_valMiddle, 0, 0, cWidth, cHeight, 0, '', '', bupdate);
      [*] = ;SetGUIElementPressState(elmParent, eventstate);
      [*] = ;SetGUIElementUserBlend(elmMask, 0.65);
      [*] = ;// body
      [*] = ;var elmSkinHead, elmChart : Integer;
      [*] = ;var i, j, plcount : Integer;
      [*] = ;for i:=0 to gc_MaxPlayerCount-1 do
      [*] = ;begin
      [*] = ;   if (gPlayer[i].bexists) or (gPlayer[i].victorystate<>gc_player_victorystate_none) then
      [*] = ;   plcount := plcount+1;
      [*] = ;end;
      [*] = ;case gInterface.statpage of
      [*] = ;   gc_gui_statpage_population, gc_gui_statpage_scores : begin
      [*] = ;      //elmSkinHead := _gui_CreateSkinHeadWindow('sh_0', elmParent, gc_halParentLeft, gc_valParentTop, 60, 64, cWidth-117, bupdate);
      [*] = ;      const cIconSize = 46;
      [*] = ;      var cMargin : Integer = 4+8-plcount;
      [*] = ;      const cMarginBottom = 97;
      [*] = ;      //const cPlayerHeight = 45+8;
      [*] = ;      var cPlayerHeight : Integer = cIconSize+cMargin;
      [*] = ;      const cAddPaperHeight = 50;
      [*] = ;      var upgHeight : Integer = cPlayerHeight*plcount;
      [*] = ;      var elmUpgrades : Integer = _gui_CreateParent('upgrades', elmParent, gc_halParentLeft, gc_valParentBottomHeight, 60, -cMarginBottom, cWidth-117, upgHeight, bupdate);
      [*] = ;      elmChart := _gui_CreatePaperWindow('chartback', elmParent, gc_halParentLeft, gc_valParentTop, 60, 99-cAddPaperHeight, cWidth-117, 522+(20+plcount)-upgHeight+cAddPaperHeight, 1, False, bupdate);
      [*] = ;      SetGUIHintWaitDelay(0);
      [*] = ;
      [*] = ;      // chart start
      [*] = ;      procedure ShowChart();
      [*] = ;      begin
      [*] = ;         const cBaseOffX = 32;
      [*] = ;         const cBaseOffY = -32;
      [*] = ;         const cBasePaddingX = 8;
      [*] = ;         var paperwidth : Integer = GetGUIElementWidth(elmChart)-cBaseOffX*2-cBasePaddingX;
      [*] = ;         var paperheight : Integer = GetGUIElementHeight(elmChart)+cBaseOffY*2;
      [*] = ;
      [*] = ;         procedure DrawGrid(elmParent, maxvalue : Integer; bpseudofloat : Boolean);
      [*] = ;         begin
      [*] = ;            const usercolor = 0;
      [*] = ;            const alpha = 0.3;
      [*] = ;            var mat : String = 'icons.keycolor.'+IntToStr(14);
      [*] = ;            var steps : Integer = 7;
      [*] = ;            var vstep : Integer = paperwidth div steps;
      [*] = ;            var hstep : Integer = paperheight div steps;
      [*] = ;            var i : Integer;
      [*] = ;            for i:=0 to steps do
      [*] = ;            begin
      [*] = ;               if i>0 then
      [*] = ;               begin
      [*] = ;                  var val : Integer = (maxvalue div steps)*i;
      [*] = ;                  if (bpseudofloat) then
      [*] = ;                  val := val div 100;
      [*] = ;                  var sval : String = IntToStr(val);
      [*] = ;                  _gui_CreateText('s'+IntToStr(i), elmParent, sval, gc_halParentLeft, gc_valParentBottomHeight, cBaseOffX+cBasePaddingX+4-46, cBaseOffY-hstep*i+19, 40, 0, gc_halRight gc_valTop, gc_font_serif_12, color, bupdate);
      [*] = ;               end;
      [*] = ;               var elm : Integer = _gui_CreateImage('', elmParent, gc_gui_material_white, gc_halParentLeft, gc_valParentBottomHeight, cBaseOffX+cBasePaddingX+vstep*i, cBaseOffY, 1, paperheight, 0, False);
      [*] = ;               SetGUIElementUseUserColor(elm, True);
      [*] = ;               SetGUIElementUserColor(elm, usercolor, usercolor, usercolor, alpha);
      [*] = ;               elm := _gui_CreateImage('', elmParent, gc_gui_material_white, gc_halParentLeft, gc_valParentBottomHeight, cBaseOffX+cBasePaddingX, cBaseOffY-hstep*i, paperwidth-cBasePaddingX div 2, 1, 0, False);
      [*] = ;               SetGUIElementUseUserColor(elm, True);
      [*] = ;               SetGUIElementUserColor(elm, usercolor, usercolor, usercolor, alpha);
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;
      [*] = ;         var maxvalue : Integer;
      [*] = ;         var pl, i : Integer;
      [*] = ;         for pl:=0 to gc_MaxPlayerCount-2 do
      [*] = ;         begin
      [*] = ;            function CalcMaxValue(var list : TIntegerList; maxvalue : Integer) : Integer;
      [*] = ;            begin
      [*] = ;               Result := maxvalue;
      [*] = ;               var count : Integer = list.GetCount;
      [*] = ;               var i : Integer;
      [*] = ;               for i:=0 to count-1 do
      [*] = ;               begin
      [*] = ;                  var val : Integer = list.Get(i);
      [*] = ;                  if (val>Result) then
      [*] = ;                  Result := val;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            if (gInterface.statpage=gc_gui_statpage_population) then
      [*] = ;            maxvalue := CalcMaxValue(gPlayer[pl].stat.population, maxvalue)
      [*] = ;            else
      [*] = ;            maxvalue := CalcMaxValue(gPlayer[pl].stat.scores, maxvalue);
      [*] = ;            if (maxvalue=0) then
      [*] = ;            maxvalue := 1; // fix div 0
      [*] = ;         end;
      [*] = ;
      [*] = ;         for pl:=0 to gc_MaxPlayerCount-2 do
      [*] = ;         begin
      [*] = ;            if (gPlayer[pl].bexists) or (gPlayer[pl].victorystate<>gc_player_victorystate_none) then
      [*] = ;            begin
      [*] = ;               procedure DrawLine(var list : TIntegerList; elmParent, maxvalue, color : Integer);
      [*] = ;               begin
      [*] = ;                  var prevy : Integer;
      [*] = ;                  var mat : String = 'icons.keycolor.'+IntToStr(color+1);
      [*] = ;                  var count : Integer = list.GetCount;
      [*] = ;                  var fstep : Float = (count/paperwidth);
      [*] = ;                  var i, j : Integer;
      [*] = ;                  for i:=0 to (paperwidth-cBasePaddingX+2)-1 do
      [*] = ;                  begin
      [*] = ;                     var find : Float = fstep*i;
      [*] = ;                     var nextind : Integer = floor(find);
      [*] = ;                     var prevind : Integer = Max(nextind-1, 0);
      [*] = ;                     var nextval : Integer = list.Get(nextind);
      [*] = ;                     var prevval : Integer = list.Get(prevind);
      [*] = ;                     var weight : Float = find-nextind;
      [*] = ;                     var val : Float = Lerp(prevval, nextval, weight);
      [*] = ;                     var x : Integer = cBaseOffX+cBasePaddingX+i;
      [*] = ;                     var y : Integer = cBaseOffY-round((val/maxvalue)*paperheight);
      [*] = ;                     var dotwidth : Integer = 2;
      [*] = ;                     var dotheight : Integer = 2;
      [*] = ;                     var absdelta : Integer;
      [*] = ;                     if (i>0) then
      [*] = ;                     begin
      [*] = ;                        var delta : Float = y-prevy;
      [*] = ;                        absdelta := round(Abs(delta));
      [*] = ;                        if ((delta>0) and (absdelta>=0)) or ((delta<0) and (absdelta>=dotheight)) then
      [*] = ;                        begin
      [*] = ;                           dotheight := absdelta;
      [*] = ;                           if delta>0 then
      [*] = ;                           absdelta := 0
      [*] = ;                           else
      [*] = ;                           if delta<0 then
      [*] = ;                           absdelta := absdelta;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;                     prevy := y;
      [*] = ;
      [*] = ;                     // look forward
      [*] = ;                     if (dotheight=2) then
      [*] = ;                     begin
      [*] = ;                        var prevfutureind : Integer = nextind;
      [*] = ;                        if (i<paperwidth-1) then
      [*] = ;                        for j:=i+1 to (paperwidth-cBasePaddingX)-1 do
      [*] = ;                        begin
      [*] = ;                           var futureind : Integer = floor(fstep*j);
      [*] = ;                           prevfutureind := futureind;
      [*] = ;                           var futureval : Integer = list.Get(futureind);
      [*] = ;                           var futurey : Integer = cBaseOffY-round((futureval/maxvalue)*paperheight);
      [*] = ;                           if (futurey<>y) then
      [*] = ;                           begin
      [*] = ;                              dotwidth := Max(2, (j-i));
      [*] = ;                              i := j-1;
      [*] = ;                              break;
      [*] = ;                           end;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;
      [*] = ;                     _gui_CreateImage('', elmParent, mat, gc_halParentLeft, gc_valParentBottomHeight, x, y+absdelta, dotwidth, dotheight, 0, False);
      [*] = ;                  end;
      [*] = ;                  {for i:=0 to count-1 do
      [*] = ;                  begin
      [*] = ;                     var val : Integer = list.Get(i);
      [*] = ;                     var x : Integer = cBaseOffX+round(fstep*i);
      [*] = ;                     var y : Integer = cBaseOffY-round((val/maxvalue)*paperheight);
      [*] = ;                     _gui_CreateImage('', elmParent, mat, gc_halParentLeft, gc_valParentBottomHeight, x, y, 2, 2, 0, False);
      [*] = ;                  end;}
      [*] = ;               end;
      [*] = ;               if (gInterface.statpage=gc_gui_statpage_population) then
      [*] = ;               DrawLine(gPlayer[pl].stat.population, elmChart, maxvalue, gMap.players[pl].color)
      [*] = ;               else
      [*] = ;               DrawLine(gPlayer[pl].stat.scores, elmChart, maxvalue, gMap.players[pl].color);
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;         DrawGrid(elmChart, maxvalue, gInterface.statpage=gc_gui_statpage_scores);
      [*] = ;      end;
      [*] = ;      ShowChart;
      [*] = ;      // chart finish
      [*] = ;
      [*] = ;      const cMinStep = 2;
      [*] = ;      const cMarginLeft = 100;
      [*] = ;
      [*] = ;      var gametime : Float = GetGameTime;
      [*] = ;      var pl, plenum : Integer;
      [*] = ;      for pl:=0 to gc_MaxPlayerCount-1 do
      [*] = ;      //for pl:=gc_MaxPlayerCount-1 downto 0 do
      [*] = ;      begin
      [*] = ;         if (gPlayer[pl].bexists) or (gPlayer[pl].victorystate<>gc_player_victorystate_none) then
      [*] = ;         begin
      [*] = ;            var elm : Integer = _gui_CreateImage('bck'+IntToStr(pl), elmUpgrades, gc_gui_material_white, gc_halParentLeft, gc_valParentTop, cMarginLeft, plenum*(cIconSize+cMargin)-2, cWidth-117-cMarginLeft, cIconSize+4, 0, bupdate);
      [*] = ;            var usercolor : Float = 0.0;
      [*] = ;            SetGUIElementUseUserColor(elm, True);
      [*] = ;            SetGUIElementUserColor(elm, usercolor, usercolor, usercolor, 0.7);
      [*] = ;
      [*] = ;            var name : String;
      [*] = ;            if (gMap.players[pl].name<>'') then
      [*] = ;            name := gMap.players[pl].name
      [*] = ;            else
      [*] = ;            if (gMap.players[pl].bai) then
      [*] = ;            name := GetLocaleTableListItemByID('gui', 'difficulty.'+IntToStr(gMap.players[pl].aidifficulty+1))
      [*] = ;            else
      [*] = ;            name := 'unknown';
      [*] = ;            var elmHnd : Integer = _gui_CreateText('pl'+IntToStr(pl), elmUpgrades, name, gc_halParentLeft, gc_valParentTop, 0, 34+plenum*(cIconSize+cMargin)-24, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;            //_gui_CreateImage('plcol'+IntToStr(pl), elmHnd, 'icons.keycolor.14', gc_halParentLeft, gc_valParentTop, 0, 0, 10, 10, 0, bupdate);
      [*] = ;            _gui_CreateImage('plcol'+IntToStr(pl), elmHnd, 'icons.keycolor.'+IntToStr(gMap.players[pl].color+1), gc_halParentLeft, gc_valParentTop, -13, 7, 8, 8, 0, bupdate);
      [*] = ;
      [*] = ;            var idlist, timelist : TIntegerList;
      [*] = ;            for i:=0 to gc_MaxCountryCount-1 do
      [*] = ;            for j:=0 to gc_country_maxupgradecount-1 do
      [*] = ;            begin
      [*] = ;               if (gPlayer[pl].upgstate[i][j].done) then
      [*] = ;               begin
      [*] = ;                  var timedone : Float = gPlayer[pl].upgstate[i][j].timedone;
      [*] = ;                  if (timedone>0) and (gCountry[i].upgrade[j].level<=2) and (gCountry[i].upgrade[j].itype<>gc_upg_type_damage) and (gCountry[i].upgrade[j].itype<>gc_upg_type_protection) then
      [*] = ;                  begin
      [*] = ;                     idlist.Add(i*gc_country_maxupgradecount+j);
      [*] = ;                     timelist.Add(floor(timedone*10000));
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            if (timelist.GetCount>0) then
      [*] = ;            begin
      [*] = ;               _misc_SortIntegerLists2D(timelist, idlist, False);
      [*] = ;
      [*] = ;               var prevx : Integer = -100;
      [*] = ;               var newx : Integer;
      [*] = ;               for i:=0 to idlist.GetCount-1 do
      [*] = ;               begin
      [*] = ;                  var packedid : Integer = idlist.Get(i);
      [*] = ;                  var cid : Integer = packedid div gc_country_maxupgradecount;
      [*] = ;                  var id : Integer = packedid mod gc_country_maxupgradecount;
      [*] = ;                  var time : Float = timelist.Get(i)/10000;
      [*] = ;                  var upgsid : String = gPlayer[pl].upgstate[cid][id].sid;
      [*] = ;                  var txtName : String;
      [*] = ;                  _country_GetUpgradeNameBySID(cid, upgsid, txtName);
      [*] = ;                  txtName := StrReplace(txtName, '%value%', FloatToStr(gCountry[cid].upgrade[id].value));
      [*] = ;                  var hint : String = gUIConst.fontstyle[gc_font_serif_14]+gc_font_color_white+txtName;
      [*] = ;                  var icon : String = 'noname';
      [*] = ;                  _misc_GetUpgradeIconNameBySID(upgsid, icon);
      [*] = ;                  newx := cMarginLeft+round((cWidth-117-cMarginLeft-cIconSize)*(time/gametime));
      [*] = ;                  if ((newx-prevx)<cMinStep) then
      [*] = ;                  newx := prevx+cMinStep;
      [*] = ;                  newx := ClampInt(newx, 0, cWidth-117-cIconSize);
      [*] = ;                  prevx := newx;
      [*] = ;                  elmHnd := _gui_CreateImageActive('sup_'+IntToStr(pl)+'_'+IntToStr(cid)+'_'+IntToStr(id), elmUpgrades, icon, gc_halParentLeft, gc_valParentTop, newx, plenum*(cIconSize+cMargin), cIconSize, cIconSize, 0, eventstate, hint, bupdate);
      [*] = ;                  //SetGUIElementUserBlend(elmHnd, 0.7);
      [*] = ;                  SetGUIElementUseUserColor(elmHnd, True);
      [*] = ;                  SetGUIElementUserColor(elmHnd, 0.65, 0.65, 0.65, 1);
      [*] = ;                  var level : Integer = gCountry[cid].upgrade[id].level;
      [*] = ;                  if (level>1) then
      [*] = ;                  _gui_CreateImage('lev', elmHnd, 'icons.num.small.'+IntToStr(level), gc_halParentRightWidth, gc_valParentBottomHeight, -3, -5, 0, 0, 0, bupdate);
      [*] = ;               end;
      [*] = ;
      [*] = ;               for i:=0 to gc_MaxCountryCount-1 do
      [*] = ;               for j:=0 to gc_country_maxupgradecount-1 do
      [*] = ;               begin
      [*] = ;                  if (gPlayer[pl].upgstate[i][j].done) then
      [*] = ;                  begin
      [*] = ;                     var timedone : Float = gPlayer[pl].upgstate[i][j].timedone;
      [*] = ;                     if (timedone>0) then
      [*] = ;                     begin
      [*] = ;                        {var upgsid : String = gPlayer[pl].upgstate[i][j].sid;
      [*] = ;                        var txtName : String;
      [*] = ;                        _country_GetUpgradeNameBySID(i, upgsid, txtName);
      [*] = ;                        txtName := StrReplace(txtName, '%value%', FloatToStr(gCountry[i].upgrade[j].value));
      [*] = ;                        var hint : String = gUIConst.fontstyle[gc_font_serif_14]+gc_font_color_white+txtName;
      [*] = ;                        var icon : String = 'noname';
      [*] = ;                        _misc_GetUpgradeIconNameBySID(upgsid, icon);
      [*] = ;                        newx := round((cWidth-117-cIconSize)*(timedone/gametime));
      [*] = ;                        if ((newx-prevx)<cMinStep) then
      [*] = ;                        newx := prevx+cMinStep;
      [*] = ;                        prevx := newx;
      [*] = ;                        elmHnd := _gui_CreateImageActive('sup_'+IntToStr(pl)+'_'+IntToStr(i)+'_'+IntToStr(j), elmUpgrades, icon, gc_halParentLeft, gc_valParentTop, newx, plenum*(cIconSize+cMargin), cIconSize, cIconSize, 0, eventstate, hint, bupdate);
      [*] = ;                        var level : Integer = gCountry[i].upgrade[j].level;
      [*] = ;                        if (level>1) then
      [*] = ;                        _gui_CreateImage('l'+IntToStr(level), elmHnd, 'icons.num.small.'+IntToStr(level), gc_halParentRightWidth, gc_valParentBottomHeight, -3, -5, 0, 0, 0, bupdate);}
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;               end;
      [*] = ;            end;
      [*] = ;            plenum := plenum+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;case gInterface.statpage of
      [*] = ;   gc_gui_statpage_population : begin
      [*] = ;      //_gui_CreateText('tpopul', elmSkinHead, cTextPopulAndUpgrades, gc_halParentLeft, gc_valParentTop, 11, 1, GetGUIElementWidth(elmSkinHead), GetGUIElementHeight(elmSkinHead), gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;      _gui_CreateText('tpopul', elmChart, cTextPopulAndUpgrades, gc_halParentLeft, gc_valParentTop, 0, 9, GetGUIElementWidth(elmChart), GetGUIElementHeight(elmChart), gc_halMiddle, gc_valTop, gc_font_serif_13, color, bupdate);
      [*] = ;   end;
      [*] = ;   gc_gui_statpage_scores : begin
      [*] = ;      //_gui_CreateText('tpopul', elmSkinHead, cTextScoreDynamics, gc_halParentLeft, gc_valParentTop, 11, 1, GetGUIElementWidth(elmSkinHead), GetGUIElementHeight(elmSkinHead), gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;      _gui_CreateText('tpopul', elmChart, cTextScoreDynamics, gc_halParentLeft, gc_valParentTop, 0, 9, GetGUIElementWidth(elmChart), GetGUIElementHeight(elmChart), gc_halMiddle, gc_valTop, gc_font_serif_13, color, bupdate);
      [*] = ;   end;
      [*] = ;   gc_gui_statpage_tables : begin
      [*] = ;      const cScrollW = 22;
      [*] = ;      const cScrollWOff = cScrollW+4;
      [*] = ;      const cPadding = cmargin+1;
      [*] = ;      // select players list
      [*] = ;      var cListWidth : Integer = 220;
      [*] = ;
      [*] = ;      //var elmListBackground : Integer = _gui_CreateSkinWindow('back', elmParent, gc_halParentLeft, gc_valParentTop, -cScrollWOff div 2, 0, cListWidth, 200, 1, bupdate);
      [*] = ;      const cPlayersListMarginTop = 14;
      [*] = ;      const cPlayersListMarginBotton = 14;
      [*] = ;      const cPlayersListRowHeight = 25;
      [*] = ;      var cPlayersListBackgroundHeight : Integer = cPlayersListMarginTop+cPlayersListRowHeight*8+cPlayersListMarginBotton;
      [*] = ;      var elmPlayersListBackground : Integer = _gui_CreateSkinWindow('descr', elmParent, gc_halParentLeft, gc_valParentTop, 60, 92+4, cListWidth, cPlayersListBackgroundHeight, 1, bupdate);
      [*] = ;
      [*] = ;      elmHnd := _gui_CreateSkinHeadWindow('sh_0', elmPlayersListBackground, gc_halParentLeft, gc_valParentTop, 0, -32, cWidth-117, bupdate);
      [*] = ;      _gui_CreateText('tplayers', elmHnd, cTextPlayers, gc_halParentLeft, gc_valParentTop, 11, 1, GetGUIElementWidth(elmHnd), GetGUIElementHeight(elmHnd), gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;      var nickW : Integer = GetGUIElementWidth(elmPlayersListBackground)-cPadding-cScrollW;
      [*] = ;      var cTextSelectHead : String;
      [*] = ;      _gui_CreateText('thead', elmHnd, cTextSelectHead, gc_halParentLeft, gc_valParentMiddle, cPadding, 2, GetGUIElementWidth(elmHnd), 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;
      [*] = ;      var elmList : Integer = _gui_CreateListBox('players', elmPlayersListBackground, gc_halParentLeft, gc_valParentTop, 2, 10, cListWidth-cPadding*2+cPadding-2+cScrollWOff, cPlayersListRowHeight*plcount+5, gc_halLeft, gc_valMiddle, 0, 0, gc_font_serif_12, eventstate, False, bupdate);
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 10, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, cPadding-2+4, 'tsImage'{'tsText'});
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, cPadding, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 200, 'tsText');
      [*] = ;      SetGUIListBoxMouseTrack(elmList, 1); // 1 - only text change color on hover, 2 - only material appears, 3 - text and material on hover
      [*] = ;      GUIListBoxClearSilent(elmList);
      [*] = ;
      [*] = ;      var plInd : Integer = gInterface.statplayer;
      [*] = ;      var selind : Integer;
      [*] = ;      var plenum : Integer;
      [*] = ;      for i:=0 to gc_MaxPlayerCount-1 do
      [*] = ;      begin
      [*] = ;         var bshow : Boolean = (gPlayer[i].bexists) or (gPlayer[i].victorystate<>gc_player_victorystate_none);
      [*] = ;         if (bshow) then
      [*] = ;         begin
      [*] = ;            var name : String;
      [*] = ;            if (gMap.players[i].name<>'') then
      [*] = ;            name := gMap.players[i].name
      [*] = ;            else
      [*] = ;            if (gMap.players[i].bai) then
      [*] = ;            name := GetLocaleTableListItemByID('gui', 'difficulty.'+IntToStr(gMap.players[i].aidifficulty+1))
      [*] = ;            else
      [*] = ;            name := 'unknown';
      [*] = ;
      [*] = ;            if (i=gInterface.statplayer) then
      [*] = ;            selind := i;
      [*] = ;            GUIListBoxAddItem(elmList, #9{+'icons.keycolor.'+IntToStr(gMap.players[i].color+1)}+#9+#9+name, i);
      [*] = ;
      [*] = ;            _gui_CreateImage('plcol'+IntToStr(i), elmPlayersListBackground, 'icons.keycolor.'+IntToStr(gMap.players[i].color+1), gc_halParentLeft, gc_valParentTop, 2+10, 10+9+plenum*25, 8, 8, 0, bupdate);
      [*] = ;            plenum := plenum+1;
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      SetGUIListBoxItemIndexSilent(elmList, selind);
      [*] = ;      // economy table
      [*] = ;      var font : Integer = gc_font_serif_12;
      [*] = ;      var lineheight : Integer = GetGUIElementFontHeight(gUIConst.font[font])+4;
      [*] = ;      var elmSkinHnd : Integer = _gui_CreateParent('sh_1', elmParent, gc_halParentLeft, gc_valParentTop, 241, 64, 0, 31, bupdate);
      [*] = ;      //_gui_CreateSkinHeadWindow('sh_1', elmParent, gc_halParentLeft, gc_valParentTop, 243, 64, 676+42, bupdate);
      [*] = ;      const cResWidth = 71+16;
      [*] = ;      const cBaseTextX = 56;
      [*] = ;      const cResBaseX = 340;
      [*] = ;      var ind : Integer;
      [*] = ;      for i:=1 to gc_ResCount-1 do
      [*] = ;      begin
      [*] = ;         if i=1 then ind := 2 else if i=2 then ind := 1 else ind := i;
      [*] = ;         var sval : String = GetLocaleTableListItemByID(gc_loc_gui, 'restype.'+IntToStr(ind));
      [*] = ;         _gui_CreateText('tres'+IntToStr(i), elmSkinHnd, sval, gc_halParentLeft, gc_valParentTop, cBaseTextX+cResBaseX+cResWidth*(i-1), 1, cResWidth, GetGUIElementHeight(elmSkinHnd), gc_halMiddle, gc_valMiddle, font, color, bupdate);
      [*] = ;      end;
      [*] = ;
      [*] = ;      var cTextEconomyResCurrent : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.rescurrent');
      [*] = ;      var cTextEconomyResTotal : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.restotal');
      [*] = ;      var cTextEconomyResUpgrades : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.resupgrades');
      [*] = ;      var cTextEconomyResMines : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.resmines');
      [*] = ;      var cTextEconomyResCreateUnits : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.rescreateunits');
      [*] = ;      var cTextEconomyResCreateBuildings : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.rescraetebuildings');
      [*] = ;      var cTextEconomyResMaintain : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.resmaintain');
      [*] = ;      var cTextEconomyResMarketBuy : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.resmarketbuy');
      [*] = ;      var cTextEconomyResMarketSell : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.resmarketsell');
      [*] = ;      procedure ShowResources(elmHnd : Integer; var parray : Pointer);
      [*] = ;      begin
      [*] = ;         var i, ind : Integer;
      [*] = ;         for i:=1 to gc_ResCount-1 do
      [*] = ;         begin
      [*] = ;            if i=1 then ind := 2 else if i=2 then ind := 1 else ind := i;
      [*] = ;            //var val : Integer = gPlayer[plInd].stat.restotal[ind];
      [*] = ;            var val : Integer = Integer(parray+ind*SizeOf(Integer));
      [*] = ;            var sval : String = IntToStr(val);
      [*] = ;            var len : Integer = StrLength(sval);
      [*] = ;            if (len>3) then
      [*] = ;            begin
      [*] = ;               var a : String = SubStr(sval, 1, len-3);
      [*] = ;               var b : String = SubStr(sval, len-2, 3);
      [*] = ;               sval := a+'.'+b;
      [*] = ;            end;
      [*] = ;            if (len>6) then
      [*] = ;            begin
      [*] = ;               var a : String = SubStr(sval, 1, len-6);
      [*] = ;               var b : String = SubStr(sval, len-5, 7);
      [*] = ;               sval := a+'.'+b;
      [*] = ;            end;
      [*] = ;            var elm : Integer = _gui_CreateText('tres'+IntToStr(i), elmHnd, sval, gc_halParentLeft, gc_valParentTop, cResBaseX+cResWidth*(i-1), 0, cResWidth, lineheight, gc_halMiddle, gc_valMiddle, font, color, bupdate);
      [*] = ;            SetGUIElementVisible(elm, (val>0));
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      elmHnd := _gui_CreateText('trestotal', elmSkinHnd, cTextEconomyResTotal, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*0, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      var p : Pointer = gPlayer[plInd].stat.restotal; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('tresupgrades', elmSkinHnd, cTextEconomyResUpgrades, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*1, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resonupgrade; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('tresmines', elmSkinHnd, cTextEconomyResMines, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*2, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resonmines; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('trescreateunits', elmSkinHnd, cTextEconomyResCreateUnits, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*3, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resonunits; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('trescreatebuildings', elmSkinHnd, cTextEconomyResCreateBuildings, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*4, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resonbuildings; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('tresmaintain', elmSkinHnd, cTextEconomyResMaintain, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*5, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resonlife; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('tresmarketbuy', elmSkinHnd, cTextEconomyResMarketBuy, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*6, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.resbuy; ShowResources(elmHnd, p);
      [*] = ;      elmHnd := _gui_CreateText('tresmarketsell', elmSkinHnd, cTextEconomyResMarketSell, gc_halParentLeft, gc_valParentTop, cBaseTextX, 44+lineheight*7, 674, lineheight, gc_halLeft, gc_valMiddle, font, color, bupdate);
      [*] = ;      p := gPlayer[plInd].stat.ressell; ShowResources(elmHnd, p);
      [*] = ;
      [*] = ;      // units table
      [*] = ;      elmSkinHnd := _gui_CreateSkinHeadWindow('sh_2', elmParent, gc_halParentLeft, gc_valParentTop, 60, 324, cWidth-117, bupdate);
      [*] = ;      var cTextCategoryUnits : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listunits');
      [*] = ;      var cTextCategoryShips : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listships');
      [*] = ;      var cTextCategoryArtillery : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listartillery');
      [*] = ;      var cTextCategoryBuildings : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listbuildings');
      [*] = ;      var cTextProducedList : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listunitscreated');
      [*] = ;      var cTextKilledList : String = GetLocaleTableListItemByID('misc', 'endgamestatistics.listunitslost');
      [*] = ;      procedure ShowUnitInList(elmList, plInd, cid, id, count, category : Integer; var categorytext : String; var ind : Integer);
      [*] = ;      begin
      [*] = ;         var bok : Boolean;
      [*] = ;         case category of
      [*] = ;            0 : if (not gObjProp[cid, id].bbuilding) and (gObjProp[cid, id].media<>gc_obj_media_water) and (not gObjProp[cid, id].bartillery) then bok := True;
      [*] = ;            1 : if (gObjProp[cid, id].media=gc_obj_media_water) then bok := True;
      [*] = ;            2 : if (gObjProp[cid, id].bartillery) then bok := True;
      [*] = ;            3 : if (gObjProp[cid, id].bbuilding) then bok := True;
      [*] = ;         end;
      [*] = ;         if bok then
      [*] = ;         begin
      [*] = ;            if (categorytext<>'') then
      [*] = ;            begin
      [*] = ;               GUIListBoxAddItem(elmList, #9+#9+'              '+gc_font_color_white+categorytext+#9, -category);
      [*] = ;               //GUIListBoxAddItem(elmList, #9+''+gc_font_color_white+categorytext+#9+#9, -category);
      [*] = ;               categorytext := '';
      [*] = ;            end;
      [*] = ;            var csid : String;
      [*] = ;            _country_GetSIDByID(cid, csid);
      [*] = ;            var ttext : String = gc_loc_units+'|'+csid;
      [*] = ;            var textCountry : String;
      [*] = ;            _misc_StringToText(ttext, textCountry);
      [*] = ;            var sid : String;
      [*] = ;            _unit_ConvertObjIDToSID(cid, id, sid);
      [*] = ;            var sname, scount : String;
      [*] = ;            _misc_GetUnitNameBySID(sid, sname);
      [*] = ;            scount := IntToStr(count);
      [*] = ;            //GUIListBoxAddItem(elmList, #9+sname+#9+textCountry+#9+' '+scount, ind);
      [*] = ;            GUIListBoxAddItem(elmList, #9+'%color(786040)%'+textCountry+#9+sname+#9+' '+scount, ind);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      // created
      [*] = ;      const cBaseWidth = 432+110;
      [*] = ;      var tw : Integer = _gui_GetFontTextWidth(cTextProducedList, gc_font_serif_12);
      [*] = ;      _gui_CreateText('tproduced', elmSkinHnd, cTextProducedList, gc_halParentLeft, gc_valParentTop, (cBaseWidth div 2)-(tw div 2), 1, 0, GetGUIElementHeight(elmSkinHnd), gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;      var elmProduce : Integer = _gui_CreateParent('produce', elmParent, gc_halParentLeft, gc_valParentTop, 56, 324, (cWidth-117) div 2, 11*25, False{bupdate});
      [*] = ;
      [*] = ;      elmList := _gui_CreateListBox('created', elmProduce, gc_halParentLeft, gc_valParentTop, 0, 34, cBaseWidth+8, 11*26, gc_halLeft, gc_valMiddle, 0, 0, gc_font_serif_12, eventstate, True, bupdate);
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 12, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 150, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, cBaseWidth-212, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 32, 'tsText');
      [*] = ;      SetGUIListBoxMouseTrack(elmList, 1); // 1 - only text change color on hover, 2 - only material appears, 3 - text and material on hover
      [*] = ;      SetGUIListBoxSelectedMaterialName(elmList, gc_gui_material_blank); // selected
      [*] = ;      GUIListBoxClearSilent(elmList);
      [*] = ;
      [*] = ;      ind := 0;
      [*] = ;      var category, cid, id : Integer;
      [*] = ;      for category:=0 to 3 do
      [*] = ;      begin
      [*] = ;         var categorytext : String;
      [*] = ;         case category of
      [*] = ;            0 : categorytext := cTextCategoryUnits;
      [*] = ;            1 : categorytext := cTextCategoryShips;
      [*] = ;            2 : categorytext := cTextCategoryArtillery;
      [*] = ;            3 : categorytext := cTextCategoryBuildings;
      [*] = ;         end;
      [*] = ;         for cid:=0 to gc_MaxCountryCount-1 do
      [*] = ;         for id:=0 to gc_country_maxmembers-1 do
      [*] = ;         begin
      [*] = ;            if (gPlayer[plInd].stat.produced[cid][id]>0) then
      [*] = ;            ShowUnitInList(elmList, plInd, cid, id, gPlayer[plInd].stat.produced[cid][id], category, categorytext, ind);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      var bNeedScroll : Boolean = _gui_SetListBoxHeight(elmList, 11);
      [*] = ;      _gui_AddScroller(elmList, gc_halParentRightWidth, gc_valParentTop, 21, 21, 0, GetGUIElementHeight(elmProduce), bNeedScroll);
      [*] = ;
      [*] = ;      // killed
      [*] = ;      tw := _gui_GetFontTextWidth(cTextKilledList, gc_font_serif_12);
      [*] = ;      _gui_CreateText('tkilled', elmSkinHnd, cTextKilledList, gc_halParentLeft, gc_valParentTop, cBaseWidth+(cBaseWidth div 2)-(tw div 2), 1, 0, GetGUIElementHeight(elmSkinHnd), gc_halLeft, gc_valMiddle, gc_font_serif_12, color, bupdate);
      [*] = ;      var elmKilled : Integer = _gui_CreateParent('killed', elmParent, gc_halParentLeft, gc_valParentTop, 10+56+cBaseWidth+21, 324, (cWidth-117) div 2, 11*25, False{bupdate});
      [*] = ;
      [*] = ;      elmList := _gui_CreateListBox('killed', elmKilled, gc_halParentLeft, gc_valParentTop, 0, 34, cBaseWidth+8, 276, gc_halLeft, gc_valMiddle, 0, 0, gc_font_serif_12, eventstate, True, bupdate);
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 12, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 150, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, cBaseWidth-212, 'tsText');
      [*] = ;      AddGUIListBoxTabProperty(elmList, 1, 1, 1, 1, 32, 'tsText');
      [*] = ;      SetGUIListBoxMouseTrack(elmList, 1); // 1 - only text change color on hover, 2 - only material appears, 3 - text and material on hover
      [*] = ;      SetGUIListBoxSelectedMaterialName(elmList, gc_gui_material_blank); // selected
      [*] = ;      GUIListBoxClearSilent(elmList);
      [*] = ;
      [*] = ;      ind := 0;
      [*] = ;      for category:=0 to 3 do
      [*] = ;      begin
      [*] = ;         var categorytext : String;
      [*] = ;         case category of
      [*] = ;            0 : categorytext := cTextCategoryUnits;
      [*] = ;            1 : categorytext := cTextCategoryShips;
      [*] = ;            2 : categorytext := cTextCategoryArtillery;
      [*] = ;            3 : categorytext := cTextCategoryBuildings;
      [*] = ;         end;
      [*] = ;         for cid:=0 to gc_MaxCountryCount-1 do
      [*] = ;         for id:=0 to gc_country_maxmembers-1 do
      [*] = ;         begin
      [*] = ;            if (gPlayer[plInd].stat.killed[cid][id]>0) then
      [*] = ;            ShowUnitInList(elmList, plInd, cid, id, gPlayer[plInd].stat.killed[cid][id], category, categorytext, ind);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;      bNeedScroll := _gui_SetListBoxHeight(elmList, 11);
      [*] = ;      _gui_AddScroller(elmList, gc_halParentRightWidth, gc_valParentTop, 21, 21, 0, GetGUIElementHeight(elmKilled), bNeedScroll);
      [*] = ;      {for i:=0 to gc_MaxCountryCount-1 do
      [*] = ;      for j:=0 to gc_country_maxmembers-1 do
      [*] = ;      if (gPlayer[plInd].stat.killed[i][j]>0) then
      [*] = ;      log('cid='+IntToStr(i)+' id='+IntToStr(j)+' sid='+gObjProp[i][j].sid+' count = '+IntToStr(gPlayer[plInd].stat.killed[i][j]));}
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;//ShowButton
      [*] = ;const btnwidth = 268+38;
      [*] = ;var posX : Integer = -2*floor(btnwidth/2);
      [*] = ;var posY : Integer = -43-16+16;
      [*] = ;
      [*] = ;var hint : String;
      [*] = ;var elmBtnPrev : Integer = _gui_CreateImage('_img_btnprev', elmParent, gc_hud_icons_control+'hideobjectives', gc_halParentLeft, gc_valParentBottomHeight, 58+78, posY, 0, 0, 0, True);
      [*] = ;elmHnd := _gui_CreateButton('swobj', elmBtnPrev, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, GetGUIElementWidth(elmBtnPrev), GetGUIElementHeight(elmBtnPrev), eventstate, hint, cTagPrev, True);
      [*] = ;if (gInterface.statpage=gc_gui_statpage_population) then
      [*] = ;begin
      [*] = ;   SetGUIElementUserBlend(elmBtnPrev, 0.35);
      [*] = ;   SetGUIElementEnabled(elmHnd, False);
      [*] = ;end;
      [*] = ;
      [*] = ;var elmBtnNext : Integer = _gui_CreateImage('_img_btnnext', elmParent, gc_hud_icons_control+'showobjectives', gc_halParentRightWidth, gc_valParentBottomHeight, -58-78, posY, 0, 0, 0, True);
      [*] = ;elmHnd := _gui_CreateButton('swobj', elmBtnNext, gc_gui_material_blank, gc_halParentLeft, gc_valParentTop, 0, 0, GetGUIElementWidth(elmBtnNext), GetGUIElementHeight(elmBtnNext), eventstate, hint, cTagNext, True);
      [*] = ;if (gInterface.statpage=gc_gui_statpage_tables) then
      [*] = ;begin
      [*] = ;   SetGUIElementUserBlend(elmBtnNext, 0.35);
      [*] = ;   SetGUIElementEnabled(elmHnd, False);
      [*] = ;end;
      [*] = ;
      [*] = ;elmHnd := _gui_CreateButton('bbacktogame', elmParent, 'btn.medium', gc_halParentMiddle, gc_valParentBottomHeight, posX, posY, 0, 0, eventstate, nul, cTagBackToGame, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextBackToGame, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;
      [*] = ;{elmHnd := _gui_CreateButton('breplay', elmParent, 'btn.medium', gc_halParentMiddle, gc_valParentBottomHeight, posX+btnwidth, posY, 0, 0, eventstate, nul, cTagReplay, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextReplay, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;SetGUIElementEnabled(elmHnd, not _net_IsOnline);}
      [*] = ;
      [*] = ;elmHnd := _gui_CreateButton('breplay', elmParent, 'btn.small', gc_halParentMiddle, gc_valParentBottomHeight, posX+btnwidth-93, posY-3, 0, 0, eventstate, nul, cTagReplay, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextReplay, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;SetGUIElementEnabled(elmHnd, (not _net_IsOnline) and (gInterface.gamemode<>gc_gamemode_editor));
      [*] = ;
      [*] = ;elmHnd := _gui_CreateButton('bsavereplay', elmParent, 'btn.small', gc_halParentMiddle, gc_valParentBottomHeight, posX+btnwidth+93+1, posY-3, 0, 0, eventstate, nul, cTagSaveReplay, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextSaveReplay, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;//SetGUIElementEnabled(elmHnd, not _net_IsOnline);
      [*] = ;//SetGUIElementEnabled(elmHnd, False); // not yet ready
      [*] = ;
      [*] = ;elmHnd := _gui_CreateButton('bexittomainmenu', elmParent, 'btn.medium', gc_halParentMiddle, gc_valParentBottomHeight, posX+btnwidth*2, posY, 0, 0, eventstate, nul, cTagExitToMenu, bupdate);
      [*] = ;_gui_CreateText('txtbtn', elmHnd, cTextExitToMenu, gc_halParentMiddle, gc_valParentMiddle, 0, 0, 0, 0, gc_halLeft, gc_valMiddle, gc_font_serif_13, color, bupdate);
      [*] = ;// body finish
      [*] = ;
      [*] = ;// background
      [*] = ;maxheight := Max(maxheight, _gui_GetBottomPos(elmHnd)+cmargin*7);
      [*] = ;var elmBackground : Integer = _gui_CreateMainWindow('background', elmBackgroundParent, gc_halParentMiddle, gc_valParentMiddle, 0, 0, cwidth, cheight, 1, bupdate);
      [*] = ;SetGUIElementPositionY(elmBackgroundParent, 0);
      [*] = ;//_gui_CreateButton('bback', elmBackground, 'btn.close', gc_halParentRightWidth, gc_valParentTop, 4, -4, 0, 0, eventstate, nul, gc_gui_event_tagClose, bupdate);
      [*] = ;
      [*] = ;// head
      [*] = ;elmHnd := GetGUIElementIndexByNameParent('head.head', elmBackground);
      [*] = ;elmHnd := _gui_CreateText('thead', elmHnd, cTextStatistics, gc_halParentMiddle, gc_valParentMiddle, 9, 3, 0, 28, gc_halMiddle, gc_valMiddle, gc_font_serif_16, color, bupdate);
      [*] = ;
      [*] = ;{
      [*] = ;Log('upgradedone: current gametime = '+FloatToStr(GetGameTime));
      [*] = ;for i:=0 to gc_MaxCountryCount-1 do
      [*] = ;for j:=0 to gc_country_maxupgradecount-1 do
      [*] = ;begin
      [*] = ;   if (gPlayer[plInd].upgstate[i][j].done) then
      [*] = ;   begin
      [*] = ;      var timedone : Float = gPlayer[plInd].upgstate[i][j].timedone;
      [*] = ;      if (timedone>0) then
      [*] = ;      begin
      [*] = ;         log('cid='+IntToStr(i)+' id='+IntToStr(j)+' upgsid='+gCountry[i].upgrade[j].id+' timedone = '+FloatToStr(timedone));
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
   struct.end
section.end

