section.begin
   Name = EventChatConsole
   Code : struct.begin
      [*] = ;const cSpaceChar  = 32; // space
      [*] = ;const cQuoteChar  = 34; // "
      [*] = ;const cEscChar    = 27; // Escape
      [*] = ;const cReturnChar = 13; // Enter or Return
      [*] = ;const cUpChar     = 38; // key up
      [*] = ;const cDownChar   = 40; // key down
      [*] = ;
      [*] = ;var elmHnd : Integer = GetIntValueByName('ElementHandle');
      [*] = ;var press : String = GetValueByName('Press');
      [*] = ;var tag : Integer = GetIntValueByName('Tag');
      [*] = ;
      [*] = ;var status : String = GetValueByName('Status');
      [*] = ;if (status='shortcut') or (status='key') then // to prevent invalid handle here
      [*] = ;elmHnd := 0;
      [*] = ;
      [*] = ;const currentstatename = 'EventChatConsole';
      [*] = ;var elmname, showstate, eventstate : String;
      [*] = ;_misc_GetGUIShowEventStateNames(currentstatename, elmname, showstate, eventstate);
      [*] = ;var inputhnd : Integer = GetGUIElementIndexByNameParent(elmname+'.input.text', _gui_GetTop);
      [*] = ;case status of
      [*] = ;   'shortcut' : begin
      [*] = ;      //Log('Console key: '+GetValueByName('Key'));
      [*] = ;      case GetValueByName('Key') of
      [*] = ;         'escape' : tag := gc_gui_event_tagClose;
      [*] = ;         'return' : tag := gc_gui_hotkey_btnEnter;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;   'button' : begin
      [*] = ;      if (press='c') then
      [*] = ;      SetGUIElementFocusedHandle(elmHnd);
      [*] = ;   end;
      [*] = ;   'key' : begin
      [*] = ;      if (press='d') then
      [*] = ;      begin
      [*] = ;         case tag of
      [*] = ;            cReturnChar : begin
      [*] = ;               var sTo : String;
      [*] = ;               var inputtext : String;
      [*] = ;               if (inputhnd<>0) then
      [*] = ;               inputtext := GetGUIElementText(inputhnd);
      [*] = ;               if (inputtext<>'') then
      [*] = ;               begin
      [*] = ;                  const mode = gc_chatmessage_mode_all;
      [*] = ;                  var msg : String = inputtext;
      [*] = ;                  if (_net_IsOnline) then
      [*] = ;                  begin
      [*] = ;                     var idTo : Integer;
      [*] = ;                     var bsend : Boolean;
      [*] = ;                     var bnotvalid : Boolean;
      [*] = ;                     var firstword : String = GetDelimiterStringByIndex(inputtext, 32, gc_gui_quotechar, 0);
      [*] = ;                     var second : String;
      [*] = ;                     case firstword of
      [*] = ;                        '/whisper', '/w' : begin
      [*] = ;                           second := GetDelimiterStringByIndex(inputtext, 32, gc_gui_quotechar, 1);
      [*] = ;                           if (second<>'') then
      [*] = ;                           begin
      [*] = ;                              var offset : Integer = StrLength(firstword)+StrLength(second)+2;
      [*] = ;                              msg := SubStr(inputtext, offset+1, StrLength(inputtext)-offset);
      [*] = ;                              if (msg<>'') then
      [*] = ;                              begin
      [*] = ;                                 var pclient : Pointer = gInternetShell.clients.GetByNick(second);
      [*] = ;                                 if (pclient<>nil) then
      [*] = ;                                 begin
      [*] = ;                                    idTo := TInternetShellClient(pclient).lanid;
      [*] = ;                                    sTo := TInternetShellClient(pclient).nick;
      [*] = ;                                    bsend := True;
      [*] = ;                                    gint_gui_chatmessagemode := gc_chatmessage_mode_private;
      [*] = ;                                 end
      [*] = ;                                 else
      [*] = ;                                 begin
      [*] = ;                                    bnotvalid := True;
      [*] = ;                                    msg := '';
      [*] = ;                                 end;
      [*] = ;                              end
      [*] = ;                              else
      [*] = ;                              bnotvalid := True;
      [*] = ;                           end;
      [*] = ;                        end;
      [*] = ;                        'net' : begin
      [*] = ;                           second := GetDelimiterStringByIndex(inputtext, 32, gc_gui_quotechar, 1);
      [*] = ;                           if (second='msg') then
      [*] = ;                           begin
      [*] = ;                              //msg := SubStr(msg, 9, StrLength(msg)-7);
      [*] = ;                              bsend := false;
      [*] = ;                           end
      [*] = ;                           else
      [*] = ;                           if (second<>'log') then
      [*] = ;                           bsend := True
      [*] = ;                           else
      [*] = ;                           begin
      [*] = ;                              var lanInd : Integer = _misc_GetMapPlayerIndexByLanID(gInternetShell.lanid);
      [*] = ;                              var name : String ;
      [*] = ;                              if (lanInd>=0) then
      [*] = ;                              name := gMap.players[lanInd].name;
      [*] = ;                              gChatMessages.Add(gint_gui_chatmessagemode, name, sTo, msg);
      [*] = ;                           end;
      [*] = ;                        end;
      [*] = ;                        else
      [*] = ;                        bsend := True;
      [*] = ;                     end;
      [*] = ;                     if (bnotvalid) then
      [*] = ;                     begin
      [*] = ;                        idTo := gInternetShell.lanid;
      [*] = ;                        msg := GetLocaleTableListItemByID('gui', 'internet.msg.nowhisperuser');
      [*] = ;                        msg := StrReplace(msg, '%nick%', second);
      [*] = ;                        msg := StrReplace(msg, '%color%', gc_font_color_orange);
      [*] = ;                        msg := StrReplace(msg, '%colordefault%', gc_font_color_default);
      [*] = ;                        var lanInd : Integer = _misc_GetMapPlayerIndexByLanID(gInternetShell.lanid);
      [*] = ;                        var name : String ;
      [*] = ;                        if (lanInd>=0) then
      [*] = ;                        name := gMap.players[lanInd].name;
      [*] = ;                        gChatMessages.Add(gint_gui_chatmessagemode, name, sTo, msg);
      [*] = ;                     end;
      [*] = ;                     if (bsend) then
      [*] = ;                     LanPublicServerSendSessionMessage(idTo, IntToStr(gint_gui_chatmessagemode)+gc_gui_delimitercharstr+msg);
      [*] = ;                  end
      [*] = ;                  else
      [*] = ;                  begin
      [*] = ;                     var name : String;
      [*] = ;                     if _net_IsOffline then
      [*] = ;                     name := gProfile.name
      [*] = ;                     else
      [*] = ;                     begin
      [*] = ;                        var iopl : Integer = GetPlayerIndexByHandle(GetPlayerHandleInterfaceIO);
      [*] = ;                        if (iopl>=0) and (iopl<gc_MaxPlayerCount-1) then
      [*] = ;                        name := gMap.players[iopl].name;
      [*] = ;                     end;
      [*] = ;                     gChatMessages.Add(gint_gui_chatmessagemode, name, sTo, msg);
      [*] = ;                  end;
      [*] = ;                  var freeind : Integer = -1;
      [*] = ;                  var i : Integer;
      [*] = ;                  for i:=0 to gc_gui_maxchatlog-1 do
      [*] = ;                  begin
      [*] = ;                     if (gChatLog[i]='') then
      [*] = ;                     begin
      [*] = ;                        freeind := i;
      [*] = ;                        break;
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;                  if (freeind<0) then
      [*] = ;                  begin
      [*] = ;                     for i:=1 to gc_gui_maxchatlog-1 do
      [*] = ;                     gChatLog[i-1] := gChatLog[gc_gui_maxchatlog-1];
      [*] = ;                     freeind := gc_gui_maxchatlog-1;
      [*] = ;                  end;
      [*] = ;                  gChatLog[freeind] := inputtext;
      [*] = ;                  _misc_ProcessMessage(inputtext);
      [*] = ;               end;
      [*] = ;               SetGUIElementText(inputhnd, '');
      [*] = ;               SetGUIElementFocusedHandle(0);
      [*] = ;            end;
      [*] = ;            cEscChar : begin
      [*] = ;               press := 'c';
      [*] = ;               tag := gc_gui_hotkey_btnEscape;
      [*] = ;            end;
      [*] = ;         end;
      [*] = ;      end
      [*] = ;      else
      [*] = ;      if (press='u') then
      [*] = ;      begin
      [*] = ;         case tag of
      [*] = ;            cUpChar, cDownChar : begin
      [*] = ;               if (inputhnd<>0) and (GetGUIElementFocusedByHandle(inputhnd)) then
      [*] = ;               begin
      [*] = ;                  var lastind : Integer = gint_gui_chatind;
      [*] = ;                  if (gint_gui_chatind=-1) then
      [*] = ;                  begin
      [*] = ;                     var i : Integer;
      [*] = ;                     for i:=-1 to gc_gui_maxchatlog-2 do
      [*] = ;                     begin
      [*] = ;                        if (gChatLog[i+1]='') then
      [*] = ;                        begin
      [*] = ;                           lastind := i;
      [*] = ;                           gint_gui_chatind := lastind+1;
      [*] = ;                           break;
      [*] = ;                        end;
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;                  if (lastind>-1) then
      [*] = ;                  begin
      [*] = ;                     if (tag=cUpChar) then
      [*] = ;                     begin
      [*] = ;                        if (gint_gui_chatind-1>=0) and (gChatLog[gint_gui_chatind-1]<>'') then
      [*] = ;                        gint_gui_chatind := gint_gui_chatind-1
      [*] = ;                     end
      [*] = ;                     else
      [*] = ;                     begin
      [*] = ;                        if ((gint_gui_chatind-1)<(gc_gui_maxchatlog-1)) and (gChatLog[gint_gui_chatind+1]<>'') then
      [*] = ;                        gint_gui_chatind := gint_gui_chatind+1;
      [*] = ;                     end;
      [*] = ;                  end;
      [*] = ;                  SetGUIElementText(inputhnd, gChatLog[gint_gui_chatind]);
      [*] = ;               end;
      [*] = ;               {if textHandle <> 0 then
      [*] = ;               begin
      [*] = ;                  var temp_str : String = gStrRegister_ConsoleLogHistory;
      [*] = ;                  var temp_str2 : String;
      [*] = ;                  var n : Integer = gIntRegister_ConsoleCommandIndex;
      [*] = ;
      [*] = ;                  if tag = cUpChar then
      [*] = ;                  n := n - 1
      [*] = ;                  else
      [*] = ;                  n := n + 1;
      [*] = ;
      [*] = ;                  n := Max(Min(n,_sa_GetNum(temp_str)-1),0);
      [*] = ;                  _sa_Get(temp_str,n,temp_str2);
      [*] = ;                  SetGUIElementText(iMsgHnd, temp_str2);
      [*] = ;                  gIntRegister_ConsoleCommandIndex := n;
      [*] = ;               end;}
      [*] = ;            end;
      [*] = ;            //cReturnChar : iTag := GetGUIElementTag(iMsgHnd);
      [*] = ;         end;
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
      [*] = ;
      [*] = ;if (press='c') then
      [*] = ;begin
      [*] = ;   case tag of
      [*] = ;      gc_gui_hotkey_btnEnter : begin
      [*] = ;         var inputhnd : Integer = GetGUIElementIndexByNameParent(elmname+'.input.text', _gui_GetTop);
      [*] = ;         var inputtext : String;
      [*] = ;         if (inputhnd<>0) then
      [*] = ;         inputtext := GetGUIElementText(inputhnd);
      [*] = ;
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;         SetGUIEventStateOnKeyDown('');
      [*] = ;      end;
      [*] = ;      gc_gui_event_tagShow : begin
      [*] = ;         ExecuteState(showstate);
      [*] = ;         gint_gui_chatind := -1;
      [*] = ;      end;
      [*] = ;      gc_gui_event_tagHide : begin
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;         SetGUIEventStateOnKeyDown('');
      [*] = ;      end;
      [*] = ;      gc_gui_event_tagClose, gc_gui_hotkey_btnEscape : begin
      [*] = ;         if (inputhnd<>0) then
      [*] = ;         SetGUIElementText(inputhnd, '');
      [*] = ;         SetGUIElementFocusedHandle(0);
      [*] = ;         _gui_SetGUIElementVisibleByName(elmname, False);
      [*] = ;         SetGUIEventStateOnKeyDown('');
      [*] = ;      end;
      [*] = ;   end;
      [*] = ;end;
   struct.end
section.end

