/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.sun.media.jai.util.Rational;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.Mosaic;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.i18n.Errors;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

final class GridCoverageRendererUtilities {
    static final Crop CROP_FACTORY;
    static final Mosaic MOSAIC_FACTORY;
    private static float RATIONAL_TOLERANCE;
    static final ParameterValueGroup RESAMPLING_PARAMS;
    static ParameterValueGroup CROP_PARAMS;
    static ParameterValueGroup MOSAIC_PARAMS;
    static final Resample RESAMPLE_FACTORY;

    GridCoverageRendererUtilities() {
    }

    static void ensureNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    static void ensureSourceNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(3, name));
        }
    }

    static Rectangle2D layoutHelper(RenderedImage source, float scaleX, float scaleY, float transX, float transY, Interpolation interp) {
        Rational scaleXRational = Rational.approximate((float)scaleX, (float)RATIONAL_TOLERANCE);
        Rational scaleYRational = Rational.approximate((float)scaleY, (float)RATIONAL_TOLERANCE);
        long scaleXRationalNum = scaleXRational.num;
        long scaleXRationalDenom = scaleXRational.denom;
        long scaleYRationalNum = scaleYRational.num;
        long scaleYRationalDenom = scaleYRational.denom;
        Rational transXRational = Rational.approximate((float)transX, (float)RATIONAL_TOLERANCE);
        Rational transYRational = Rational.approximate((float)transY, (float)RATIONAL_TOLERANCE);
        long transXRationalNum = transXRational.num;
        long transXRationalDenom = transXRational.denom;
        long transYRationalNum = transYRational.num;
        long transYRationalDenom = transYRational.denom;
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        long dx0Num = x0;
        long dx0Denom = 1L;
        long dy0Num = y0;
        long dy0Denom = 1L;
        long dx1Num = x0 + w;
        long dx1Denom = 1L;
        long dy1Num = y0 + h;
        long dy1Denom = 1L;
        dx0Num *= scaleXRationalNum;
        dx0Denom *= scaleXRationalDenom;
        dy0Num *= scaleYRationalNum;
        dy0Denom *= scaleYRationalDenom;
        dx1Num *= scaleXRationalNum;
        dx1Denom *= scaleXRationalDenom;
        dy1Num *= scaleYRationalNum;
        dy1Denom *= scaleYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dx0Denom *= 2L;
        dy0Num = 2L * dy0Num - dy0Denom;
        dy0Denom *= 2L;
        dx1Num = 2L * dx1Num - 3L * dx1Denom;
        dx1Denom *= 2L;
        dy1Num = 2L * dy1Num - 3L * dy1Denom;
        dy1Denom *= 2L;
        dx0Num = dx0Num * transXRationalDenom + transXRationalNum * dx0Denom;
        dy0Num = dy0Num * transYRationalDenom + transYRationalNum * dy0Denom;
        dx1Num = dx1Num * transXRationalDenom + transXRationalNum * dx1Denom;
        dy1Num = dy1Num * transYRationalDenom + transYRationalNum * dy1Denom;
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= transXRationalDenom));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= transYRationalDenom));
        int l_x1 = Rational.ceil((long)dx1Num, (long)(dx1Denom *= transXRationalDenom));
        int l_y1 = Rational.ceil((long)dy1Num, (long)(dy1Denom *= transYRationalDenom));
        Rectangle2D.Double retValue = new Rectangle2D.Double();
        retValue.setFrame(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        return retValue;
    }

    static GridCoverage2D reproject(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope, double[] bkgValues, Hints hints) throws FactoryException {
        assert (CRS.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs) || CRS.findMathTransform((CoordinateReferenceSystem)destinationEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs).isIdentity());
        ParameterValueGroup param = RESAMPLING_PARAMS.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        if (bkgValues != null) {
            param.parameter("BackgroundValues").setValue((Object)bkgValues);
        }
        return (GridCoverage2D)RESAMPLE_FACTORY.doOperation(param, hints);
    }

    static GridCoverage2D crop(GridCoverage2D gc, GeneralEnvelope envelope, Hints hints) {
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((Envelope)envelope);
        intersectionEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect((Envelope)oldEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        ParameterValueGroup param = CROP_PARAMS.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("Envelope").setValue((Object)intersectionEnvelope);
        return (GridCoverage2D)CROP_FACTORY.doOperation(param, hints);
    }

    static GridCoverage2D mosaic(List<GridCoverage2D> coverages, List<GridCoverage2D> alphas, GeneralEnvelope renderingEnvelope, Hints hints, double[] background) {
        Comparator<GridCoverage2D> c = new Comparator<GridCoverage2D>(){

            @Override
            public int compare(GridCoverage2D o1, GridCoverage2D o2) {
                double minx2;
                double minx1 = o1.getEnvelope().getMinimum(0);
                if (minx1 == (minx2 = o2.getEnvelope().getMinimum(0))) {
                    double maxy1 = o1.getEnvelope().getMaximum(1);
                    double maxy2 = o2.getEnvelope().getMaximum(1);
                    return this.compareDoubles(maxy1, maxy2);
                }
                return this.compareDoubles(minx1, minx2);
            }

            private int compareDoubles(double maxy1, double maxy2) {
                if (maxy1 == maxy2) {
                    return 0;
                }
                return (int)Math.signum(maxy1 - maxy2);
            }
        };
        Collections.sort(coverages, c);
        Collections.sort(alphas, c);
        try {
            ReferencedEnvelope targetEnvelope = ReferencedEnvelope.reference((Envelope)renderingEnvelope);
            ReferencedEnvelope coveragesEnvelope = null;
            for (GridCoverage2D coverage : coverages) {
                ReferencedEnvelope re = ReferencedEnvelope.reference((BoundingBox)coverage.getEnvelope2D());
                if (coveragesEnvelope == null) {
                    coveragesEnvelope = re;
                    continue;
                }
                coveragesEnvelope.expandToInclude(re);
            }
            if ((targetEnvelope = new ReferencedEnvelope(targetEnvelope.intersection(coveragesEnvelope), renderingEnvelope.getCoordinateReferenceSystem())).isEmpty() || targetEnvelope.isNull()) {
                return null;
            }
            MathTransform2D mt = coverages.get(0).getGridGeometry().getCRSToGrid2D();
            Rectangle rasterSpaceEnvelope = CRS.transform((MathTransform)mt, (Envelope)targetEnvelope).toRectangle2D().getBounds();
            GridEnvelope2D gridRange = new GridEnvelope2D(rasterSpaceEnvelope);
            GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)targetEnvelope);
            ParameterValueGroup param = MOSAIC_PARAMS.clone();
            param.parameter("sources").setValue(coverages);
            param.parameter("geometry").setValue((Object)gridGeometry);
            if (background != null) {
                param.parameter("outputNoData").setValue((Object)background);
            }
            if (!alphas.isEmpty()) {
                param.parameter("alphas").setValue(alphas);
            }
            return (GridCoverage2D)MOSAIC_FACTORY.doOperation(param, hints);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to mosaic the input coverages", e);
        }
    }

    static GeneralEnvelope reprojectEnvelope(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem outputCRS) throws Exception {
        GeneralEnvelope outputEnvelope = null;
        CoordinateReferenceSystem inputCRS = inputEnvelope.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)inputCRS, (Object)outputCRS)) {
            outputEnvelope = CRS.transform((Envelope)inputEnvelope, (CoordinateReferenceSystem)outputCRS);
            outputEnvelope.setCoordinateReferenceSystem(outputCRS);
        }
        if (outputEnvelope == null) {
            outputEnvelope = new GeneralEnvelope((Envelope)inputEnvelope);
            outputEnvelope.setCoordinateReferenceSystem(inputCRS);
        }
        return null;
    }

    static GeneralEnvelope reprojectEnvelopeWithWGS84Pivot(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem targetCRS) throws Exception {
        GridCoverageRendererUtilities.ensureNotNull(inputEnvelope, "destinationEnvelope");
        GridCoverageRendererUtilities.ensureNotNull(targetCRS, "coverageCRS");
        CoordinateReferenceSystem destinationCRS = inputEnvelope.getCoordinateReferenceSystem();
        try {
            CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation(destinationCRS, targetCRS);
            GeneralEnvelope output = CRS.transform((CoordinateOperation)operation, (Envelope)inputEnvelope);
            output.setCoordinateReferenceSystem(targetCRS);
            return output;
        }
        catch (TransformException te) {
            GeneralEnvelope destinationEnvelopeWGS84 = GridCoverageRendererUtilities.reprojectEnvelope(inputEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return GridCoverageRendererUtilities.reprojectEnvelope(destinationEnvelopeWGS84, targetCRS);
        }
    }

    public static double[] colorToArray(Color color) {
        if (color == null) {
            return null;
        }
        return new double[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    static {
        CoverageProcessor processor = new CoverageProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        RESAMPLING_PARAMS = processor.getOperation("Resample").getParameters();
        CROP_PARAMS = processor.getOperation("CoverageCrop").getParameters();
        MOSAIC_PARAMS = processor.getOperation("Mosaic").getParameters();
        CROP_FACTORY = new Crop();
        MOSAIC_FACTORY = new Mosaic();
        RATIONAL_TOLERANCE = 1.0E-6f;
        RESAMPLE_FACTORY = new Resample();
    }
}

