/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class OpacityFinder
implements StyleVisitor {
    private Class[] acceptableTypes;
    public boolean hasOpacity;

    public OpacityFinder(Class[] acceptableTypes) {
        this.acceptableTypes = acceptableTypes;
    }

    @Override
    public void visit(Style style) {
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        for (int i = 0; i < styles.length && !this.hasOpacity; ++i) {
            styles[i].accept(this);
        }
    }

    @Override
    public void visit(Rule rule) {
        Symbolizer[] symbs = rule.getSymbolizers();
        for (int i = 0; i < symbs.length && !this.hasOpacity; ++i) {
            symbs[i].accept(this);
        }
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length && !this.hasOpacity; ++i) {
            rules[i].accept(this);
        }
    }

    @Override
    public void visit(Fill fill) {
        this.checkOpacity(fill.getOpacity());
    }

    private void checkOpacity(Expression exp) {
        if (exp != null && exp instanceof Literal) {
            float opacity;
            Literal literal = (Literal)exp;
            Object obj = literal.getValue();
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Float) {
                Float i = (Float)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Double) {
                Double i = (Double)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Short) {
                Short i = (Short)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Byte) {
                Byte i = (Byte)obj;
                opacity = i.floatValue();
            } else if (obj instanceof String) {
                try {
                    Double value = Double.valueOf((String)obj);
                    opacity = value.floatValue();
                }
                catch (NumberFormatException e) {
                    return;
                }
            } else {
                return;
            }
            if ((double)opacity > 0.01 && (double)opacity < 0.99) {
                this.hasOpacity = true;
            }
        }
    }

    @Override
    public void visit(Stroke stroke) {
        this.checkOpacity(stroke.getOpacity());
    }

    @Override
    public void visit(Symbolizer sym) {
        Symbolizer ps;
        if (sym instanceof PointSymbolizer) {
            ps = (PointSymbolizer)sym;
            ps.accept(this);
        }
        if (sym instanceof LineSymbolizer) {
            ps = (LineSymbolizer)sym;
            ps.accept(this);
        }
        if (sym instanceof PolygonSymbolizer) {
            ps = (PolygonSymbolizer)sym;
            ps.accept(this);
        }
        if (sym instanceof RasterSymbolizer) {
            RasterSymbolizer rs = (RasterSymbolizer)sym;
            rs.accept(this);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        if (this.isAcceptable(ps)) {
            ps.getGraphic().accept(this);
        }
    }

    private boolean isAcceptable(Symbolizer s) {
        for (int i = 0; i < this.acceptableTypes.length; ++i) {
            Class type = this.acceptableTypes[i];
            if (!type.isAssignableFrom(s.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(LineSymbolizer line) {
        if (this.isAcceptable(line) && line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        if (this.isAcceptable(poly)) {
            if (poly.getStroke() != null) {
                poly.getStroke().accept(this);
            }
            if (poly.getFill() != null) {
                poly.getFill().accept(this);
            }
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
    }

    @Override
    public void visit(RasterSymbolizer raster) {
        if (this.isAcceptable(raster)) {
            if (raster.getOpacity() != null) {
                this.checkOpacity(raster.getOpacity());
            }
            if (raster.getColorMap() != null) {
                raster.getColorMap().accept(this);
            }
        }
    }

    @Override
    public void visit(Graphic gr) {
    }

    @Override
    public void visit(Mark mark) {
    }

    @Override
    public void visit(ExternalGraphic exgr) {
    }

    @Override
    public void visit(PointPlacement pp) {
    }

    @Override
    public void visit(AnchorPoint ap) {
    }

    @Override
    public void visit(Displacement dis) {
    }

    @Override
    public void visit(LinePlacement lp) {
    }

    @Override
    public void visit(Halo halo) {
    }

    public static void main(String[] args) {
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
    }

    @Override
    public void visit(NamedLayer layer) {
    }

    @Override
    public void visit(UserLayer layer) {
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
    }

    @Override
    public void visit(ColorMap cm) {
        for (ColorMapEntry cme : cm.getColorMapEntries()) {
            cme.accept(this);
        }
    }

    @Override
    public void visit(ColorMapEntry cme) {
        if (cme.getOpacity() != null) {
            this.checkOpacity(cme.getOpacity());
        }
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    @Override
    public void visit(ImageOutline outline) {
    }

    @Override
    public void visit(ChannelSelection cs) {
    }

    @Override
    public void visit(OverlapBehavior ob) {
    }

    @Override
    public void visit(SelectedChannelType sct) {
    }

    @Override
    public void visit(ShadedRelief sr) {
    }
}

