/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.ConicHandlerFactory;
import org.geotools.renderer.crs.GeographicHandlerFactory;
import org.geotools.renderer.crs.LambertAzimuthalEqualAreaHandlerFactory;
import org.geotools.renderer.crs.MercatorHandlerFactory;
import org.geotools.renderer.crs.PolarStereographicHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.TransverseMercatorHandlerFactory;
import org.geotools.renderer.crs.WorldVanDerGrintenIHandlerFactory;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProjectionHandlerFinder {
    static List<ProjectionHandlerFactory> factories = new ArrayList<ProjectionHandlerFactory>();
    static final Logger LOGGER = Logging.getLogger(ProjectionHandlerFinder.class);
    public static final String WRAP_LIMIT_KEY = "org.geotools.render.wrapLimit";
    static int WRAP_LIMIT;

    public void setWrapLimit(int wrapLimit) {
        WRAP_LIMIT = wrapLimit;
    }

    public static ProjectionHandler getHandler(ReferencedEnvelope renderingArea, CoordinateReferenceSystem sourceCrs, boolean wrap) throws FactoryException {
        if (renderingArea.getCoordinateReferenceSystem() == null) {
            return null;
        }
        for (ProjectionHandlerFactory factory : factories) {
            ProjectionHandler handler = factory.getHandler(renderingArea, sourceCrs, wrap, WRAP_LIMIT);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    static {
        factories.add(new GeographicHandlerFactory());
        factories.add(new MercatorHandlerFactory());
        factories.add(new TransverseMercatorHandlerFactory());
        factories.add(new PolarStereographicHandlerFactory());
        factories.add(new LambertAzimuthalEqualAreaHandlerFactory());
        factories.add(new ConicHandlerFactory());
        factories.add(new WorldVanDerGrintenIHandlerFactory());
        String wrapLimit = System.getProperty(WRAP_LIMIT_KEY);
        int limit = 10;
        try {
            if (wrapLimit != null) {
                limit = Integer.valueOf(wrapLimit);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.SEVERE, "org.geotools.render.wrapLimit has invalid value, it should be an integer number but it was: " + wrapLimit);
        }
        WRAP_LIMIT = limit;
    }
}

