/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import it.geosolutions.imageio.matfile5.MatFileImageReader;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASTileMetadata
extends IIOMetadata {
    private static Set<String> filterElements = new HashSet<String>();
    public static final String SAS_PIXELS = "pixels";
    public static final String SAS_LATITUDE = "latitude";
    public static final String SAS_LONGITUDE = "longitude";
    public static final String SAS_ORIENTATION = "orientation";
    public static final String SAS_PIXEL_DIMS = "pixel_dims";
    public static final String SAS_CHANNEL = "channel";
    public static final String SAS_TILE_RAW = "sas_tile_raw";
    public static final String SAS_TILE_LOG = "sas_tile_log";
    public static final String SAS_MU = "mu";
    public static final String SAS_PINGS = "pings";
    public static final String SAS_TILE_RANGES = "tile_ranges";
    public static final String SAS_AV_VELOCITY = "av_velocity";
    public static final String SAS_AV_ALTITUDE = "av_altitude";
    public static final String SAS_X = "x";
    public static final String SAS_Y = "y";
    public static final String SAS_THETA = "theta";
    private int xPixels;
    private int yPixels;
    private double latitude;
    private double longitude;
    private double orientation;
    private double xPixelDim;
    private double yPixelDim;
    private boolean logScale;
    private Channel channel;

    public static Set<String> getFilterElements() {
        return new HashSet<String>(filterElements);
    }

    public SASTileMetadata(MatFileReader matReader) {
        MLArray sasTileData = matReader.getMLArray(SAS_TILE_RAW);
        if (sasTileData != null) {
            this.logScale = false;
        } else {
            this.logScale = true;
            sasTileData = matReader.getMLArray(SAS_TILE_LOG);
        }
        if (sasTileData == null) {
            throw new IllegalArgumentException("The provided input doesn't contain any valid SAS tile data");
        }
        this.latitude = MatFileImageReader.getDouble((MatFileReader)matReader, (String)SAS_LATITUDE);
        this.longitude = MatFileImageReader.getDouble((MatFileReader)matReader, (String)SAS_LONGITUDE);
        this.orientation = MatFileImageReader.getDouble((MatFileReader)matReader, (String)SAS_ORIENTATION);
        double[] pixelDims = new double[2];
        int[] pixels = null;
        int pixelType = MatFileImageReader.getElementType((MatFileReader)matReader, (String)SAS_PIXELS);
        if (pixelType == 6) {
            double[] pixelsD = new double[2];
            MatFileImageReader.getDoubles((MatFileReader)matReader, (String)SAS_PIXELS, (double[])pixelsD);
            pixels = new int[]{Double.isNaN(pixelsD[0]) ? Integer.MIN_VALUE : (int)pixelsD[0], Double.isNaN(pixelsD[1]) ? Integer.MIN_VALUE : (int)pixelsD[1]};
        } else if (pixelType == 12) {
            int[] pixelsI = new int[2];
            MatFileImageReader.getIntegers((MatFileReader)matReader, (String)SAS_PIXELS, (int[])pixelsI);
            pixels = pixelsI;
        }
        MatFileImageReader.getDoubles((MatFileReader)matReader, (String)SAS_PIXEL_DIMS, (double[])pixelDims);
        String channel = MatFileImageReader.getString((MatFileReader)matReader, (String)SAS_CHANNEL);
        this.xPixels = pixels[0];
        this.yPixels = pixels[1];
        this.channel = Channel.getChannel(channel);
        this.xPixelDim = pixelDims[0];
        this.yPixelDim = pixelDims[1];
    }

    public int getXPixels() {
        return this.xPixels;
    }

    public void setXPixels(int pixels) {
        this.xPixels = pixels;
    }

    public int getYPixels() {
        return this.yPixels;
    }

    public void setYPixels(int pixels) {
        this.yPixels = pixels;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public double getXPixelDim() {
        return this.xPixelDim;
    }

    public void setXPixelDim(double pixelDim) {
        this.xPixelDim = pixelDim;
    }

    public double getYPixelDim() {
        return this.yPixelDim;
    }

    public void setYPixelDim(double pixelDim) {
        this.yPixelDim = pixelDim;
    }

    @Override
    public Node getAsTree(String formatName) {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
    }

    @Override
    public void reset() {
    }

    public String getMetadataAsXML() {
        return null;
    }

    static {
        filterElements.add(SAS_TILE_RAW);
        filterElements.add(SAS_TILE_LOG);
        filterElements.add(SAS_PIXELS);
        filterElements.add(SAS_LATITUDE);
        filterElements.add(SAS_LONGITUDE);
        filterElements.add(SAS_PIXEL_DIMS);
        filterElements.add(SAS_ORIENTATION);
        filterElements.add(SAS_CHANNEL);
        filterElements.add(SAS_MU);
        filterElements.add(SAS_X);
        filterElements.add(SAS_Y);
        filterElements.add(SAS_THETA);
        filterElements.add(SAS_PINGS);
        filterElements.add(SAS_TILE_RANGES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        PORT,
        STARBOARD,
        UNKNOWN;


        public static Channel getChannel(String channel) {
            if (channel != null && channel.trim().length() > 0) {
                if (channel.equalsIgnoreCase("port")) {
                    return PORT;
                }
                if (channel.equalsIgnoreCase("starboard")) {
                    return STARBOARD;
                }
            }
            return UNKNOWN;
        }
    }
}

