/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.matfile5.sas;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLNumericArray;
import it.geosolutions.imageio.matfile5.MatFileImageReader;
import it.geosolutions.imageio.matfile5.MatFileImageReaderSpi;
import it.geosolutions.imageio.matfile5.sas.SASTileImageReaderSpi;
import it.geosolutions.imageio.matfile5.sas.SASTileMetadata;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.TransposeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASTileImageReader
extends MatFileImageReader {
    private static final boolean COMPUTE_LOGARITHM;
    private static final boolean DISABLE_MEDIALIB_LOG;
    private boolean isInitialized = false;
    private SASTileMetadata sasTile = null;

    public SASTileImageReader(SASTileImageReaderSpi originatingProvider) {
        super((MatFileImageReaderSpi)originatingProvider);
    }

    protected synchronized void initialize() {
        if (!this.isInitialized) {
            Object datainput = super.getInput();
            String fileName = this.getDatasetSource(datainput).getAbsolutePath();
            MatFileFilter filter = new MatFileFilter();
            this.initFilter(filter, SASTileMetadata.getFilterElements());
            try {
                this.matReader = new MatFileReader(new String(fileName), filter, true);
                this.sasTile = new SASTileMetadata(this.matReader);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to Initialize the reader", e);
            }
        }
        this.isInitialized = true;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile.getYPixels();
    }

    public int getWidth(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile.getXPixels();
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.initialize();
        return this.sasTile;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        ParameterBlockJAI pbTranspose;
        RenderedOp magnitude;
        DataBuffer imgBufferImaginary;
        Buffer buffImaginary;
        Object[] dstImaginary;
        DataBuffer imgBufferReal;
        Buffer buffReal;
        Object[] dstReal;
        this.initialize();
        int width = this.sasTile.getXPixels();
        int height = this.sasTile.getYPixels();
        SASTileMetadata.Channel channel = this.sasTile.getChannel();
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        int dstWidth = -1;
        int dstHeight = -1;
        int srcRegionWidth = -1;
        int srcRegionHeight = -1;
        int srcRegionXOffset = -1;
        int srcRegionYOffset = -1;
        int xSubsamplingFactor = -1;
        int ySubsamplingFactor = -1;
        Rectangle srcRegion = param.getSourceRegion();
        if (srcRegion != null) {
            srcRegionWidth = (int)srcRegion.getWidth();
            srcRegionHeight = (int)srcRegion.getHeight();
            srcRegionXOffset = (int)srcRegion.getX();
            srcRegionYOffset = (int)srcRegion.getY();
            if (srcRegionXOffset < 0) {
                srcRegionXOffset = 0;
            }
            if (srcRegionYOffset < 0) {
                srcRegionYOffset = 0;
            }
            if (srcRegionXOffset + srcRegionWidth > width) {
                srcRegionWidth = width - srcRegionXOffset;
            }
            dstWidth = srcRegionWidth;
            if (srcRegionYOffset + srcRegionHeight > height) {
                srcRegionHeight = height - srcRegionYOffset;
            }
            dstHeight = srcRegionHeight;
        } else {
            dstWidth = width;
            dstHeight = height;
            srcRegionYOffset = 0;
            srcRegionXOffset = 0;
            srcRegionWidth = width;
            srcRegionHeight = height;
        }
        xSubsamplingFactor = param.getSourceXSubsampling();
        ySubsamplingFactor = param.getSourceYSubsampling();
        dstWidth = (dstWidth - 1) / xSubsamplingFactor + 1;
        dstHeight = (dstHeight - 1) / ySubsamplingFactor + 1;
        Rectangle roi = new Rectangle(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight);
        MLArray mlArrayRetrived = this.sasTile.isLogScale() ? this.matReader.getMLArray("sas_tile_log") : this.matReader.getMLArray("sas_tile_raw");
        ByteBuffer real = ((MLNumericArray)mlArrayRetrived).getRealByteBuffer();
        ByteBuffer imaginary = ((MLNumericArray)mlArrayRetrived).getImaginaryByteBuffer();
        boolean isDouble = mlArrayRetrived instanceof MLDouble;
        int imageSize = width * height;
        if (isDouble) {
            dstReal = new double[imageSize];
            buffReal = real.asDoubleBuffer();
            ((DoubleBuffer)buffReal).get((double[])dstReal);
            imgBufferReal = new DataBufferDouble((double[])dstReal, imageSize);
            dstImaginary = new double[imageSize];
            buffImaginary = imaginary.asDoubleBuffer();
            ((DoubleBuffer)buffImaginary).get((double[])dstImaginary);
            imgBufferImaginary = new DataBufferDouble((double[])dstImaginary, imageSize);
        } else {
            dstReal = new float[imageSize];
            buffReal = real.asFloatBuffer();
            ((FloatBuffer)buffReal).get((float[])dstReal);
            imgBufferReal = new DataBufferFloat((float[])dstReal, imageSize);
            dstImaginary = new float[imageSize];
            buffImaginary = imaginary.asFloatBuffer();
            ((FloatBuffer)buffImaginary).get((float[])dstImaginary);
            imgBufferImaginary = new DataBufferFloat((float[])dstImaginary, imageSize);
        }
        int smWidth = height;
        int smHeight = width;
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(isDouble ? 5 : 4, smWidth, smHeight, 1, smWidth, new int[]{0});
        ColorModel cm = SASTileImageReader.buildColorModel((SampleModel)sampleModel);
        BufferedImage realBandOriginal = new BufferedImage(cm, Raster.createWritableRaster(sampleModel, imgBufferReal, null), false, null);
        BufferedImage imaginaryBandOriginal = new BufferedImage(cm, Raster.createWritableRaster(sampleModel, imgBufferImaginary, null), false, null);
        ImageLayout layout = new ImageLayout();
        layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(2048).setTileWidth(2048);
        RenderingHints rHints = null;
        rHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        PlanarImage realBand = null;
        PlanarImage imaginaryBand = null;
        boolean doCrop = false;
        boolean doSubSampling = false;
        if (srcRegion != null) {
            int x = roi.y;
            int y = roi.x;
            int w = roi.height;
            int h = roi.width;
            ParameterBlockJAI pbCropReal = new ParameterBlockJAI("Crop");
            pbCropReal.addSource((Object)realBandOriginal);
            pbCropReal.setParameter("x", (Object)Float.valueOf(x));
            pbCropReal.setParameter("y", (Object)Float.valueOf(y));
            pbCropReal.setParameter("width", (Object)Float.valueOf(w));
            pbCropReal.setParameter("height", (Object)Float.valueOf(h));
            RenderedOp cropReal = JAI.create((String)"Crop", (ParameterBlock)pbCropReal, (RenderingHints)rHints);
            realBand = cropReal;
            ParameterBlockJAI pbCropImaginary = new ParameterBlockJAI("Crop");
            pbCropImaginary.addSource((Object)imaginaryBandOriginal);
            pbCropImaginary.setParameter("x", (Object)Float.valueOf(x));
            pbCropImaginary.setParameter("y", (Object)Float.valueOf(y));
            pbCropImaginary.setParameter("width", (Object)Float.valueOf(w));
            pbCropImaginary.setParameter("height", (Object)Float.valueOf(h));
            RenderedOp cropImaginary = JAI.create((String)"Crop", (ParameterBlock)pbCropImaginary, (RenderingHints)rHints);
            imaginaryBand = cropImaginary;
            doCrop = true;
        }
        if (xSubsamplingFactor != 1 || ySubsamplingFactor != 1) {
            if (!doCrop) {
                realBand = PlanarImage.wrapRenderedImage((RenderedImage)realBandOriginal);
                imaginaryBand = PlanarImage.wrapRenderedImage((RenderedImage)imaginaryBandOriginal);
            }
            Raster translatedRasterReal = realBand.getData().createTranslatedChild(0, 0);
            int dstW = dstHeight;
            int dstH = dstWidth;
            WritableRaster destRasterReal = Raster.createWritableRaster(translatedRasterReal.getSampleModel().createCompatibleSampleModel(dstW, dstH), new Point(0, 0));
            int origRasterWidth = translatedRasterReal.getWidth();
            int origRasterHeight = translatedRasterReal.getHeight();
            float[] data = null;
            for (int i = 0; i < origRasterHeight; i += ySubsamplingFactor) {
                for (int j = 0; j < origRasterWidth; j += xSubsamplingFactor) {
                    data = translatedRasterReal.getPixel(j, i, data);
                    destRasterReal.setPixel(j / xSubsamplingFactor, i / ySubsamplingFactor, data);
                }
            }
            realBand = PlanarImage.wrapRenderedImage((RenderedImage)new BufferedImage(cm, destRasterReal, false, null));
            Raster translatedRasterImaginary = imaginaryBand.getData().createTranslatedChild(0, 0);
            WritableRaster destRasterImaginary = Raster.createWritableRaster(translatedRasterImaginary.getSampleModel().createCompatibleSampleModel(dstW, dstH), new Point(0, 0));
            data = null;
            for (int i = 0; i < origRasterHeight; i += ySubsamplingFactor) {
                for (int j = 0; j < origRasterWidth; j += xSubsamplingFactor) {
                    data = translatedRasterImaginary.getPixel(j, i, data);
                    destRasterImaginary.setPixel(j / xSubsamplingFactor, i / ySubsamplingFactor, data);
                }
            }
            imaginaryBand = PlanarImage.wrapRenderedImage((RenderedImage)new BufferedImage(cm, destRasterImaginary, false, null));
            doSubSampling = true;
        }
        ParameterBlockJAI pbMerge = new ParameterBlockJAI("BandMerge");
        if (doSubSampling || doCrop) {
            pbMerge.addSource((Object)realBand);
            pbMerge.addSource((Object)imaginaryBand);
        } else {
            pbMerge.addSource((Object)realBandOriginal);
            pbMerge.addSource((Object)imaginaryBandOriginal);
        }
        RenderedOp banded = JAI.create((String)"BandMerge", (ParameterBlock)pbMerge, (RenderingHints)rHints);
        ParameterBlockJAI pbMagnitude = new ParameterBlockJAI("Magnitude");
        pbMagnitude.addSource((Object)banded);
        RenderedOp beforeLogarithm = magnitude = JAI.create((String)"Magnitude", (ParameterBlock)pbMagnitude);
        if (channel == SASTileMetadata.Channel.STARBOARD) {
            pbTranspose = new ParameterBlockJAI("Transpose");
            pbTranspose.addSource((Object)magnitude);
            pbTranspose.setParameter("type", (Object)TransposeDescriptor.FLIP_DIAGONAL);
            beforeLogarithm = JAI.create((String)"Transpose", (ParameterBlock)pbTranspose);
            ParameterBlockJAI pbFlippedH = new ParameterBlockJAI("Transpose");
            pbFlippedH.addSource((Object)beforeLogarithm);
            pbFlippedH.setParameter("type", (Object)TransposeDescriptor.FLIP_VERTICAL);
            beforeLogarithm = JAI.create((String)"Transpose", (ParameterBlock)pbFlippedH);
        } else {
            pbTranspose = new ParameterBlockJAI("Transpose");
            pbTranspose.addSource((Object)magnitude);
            pbTranspose.setParameter("type", (Object)TransposeDescriptor.FLIP_ANTIDIAGONAL);
            beforeLogarithm = JAI.create((String)"Transpose", (ParameterBlock)pbTranspose);
        }
        if (COMPUTE_LOGARITHM) {
            ParameterBlockJAI pbLog = new ParameterBlockJAI("Log");
            pbLog.addSource((Object)beforeLogarithm);
            RenderedOp logarithm = JAI.create((String)"Log", (ParameterBlock)pbLog);
            ParameterBlock pbRescale = new ParameterBlock();
            double scaleFactor = 20.0 / Math.log(10.0);
            double[] scaleF = new double[]{scaleFactor};
            double[] offsetF = new double[]{0.0};
            pbRescale.add(scaleF);
            pbRescale.add(offsetF);
            pbRescale.addSource(logarithm);
            RenderedOp rescale = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
            return rescale.getAsBufferedImage();
        }
        return beforeLogarithm.getAsBufferedImage();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.initialize();
        int width = this.sasTile.getXPixels();
        int height = this.sasTile.getYPixels();
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(5, width, height, 1, width, new int[]{0});
        ColorModel cm = SASTileImageReader.buildColorModel((SampleModel)sampleModel);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(1);
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(cm, sampleModel);
        l.add(imageType);
        return l.iterator();
    }

    static {
        String cl = System.getenv("SAS_COMPUTE_LOG");
        String disableMediaLog = System.getenv("DISABLE_MEDIALIB_LOG");
        COMPUTE_LOGARITHM = cl != null && cl.trim().length() > 0 ? Boolean.parseBoolean(cl) : true;
        DISABLE_MEDIALIB_LOG = disableMediaLog != null && disableMediaLog.trim().length() > 0 ? Boolean.parseBoolean(disableMediaLog) : false;
        if (DISABLE_MEDIALIB_LOG) {
            Utilities.setNativeAccelerationAllowed((String)"Log", (boolean)false);
        }
    }
}

