/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.selector.AbstractSelectorVisitor;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.Selector;
import org.geotools.util.Range;

public class ScaleRangeExtractor
extends AbstractSelectorVisitor {
    private boolean insideOr;
    private Range<Double> range;

    public static Range<Double> getScaleRange(CssRule cssRule) {
        Selector selector = cssRule.getSelector();
        return ScaleRangeExtractor.getScaleRange(selector);
    }

    public static Range<Double> getScaleRange(Selector selector) {
        try {
            ScaleRangeExtractor extractor = new ScaleRangeExtractor();
            selector.accept(extractor);
            return extractor.range;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Failed to extract scale range from: " + selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(Or or) {
        try {
            this.insideOr = true;
            super.visit(or);
        }
        finally {
            this.insideOr = false;
        }
        return null;
    }

    @Override
    public Object visit(ScaleRange scaleRange) {
        if (this.insideOr) {
            throw new IllegalStateException("Cannot translate to SLD when a scale range is used inside a OR in the selector");
        }
        if (this.range == null) {
            this.range = scaleRange.range;
        } else {
            this.range.intersect(scaleRange.range);
        }
        return null;
    }
}

